/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch.servlet;

import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.textsearch.servlet.MakeTextIndex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public class MakeTextIndexThread
implements Runnable {
    static final Logger logger = LogManager.getLogger(MakeTextIndexThread.class);
    private ApplicationContext appctx;

    public MakeTextIndexThread(ApplicationContext appctx) {
        this.appctx = appctx;
    }

    @Override
    public void run() {
        try {
            logger.info("(admin@localhost) start making textsearch index.");
            this.makeIndex();
            logger.info("(admin@localhost) finished making textsearch index.");
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private void makeIndex() throws ServletException {
        MakeTextIndex mti = (MakeTextIndex)this.appctx.getBean("MakeTextIndex");
        MakeTextIndex.CreateIndexGetDataType type = mti.getCreateIndexGetDataType();
        if (type == MakeTextIndex.CreateIndexGetDataType.Hibernate) {
            this.createIndexFromTable(mti);
        } else if (type == MakeTextIndex.CreateIndexGetDataType.ProcessBean) {
            this.createIndexFromProcessBean(mti, this.appctx);
        } else if (type == MakeTextIndex.CreateIndexGetDataType.Table) {
            this.createIndexFromTable(mti);
        } else {
            logger.error("Unknown type " + type);
        }
    }

    private void createIndexFromProcessBean(MakeTextIndex mti, ApplicationContext appctx) throws ServletException {
        ActionParameter p = null;
        try {
            p = ActionParameter.createActionParameter(logger, "initdb", appctx);
            mti.setActionParameter(p);
            mti.createIndex(false);
            mti.optimizeIndex();
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ServletException(t.toString(), t);
        }
    }

    private void createIndexFromTable(MakeTextIndex mti) throws ServletException {
        try {
            mti.createIndex(false);
            mti.optimizeIndex();
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ServletException(t.toString(), t);
        }
    }
}

