/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.textsearch.IndexerDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextsearchUtil
implements IndexerDefinition {
    private static Logger logger = LogManager.getLogger(TextsearchUtil.class);
    private static final List<String> suggestMatchMethods = new ArrayList<String>();

    public static String getSuggestMode(HttpServletRequest request) {
        String dfltMethod = "prefix";
        if (request == null) {
            logger.debug("request is null. return " + dfltMethod);
            return dfltMethod;
        }
        if (request.getParameter("TEXTSEARCH_SUGGEST_METHOD") != null && suggestMatchMethods.contains(request.getParameter("TEXTSEARCH_SUGGEST_METHOD"))) {
            logger.debug("return " + request.getParameter("TEXTSEARCH_SUGGEST_METHOD"));
            return request.getParameter("TEXTSEARCH_SUGGEST_METHOD");
        }
        return dfltMethod;
    }

    public static String getHttpSessionKey4TextSearch(String mainModelId, ActionParameter p) {
        String suggestItemName = p.request.getParameter("TEXTSEARCH_SUGGEST_ITEMNAME");
        if (StringUtils.isNotBlank((CharSequence)suggestItemName)) {
            return "TEXTSEARCH_RESULTMAP_" + suggestItemName;
        }
        return "TEXTSEARCH_RESULTMAP_" + mainModelId;
    }

    public static String getIndexModelId(String indexDir) {
        return StringUtils.substringAfterLast((String)indexDir, (String)"/");
    }

    static {
        suggestMatchMethods.add("prefix");
        suggestMatchMethods.add("partial");
    }
}

