/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.repository;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.tools.repository.PropertiesUtil;
import jp.jasminesoft.jfc.tools.repository.RepositoryManagerUtil;
import jp.jasminesoft.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class R8RepositoryConverter {
    private static final Logger logger = LogManager.getLogger(R8RepositoryConverter.class);
    private Map<String, String> dic = new HashMap<String, String>();
    private static String[][] conversionTable = new String[][]{{"\u25cb", "true"}, {"\u25ef", "true"}, {"\u25ce", "default"}, {"\u00d7", "false"}, {"\u30a8\u30e9\u30fc", "error"}, {"\u8b66\u544a", "warning"}, {"\u30dc\u30bf\u30f3", "button"}, {"\u540c\u4e00\u30b0\u30eb\u30fc\u30d7\u30e6\u30fc\u30b6", "sameGroupUser"}, {"\u5168\u30e6\u30fc\u30b6", "allUser"}, {"\u30d1\u30bf\u30fc\u30f31", "pattern1"}, {"\u30d1\u30bf\u30fc\u30f32", "pattern2"}, {"\u30d1\u30bf\u30fc\u30f33", "pattern3"}, {"\u30d1\u30bf\u30fc\u30f34", "pattern4"}, {"\u30d1\u30bf\u30fc\u30f35", "pattern5"}, {"\u30d1\u30bf\u30fc\u30f36", "pattern6"}, {"\u79d2", "second"}, {"\u5206", "minute"}, {"\u6642", "hour"}, {"\u65e5", "day"}, {"\u6708", "month"}, {"\u5e74", "year"}, {"\u7e26\u3001\u6a2a", "verticalAndHolizontal"}, {"\u7e26\u306e\u307f", "vertical"}, {"\u6a2a\u306e\u307f", "holizontal"}, {"\u5b9f\u884c\u6642\u6307\u5b9a", "runtime"}, {"\uff08\u306a\u3057\uff09", "none"}, {"\u691c\u7d22\u30dc\u30bf\u30f3\u62bc\u4e0b\u6642", "pushButton"}, {"\u521d\u671f\u691c\u7d22\u6642", "initialSearch"}, {"\u5e38\u306b", "always"}, {"\u30e2\u30c7\u30eb\u5168\u4f53", "modelLevelLock"}, {"\u30ec\u30b3\u30fc\u30c9\u6bce", "recordLevelLock"}, {"\u691c\u7d22\u753b\u9762", "searchScreen"}, {"\u4e00\u89a7\u8868\u793a\u753b\u9762", "showListScreen"}, {"\u4e00\u89a7\u8868\u793a\u753b\u9762(\u884c\u6bce)", "showListScreenPerRecord"}, {"\u8a73\u7d30\u8868\u793a\u753b\u9762", "showScreen"}, {"\u65b0\u898f\u767b\u9332\u753b\u9762", "insertScreen"}, {"\u66f4\u65b0\u753b\u9762", "updateScreen"}, {"\u4e00\u89a7\u66f4\u65b0\u753b\u9762", "updateListScreen"}, {"\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u753b\u9762", "downloadScreen"}, {"\u30ab\u30ec\u30f3\u30c0\u30d3\u30e5\u30fc\u753b\u9762", "calendarScreen"}, {"\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u66f4\u65b0\u753b\u9762", "uploadUpdateScreen"}, {"\u96c6\u8a08\u753b\u9762", "totalScreen"}, {"\u9805\u76ee\u540d", "itemname"}, {"\u5024", "value"}, {"\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u30e6\u30cb\u30fc\u30af\u3001\u62e1\u5f35\u5b50\u306f\u7dad\u6301", "uniqueFilenameKeepExtension"}, {"\u30aa\u30ea\u30b8\u30ca\u30eb\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u305d\u306e\u307e\u307e\u4f7f\u3046", "keepOriginalFilename"}, {"\u9752", "blue"}, {"\u6a59", "orange"}, {"\u9752\u7dd1", "turquoise"}, {"\u8d64", "red"}, {"\u7d2b", "purple"}, {"\u7dd1", "green"}, {"\u7e26\u68d2\u30b0\u30e9\u30d5", "columnChart"}, {"\u96c6\u5408\u7e26\u68d2\u30b0\u30e9\u30d5", "collectiveColumnChart"}, {"\u6a2a\u68d2\u30b0\u30e9\u30d5", "horizontalBarChart"}, {"\u96c6\u5408\u6a2a\u68d2\u30b0\u30e9\u30d5", "collectiveBarChart"}, {"\u7a4d\u307f\u4e0a\u3052\u6a2a\u68d2\u30b0\u30e9\u30d5", "stackedBarChart"}, {"\u5186\u30b0\u30e9\u30d5\uff08\u7e26\u5408\u8a08\uff09", "pieChartVertical"}, {"\u5186\u30b0\u30e9\u30d5\uff08\u6a2a\u5408\u8a08\uff09", "pieChartHorizontal"}, {"\u6298\u308c\u7dda\u30b0\u30e9\u30d5", "lineChart"}, {"\u6298\u308c\u7dda\u30b0\u30e9\u30d5\uff08\u30de\u30fc\u30ab\u30fc\u6709\uff09", "lineChartMarker"}, {"\u7a4d\u307f\u4e0a\u3052\u6298\u308c\u7dda\u30b0\u30e9\u30d5", "stackedLineChart"}, {"\u6563\u5e03\u56f3", "scatterPlot"}, {"\u9762\u30b0\u30e9\u30d5", "areaChart"}, {"\u7a4d\u307f\u4e0a\u3052\u9762\u30b0\u30e9\u30d5", "stackedAreaChart"}, {"3D\u68d2\u30b0\u30e9\u30d5", "3DBarChart"}, {"\u9078\u629e\u3057\u305f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u6a19\u6e96\u6587\u5b57", "default"}, {"\u533a\u5207\u308a\u6587\u5b57\u3092\u6307\u5b9a\u3057\u306a\u3044", "noDelimiter"}, {"\u4e0b", "below"}, {"\u5de6", "left"}, {"\u30d8\u30c3\u30c0\u884c\u3092\u56fa\u5b9a", "fixHeader"}, {"\u5217\u3092\u56fa\u5b9a", "fixColumns"}, {"\u30d8\u30c3\u30c0\u884c\u30fb\u5217\u3092\u56fa\u5b9a", "fixHeaderAndColumns"}, {"\u5168\u4f53\u3092\u56db\u89d2\u3067\u56f2\u3080", "surroundedByBox"}, {"\u7e26\u65b9\u5411\u306b\u30b0\u30eb\u30fc\u30d7\u5316", "groupInVertical"}, {"\u30a2\u30af\u30b7\u30e7\u30f3\u9818\u57df\u306e\u524d", "beforeActionArea"}, {"\u30a2\u30af\u30b7\u30e7\u30f3\u9818\u57df\u306e\u5f8c", "afterActionArea"}, {"\u4e0a", "top"}, {"\u4e0b", "bottom"}, {"\u4e0a\u4e0b", "topAndBottom"}, {"\u7d5e\u8fbc\u6761\u4ef6\u306b\u3057\u306a\u3044", "ignore"}, {"\u9078\u629e\u80a2\u3092\u4f5c\u3089\u306a\u3044", "empty"}, {"\u30b9\u30c6\u30c3\u30d7\u6307\u5b9a", "step"}, {"\u5e74\u6708\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9", "ym"}, {"\u753b\u9762\u306b\u8868\u793a", "displayed"}, {"\u753b\u9762\u8868\u793a\u30c7\u30fc\u30bf\u306e\u307f\u4e00\u62ec\u51e6\u7406\u306e\u5bfe\u8c61\u3068\u3059\u308b", "displayedOnly"}, {"\u5168\u30c7\u30fc\u30bf\u4e00\u62ec\u51e6\u7406\u306e\u5bfe\u8c61\u3068\u3059\u308b", "all"}, {"\u8868\u793a\u3057\u306a\u3044", "hide"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9", "listbox"}, {"\u691c\u7d22\u753b\u9762\uff08\u30b5\u30d6\u30a6\u30a3\u30f3\u30c9\u30a6\uff09", "searchSubwindow"}, {"\u691c\u7d22\u753b\u9762(\u30b5\u30d6\u30a6\u30a3\u30f3\u30c9\u30a6)", "searchSubwindow"}, {"\u8a73\u7d30\u8868\u793a", "show"}, {"\u4e00\u89a7\u8868\u793a", "showList"}, {"\u5e33\u7968\u753b\u9762", "reportList"}, {"\u65b0\u898f\u767b\u9332", "insert"}, {"\u30b3\u30d4\u30fc\u767b\u9332", "copy"}, {"\u66f4\u65b0", "update"}, {"\u30bf\u30a4\u30d7", "type"}, {"\u65e5\u4ed8", "date"}, {"\u30bf\u30a4\u30c8\u30eb", "title"}, {"\u898b\u51fa\u3057", "subject"}, {"\u958b\u59cb\u6642\u5206", "beginHourMinute"}, {"\u7d42\u4e86\u6642\u5206", "endHourMinute"}, {"\u62c5\u5f53\u8005", "personInCharge"}, {"\u5834\u6240", "place"}, {"\u5099\u8003", "note"}, {"URL", "URL"}, {"\u7d42\u65e5", "allday"}, {"\u958b\u59cb\u6642\u9593", "beginHour"}, {"\u958b\u59cb\u5206", "beginMinute"}, {"\u7d42\u4e86\u6642\u9593", "endHour"}, {"\u7d42\u4e86\u5206", "endMinute"}, {"\u4f4f\u6240", "address"}, {"\u7def\u5ea6", "latitude"}, {"\u7d4c\u5ea6", "longitude"}, {"\u540d\u79f0", "name"}, {"\u30ba\u30fc\u30e0\u30ec\u30d9\u30eb", "zoomLevel"}, {"\u534a\u5f84", "radius"}, {"MBR", "MBR"}, {"\u91cd\u306d\u753b\u50cf", "image"}, {"\u30de\u30fc\u30ab\u30fc\u8272", "markerColor"}, {"\u30de\u30fc\u30ab\u30fc\u30a2\u30a4\u30b3\u30f3URL", "markerIconUrl"}, {"\u56db\u89d2\u3067\u56f2\u3080", "surroundedByBox"}, {"\u7e26\u2193", "verticalDirection"}, {"\u7e26", "vertical"}, {"\u6a2a\u2192", "horizontalDirection"}, {"\u6a2a", "horizontal"}, {"\u30bf\u30d6", "tab"}, {"\u4ee5\u4e0a", "ge"}, {"\u4ee5\u4e0b", "le"}, {"\u3088\u308a\u5927\u304d\u3044", "gt"}, {"\u3088\u308a\u5c0f\u3055\u3044", "lt"}, {"\u7b49\u3057\u3044", "eq"}, {"\u7b49\u3057\u304f\u306a\u3044", "neq"}, {"\u6587\u5b57\u5217\u306e\u90e8\u5206\u4e00\u81f4", "partial"}, {"\u6587\u5b57\u5217\u306e\u90e8\u5206\u4e00\u81f4\uff08\u8b66\u544a\uff09", "partial_warning"}, {"\u6587\u5b57\u5217\u306e\u524d\u65b9\u4e00\u81f4", "prefix"}, {"\u6587\u5b57\u5217\u306e\u524d\u65b9\u4e00\u81f4\uff08\u8b66\u544a\uff09", "prefix_warning"}, {"\u6587\u5b57\u5217\u306e\u5f8c\u65b9\u4e00\u81f4", "postfix"}, {"\u6587\u5b57\u5217\u306e\u5f8c\u65b9\u4e00\u81f4\uff08\u8b66\u544a\uff09", "postfix_warning"}, {"\u6587\u5b57\u5217\u306e\u90e8\u5206\u4e00\u81f4(\u5b9f\u884c\u6642\u6307\u5b9a)", "partial_runtime"}, {"\u30e6\u30fc\u30b6ID", "userid"}, {"\u30b0\u30eb\u30fc\u30d7ID", "groupid"}, {"\u30ab\u30ec\u30f3\u30c0\u306e\u5229\u7528", "datePicker"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u5e74)", "listbox_y"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u5e74)", "listbox_y"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u5e74\u6708)", "listbox_ym"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u5e74\u6708)", "listbox_ym"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u5e74\u6708\u65e5)", "listbox_ymd"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u5e74\u6708\u65e5)", "listbox_ymd"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528", "listbox"}, {"\u6587\u5b57\u5217(\u4e00\u822c)", "commonFilter"}, {"\u6587\u5b57\u5217(\u6700\u5c0f\u9650)", "minimumFilter"}, {"\u65e5\u4ed8\u578b", "dateFilter"}, {"\u6570\u5b57\u578b", "intFilter"}, {"\u534a\u89d2->\u5168\u89d2", "singleToDoubleByteCharacterFilter"}, {"\u534a\u89d2->\u5168\u89d2(\u30ab\u30ca\u306e\u307f)", "singleToDoubleByteCharacterKanaFilter"}, {"\u534a\u89d2->\u5168\u89d2\u30ab\u30ca\u306e\u307f", "singleToDoubleByteCharacterKanaFilter"}, {"\u534a\u89d2->\u5168\u89d2(\u7a7a\u767d\u3092\u542b\u3080)", "singleToDoubleByteCharacterWithSpaceFilter"}, {"\u5168\u89d2->\u534a\u89d2", "doubleToSingleByteCharacterFilter"}, {"\u5168\u89d2->\u534a\u89d2(\u7a7a\u767d\u3092\u542b\u3080)", "doubleToSingleByteCharacterWithSpaceFilter"}, {"\u30de\u30b9\u30bf\u30e2\u30c7\u30eb\u5c02\u7528", "masterFilter"}, {"\u30de\u30b9\u30bf\u30fc\u30e2\u30c7\u30eb\u5c02\u7528", "masterFilter"}, {"\u6570\u5024", "number"}, {"\u534a\u89d2\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8", "alphabet"}, {"\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9", "mailaddress"}, {"\u30ab\u30bf\u30ab\u30ca", "katakana"}, {"\u534a\u89d2\u30ab\u30bf\u30ab\u30ca", "singleByteCharacterKatakana"}, {"\u5168\u89d2\u30ab\u30bf\u30ab\u30ca", "doubleByteCharacterKatakana"}, {"\u3072\u3089\u304c\u306a", "hiragana"}, {"\u65e5\u4ed8", "date"}, {"\u65e5\u4ed8(yyyy-MM-dd)", "date_yyyy-MM-dd"}, {"\u65e5\u4ed8(yyyy-MM)", "date_yyyy-MM"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u6642)", "listbox_h"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u6642)", "listbox_h"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u6642\u5206)", "listbox_hm"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u6642\u5206)", "listbox_hm"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u6642\u5206\u79d2)", "listbox_hms"}, {"\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\u306e\u5229\u7528(\u6642\u5206\u79d2)", "listbox_hms"}, {"\u30b5\u30b8\u30a7\u30b9\u30c8\u306e\u307f", "suggest"}, {"\u524d\u65b9\u4e00\u81f4", "prefix"}, {"\u90e8\u5206\u4e00\u81f4", "partial"}, {"\u4efb\u610f\u9078\u629e", "runtime"}, {"\u81ea\u52d5\u8a08\u7b97\u306e\u524d", "beforeCalc"}, {"\u81ea\u52d5\u8a08\u7b97\u306e\u5f8c", "afterCalc"}, {"\u521d\u671f\u5024\u8a2d\u5b9a\u306e\u524d", "beforeInit"}, {"\u521d\u671f\u5024\u8a2d\u5b9a\u306e\u5f8c", "afterInit"}, {"\u5148\u982d\u306b\u8ffd\u52a0", "addFirst"}, {"\u672b\u5c3e\u306b\u8ffd\u52a0", "addLast"}, {"\u5148\u982d\u3092\u524a\u9664", "removeFirst"}, {"\u672b\u5c3e\u3092\u524a\u9664", "removeLast"}, {"\u56db\u5247\u6f14\u7b97", "calc"}, {"\u5e74\u9f62", "age"}, {"\u6240\u8981\u6642\u9593", "requiredTime"}, {"\u30d1\u30c7\u30a3\u30f3\u30b0", "padding"}, {"\u4ee5\u4e0a\uff08\u8b66\u544a\uff09", "ge_warning"}, {"\u4ee5\u4e0a(\u8b66\u544a)", "ge_warning"}, {"\u4ee5\u4e0b\uff08\u8b66\u544a\uff09", "le_warning"}, {"\u4ee5\u4e0b(\u8b66\u544a)", "le_warning"}, {"\u3088\u308a\u5927\u304d\u3044\uff08\u8b66\u544a\uff09", "gt_warning"}, {"\u3088\u308a\u5927\u304d\u3044(\u8b66\u544a)", "gt_warning"}, {"\u3088\u308a\u5c0f\u3055\u3044\uff08\u8b66\u544a\uff09", "lt_warning"}, {"\u3088\u308a\u5c0f\u3055\u3044(\u8b66\u544a)", "lt_warning"}, {"\u7b49\u3057\u3044\uff08\u8b66\u544a\uff09", "eq_warning"}, {"\u7b49\u3057\u3044(\u8b66\u544a)", "eq_warning"}, {"\u7b49\u3057\u304f\u306a\u3044\uff08\u8b66\u544a\uff09", "neq_warning"}, {"\u7b49\u3057\u304f\u306a\u3044(\u8b66\u544a)", "neq_warning"}, {"\u7a7a\u767d\u3067\u4e0a\u66f8\u304d", "override"}, {"\u5024\u3092\u4fdd\u6301", "keep"}, {"\u6587\u5b57\u5217\uff08\u30e9\u30f3\u30c0\u30e0\uff09", "random"}, {"\u6587\u5b57\u5217(\u30e9\u30f3\u30c0\u30e0)", "random"}, {"\u30ed\u30b0\u30aa\u30f3ID", "logonId"}, {"\u6240\u5c5e\u30b0\u30eb\u30fc\u30d7", "group"}, {"\u56db\u5247\u6f14\u7b97", "calc"}, {"Java\u30b3\u30fc\u30c9", "javacode"}, {"char", "char"}, {"byte", "byte"}, {"char\uff08\u8b66\u544a\uff09", "char_warning"}, {"byte\uff08\u8b66\u544a\uff09", "byte_warning"}, {"\u4e0b\u9650\u9805\u76ee:\u5fc5\u9808\u3001\u4e0a\u9650\u9805\u76ee:\u5fc5\u9808", "lowerLimitError_upperLimitError"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u5fc5\u9808\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u5fc5\u9808", "lowerLimitError_upperLimitError"}, {"\u4e0b\u9650\u9805\u76ee:\u8b66\u544a\u3001\u4e0a\u9650\u9805\u76ee:\u8b66\u544a", "lowerLimitWarning_upperLimitWarning"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u8b66\u544a\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u8b66\u544a", "lowerLimitWarning_upperLimitWarning"}, {"\u4e0b\u9650\u9805\u76ee:\u8b66\u544a\u3001\u4e0a\u9650\u9805\u76ee:\u5fc5\u9808", "lowerLimitWarning_upperLimitError"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u8b66\u544a\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u5fc5\u9808", "lowerLimitWarning_upperLimitError"}, {"\u4e0b\u9650\u9805\u76ee:\u5fc5\u9808\u3001\u4e0a\u9650\u9805\u76ee:\u8b66\u544a", "lowerLimitError_upperLimitWarning"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u5fc5\u9808\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u8b66\u544a", "lowerLimitError_upperLimitWarning"}, {"\u4e0b\u9650\u9805\u76ee:\u306a\u3057\u3001\u4e0a\u9650\u9805\u76ee:\u5fc5\u9808", "lowerLimitNone_upperLimitError"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u306a\u3057\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u5fc5\u9808", "lowerLimitNone_upperLimitError"}, {"\u4e0b\u9650\u9805\u76ee:\u306a\u3057\u3001\u4e0a\u9650\u9805\u76ee:\u8b66\u544a", "lowerLimitNone_upperLimitWarning"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u306a\u3057\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u8b66\u544a", "lowerLimitNone_upperLimitWarning"}, {"\u4e0b\u9650\u9805\u76ee:\u5fc5\u9808\u3001\u4e0a\u9650\u9805\u76ee:\u306a\u3057", "lowerLimitError_upperLimitNone"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u5fc5\u9808\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u306a\u3057", "lowerLimitError_upperLimitNone"}, {"\u4e0b\u9650\u9805\u76ee:\u8b66\u544a\u3001\u4e0a\u9650\u9805\u76ee:\u306a\u3057", "lowerLimitWarning_upperLimitNone"}, {"\u4e0b\u9650\u9805\u76ee\uff1a\u8b66\u544a\u3001\u4e0a\u9650\u9805\u76ee\uff1a\u306a\u3057", "lowerLimitWarning_upperLimitNone"}, {"\u81ea\u30e2\u30c7\u30eb", "thisModel"}, {"\u53c2\u7167\u5148\u306e\u30e2\u30c7\u30eb", "refModel"}, {"\u6607\u9806", "ascending"}, {"\u964d\u9806", "descending"}, {"\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9", "listbox"}, {"\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9", "checkbox"}, {"\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3", "radiobutton"}, {"[\u63a5\u982d\u8a9e][\u533a\u5207\u6587\u5b57][\u9806\u5e8f]", "prefix_delimiter_sequence"}, {"\u5e73\u6210\u25cb\u25cb[\u533a\u5207\u6587\u5b57][\u9806\u5e8f]", "wareki_delimiter_sequence"}, {"\u5e73\u25cb\u25cb[\u533a\u5207\u6587\u5b57][\u9806\u5e8f]", "warekiOneCharacter_delimiter_sequence"}, {"H\u25cb\u25cb[\u533a\u5207\u6587\u5b57][\u9806\u5e8f]", "warekiAlphabet_delimiter_sequence"}, {"YYYY[\u533a\u5207\u6587\u5b57][\u9806\u5e8f]", "yyyy_delimiter_sequence"}, {"[\u63a5\u982d\u8a9e][\u533a\u5207\u6587\u5b57][\u81ea\u52d5\u63a1\u756a]", "prefix_delimiter_sequence"}, {"\u5e73\u6210\u25cb\u25cb[\u533a\u5207\u6587\u5b57][\u81ea\u52d5\u63a1\u756a]", "wareki_delimiter_sequence"}, {"\u5e73\u25cb\u25cb[\u533a\u5207\u6587\u5b57][\u81ea\u52d5\u63a1\u756a]", "warekiOneCharacter_delimiter_sequence"}, {"H\u25cb\u25cb[\u533a\u5207\u6587\u5b57][\u81ea\u52d5\u63a1\u756a]", "warekiAlphabet_delimiter_sequence"}, {"YYYY[\u533a\u5207\u6587\u5b57][\u81ea\u52d5\u63a1\u756a]", "yyyy_delimiter_sequence"}, {"1\u6708\u958b\u59cb", "startInJanuary"}, {"2\u6708\u958b\u59cb", "startInFebruary"}, {"3\u6708\u958b\u59cb", "startInMarch"}, {"4\u6708\u958b\u59cb", "startInApril"}, {"5\u6708\u958b\u59cb", "startInMay"}, {"6\u6708\u958b\u59cb", "startInJune"}, {"7\u6708\u958b\u59cb", "startInJuly"}, {"8\u6708\u958b\u59cb", "startInAugust"}, {"9\u6708\u958b\u59cb", "startInSeptember"}, {"10\u6708\u958b\u59cb", "startInOctober"}, {"11\u6708\u958b\u59cb", "startInNovember"}, {"12\u6708\u958b\u59cb", "startInDecember"}, {"\u5165\u529b\u6b04\u306e\u307f", "inputFieldOnly"}, {"\u5165\u529b\u6b04\u3092\u56f2\u3046\u9818\u57df", "inputFieldArea"}, {"\u4e21\u65b9", "inputFieldAndArea"}, {"\u5de6\u5bc4\u305b", "leftAlignment"}, {"\u30bb\u30f3\u30bf\u30ea\u30f3\u30b0", "centering"}, {"\u53f3\u5bc4\u305b", "rightAlignment"}, {"\u4e0a\u5bc4\u305b", "top"}, {"\u4e0b\u5bc4\u305b", "bottom"}, {"\u7121\u8996\u3059\u308b", "ignore"}, {"\u30bf\u30d6\u30ad\u30fc\u6271\u3044", "asTabkey"}, {"\u30dc\u30bf\u30f3\u62bc\u4e0b", "pressButton"}, {"\u30aa\u30f3", "on"}, {"\u30aa\u30d5\uff08\u82f1\u8a9e\u30e2\u30fc\u30c9\uff09", "off"}, {"\u7121\u52b9", "invalid"}, {"\u6607\u9806\uff0f\u964d\u9806", "ascending_descending"}, {"\uff08\u5e73\u6210\u25cb\u5e74\uff09", "wareki_y"}, {"\uff08\u5e73\u6210\u25cb\u5e74\u25cb\u6708\uff09", "wareki_ym"}, {"\uff08\u5e73\u6210\u25cb\u5e74\u25cb\u6708\u25cb\u65e5\uff09", "wareki_ymd"}, {"\uff08\u25cb\u66dc\u65e5\uff09", "dayOfWeek"}, {"\uff08\u6708\uff09[\u66dc\u65e5\u30921\u6587\u5b57\u3067\u8868\u73fe]", "oneCharacterDayOfWeek"}, {"\uff08\u5e73\u6210\u25cb\u5e74\u25cb\u6708\u25cb\u65e5\u25cb\u66dc\u65e5\uff09", "wareki_ymd_dayOfWeek"}, {"\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2", "textarea"}, {"\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2(\u30ea\u30c3\u30c1)", "rtextarea"}, {"\u30d1\u30b9\u30ef\u30fc\u30c9", "password"}, {"\u6570\u5b57\u5f62\u5f0f", "number"}, {"\u81ea\u52d5\u63a1\u756a\u4e3b\u30ad\u30fc", "sequence"}, {"\u4eba\u5de5\u30ad\u30fc", "artificial"}, {"\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9", "mailaddress"}, {"URL", "URL"}, {"\u96fb\u8a71\u756a\u53f7", "telephone"}, {"\u5408\u8a08", "sum"}, {"\u5408\u8a08\u5024", "sum"}, {"\u500b\u6570", "count"}, {"\u5e73\u5747", "average"}, {"\u6700\u5927", "max"}, {"\u6700\u5c0f", "min"}, {"\u7a4d", "moment"}, {"\u4e2d\u592e", "median"}, {"\u6700\u983b", "mode"}, {"\u6a19\u6e96\u504f\u5dee", "deviation"}, {"\u6bcd\u96c6\u56e3\u306e\u6a19\u6e96\u504f\u5dee", "deviationOfPopulation"}, {"\u5206\u6563", "variance"}, {"\u6bcd\u96c6\u56e3\u306e\u5206\u6563", "varianceOfPopulation"}, {"\u30e1\u30b8\u30e3\u30fc", "major"}, {"\u30e1\u30b8\u30e3\u30fc(\u5408\u8a08)", "major(sum)"}, {"\u30e1\u30b8\u30e3\u30fc(\u5408\u8a08\u5024)", "major(sum)"}, {"\u30e1\u30b8\u30e3\u30fc(\u500b\u6570)", "major(count)"}, {"\u30e1\u30b8\u30e3\u30fc(\u5e73\u5747)", "major(average)"}, {"\u30e1\u30b8\u30e3\u30fc(\u6700\u5927)", "major(max)"}, {"\u30e1\u30b8\u30e3\u30fc(\u6700\u5c0f)", "major(min)"}, {"\u30e1\u30b8\u30e3\u30fc(\u7a4d)", "major(moment)"}, {"\u30e1\u30b8\u30e3\u30fc(\u4e2d\u592e)", "major(median)"}, {"\u30e1\u30b8\u30e3\u30fc(\u6700\u983b)", "major(mode)"}, {"\u30e1\u30b8\u30e3\u30fc(\u6a19\u6e96\u504f\u5dee)", "major(deviation)"}, {"\u30e1\u30b8\u30e3\u30fc(\u6bcd\u96c6\u56e3\u306e\u6a19\u6e96\u504f\u5dee)", "major(deviationOfPopulation)"}, {"\u30e1\u30b8\u30e3\u30fc(\u5206\u6563)", "major(variance)"}, {"\u30e1\u30b8\u30e3\u30fc(\u6bcd\u96c6\u56e3\u306e\u5206\u6563)", "major(varianceOfPopulation)"}, {"\u30c7\u30a3\u30e1\u30f3\u30b8\u30e7\u30f3", "dimension"}, {"\u30c7\u30a3\u30e1\u30f3\u30b8\u30e7\u30f31", "dimension1"}, {"\u30c7\u30a3\u30e1\u30f3\u30b8\u30e7\u30f32", "dimension2"}, {"\u53c2\u7167\u30e2\u30c7\u30eb\u306e\u4e3b\u30ad\u30fc", "pkeyOfRefmodel"}, {"\u9023\u52d5\u3059\u308b\u9805\u76ee\u540d", "relatedItemname"}, {"\u8868\u793a\u512a\u5148\u5ea6", "priority"}, {"ID", "ID"}, {"\u5185\u5bb9", "content"}, {"\u53c2\u7167\u5148\u30e2\u30c7\u30eb\u306e\u56fa\u5b9a\u30bd\u30fc\u30c8\u30ad\u30fc", "fixedSortkeyOfRefmodel"}, {"\u4e0a\u66f8\u304d", "overwrite"}, {"\u8ffd\u8a18", "append"}, {"\u6587\u5b57\u5217", "string"}, {"\u90f5\u4fbf\u756a\u53f7", "zipcode"}, {"\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9", "mailaddress"}, {"URL", "URL"}, {"\u30d5\u30a1\u30a4\u30eb\u540d", "filename"}, {"\u6574\u6570", "number"}, {"1\u30d0\u30a4\u30c8\u6574\u6570", "byte"}, {"2\u30d0\u30a4\u30c8\u6574\u6570", "short"}, {"4\u30d0\u30a4\u30c8\u6574\u6570", "integer"}, {"8\u30d0\u30a4\u30c8\u6574\u6570", "long"}, {"4\u30d0\u30a4\u30c8\u6d6e\u52d5\u5c0f\u6570\u70b9", "float"}, {"8\u30d0\u30a4\u30c8\u6d6e\u52d5\u5c0f\u6570\u70b9", "double"}, {"\u65e5\u4ed8", "date"}, {"\u65e5\u4ed8\u3068\u6642\u9593", "dateTime"}, {"\u6642\u9593", "time"}, {"\u4ed6\u306e", "reference"}, {"\u53c2\u7167\u9023\u52d5", "lookup"}, {"\u9023\u52d5", "lookup"}, {"\u4ed6\u306e\u30b9\u30c8\u30a2\u30e2\u30c7\u30eb\u306e\u53c2\u7167", "reference"}, {"\u30de\u30b9\u30bf\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9)", "referenceMaster_listbox"}, {"\u30de\u30b9\u30bf\u30fc\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9)", "referenceMaster_listbox"}, {"\u30de\u30b9\u30bf\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3)", "referenceMaster_radiobutton"}, {"\u30de\u30b9\u30bf\u30fc\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3)", "referenceMaster_radiobutton"}, {"\u30de\u30b9\u30bf\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9)", "referenceMaster_checkbox"}, {"\u30de\u30b9\u30bf\u30fc\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9)", "referenceMaster_checkbox"}, {"\u4ed6\u306e\u30b9\u30c8\u30a2\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30b3\u30f3\u30dc\u30dc\u30c3\u30af\u30b9)", "reference_listbox"}, {"\u4ed6\u306e\u30b9\u30c8\u30a2\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3)", "reference_radiobutton"}, {"\u4ed6\u306e\u30b9\u30c8\u30a2\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9)", "reference_checkbox"}, {"\u4ed6\u306e\u30b9\u30c8\u30a2\u30e2\u30c7\u30eb\u306e\u53c2\u7167(\u691c\u7d22\u753b\u9762)", "reference_searchWindow"}, {"\u4ed6\u306e\u30b9\u30c8\u30a2\u30e2\u30c7\u30eb\u306e\u53c2\u7167\u9023\u52d5", "reference_lookup"}, {"(\u7e70\u308a\u8fd4\u3057\u9805\u76ee\u306e\u30b3\u30f3\u30c6\u30ca)", "container"}, {"(\u7e70\u308a\u8fd4\u3057\u9805\u76ee\u30b3\u30f3\u30c6\u30ca\u7528\u306eID)", "containerId"}, {"\u56fa\u5b9a\u5024(\u4f5c\u6210\u3057\u305f\u30e6\u30fc\u30b6\u306eID)", "createuserid"}, {"\u56fa\u5b9a\u5024(\u66f4\u65b0\u3057\u305f\u30e6\u30fc\u30b6\u306eID)", "updateuserid"}, {"\u56fa\u5b9a\u5024(\u4f5c\u6210\u3057\u305f\u65e5\u4ed8\u3068\u6642\u9593)", "createdatetime"}, {"\u56fa\u5b9a\u5024(\u66f4\u65b0\u3057\u305f\u65e5\u4ed8\u3068\u6642\u9593)", "updatedatetime"}, {"\u56fa\u5b9a\u5024", "fixed"}, {"\u8868\u793a\u3059\u308b", "displayed"}, {"\u8868\u793a\u3057\u306a\u3044", "hide"}, {"\u53ef", "enable"}, {"\u4e0d\u53ef", "disable"}, {"\u5229\u7528\u3059\u308b", "use"}, {"\u5229\u7528\u3057\u306a\u3044", "notUse"}, {"\u6a19\u6e96", "default"}, {"\u5916\u90e8\u8a8d\u8a3c(HttpServletRequest#getRemoteUser() \u3092\u5229\u7528)", "remoteuser"}, {"\u5916\u90e8\u8a8d\u8a3c(LDAP)", "ldap"}, {"\u5916\u90e8\u8a8d\u8a3c(Active Directory)", "activeDirectory"}, {"\u305d\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8", "zeroLevel"}, {"1\u3064\u4e0b", "oneLevel"}, {"\u30b5\u30d6\u30c4\u30ea\u30fc", "subtree"}, {"\u30c6\u30ad\u30b9\u30c8\u306e\u307f\uff08\u6a19\u6e96\uff09", "textonly"}, {"Tika", "Tika"}, {"\u5c0f", "small"}, {"\u4e2d", "medium"}, {"\u5927", "large"}, {"\u30a2\u30a4\u30b3\u30f3", "icon"}, {"\u30dc\u30bf\u30f3", "button"}, {"\u30d5\u30a9\u30fc\u30ab\u30b9", "focus"}, {"\u533a\u5207\u308a\u6587\u5b57\u304c\u8a18\u53f7\u306e\u3068\u304d\u5168\u89d2\u534a\u89d2\u3092\u7121\u8996\u3059\u308b", "ignore"}, {"HTML\u30bd\u30fc\u30b9", "HTML"}, {"\u30dc\u30bf\u30f3\u62bc\u4e0b\u6642", "pushButton"}, {"\u51e6\u7406\u5b8c\u4e86\u6642", "atCompletionOfProcessing"}, {"\u30e1\u30fc\u30eb\u9001\u4fe1\u30dc\u30bf\u30f3", "sendmailButton"}, {"HSQLDB(\u7d44\u307f\u8fbc\u307fDB)", "hsqldb"}, {"PostgreSQL", "postgresql"}, {"Oracle 9i", "oracle9i"}, {"Oracle 10g/11g", "oracle10g/11g"}, {"Oracle 12c", "oracle12c"}, {"SQLServer2005/2008/2012/2014", "sqlserver2005/2008/2012/2014"}, {"DB2", "db2"}, {"DB2 AS/400", "db2_AS/400"}, {"MySQL", "mysql"}, {"MySQL 6", "mysql6"}, {"DBMaster", "dbmaster"}, {"DBMaker", "dbmaker"}, {"\u96a0\u3057\u9805\u76ee", "hiddenItem"}, {"\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9", "download"}, {"\u30c7\u30d5\u30a9\u30eb\u30c8", "default"}, {"\u30c6\u30ad\u30b9\u30c8", "text"}, {"HTML\u30bd\u30fc\u30b9", "HTML"}};

    public R8RepositoryConverter() {
        for (String[] s : conversionTable) {
            this.dic.put(s[0], s[1]);
        }
    }

    public String get(String key) {
        return this.dic.get(key);
    }

    public void customizeProjectFolder(Properties prop) {
        String v = prop.getProperty("project/environment/@browserCacheMaxAge");
        if (v != null && v.endsWith("\u65e5")) {
            v = v.substring(0, v.length() - 1);
            prop.setProperty("project/environment/@browserCacheMaxAge", v);
        }
        prop.removeProperty("project/environment/preference/@layoutType");
        prop.removeProperty("project/environment/preference/@layoutType_2");
        Set keySet = prop.stringPropertyNames();
        for (String key : keySet) {
            if (key.startsWith("project/message/")) continue;
            String value = prop.getProperty(key);
            String n_value = null;
            if (n_value == null) {
                n_value = this.dic.get(value);
            }
            if (n_value == null) {
                n_value = value;
            }
            prop.setProperty(key, n_value);
        }
        String database_type = prop.getProperty("project/environment/database/@database");
        if (StringUtils.isBlank((CharSequence)database_type)) {
            database_type = "hsqldb";
        }
        database_type = RepositoryManagerUtil.checkOldExpression(database_type, logger);
        prop.setProperty("project/environment/database/@database", database_type);
        prop.setProperty("project/environment/@httpsessionstoretype", "HTTP Session");
    }

    public void convertPropertiesValue4Model(String modelId, Properties prop) {
        Set keySet = prop.stringPropertyNames();
        for (String key : keySet) {
            String value = prop.getProperty(key);
            String n_value = null;
            if (key.startsWith("printlayout/filename") && key.endsWith("_2")) {
                if (value.startsWith("\u4e00\u89a7\u8868\u793a \u5168\u4ef6\u306e\u307f")) {
                    n_value = value.replace("\u4e00\u89a7\u8868\u793a \u5168\u4ef6\u306e\u307f", "showList");
                } else if (value.startsWith("\u4e00\u89a7\u8868\u793a")) {
                    n_value = value.replace("\u4e00\u89a7\u8868\u793a", "showList");
                } else if (value.startsWith("\u5e33\u7968\u753b\u9762")) {
                    n_value = value.replace("\u5e33\u7968\u753b\u9762", "reportList");
                } else if (value.startsWith("\u8a73\u7d30\u8868\u793a")) {
                    n_value = value.replace("\u8a73\u7d30\u8868\u793a", "show");
                } else if (value.startsWith("\u65b0\u898f\u767b\u9332")) {
                    n_value = value.replace("\u65b0\u898f\u767b\u9332", "insert");
                } else if (value.startsWith("\u30b3\u30d4\u30fc\u767b\u9332")) {
                    n_value = value.replace("\u30b3\u30d4\u30fc\u767b\u9332", "copy");
                } else if (value.startsWith("\u66f4\u65b0")) {
                    n_value = value.replace("\u66f4\u65b0", "show");
                } else {
                    System.out.println("[Internal Error] illegal pattern is detected. " + key + "=" + value);
                }
                if (n_value != null && n_value.indexOf("JExcelAPI") > 0) {
                    n_value = n_value.replace("JExcelAPI", "POI");
                }
            } else if (!(key.equals("model/@id") || key.equals("model/@description") || key.equals("model/wizardLabel") || key.endsWith("Label") || key.equals("model/foreignkey/display/@label") || key.equals("model/foreignkey/show/link/@showLabel") || key.equals("model/foreignkey/showlist/link/@showLabel") || key.startsWith("action/userDefinedButton") && key.endsWith("@label") || key.startsWith("model/sendmail/") && key.endsWith("@label") || key.startsWith("model/sendmail") && key.endsWith("@bcc") || key.startsWith("model/sendmail") && key.endsWith("@cc") || key.startsWith("model/sendmail") && key.endsWith("@from") || key.startsWith("model/sendmail") && key.endsWith("@mailhost") || key.startsWith("model/sendmail") && key.endsWith("@name") || key.startsWith("model/sendmail") && key.endsWith("@subject") || key.startsWith("model/sendmail") && key.endsWith("@to") || key.startsWith("model/sendmail/") && key.endsWith("@attachmentFilename") || key.startsWith("model/sendmail") && key.endsWith("jobdesc") || key.startsWith("model/sendmail") && key.indexOf("/jobrule") > 0 || key.startsWith("presentation//displaytotalratio") || key.equals("presentation/displaymodel/@showListFixedItem") || key.equals("presentation/displaymodel/displaytext/@content") || key.equals("presentation/layout/panel/displaycondition/@downloadbuttonlabel") || key.startsWith("presentation/layout/panel/link") && key.endsWith("@label") || key.startsWith("presentation/layout/panel/foreignmodel/displaytext") || key.startsWith("presentation/panel/@name") || key.startsWith("presentation/panel/displaytext/@style") || key.startsWith("presentation[@idref") && key.endsWith("@label") || key.startsWith("printlayout/filename") || key.startsWith("printlayout/outputfilename"))) {
                if (key.equals("model/@copyinsertshow") && ("\u25cb".equals(value) || "\u25ef".equals(value))) {
                    n_value = "\u30b3\u30d4\u30fc\u767b\u9332\u3078";
                } else if (key.startsWith("action/userDefinedButton") && key.endsWith("/@actiontype")) {
                    if (value.equals("\u691c\u7d22\u753b\u9762")) {
                        n_value = "searchScreen";
                    } else if (value.equals("\u4e00\u89a7\u8868\u793a\u753b\u9762")) {
                        n_value = "showListScreen";
                    } else if (value.equals("\u4e00\u89a7\u8868\u793a\u753b\u9762(\u884c\u6bce)")) {
                        n_value = "showListScreenPerRecord";
                    } else if (value.equals("\u4e00\u89a7\u8868\u793a\u753b\u9762(\u4e00\u62ec)")) {
                        n_value = "showListScreenProcessAll";
                    } else if (value.equals("\u8a73\u7d30\u8868\u793a\u753b\u9762")) {
                        n_value = "showScreen";
                    } else if (value.equals("\u65b0\u898f\u767b\u9332\u753b\u9762")) {
                        n_value = "insertScreen";
                    } else if (value.equals("\u66f4\u65b0\u753b\u9762")) {
                        n_value = "updateScreen";
                    } else if (value.equals("\u5e33\u7968\u753b\u9762")) {
                        n_value = "reportListScreen";
                    }
                } else if (StringUtils.isNotBlank((CharSequence)value) && n_value == null) {
                    n_value = this.dic.get(value);
                }
            }
            if (StringUtils.isBlank(n_value)) {
                n_value = value;
            }
            prop.setProperty(key, n_value);
        }
        String v = prop.getProperty("presentation/@mobile");
        if ("featurePhone".equals(v)) {
            prop.setProperty("presentation/@mobile", "smartPhone");
        }
    }

    public void convertPropertiesValue4Modelitem(String modelId, Properties prop) {
        Set keySet = prop.stringPropertyNames();
        for (String key : keySet) {
            String value;
            String n_value = this.convertPropertiesValue4Modelitem0(modelId, key, value = prop.getProperty(key));
            if (StringUtils.isBlank((CharSequence)n_value)) {
                n_value = value;
            }
            prop.setProperty(key, n_value);
        }
    }

    public String convertPropertiesValue4Modelitem0(String modelId, String key, String value) {
        String n_value = null;
        if (key.equals("model/modelitem/notnull") || key.equals("model/modelitem/notnullForSelect") || key.startsWith("model/modelitem/chartype")) {
            if ("\u25cb".equals(value) || "\u25ef".equals(value)) {
                n_value = "error";
            } else if (StringUtils.isNotBlank((CharSequence)value)) {
                n_value = this.dic.get(value);
            }
        } else if (key.startsWith("model/modelitem/relation/restrictparamlist/restrictparam/@cond")) {
            if ("\u4e0a".equals(value)) {
                n_value = "upper";
            } else if ("\u4e0b".equals(value)) {
                n_value = "lower";
            } else if (StringUtils.isNotBlank((CharSequence)value)) {
                n_value = this.dic.get(value);
            }
        } else if (key.startsWith("model/modelitem/relation/restrictparamlist/restrictparam/@source")) {
            if ("\u56fa\u5b9a\u5024".equals(value)) {
                n_value = "fixedValue";
            } else if ("\u9805\u76ee\u540d".equals(value)) {
                n_value = "itemname";
            }
        } else if (key.equals("presentation/displayitem/@type") && "\u6570\u5b57".equals(value)) {
            n_value = "numberformat";
        } else if (key.equals("presentation/displayitem/@type_ext") && "\u6570\u5b57".equals(value)) {
            n_value = "numberformat";
        } else if (!(key.equals("model/modelitem/@name") || key.equals("model/modelitem/@label") || key.equals("model/modelitem/@labelWithoutLayout") || key.equals("model/modelitem/@note") || key.startsWith("model/inititem/text") || key.equals("model/modelitem/regexp") || key.equals("model/modelitem/autocalc_2") || key.startsWith("model/modelitem/@rdb") || key.startsWith("model/modelitem/generic_check") && !key.endsWith("_2") || key.equals("model/datalock/@name") || key.startsWith("action/condition/@implicit") && !key.endsWith("_2") || key.startsWith("action/condition/@exceptPermaction") || key.equals("action/view/item/@aftercontent") || key.equals("action/view/item/@beforecontent") || key.equals("presentation/displayitem/@actionbuttonlabel") || key.equals("presentation/displayitem/@poststring") || key.equals("presentation/displayitem/@prestring") || key.equals("presentation/displayitem/@paddingForSearch") || key.startsWith("presentation/displayitem/@multipleSeparator") || key.startsWith("presentation/displayitem/@numberformat") || key.startsWith("presentation/displayitem/@placeholder") || key.startsWith("presentation/displayitem/@labelname") || key.startsWith("presentation/displayitem/@tips") || key.startsWith("presentation/displayitem/@tooltip") || key.startsWith("presentation/displayitem/@subformat") || key.startsWith("presentation/displayitem/@style") || key.startsWith("presentation/displayitem/@ruby") || key.startsWith("presentation/displayitem/displaytext") || key.startsWith("presentation/displaymodel/link") && key.endsWith("@label") || key.equals("presentation/displayitem/@valueClass") || key.startsWith("presentation/displayitem/@type") && key.indexOf("count_2") > 0 || !StringUtils.isNotBlank((CharSequence)value) || n_value != null)) {
            n_value = this.dic.get(value);
        }
        return n_value;
    }

    public void convertPropertiesValue4DotFolders(Properties prop) {
        Set keySet = prop.stringPropertyNames();
        for (String key : keySet) {
            String value = prop.getProperty(key);
            String n_value = null;
            if (!key.equals("model/displayitemgroup/@label") && !key.equals("acl/permission/@content") && !key.equals("acl/principal/@content") && StringUtils.isNotBlank((CharSequence)value)) {
                n_value = this.dic.get(value);
            }
            if (n_value == null) {
                n_value = value;
            }
            prop.setProperty(key, n_value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertSelectorValue4Menu(File file) {
        File nfile = new File(file.getAbsolutePath() + ".tmp");
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(nfile), "utf-8")));
            Object line = null;
            while ((line = reader.readLine()) != null) {
                int ptr = ((String)line).lastIndexOf("=");
                if (ptr > 0) {
                    String key = ((String)line).substring(0, ptr).trim();
                    String value = ((String)line).substring(ptr + 1).trim();
                    if ("\u25cb".equals(value)) {
                        value = "true";
                    }
                    line = key + "=" + value;
                }
                writer.println((String)line);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                file.delete();
                nfile.renameTo(file);
            }
            catch (IOException iOException) {}
        }
    }

    public void forceConvert(String path) {
        File[] lists;
        File srcFolder = new File(path);
        String r8folderPath = path + ".r8";
        File r8folder = new File(r8folderPath);
        try {
            if (r8folder.exists()) {
                FileUtils.deleteDirectory((File)r8folder);
            }
            FileUtils.forceMkdir((File)r8folder);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return;
        }
        for (File src : lists = srcFolder.listFiles()) {
            String name = src.getName();
            if (src.isDirectory()) {
                File nfolder = new File(r8folderPath + File.separator + name);
                if (name.startsWith(".")) {
                    if (!name.startsWith(".project_outerlink") && !name.equals(".menu") && !name.equals(".userDefinedItem")) continue;
                    try {
                        FileUtils.copyDirectory((File)src, (File)nfolder);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    FileUtils.forceMkdir((File)nfolder);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.forceConvert_modelContainer(src, nfolder);
                continue;
            }
            if (name.equals("project.txt")) {
                Properties prop = PropertiesUtil.readProperties(src);
                this.customizeProjectFolder(prop);
                PropertiesUtil.writeProperties(prop, new File(r8folderPath + File.separator + "project.txt"));
                continue;
            }
            if (!name.endsWith(".txt")) continue;
            try {
                File dest = new File(r8folderPath + File.separator + name);
                FileUtils.copyFile((File)src, (File)dest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileUtils.deleteDirectory((File)srcFolder);
            r8folder.renameTo(srcFolder);
        }
        catch (IOException e) {
            logger.error("Failed to swap r8 repository. " + e.getMessage());
        }
        this.reconstructJfcmenu(srcFolder);
    }

    private void forceConvert_modelContainer(File srcModelFolder, File destModelFolder) {
        File[] lists;
        for (File src : lists = srcModelFolder.listFiles()) {
            String modelId;
            String name = src.getName();
            String string = modelId = name.endsWith(".txt") ? name.substring(0, name.length() - ".txt".length()) : name;
            if (src.isDirectory()) {
                File nfolder = new File(destModelFolder.getAbsolutePath() + File.separator + name);
                try {
                    FileUtils.forceMkdir((File)nfolder);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.forceConvert_model(modelId, src, nfolder);
                continue;
            }
            if (!name.endsWith(".txt")) continue;
            Properties prop = PropertiesUtil.readProperties(src);
            this.convertPropertiesValue4Model(modelId, prop);
            PropertiesUtil.writeProperties(prop, new File(destModelFolder.getAbsolutePath() + File.separator + name));
        }
    }

    private void forceConvert_model(String modelId, File srcModelFolder, File destModelFolder) {
        File[] lists;
        for (File src : lists = srcModelFolder.listFiles()) {
            String name = src.getName();
            if (!src.isDirectory()) continue;
            File nfolder = new File(destModelFolder.getAbsolutePath() + File.separator + name);
            try {
                FileUtils.forceMkdir((File)nfolder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (name.startsWith(".")) {
                this.forceConvert_others(modelId, src, nfolder);
                continue;
            }
            this.forceConvert_modelitem(modelId, src, nfolder);
        }
    }

    private void forceConvert_others(String modelId, File srcModelFolder, File destModelFolder) {
        File[] lists;
        for (File src : lists = srcModelFolder.listFiles()) {
            String name = src.getName();
            if (!name.endsWith(".txt")) continue;
            Properties prop = PropertiesUtil.readProperties(src);
            this.convertPropertiesValue4DotFolders(prop);
            PropertiesUtil.writeProperties(prop, new File(destModelFolder.getAbsolutePath() + File.separator + name));
        }
    }

    private void forceConvert_modelitem(String modelId, File srcModelFolder, File destModelFolder) {
        File[] lists;
        for (File src : lists = srcModelFolder.listFiles()) {
            String name = src.getName();
            if (!name.endsWith(".txt")) continue;
            Properties prop = PropertiesUtil.readProperties(src);
            this.convertPropertiesValue4Modelitem(modelId, prop);
            PropertiesUtil.writeProperties(prop, new File(destModelFolder.getAbsolutePath() + File.separator + name));
        }
    }

    public void reconstructJfcmenu(File baseDest) {
        File[] files;
        File jfcMenuFolder = new File(baseDest.getAbsolutePath() + File.separator + ".menu");
        File jfcMenuOrderFolder = new File(jfcMenuFolder.getAbsolutePath() + File.separator + ".menuorder");
        if (!jfcMenuFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)jfcMenuFolder);
            }
            catch (IOException e) {
                return;
            }
            try {
                FileUtils.forceMkdir((File)jfcMenuOrderFolder);
            }
            catch (IOException e) {
                return;
            }
        }
        File projectfile = new File(baseDest.getAbsolutePath() + File.separator + "project.txt");
        Properties pprop = PropertiesUtil.readProperties(projectfile);
        Properties n_project = new Properties();
        Properties n_project_order = new Properties();
        boolean changeFlag = false;
        for (String key : pprop.stringPropertyNames()) {
            if (!key.startsWith("menutab[") && !key.startsWith("project/environment/menu/@") && !key.startsWith("project/environment/menu/")) continue;
            String value = pprop.getProperty(key);
            if (key.startsWith("menutab[") && key.endsWith("/@order") || key.startsWith("project/environment/menu/@") && key.endsWith("_2") || key.startsWith("project/environment/menu/") && key.endsWith("_3")) {
                n_project_order.setProperty(key, value);
            } else {
                n_project.setProperty(key, value);
            }
            pprop.removeProperty(key);
            changeFlag = true;
        }
        if (changeFlag) {
            PropertiesUtil.writeProperties(pprop, projectfile);
            PropertiesUtil.writeProperties(n_project, new File(jfcMenuFolder.getAbsolutePath() + File.separator + "__project.txt"));
            PropertiesUtil.writeProperties(n_project_order, new File(jfcMenuOrderFolder.getAbsolutePath() + File.separator + "__project.txt"));
        } else {
            File f2;
            File f1 = new File(jfcMenuFolder.getAbsolutePath() + File.separator + "__project.txt");
            if (!f1.exists()) {
                try {
                    FileUtils.touch((File)f1);
                }
                catch (IOException key) {
                    // empty catch block
                }
            }
            if (!(f2 = new File(jfcMenuOrderFolder.getAbsolutePath() + File.separator + "__project.txt")).exists()) {
                try {
                    FileUtils.touch((File)f2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (File file : files = baseDest.listFiles()) {
            if (!file.isDirectory() || file.getName().startsWith("jfcDesigner")) continue;
            Collection mfiles = FileUtils.listFiles((File)file, (String[])new String[]{"txt"}, (boolean)false);
            for (File modelfile : mfiles) {
                changeFlag = false;
                Properties mprop = PropertiesUtil.readProperties(modelfile);
                Properties n_mprop = new Properties();
                Properties n_mprop_order = new Properties();
                String id = mprop.getProperty("model/@id");
                if (StringUtils.isBlank((CharSequence)id)) continue;
                for (String key : mprop.stringPropertyNames()) {
                    if (!key.startsWith("action/@menu") && !key.startsWith("model/@menu")) continue;
                    String value = mprop.getProperty(key);
                    if (key.startsWith("action/@menuorder") || key.equals("model/@menuorder")) {
                        n_mprop_order.setProperty(key, value);
                    } else {
                        n_mprop.setProperty(key, value);
                    }
                    mprop.removeProperty(key);
                    changeFlag = true;
                }
                if (!changeFlag) continue;
                PropertiesUtil.writeProperties(mprop, modelfile);
                PropertiesUtil.writeProperties(n_mprop, new File(jfcMenuFolder.getAbsolutePath() + File.separator + id + ".txt"));
                PropertiesUtil.writeProperties(n_mprop_order, new File(jfcMenuOrderFolder.getAbsolutePath() + File.separator + id + ".txt"));
            }
        }
    }
}

