/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.repository;

import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.tools.repository.RepositoryKey;
import jp.jasminesoft.util.ResourceManager;

public class RepositoryItem {
    private String name;
    private String classify_res_key;
    private String title_res_key;
    private String subtitle_res_key;
    private String desc_res_key;
    private boolean isMust;
    private boolean isOptional;
    private boolean isDeprecated;
    private boolean isMultiple;
    private boolean isMatrix;
    private boolean underConstruction;
    private List<RepositoryKey> keyList = new ArrayList<RepositoryKey>();
    private MultipleInformation multiinfo;
    private String releaseNo;

    public String toString() {
        return this.name;
    }

    public RepositoryItem setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RepositoryItem setClassifyResourceKey(String classify_res_key) {
        this.classify_res_key = classify_res_key;
        return this;
    }

    public String getClassifyResourceKey() {
        return this.classify_res_key;
    }

    public String getClassify(ResourceManager rman) {
        return rman.getValue(this.classify_res_key);
    }

    public RepositoryItem setTitleResourceKey(String title_res_key) {
        this.title_res_key = title_res_key;
        return this;
    }

    public String getTitle(ResourceManager rman) {
        return rman.getValue(this.title_res_key);
    }

    public String getTitleResourceKey() {
        return this.title_res_key;
    }

    public RepositoryItem setSubtitleResourceKey(String subtitle_res_key) {
        this.subtitle_res_key = subtitle_res_key;
        return this;
    }

    public String getSubtitle(ResourceManager rman) {
        if (this.subtitle_res_key == null) {
            return null;
        }
        return rman.getValue(this.subtitle_res_key);
    }

    public RepositoryItem setDescriptionResourceKey(String desc_res_key) {
        this.desc_res_key = desc_res_key;
        return this;
    }

    public String getDescription(ResourceManager rman) {
        return rman.getValue(this.desc_res_key);
    }

    public RepositoryItem must() {
        this.isMust = true;
        return this;
    }

    public boolean isMust() {
        return this.isMust;
    }

    public RepositoryItem multiple() {
        this.isMultiple = true;
        this.multiinfo = new MultipleInformation();
        return this;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public RepositoryItem matrix() {
        this.isMatrix = true;
        return this;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    public RepositoryItem option() {
        this.isOptional = true;
        return this;
    }

    public boolean isOption() {
        return this.isOptional;
    }

    public RepositoryItem deprecated() {
        this.isDeprecated = true;
        return this;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public RepositoryItem notImplemented() {
        this.underConstruction = true;
        return this;
    }

    public boolean isValid() {
        return !this.underConstruction;
    }

    public RepositoryItem since(String releaseNo) {
        this.releaseNo = releaseNo;
        return this;
    }

    public String getReleaseNo() {
        return this.releaseNo;
    }

    public RepositoryItem addRepositoryKey(RepositoryKey key) {
        this.keyList.add(key);
        return this;
    }

    public RepositoryKey[] getRepositoryKey() {
        return this.keyList.toArray(new RepositoryKey[this.keyList.size()]);
    }

    public static class MultipleInformation {
        private String header;
        private String lineNumber;
    }
}

