/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.tools.repository.RepositoryDef;
import jp.jasminesoft.jfc.tools.repository.RepositoryIO;
import jp.jasminesoft.jfc.tools.repository.RepositoryItem;
import jp.jasminesoft.jfc.tools.repository.RepositoryKey;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipal;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepositoryManager {
    protected Logger log = LogManager.getLogger(RepositoryManager.class);
    private RepositoryIO rio = RepositoryIO.getInstance();
    private String targetModelId;
    private Map<String, String> projectMap;
    private Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap;
    private Map<String, ModelInfo> modelMap;
    private Map<String, String> modelVersionMap;
    private Map<Integer, Map<String, String>> outerLinkMap;
    private Map<Integer, Map<Integer, Map<String, String>>> principalInfoMap;
    private Map<String, Filterlist> filterlistMap;
    private Map<String, RepositoryItem> repositoryKeyMap;
    private Map<String, RepositoryItem> repositoryNameMap;
    private Map<String, String> menuMap;

    private RepositoryManager() {
        this.init();
    }

    private void init() {
        this.targetModelId = null;
        this.projectMap = new HashMap<String, String>();
        this.authorityPrincipalInfoMap = new TreeMap<Integer, AuthorityPrincipal>();
        this.modelMap = new TreeMap<String, ModelInfo>();
        this.modelVersionMap = new HashMap<String, String>();
        this.outerLinkMap = new TreeMap<Integer, Map<String, String>>();
        this.principalInfoMap = new TreeMap<Integer, Map<Integer, Map<String, String>>>();
        this.filterlistMap = new TreeMap<String, Filterlist>();
        this.repositoryKeyMap = new HashMap<String, RepositoryItem>();
        this.repositoryNameMap = new HashMap<String, RepositoryItem>();
        this.menuMap = new HashMap<String, String>();
        this.rio.loadProjectMap(this.projectMap);
        this.rio.loadAuthorityPrincipalMap(this.authorityPrincipalInfoMap);
        this.rio.loadModelMap(this.modelMap, this.authorityPrincipalInfoMap);
        this.rio.loadModelVersionMap(this.modelVersionMap);
        this.rio.loadProjectOuterlink(this.outerLinkMap, this.principalInfoMap);
        this.rio.loadProjectFilter(this.filterlistMap);
        this.rio.loadMenu(this.menuMap);
        for (RepositoryItem ritem : RepositoryDef.ritems) {
            this.repositoryNameMap.put(ritem.getName(), ritem);
            for (RepositoryKey rkey : ritem.getRepositoryKey()) {
                this.repositoryKeyMap.put(rkey.getKey(), ritem);
            }
        }
    }

    public String getTargetModelId() {
        return this.targetModelId;
    }

    public void setTargetModelId(String targetModelId) {
        this.targetModelId = targetModelId;
    }

    public Map<String, String> getProjectMap() {
        return this.projectMap;
    }

    public Map<String, String> getProjectMapByDomainId(int domainId) {
        HashMap<String, String> _projectMap = new HashMap<String, String>();
        this.rio.loadProjectMap(_projectMap, domainId);
        return _projectMap;
    }

    public Map<String, String> getOuterLinkMap(int lineNo) {
        return this.outerLinkMap.get(lineNo);
    }

    public int sizeOuterLinkMap() {
        return this.outerLinkMap.size();
    }

    public Map<String, ModelInfo> getModelMap() {
        return this.modelMap;
    }

    public Map<String, String> getModelVerisionMap() {
        return this.modelVersionMap;
    }

    public String[] getModelIds() {
        Set<String> modelIdSet = this.modelMap.keySet();
        return modelIdSet.toArray(new String[modelIdSet.size()]);
    }

    public boolean hasModelId(String modelId) {
        return this.modelMap.containsKey(modelId);
    }

    public RepositoryItem getRepositoryItemByKey(String key) {
        return this.repositoryKeyMap.get(key);
    }

    public RepositoryItem getRepositoryItemByName(String name) {
        return this.repositoryNameMap.get(name);
    }

    public Map<String, Filterlist> getFilterlistMap() {
        return this.filterlistMap;
    }

    public Map<String, String> getMenuMap() {
        return this.menuMap;
    }

    public void save() {
    }

    public void saveProjectMap() {
        this.rio.saveProjectMap(this.projectMap);
    }

    public void saveProjectMapByDomainId(int domainId) {
        this.rio.saveProjectMap(this.projectMap, domainId);
    }
}

