/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Javascriptlist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.logging.log4j.Logger;

public abstract class AppSchemaBuilderFileTemplate
extends AppSchemaBuilder {
    public static final String basedir = "template" + File.separator + "appschema" + File.separator;

    public abstract Logger getLog();

    public void readAppSchemaElement(String filename, Project project) {
        this.readAppSchemaElement(filename, null, project);
    }

    public void readAppSchemaElement(String filename, Map<String, Object> map, Project project) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        try {
            String content = VelocityUtils.mergeContent((String)(basedir + filename), map);
            StringReader reader = new StringReader(content);
            if (filename.equals("javascriptlist.xml")) {
                Javascriptlist javascriptlist = new Javascriptlist((Reader)reader);
                project.setJavascriptlist(javascriptlist);
            } else {
                Model ipc = null;
                IAppschemaFactory factory = AppschemaFactory.getFactory();
                if (filename.startsWith("model_")) {
                    ipc = factory.createModel((Reader)reader, project.rGetRContext());
                } else if (filename.startsWith("action_")) {
                    ipc = factory.createAction((Reader)reader, project.rGetRContext());
                } else if (filename.startsWith("presentation_")) {
                    ipc = factory.createPresentation((Reader)reader, project.rGetRContext());
                }
                if (ipc != null) {
                    project.addContent((IProjectChoice)ipc);
                }
            }
        }
        catch (FileNotFoundException e) {
            this.getLog().error(filename + " is not found.");
        }
        catch (Exception e) {
            this.getLog().error(filename + " read error, " + e.getMessage(), (Throwable)e);
        }
    }
}

