/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.gen.appschema.Jfcdomain;
import jp.jasminesoft.jfc.tools.repository.RepositoryIO;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipal;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipalCategory;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo;
import jp.jasminesoft.util.FileUtil;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="CacheFileManager")
public class CacheFileManager {
    private static final Logger log = LogManager.getLogger(CacheFileManager.class);
    private ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private Map<String, FileInfo> fileMap_;
    private String targetDefFileName = null;
    private boolean useCache = true;
    private ElementContainer con = null;
    private RepositoryIO rio = RepositoryIO.getInstance();
    private static final Object IS_SKIP_READING_EXCEL_FILES = "isSkipReadingExcelFiles";
    private static boolean isSkipReadingExcelFiles = false;

    public static String getRepositoryDirectory() {
        return RepositoryIO.getRepositoryDirectory();
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setElementContainer(ElementContainer con) {
        this.con = con;
    }

    public ElementContainer getElementContainer() {
        return this.con;
    }

    public void init() {
        block3: {
            File dir = new File(CacheFileManager.getRepositoryDirectory());
            if (!dir.exists()) {
                dir.mkdirs();
                log.debug(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.createfolder", new Object[]{dir.getPath()}));
            }
            this.fileMap_ = new TreeMap<String, FileInfo>();
            try {
                this.loadFileMap();
            }
            catch (Exception e) {
                this.fileMap_.clear();
                this.removeAllCacheFiles();
                if (e instanceof FileNotFoundException) break block3;
                log.warn(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.CacheFileManager.init"));
            }
        }
    }

    private void loadFileMap() throws Exception {
        File file = new File(CacheFileManager.getRepositoryDirectory(), "filelist.txt");
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        try (BufferedReader in = null;){
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                int ptr = line.indexOf("=");
                if (ptr < 0) continue;
                String filename = line.substring(0, ptr);
                String content = line.substring(ptr + 1);
                if (IS_SKIP_READING_EXCEL_FILES.equals(filename) && Boolean.parseBoolean(content)) {
                    isSkipReadingExcelFiles = true;
                    continue;
                }
                this.fileMap_.put(filename, new FileInfo(content));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFileMap() {
        try (PrintWriter out = null;){
            File file = new File(CacheFileManager.getRepositoryDirectory(), "filelist.txt");
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            if (isSkipReadingExcelFiles) {
                out.println(IS_SKIP_READING_EXCEL_FILES + "=true");
            }
            for (String filename : this.fileMap_.keySet()) {
                FileInfo fileinfo = this.fileMap_.get(filename);
                out.println(filename + "=" + fileinfo.toString());
            }
        }
    }

    public boolean invalidate(File target) {
        if (!this.useCache) {
            return true;
        }
        String rpath = CacheFileManager.createRelativePathName(target.getPath());
        FileInfo fileinfo = this.fileMap_.get(rpath);
        if (fileinfo == null) {
            return true;
        }
        FileInfo me = new FileInfo(target);
        boolean isMatch = me.equals(fileinfo);
        return !isMatch;
    }

    public static String createRelativePathName(String path) {
        File current = new File(".");
        String currentPath = current.getAbsolutePath();
        if (path.startsWith(currentPath = currentPath.substring(0, currentPath.length() - 1))) {
            path = path.substring(currentPath.length());
        }
        return path;
    }

    public void removeAllCacheFiles() {
        File dir = new File(CacheFileManager.getRepositoryDirectory());
        this.removeDir(dir);
    }

    private void removeDir(File file) {
        String[] names = file.list();
        if (names != null && names.length > 0) {
            for (String s : names) {
                this.remove(new File(file, s));
            }
        }
    }

    private void remove(File file) {
        if (file.isDirectory()) {
            this.removeDir(file);
        }
        file.delete();
    }

    public void clear4ProjectFile(String defFileName) {
        File file;
        if ("project".equals(defFileName = this.removeSuffix(defFileName)) || "project_env".equals(defFileName)) {
            File file2 = new File(CacheFileManager.getRepositoryDirectory(), "project.txt");
            if (file2.exists()) {
                file2.delete();
            }
        } else if ("project_filter".equals(defFileName) && (file = new File(CacheFileManager.getRepositoryDirectory(), "filterlist.txt")).exists()) {
            file.delete();
        }
    }

    public void clear(String defFileName) {
        File file;
        defFileName = this.removeSuffix(defFileName);
        File dir = new File(CacheFileManager.getRepositoryDirectory(), defFileName);
        if (dir.isDirectory()) {
            String[] names;
            for (String s : names = dir.list()) {
                File file2 = new File(dir.getPath() + File.separator + s);
                if (file2.isDirectory()) {
                    FileUtil.removeAll((File)file2);
                    continue;
                }
                file2.delete();
                String modelId = s.endsWith(".txt") ? s.substring(0, s.length() - ".txt".length()) : s;
                this.con.removeModelId(modelId);
            }
            dir.delete();
        } else if (("project".equals(defFileName) || "project_env".equals(defFileName)) && (file = new File(CacheFileManager.getRepositoryDirectory(), "project.txt")).exists()) {
            file.delete();
        }
    }

    public void clearRest(Set<String> filenameSet) {
        HashSet<String> removeSet = new HashSet<String>();
        for (String fname : this.fileMap_.keySet()) {
            String fname0;
            if (filenameSet.contains(fname) || (fname0 = StringUtil.lastToken((String)fname, (String)File.separator)).startsWith("common-") || fname0.equals("project.xls") || fname0.equals("project_env.xls") || fname0.equals("project_outerlink.xls")) continue;
            this.clear(fname0);
            removeSet.add(fname);
        }
        if (removeSet.size() > 0) {
            for (String key : removeSet) {
                this.fileMap_.remove(key);
            }
        }
    }

    public void regist(File target) {
        this.fileMap_.put(CacheFileManager.createRelativePathName(target.getPath()), new FileInfo(target));
        this.targetDefFileName = this.removeSuffix(target.getName());
    }

    private String removeSuffix(String s) {
        if (s != null && s.endsWith(".xls")) {
            s = s.substring(0, s.length() - ".xls".length());
        }
        return s;
    }

    public void loadModelMap(Map<String, ModelInfo> modelMap) {
        this.rio.loadModelMap(modelMap);
    }

    public void saveModelMap(Map<String, ModelInfo> modelMap, Set<String> modelIdSet) {
        if (!this.useCache) {
            return;
        }
        this.rio.saveModelMap(this.targetDefFileName, modelMap, modelIdSet);
        this.targetDefFileName = null;
    }

    public void loadProjectMap(Map<String, String> projectMap) {
        this.rio.loadProjectMap(projectMap);
    }

    public void loadProjectMap(Map<String, String> projectMap, int domainId) {
        this.rio.loadProjectMap(projectMap, domainId);
    }

    public void saveProjectMap(Map<String, String> projectMap) {
        if (!this.useCache) {
            return;
        }
        this.rio.saveProjectMap(projectMap);
    }

    public void saveProjectMap(Map<String, String> projectMap, int domainId) {
        if (!this.useCache) {
            return;
        }
        this.rio.saveProjectMap(projectMap, domainId);
    }

    public void loadAuthorityPrincipalInfoMap(Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap) {
        this.rio.loadAuthorityPrincipalMap(authorityPrincipalInfoMap);
    }

    public void loadAuthorityPrincipalCategoryMap(Map<Integer, AuthorityPrincipalCategory> authorityCategoryMap) {
        this.rio.loadAuthorityPrincipalCategoryMap(authorityCategoryMap);
    }

    public void loadDomainMap(Map<Integer, Jfcdomain> domainMap) {
        this.rio.loadDomain(domainMap);
    }

    public void loadProjectOuterlink(Map<Integer, Map<String, String>> outerLinkMap, Map<Integer, Map<Integer, Map<String, String>>> principalInfoMap) {
        this.rio.loadProjectOuterlink(outerLinkMap, principalInfoMap);
    }

    public void saveProjectOuterlink(Map<Integer, Map<String, String>> outerLinkMap, Map<Integer, Map<Integer, Map<String, String>>> principalInfoMap) {
        if (!this.useCache) {
            return;
        }
        this.rio.saveProjectOuterlink(outerLinkMap, principalInfoMap);
    }

    public void loadModelVersionMap(Map<String, String> modelVersionMap) {
        this.rio.loadModelVersionMap(modelVersionMap);
    }

    public void saveModelVersionMap(Map<String, String> modelVersionMap) {
        if (!this.useCache) {
            return;
        }
        if (modelVersionMap == null || modelVersionMap.size() == 0) {
            return;
        }
        this.rio.saveModelVersionMap(modelVersionMap);
    }

    public void loadProjectFilter(Map<String, Filterlist> filterlistMap) {
        this.rio.loadProjectFilter(filterlistMap);
    }

    public void saveProjectFilter(Map<String, Filterlist> filterlistMap) {
        this.rio.saveProjectFilter(filterlistMap);
    }

    public boolean loadMenuMap(Map<String, String> menuMap) {
        return this.rio.loadMenu(menuMap);
    }

    public boolean isSkipReadingExcelFiles() {
        return isSkipReadingExcelFiles;
    }

    private static class FileInfo {
        private Date date_;
        private long size_;

        public FileInfo(String fileInfo) throws Exception {
            String sizeStr;
            int ptr = fileInfo.indexOf(",");
            if (ptr <= 0) {
                log.error("Illegal FileInfo no comma " + fileInfo);
                throw new Exception();
            }
            String dateStr = fileInfo.substring(0, ptr);
            if (StringUtils.isNotBlank((CharSequence)dateStr)) {
                try {
                    this.date_ = new Date(Long.parseLong(dateStr));
                }
                catch (NumberFormatException e) {
                    log.error("Illegal FileInfo date " + fileInfo, (Throwable)e);
                    throw new Exception();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(sizeStr = fileInfo.substring(ptr + 1)))) {
                try {
                    this.size_ = Long.parseLong(sizeStr);
                }
                catch (NumberFormatException e) {
                    log.error("Illegal FileInfo size " + fileInfo, (Throwable)e);
                    throw new Exception();
                }
            }
        }

        public FileInfo(File file) {
            this.date_ = new Date(file.lastModified());
            this.size_ = file.length();
        }

        public final Date getDate() {
            return this.date_;
        }

        public final long getSize() {
            return this.size_;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FileInfo)) {
                return false;
            }
            FileInfo target = (FileInfo)o;
            return this.date_.equals(target.getDate()) && this.size_ == target.getSize();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.date_.getTime());
            sb.append(",");
            sb.append(this.size_);
            return sb.toString();
        }
    }
}

