/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.util.StringUtil;

public class CacheViewer {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: jp.jasminesoft.jfc.tools.xls2appschema.CacheViewer [filename]");
            System.exit(1);
        }
        String target = args[0];
        CacheViewer viewer = new CacheViewer();
        viewer.parse(target);
    }

    public void parse(String target) {
        File file = new File(target);
        if (!file.exists()) {
            System.out.println("File not found, " + target);
            return;
        }
        String _name = StringUtil.lastToken((String)target, (String)File.separator);
        if ("project_outerlink.ser".equals(_name)) {
            this.parse(file, new CacheProcessor_ProjectOuterlink());
        } else {
            this.parse(file, new CacheProcessor_CommonModel());
        }
    }

    private void parse(File file, CacheProcessor processor) {
        try {
            ObjectInputStream ip = new ObjectInputStream(new FileInputStream(file.getAbsolutePath()));
            processor.getData(ip);
            ip.close();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        processor.output();
    }

    class CacheProcessor_ProjectOuterlink
    implements CacheProcessor {
        private Set<Map<String, String>> allSet = null;

        CacheProcessor_ProjectOuterlink() {
        }

        @Override
        public void getData(ObjectInputStream ip) throws IOException, ClassNotFoundException {
            this.allSet = (Set)ip.readObject();
        }

        @Override
        public void output() {
            System.out.println(this.allSet);
        }
    }

    static interface CacheProcessor {
        public void getData(ObjectInputStream var1) throws IOException, ClassNotFoundException;

        public void output();
    }

    class CacheProcessor_CommonModel
    implements CacheProcessor {
        private Map<String, String> map = null;

        CacheProcessor_CommonModel() {
        }

        @Override
        public void getData(ObjectInputStream ip) throws IOException, ClassNotFoundException {
            this.map = (Map)ip.readObject();
        }

        @Override
        public void output() {
            for (String key : this.map.keySet()) {
                String value = this.map.get(key);
                System.out.println(key + "=" + value);
            }
        }
    }
}

