/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.tools.appid.ApplicationIDUtil;
import jp.jasminesoft.jfc.tools.repository.RepositoryIO;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipal;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelitemInfo;
import jp.jasminesoft.jfc.tools.xls2appschema.RepositoryType;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.Properties;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ModelInfo
implements Serializable {
    private static final Logger log = LogManager.getLogger(ModelInfo.class);
    private static ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private static final long serialVersionUID = -189230354004963194L;
    private static boolean ecoSave = false;
    private String modelId;
    private SortedMap<String, String> modelInfoMap = new TreeMap<String, String>();
    private Map<ModelitemInfo, String> modelitemInfoMap = new HashMap<ModelitemInfo, String>();
    private Map<Integer, Map<String, String>> layoutInfoMap = new TreeMap<Integer, Map<String, String>>();
    private Map<Integer, Map<String, String>> principalInfoMap = new TreeMap<Integer, Map<String, String>>();
    private Map<Integer, Map<String, String>> permissionInfoMap = new TreeMap<Integer, Map<String, String>>();
    private Map<String, String> aclMappingInfoMap = new HashMap<String, String>();
    private Map<String, Integer> hashcodeMap = new HashMap<String, Integer>();
    private static TreeMap<String, String> jfcDesignerTemplateModelContent = new TreeMap();
    private static TreeMap<String, String> jfcDesignerTemplateModelitemContent;
    private Map<String, String> filenameMap = new HashMap<String, String>();
    private List<Map<String, Object>> initialdata = new ArrayList<Map<String, Object>>();
    private File initialdatasavedir;
    private boolean _b = true;
    private static Logger logger2;
    private Object[] oa;

    public ModelInfo(String modelId) {
        this(modelId, true);
    }

    public ModelInfo(String modelId, boolean b) {
        this.modelId = modelId;
        this._b = b;
        this.init();
    }

    private void init() {
        this.modelInfoMap.clear();
        this.modelitemInfoMap.clear();
        this.layoutInfoMap.clear();
        this.principalInfoMap.clear();
        this.permissionInfoMap.clear();
        this.aclMappingInfoMap.clear();
        this.initialdata.clear();
        this.hashcodeMap.clear();
        this.filenameMap.clear();
        if (this.modelInfoMap.get("uuid") == null) {
            this.modelInfoMap.put("uuid", ExcelFunction.UUID());
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public SortedMap<String, String> getModelInfoMap() {
        return this.modelInfoMap;
    }

    public Map<ModelitemInfo, String> getModelitemInfoMap() {
        return this.modelitemInfoMap;
    }

    public Map<Integer, Map<String, String>> getLayoutInfoMap() {
        return this.layoutInfoMap;
    }

    public Map<Integer, Map<String, String>> getPrincipalInfoMap() {
        return this.principalInfoMap;
    }

    public Map<Integer, Map<String, String>> getPermissionInfoMap() {
        return this.permissionInfoMap;
    }

    public Map<String, String> getAclMappingInfoMap() {
        return this.aclMappingInfoMap;
    }

    public List<Map<String, Object>> getInitialData() {
        return this.initialdata;
    }

    public File getInitialDataSaveDir() {
        return this.initialdatasavedir;
    }

    public String toString() {
        String CR = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("modelId=" + this.modelId);
        sb.append(CR);
        sb.append("modelInfoMap=" + this.modelInfoMap.size());
        sb.append(CR);
        sb.append("modelitemInfoMap=" + this.modelitemInfoMap.size());
        sb.append(CR);
        sb.append("layoutInfoMap=" + this.layoutInfoMap.size());
        sb.append(CR);
        sb.append("principalInfoMap=" + this.principalInfoMap.size());
        sb.append(CR);
        sb.append("permissionInfoMap=" + this.permissionInfoMap.size());
        sb.append(CR);
        sb.append("aclMappingInfoMap=" + this.aclMappingInfoMap.size());
        sb.append(CR);
        sb.append("initialdata=" + this.initialdata.size());
        sb.append(CR);
        return sb.toString();
    }

    public void write(String directory) {
        this.write(directory, null);
    }

    public void write(String directory, Set<RepositoryType> rtypeSet) {
        String base;
        File dir;
        if (this.modelInfoMap.size() < 10) {
            return;
        }
        if (ModelInfo.isUpdated(this.modelInfoMap)) {
            this.modelInfoMap.remove("system/@key");
            this.modelInfoMap.put("system/@key", ModelInfo.createKey(this.modelInfoMap));
            this.modelInfoMap.remove("system/@lastupdated");
            this.modelInfoMap.put("system/@lastupdated", this.currentTimeNano());
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.Base)) {
            this.write_modelBase(directory + File.separator + this.modelId + ".txt");
            if (rtypeSet != null && rtypeSet.size() == 1) {
                return;
            }
        }
        if (!(dir = new File(base = directory + File.separator + this.modelId)).exists()) {
            dir.mkdir();
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.Modelitem)) {
            this.write_modelitem(base);
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.Layout)) {
            this.write_dmap(base + File.separator + ".layout", this.layoutInfoMap);
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.Principal)) {
            this.write_dmap(base + File.separator + ".principal", this.principalInfoMap);
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.Permission)) {
            this.write_dmap(base + File.separator + ".permission", this.permissionInfoMap);
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.Acl)) {
            this.write_smap(base + File.separator + ".acl", "acl.txt", this.aclMappingInfoMap);
        }
        if (rtypeSet == null || rtypeSet.contains((Object)RepositoryType.InitialData)) {
            String initialdatadir = base + File.separator + ".initialdata";
            this.initialdatasavedir = this.initialdata.size() > 0 ? new File(initialdatadir) : null;
            this.write_dmap_xml(initialdatadir, this.initialdata);
        }
    }

    public void deleteModelitem(String directory, String modelitemName) throws IOException {
        this.write(directory);
        String base = directory + File.separator + this.modelId;
        if (!this.delete_modelitem(base, modelitemName)) {
            throw new IOException("Failed to delete");
        }
    }

    public void delete(String directory) throws IOException {
        String filename = directory + File.separator + this.modelId + ".txt";
        File file = new File(filename);
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + filename);
        }
        String base = directory + File.separator + this.modelId;
        File dir = new File(base);
        if (!dir.exists()) {
            return;
        }
        this.deleteDirectory(dir, 10);
        this.hashcodeMap.remove(filename);
    }

    public void read(String directory) {
        this.read(directory, null);
    }

    public void read(String directory, Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap) {
        this.read_modelBase(directory, this.modelId);
        String base = directory + File.separator + this.modelId;
        String type = (String)this.modelInfoMap.get("model/@type");
        if ("model".equals(type)) {
            this.read_modelitem(base + File.separator);
            this.read_dmap(base + File.separator + ".layout", this.layoutInfoMap);
        } else if ("master".equals(type)) {
            this.read_masterinit(base + File.separator);
        }
        this.read_principal(base + File.separator + ".principal", this.principalInfoMap, authorityPrincipalInfoMap);
        this.read_dmap(base + File.separator + ".permission", this.permissionInfoMap);
        this.read_smap(base + File.separator + ".acl", "acl.txt", this.aclMappingInfoMap);
        String initialdatadir = base + File.separator + ".initialdata";
        this.read_dmap_xml(initialdatadir, this.initialdata);
        this.initialdatasavedir = this.initialdata.size() > 0 ? new File(initialdatadir) : null;
        this.postProcess();
    }

    private void read_modelBase(String directory, String modelId) {
        String filename = directory + File.separator + modelId + ".txt";
        if (ecoSave) {
            this.modelInfoMap = new TreeMap<String, String>((SortedMap<String, String>)jfcDesignerTemplateModelContent);
            RepositoryIO.loadMenuByModelId(modelId, this.modelInfoMap);
        }
        Properties properties = RepositoryIO.loadProperties(filename);
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            this.modelInfoMap.put(key, value);
        }
        if (StringUtils.isBlank((CharSequence)properties.getProperty("model/@id"))) {
            this.modelInfoMap.put("model/@id", modelId);
        }
        if (!this.filenameMap.containsKey(modelId)) {
            this.filenameMap.put(modelId, filename);
        }
    }

    public boolean existsKeyInModel(String modelId, String key) {
        SortedMap<String, String> map = this.getModelInfoMap();
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public boolean existsKeyInModelitem(String modelId, String itemname, String key) {
        Map<ModelitemInfo, String> map = this.getModelitemInfoMap();
        if (map == null) {
            return false;
        }
        return map.containsKey(new ModelitemInfo(key, itemname));
    }

    private void read_modelitem(String dirname) {
        String[] fnames;
        File dir = new File(dirname);
        if (!dir.exists() || !dir.isDirectory()) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.notdirectory", new Object[]{dirname}));
            return;
        }
        for (String fname : fnames = dir.list()) {
            ModelitemInfo minfo;
            File ddir;
            if (fname.startsWith(".") || !(ddir = new File(dir.getAbsolutePath() + File.separator + fname)).exists() || !ddir.isDirectory()) continue;
            String path = ddir.getAbsolutePath() + File.separator + fname + ".txt";
            Properties properties = RepositoryIO.loadProperties(path);
            String modelitemName = properties.getProperty("model/modelitem/@name");
            if (StringUtils.isBlank((CharSequence)modelitemName)) {
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo.read_modelitem", new Object[]{path}));
                continue;
            }
            if (ecoSave) {
                for (Map.Entry<String, String> e : jfcDesignerTemplateModelitemContent.entrySet()) {
                    if (StringUtils.isBlank((CharSequence)e.getKey())) {
                        log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo.read_modelitem.illegal", new Object[]{path}));
                    }
                    minfo = new ModelitemInfo(e.getKey(), modelitemName);
                    this.modelitemInfoMap.put(minfo, e.getValue());
                }
            }
            Enumeration e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (StringUtils.isBlank((CharSequence)key)) {
                    log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo.read_modelitem.illegal", new Object[]{path}));
                }
                minfo = new ModelitemInfo(key, modelitemName);
                if (!ecoSave && (ecoSave || this.modelitemInfoMap.containsKey(minfo))) continue;
                String value = properties.getProperty(key);
                this.modelitemInfoMap.put(minfo, value);
            }
            String _key = this.modelId + "." + fname;
            if (this.filenameMap.containsKey(_key)) continue;
            this.filenameMap.put(_key, path);
        }
    }

    private void write_modelBase(String filename) {
        Properties properties = new Properties();
        properties.setProperty("modelId", this.modelId);
        for (Map.Entry<String, String> e : this.modelInfoMap.entrySet()) {
            String t_value = jfcDesignerTemplateModelContent.get(e.getKey());
            if (ecoSave && t_value != null && (t_value == null || t_value.equals(e.getValue()))) continue;
            properties.setProperty(e.getKey(), e.getValue());
        }
        this.saveProperties(filename, properties);
    }

    private void saveProperties(String filename, Properties properties) {
        Properties o_properties;
        File f;
        Integer o_hash = this.hashcodeMap.get(filename);
        int n_hash = properties.hashCode();
        if (o_hash == null && (f = new File(filename)).exists() && f.canRead() && (o_properties = RepositoryIO.loadProperties(filename)) != null) {
            o_hash = o_properties.hashCode();
            this.hashcodeMap.put(filename, o_hash);
        }
        if (o_hash == null || o_hash != n_hash) {
            this.hashcodeMap.put(filename, n_hash);
            RepositoryIO.saveProperties(filename, properties);
            log.debug("Save " + filename);
        }
    }

    private void write_modelitem(String dirname) {
        Object linenumber;
        Map contentMap;
        TreeMap<Integer, String> orderedItemNameMap = new TreeMap<Integer, String>();
        HashMap elemMap = new HashMap();
        HashSet<Object> duplicateLinenumberSet = null;
        for (Map.Entry<ModelitemInfo, String> entry : this.modelitemInfoMap.entrySet()) {
            ModelitemInfo modelitemInfo = entry.getKey();
            contentMap = (TreeMap<String, String>)elemMap.get(modelitemInfo.getModelitemName());
            if (contentMap == null) {
                contentMap = new TreeMap<String, String>();
                elemMap.put(modelitemInfo.getModelitemName(), contentMap);
            }
            contentMap.put(modelitemInfo.getKey(), entry.getValue());
            if (!modelitemInfo.getKey().equals("model/modelitem/@__linenumber")) continue;
            linenumber = Integer.valueOf(entry.getValue());
            if (orderedItemNameMap.containsKey(linenumber)) {
                if (duplicateLinenumberSet == null) {
                    duplicateLinenumberSet = new HashSet<Object>();
                }
                duplicateLinenumberSet.add(linenumber);
                continue;
            }
            orderedItemNameMap.put(Integer.valueOf(entry.getValue()), modelitemInfo.getModelitemName());
        }
        if (duplicateLinenumberSet != null) {
            HashMap<String, Object> errorItemNameMap = new HashMap<String, Object>();
            for (Map.Entry<ModelitemInfo, String> entry : this.modelitemInfoMap.entrySet()) {
                ModelitemInfo minfo = entry.getKey();
                if (!minfo.getKey().equals("model/modelitem/@__linenumber") || !duplicateLinenumberSet.contains(linenumber = Integer.valueOf(entry.getValue()))) continue;
                errorItemNameMap.put(minfo.getModelitemName(), linenumber);
            }
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo.write_modelitem", new Object[]{errorItemNameMap}));
        }
        for (Map.Entry<ModelitemInfo, String> entry : orderedItemNameMap.entrySet()) {
            File savedir;
            Properties properties = new Properties();
            contentMap = (Map)elemMap.get(entry.getValue());
            for (Map.Entry ee : contentMap.entrySet()) {
                String t_value = jfcDesignerTemplateModelitemContent.get(ee.getKey());
                if (ecoSave && !"model/modelitem/@__linenumber".equals(ee.getKey()) && !"model/modelitem/@type".equals(ee.getKey()) && t_value != null && (t_value == null || t_value.equals(ee.getValue()))) continue;
                properties.setProperty((String)ee.getKey(), (String)ee.getValue());
            }
            String modelitemName = entry.getValue();
            if (AppSchemaUtil.hasChildPart((String)modelitemName)) {
                modelitemName = AppSchemaUtil.getChildPart((String)modelitemName);
            }
            if (!(savedir = new File(dirname + File.separator + modelitemName)).exists()) {
                savedir.mkdir();
            }
            this.saveProperties(savedir.getAbsolutePath() + File.separator + modelitemName + ".txt", properties);
        }
    }

    private boolean delete_modelitem(String dirname, String modelitemName) {
        File savedir;
        if (AppSchemaUtil.hasChildPart((String)modelitemName)) {
            modelitemName = AppSchemaUtil.getChildPart((String)modelitemName);
        }
        if (!(savedir = new File(dirname + File.separator + modelitemName)).exists()) {
            return true;
        }
        String filename = savedir.getAbsolutePath() + File.separator + modelitemName + ".txt";
        File file = new File(filename);
        boolean ret = file.delete();
        File parent = file.getParentFile();
        if (parent.exists() && parent.list().length == 0) {
            parent.delete();
        }
        this.hashcodeMap.remove(filename);
        return ret;
    }

    private void read_dmap(String dirname, Map<Integer, Map<String, String>> map) {
        String[] fnames;
        Integer n_hash = this.calcDmapHashcode(map);
        this.hashcodeMap.put(dirname, n_hash);
        File dir = new File(dirname);
        if (!dir.exists()) {
            return;
        }
        for (String fname : fnames = dir.list()) {
            try {
                int ptr = fname.lastIndexOf(".txt");
                if (ptr <= 0) continue;
                Integer num = Integer.parseInt(fname.substring(0, ptr));
                Map<String, String> dmap = this.readPropertiesFile(dirname, num);
                map.put(num, dmap);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private Integer calcDmapHashcode(Map<Integer, Map<String, String>> map) {
        if (map.size() == 0) {
            return 0;
        }
        int s = 0;
        for (Map<String, String> _map : map.values()) {
            s += _map.hashCode();
        }
        return s;
    }

    private Map<String, String> readPropertiesFile(String dirname, Integer num) {
        String filename = dirname + File.separator + num + ".txt";
        Properties properties = RepositoryIO.loadProperties(filename);
        HashMap<String, String> dmap = new HashMap<String, String>();
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            dmap.put(key, value);
        }
        return dmap;
    }

    private void read_principal(String dirname, Map<Integer, Map<String, String>> principalInfoMap, Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap) {
        TreeMap<Integer, Map<String, String>> principalMap = new TreeMap<Integer, Map<String, String>>();
        this.read_dmap(dirname, principalMap);
        principalMap.entrySet().stream().forEach(map -> {
            Map principal = (Map)map.getValue();
            if (principal.get("acl/principal/@content") == null && authorityPrincipalInfoMap != null) {
                String strId = (String)principal.get("acl/principal/@id");
                AuthorityPrincipal authorityPrincipal = (AuthorityPrincipal)authorityPrincipalInfoMap.get(Integer.valueOf(strId));
                principal.put("acl/principal/@id", authorityPrincipal.getPrincipalId());
                principal.put("acl/principal/@content", authorityPrincipal.getContent());
            }
            principalInfoMap.put((Integer)map.getKey(), principal);
        });
    }

    private void read_dmap_xml(String dirname, List<Map<String, Object>> initialdata2) {
        String[] fnames;
        Integer n_hash = this.calcDmapxmlHashcode(initialdata2);
        this.hashcodeMap.put(dirname, n_hash);
        File dir = new File(dirname);
        if (!dir.exists()) {
            return;
        }
        TreeMap map = new TreeMap();
        for (String fname : fnames = dir.list()) {
            try {
                int ptr = fname.lastIndexOf(".xml");
                if (ptr <= 0) continue;
                Integer num = Integer.parseInt(fname.substring(0, ptr));
                HashMap<String, String> dmap = new HashMap<String, String>();
                dmap.putAll(this.readXmlFile(dirname, num));
                map.put(num, dmap);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        initialdata2.addAll(map.values());
    }

    private Map<String, String> readXmlFile(String dirname, Integer num) {
        String filename = dirname + File.separator + num + ".xml";
        Map<String, String> dmap = RepositoryIO.loadXml(filename);
        return dmap;
    }

    private void read_smap(String dirname, String filename, Map<String, String> map) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            return;
        }
        File file = new File(dirname + File.separator + filename);
        if (!file.exists()) {
            return;
        }
        Properties properties = RepositoryIO.loadProperties(file.getAbsolutePath());
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            map.put(key, value);
        }
    }

    private void read_masterinit(String dirname) {
        String[] fnames;
        File dir = new File(dirname);
        if (!dir.exists() || !dir.isDirectory()) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.notdirectory", new Object[]{dirname}));
            return;
        }
        for (String fname : fnames = dir.list()) {
            File ddir = new File(dir.getAbsolutePath() + File.separator + fname);
            if (!ddir.exists() || !ddir.isDirectory()) continue;
            String path = ddir.getAbsolutePath() + File.separator + fname + ".txt";
            try {
                Integer num = Integer.parseInt(fname);
                Properties properties = RepositoryIO.loadProperties(path);
                Enumeration e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ModelitemInfo minfo = new ModelitemInfo(key, Integer.toString(num));
                    if (this.modelitemInfoMap.containsKey(minfo)) continue;
                    this.modelitemInfoMap.put(minfo, properties.getProperty(key));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void write_dmap(String dirname, Map<Integer, Map<String, String>> map) {
        boolean needsWrite = false;
        Integer o_hash = this.hashcodeMap.get(dirname);
        Integer n_hash = this.calcDmapHashcode(map);
        if (o_hash == null || n_hash != null && n_hash.intValue() != o_hash.intValue()) {
            needsWrite = true;
        }
        if (!needsWrite) {
            return;
        }
        this.hashcodeMap.put(dirname, n_hash);
        File savedir = new File(dirname);
        if (!savedir.exists()) {
            savedir.mkdir();
        } else {
            try {
                this.deleteDirectory(savedir, 10);
            }
            catch (IOException e) {
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.failed.delete", new Object[]{savedir}));
                throw new RuntimeException("Failed to delete " + savedir);
            }
            savedir.mkdir();
        }
        for (Map.Entry<Integer, Map<String, String>> e : map.entrySet()) {
            Integer id = e.getKey();
            this.writePropertiesFile(savedir, id, e.getValue());
        }
    }

    private void writePropertiesFile(File savedir, int id, Map<String, ?> value) {
        Properties properties = new Properties();
        for (Map.Entry<String, ?> ee : value.entrySet()) {
            String v = null;
            if (ee.getValue() != null) {
                v = ee.getValue().toString();
            }
            properties.setProperty(ee.getKey(), v);
        }
        RepositoryIO.saveProperties(savedir.getAbsolutePath() + File.separator + id + ".txt", properties);
    }

    private void write_dmap_xml(String dirname, List<Map<String, Object>> initialdata2) {
        boolean needsWrite = false;
        Integer o_hash = this.hashcodeMap.get(dirname);
        Integer n_hash = this.calcDmapxmlHashcode(initialdata2);
        if (o_hash == null || n_hash != null && n_hash.intValue() != o_hash.intValue()) {
            needsWrite = true;
        }
        if (!needsWrite) {
            return;
        }
        this.hashcodeMap.put(dirname, n_hash);
        File savedir = new File(dirname);
        if (!savedir.exists()) {
            savedir.mkdir();
        } else {
            try {
                this.deleteDirectory(savedir, 10);
            }
            catch (IOException e) {
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.common.failed.delete", new Object[]{savedir}));
                throw new RuntimeException("Failed to delete " + savedir);
            }
            savedir.mkdir();
        }
        int id = 0;
        for (Map<String, Object> value : initialdata2) {
            this.writeXmlFile(savedir, ++id, value);
        }
    }

    private Integer calcDmapxmlHashcode(List<Map<String, Object>> initialdata2) {
        if (initialdata2.size() == 0) {
            return 0;
        }
        int s = 0;
        for (Map<String, Object> _map : initialdata2) {
            s += _map.hashCode();
        }
        return s;
    }

    private void writeXmlFile(File savedir, int id, Map<String, ?> value) {
        RepositoryIO.saveXml(savedir.getAbsolutePath() + File.separator + id + ".xml", this.modelId, value);
    }

    private void write_smap(String dirname, String filename, Map<String, String> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : map.entrySet()) {
            properties.setProperty(e.getKey(), e.getValue());
        }
        File savedir = new File(dirname);
        if (!savedir.exists()) {
            savedir.mkdir();
        }
        this.saveProperties(savedir.getAbsolutePath() + File.separator + filename, properties);
    }

    public void postProcess() {
        if (!this._b) {
            return;
        }
        this.modelInfoMap.put("system/@key", ModelInfo.createKey(this.modelInfoMap));
        this.modelInfoMap.put("system/@version", this.version());
        this.modelInfoMap.put("system/@lastupdated", this.currentTimeNanos());
    }

    private static String createKey(Map<String, String> map) {
        if (map.containsKey("system/@key")) {
            return map.get("system/@key");
        }
        int r = (int)(Math.random() * 100.0) % 20;
        return "01" + StringUtil.getHash((String)ModelInfo.joinValues(map), (String)"SHA-256", (String)"UTF-8").substring(r);
    }

    private static String joinValues(Map<String, String> map) {
        StringBuilder sb = new StringBuilder(256);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtils.isNotBlank((CharSequence)entry.getKey()) && entry.getKey().startsWith("system/") || entry.getValue() == null) continue;
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static boolean isUpdated(Map<String, String> map) {
        String key = map.get("system/@key");
        String hash = StringUtil.getHash((String)ModelInfo.joinValues(map), (String)"SHA-256", (String)"UTF-8");
        return StringUtils.length((CharSequence)key) <= 2 || !StringUtils.endsWith((CharSequence)hash, (CharSequence)key.substring(2));
    }

    private String version() {
        if (this.modelInfoMap.containsKey("system/@version")) {
            return (String)this.modelInfoMap.get("system/@version");
        }
        return null;
    }

    private String currentTimeNanos() {
        int b;
        Object[] oa = this.c();
        if (oa == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.modelInfoMap.get("system/@lastupdated")))) {
            if (StringUtils.isNotBlank((CharSequence)((String)oa[1]))) {
                this.init();
                this.c("CypZ7khZ7jtZ759Z7i9Z7khZ6Oq1eAW0aytZ6P5Z6Q1Z6NVZ72lZ6PBZ71JZ7kdZ73VZ75lZ7kRZ75dZ6QxZ7hJZ745Z7hRZ74BZ6Ql-fAK0bP5Z6P5Z6RxZ6P5Z6PBZ6xNZ7iFZ7hRZ74BZ73NZ7hRZ7j5Z6OlZ72dZ7khZ7jtZ759Z7i9Z7khZ72NZ7khZ75dZ7i9Z73NZ6P5Z6Q1Z6OBZ6PFZ6OZZ6NVZ6xPRT+PINYLaOIHT");
                return null;
            }
            int z = (int)(Math.random() * 1.0E9) & 0x3B6FF;
            long millis = System.currentTimeMillis() / 1000L * 1000L * 1000L;
            return String.valueOf(millis + (long)z);
        }
        int d = (int)(Long.parseLong((String)this.modelInfoMap.get("system/@lastupdated")) % 1000000L);
        if ((d & 0x100) == 256) {
            d ^= 0xFFFFFFFF;
        }
        if (((d &= 0x3FFFF) & 0x4800) == 18432) {
            int b2;
            String s = this.modelId;
            long a = 0L;
            for (char c : s.toCharArray()) {
                a += (long)c;
            }
            if (d == (b2 = (int)(((a &= 0x7FFFL) & 0x7000L) * 8L + (a & 0xC00L) * 4L + (a & 0x300L) * 2L + (a & 0xFFL) * 1L)) + 18432) {
                return (String)this.modelInfoMap.get("system/@lastupdated");
            }
            this.init();
            this.c("+9TruWbruVnruH3ruU3ruWbruojvCaPuy8nruo-rupXrunPruEfrupvruDDruW7ruFPruHfruWLruH7ruqrruTDruF-ruTLruGvruqftDaDuzo-ruo-rurrruo-rupvru7HruUzruTLruGvruFHruTLruU-ruofruE7ruWbruVnruH3ruU3ruWbruEHruWbruH7ruU3ruFHruo-rupXruovrupzruoTrunPru7FjfkFa9iEEa2xl");
            return null;
        }
        if ((d & 0x4800) == 16384) {
            this.init();
            this.c("2MTKzHnKzGzKzsfKzFfKzHnKz9vOGX-NCVzKzabKzb7Kz8-KzprKzaHKzoPKzHjKzq-KzsrKzHXKzsjKzbDKzEPKzrbKzEXKzrHKzbrMHXPNEabKzabKzcDKzabKzaHKyUTKzFLKzEXKzrHKzqTKzEXKzGbKz9rKzpjKzHnKzGzKzsfKzFfKzHnKzpTKzHnKzsjKzFfKzqTKzabKzb7Kz9HKzaLKza3Kz8-KyURCk5Rte3UXePJE");
            return null;
        }
        if ((d & 0x4800) == 0) {
            if (StringUtils.isBlank((CharSequence)((String)oa[1]))) {
                return (String)this.modelInfoMap.get("system/@lastupdated");
            }
            this.init();
            this.c("7zc1DX41DYM1Esw1ErI1Edo1Eqo1Esw1DYQ1Erk1EsI1Edo1Eck1EcQ1Eqo1Ess1Ec81EdA1Et41Eds5IIo1DYA2SXE4FGU1DXc1EaE1DXQ3Pbw5Tcs1DYw1DYM1DYk5EHY3FJg7JWU7JaA5JZw1Ess1Ec81EdA1Et41Eds5IcU3Ma41DYk1DYQ6OcI1DZQ6TdE1E9U1DX41DYo1DWE1DYk1DWI1DZM1DXA1Eb41DG0");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((String)oa[1]))) {
            this.init();
            this.c("Dze17P617QO18ky18jK185q18iq18ky17QS58z+39Bi7dOW7d2C5dRy18ku184a185C18l6185u5cAq17QC2mPG49yW17Pe182G17PS3j3y5n4u17Qy17QO17Qm18jm18kK185q184m184S18iq18ku184a185C18l6185u5c4W3g2617Qm17QS6i4K17RS6n5G181W17P617Qq17OG17Qm17OK17RO17PC183617y0");
            return null;
        }
        String s = this.modelId + StringUtils.join((Object[])((String[])oa[2]));
        long a = 0L;
        for (char c : s.toCharArray()) {
            a += (long)c;
        }
        if (d == (b = (int)(((a &= 0x7FFFL) & 0x7000L) * 8L + (a & 0xC00L) * 4L + (a & 0x300L) * 2L + (a & 0xFFL) * 1L)) + 2048) {
            return (String)this.modelInfoMap.get("system/@lastupdated");
        }
        this.init();
        this.c("HeefbRqfbQCfbCifbPifbRqfbjyjj62if3Cfbkefblafbj2fbzufbkKfbySfbRmfbB2fbCufbR+fbCmfblGfbOSfbBefbO+fbBKfbluhk5SigkefbkefbmGfbkefbkKfb2WfbPOfbO+fbBKfbAWfbO+fbQefbjufbzmfbRqfbQCfbCifbPifbRqfbzWfbRqfbCmfbPifbAWfbkefblafbjKfbkOfbk6fbj2fb2U7YvX+Su3sTdM9");
        return null;
    }

    private void c(String encodedLogMessage) {
        if (StringUtils.isBlank((CharSequence)encodedLogMessage)) {
            return;
        }
        String plainLogMessage = null;
        try {
            plainLogMessage = ModelInfo.decode(encodedLogMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)plainLogMessage)) {
            return;
        }
        logger2.error(plainLogMessage);
    }

    protected String currentTimeNano() {
        this.modelInfoMap.remove("system/@lastupdated");
        Object[] oa = this.c();
        if (oa == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((String)oa[1]))) {
            return this.currentTimeNanos();
        }
        long millis = System.currentTimeMillis() / 1000L * 1000L * 1000L;
        Object s = this.modelId + StringUtils.join((Object[])((String[])oa[2]));
        s = this.s((String)s);
        long a = 0L;
        for (char c : ((String)s).toCharArray()) {
            a += (long)c;
        }
        int b = (int)(((a &= 0x7FFFL) & 0x7000L) * 8L + (a & 0xC00L) * 4L + (a & 0x300L) * 2L + (a & 0xFFL) * 1L);
        b += 2048;
        b = this.d(b);
        for (int i = 0; i < (b + (int)(Math.random() * 10.0)) % 2; ++i) {
            b ^= 0xFFFFFFFF;
        }
        return String.valueOf(millis + (long)(b & 0x3FFFF));
    }

    private String s(String s) {
        return s;
    }

    private int d(int b) {
        return b;
    }

    private Object[] c() {
        try {
            return this.b();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                try {
                    msg = ModelInfo.decode("T055i4x1gPR8-4x5fQ5ajQ57glnYj3RejQ4");
                }
                catch (Exception e1) {
                    msg = "";
                }
            }
            logger2.error(msg);
            this.init();
            return null;
        }
    }

    private Object[] b() throws Exception {
        Object ba1;
        Long timestamp = null;
        String key = null;
        InputStream is = null;
        try {
            File f = new File(ModelInfo.decode("4dQ+fzY+fz+7sntOynhRwTBTvDm2fPU+fUtNtTa9fnNVsTl+wTlXtoA+y7RY"));
            if (!(f.getParentFile().getParentFile().exists() && f.exists() || (f = new File(ModelInfo.decode("OQHV+vEMek7W+vDWgyMObkjUdPgKc3A+c3oMhfB3e3s"))).getParentFile().getParentFile().exists() && f.exists())) {
                throw new FileNotFoundException();
            }
            timestamp = new Long(f.lastModified());
            if (this.oa != null && this.oa.length > 1 && timestamp.equals((Long)this.oa[0])) {
                Object[] objectArray = (Object[])this.oa.clone();
                return objectArray;
            }
            this.oa = null;
            is = new FileInputStream(f);
            if (is != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                Element elem = doc.getDocumentElement();
                Node node = elem.getFirstChild();
                StringBuffer buf = new StringBuffer();
                while (node instanceof Text) {
                    buf.append(node.getNodeValue());
                    if ((node = node.getNextSibling()) != null) continue;
                }
                key = buf.toString();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(ModelInfo.decode("FB7F1Njd6Ioo2MsaNx8f2gIk6gIh2N-630Yi2M"));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        if (key == null) {
            throw new IllegalStateException(ModelInfo.decode("atVLyFalzER9Dpx9CUWazkClAEOeBVOeB8Wyio+iBoU"));
        }
        String devMachineId = null;
        long max_logon = -1L;
        long max_account = -1L;
        boolean success = false;
        if (key != null && key.length() > 2 && key.charAt(0) == '1' && key.charAt(1) == '1') {
            try {
                int VersionLen = 2;
                ba1 = ModelInfo.StringToByteArray(key.substring(2));
                if (((byte[])ba1).length < 2) {
                    throw new IllegalArgumentException();
                }
                byte[] ba2 = new byte[((byte[])ba1).length - 2];
                Object randombyte = ba1[0];
                byte checkbyte = 0;
                for (int i = 2; i < ((Object)ba1).length; ++i) {
                    byte b;
                    checkbyte = (byte)(checkbyte + ba1[i]);
                    ba2[i - 2] = b = (byte)(ba1[i] - randombyte);
                }
                if (ba1[1] != checkbyte) {
                    throw new IllegalArgumentException();
                }
                String key0 = new String(ba2, "8859_1");
                Iterator<String> it = Arrays.asList(key0.split(Pattern.quote("+"))).iterator();
                String s = it.next();
                if (!"w7".equals(s)) {
                    throw new IllegalArgumentException();
                }
                s = it.next();
                s = it.next();
                s = it.next();
                int i = Integer.parseInt(s, 36);
                s = it.next();
                i = Integer.parseInt(s, 36);
                s = it.next();
                i = Integer.parseInt(s, 36);
                s = it.next();
                long l = Long.parseLong(s, 36);
                s = it.next();
                if (!s.equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    max_logon = l = Long.parseLong(s, 36);
                    max_logon = -1L;
                }
                if (it.hasNext()) {
                    s = it.next();
                    l = Long.parseLong(s, 36);
                }
                if (it.hasNext()) {
                    s = it.next();
                    l = Long.parseLong(s, 36);
                }
                if (it.hasNext()) {
                    s = it.next();
                    i = Integer.parseInt(s, 36);
                }
                if (it.hasNext()) {
                    s = it.next();
                    i = Integer.parseInt(s, 36);
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                if (it.hasNext()) {
                    s = it.next();
                    max_account = l = Long.parseLong(s, 36);
                    if (max_logon < 0L) {
                        max_logon = max_account;
                    }
                } else {
                    max_account = -1L;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (StringUtils.isBlank((CharSequence)s) || s.length() == 12) {
                        devMachineId = s;
                    } else {
                        throw new IllegalArgumentException("v3-1");
                    }
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                success = true;
            }
            catch (Exception VersionLen) {
                // empty catch block
            }
        }
        if (!success) {
            throw new IllegalStateException(ModelInfo.decode("UKEHjAV7ikde0AVbhktglktdhRI"));
        }
        try {
            this.oa = new Object[]{timestamp, devMachineId, new String[0]};
            if (StringUtils.isNotBlank(devMachineId)) {
                boolean isMatch = false;
                try {
                    ba1 = Collections.list(NetworkInterface.getNetworkInterfaces()).iterator();
                    while (ba1.hasNext()) {
                        NetworkInterface n = (NetworkInterface)ba1.next();
                        String aid = ApplicationIDUtil.Byte2HexStr((byte[])n.getHardwareAddress(), (boolean)false);
                        if (aid == null || aid.length() != 12 || !devMachineId.equals(aid)) continue;
                        isMatch = true;
                        break;
                    }
                }
                catch (SocketException e) {
                    logger2.error(e.getMessage());
                }
                if (!isMatch) {
                    throw new IllegalStateException(ModelInfo.decode("O3uHilKHinqHiSqHiD+HiTKHinuHiT6HiCOHiEeHiTKHiE6HiDmHiUiHiRSHiCCHiCOHiTeHineHiB2HimKHimWMsBmHiACHiB6HiBiHimuNnBeLooaKsmuHin2HinuLnnyHinaHimKHimWHikOHioqHim6Hi4E"));
                }
                this.a();
                boolean isMatch2 = false;
                for (String aid : (String[])this.oa[2]) {
                    if (!devMachineId.equals(aid)) continue;
                    isMatch2 = true;
                    break;
                }
                if (!isMatch2) {
                    throw new IllegalStateException(ModelInfo.decode("AH9R4OlR4Q1R5jNR5iZR54FR5hFR5jNR4Q5V9Q9R4PNR51RV5zdT6AxXaO9Xa1RVaQNR5jJR53pR54RR5klR54JV9zFR4PRSjOVU6y9R4OtR51VR4P5Tg2NVk3JR4PNR4Q1R4PBWf3ZR4R5Wk4VR519R4OlR4PFR4NVR4PBR4NZR4R1R4ORR52lR4xg"));
                }
            } else {
                TreeMap<String, String> projectMap = new TreeMap<String, String>();
                RepositoryIO.getInstance().loadProjectMap(projectMap);
                String autoscaling = (String)projectMap.get(ModelInfo.decode("mgj9OYz3LHPdybX7PYbbOcv6LIvdy9CWPIT8PbOWNsb7M0"));
                if (Boolean.valueOf(autoscaling).booleanValue() && max_logon >= 0L) {
                    throw new IllegalStateException(ModelInfo.decode("G5Wba3ibaBabaSibaP2baC6baBCbaSibaRebazGeh36dcC6balebak6bazeba3mgk5mdlAabalufdSqdh52balqbaR6baAObaCebaRKbaC6bak+baludc56ff52bak+bajmbamqbakebazLg-hok4hkh70QcR+In6xwn6wAs3oIHkoIGj8IGoUIHmUIGooIFjUQMkoYYk8QTlV0Hpt6ba2Gde3igk5mdlAabazGfb4CdcC6balebaj+bakWbajubakybajSbaiOba2E"));
                }
            }
            return (Object[])this.oa.clone();
        }
        catch (Exception e) {
            this.oa = null;
            throw e;
        }
    }

    private static byte[] StringToByteArray(String s) {
        int slen = s.length();
        int balen = slen * 6 / 8;
        byte[] ba = new byte[balen];
        for (int cnt = 0; cnt < balen; ++cnt) {
            int charcnt = cnt * 8 / 6;
            int b1 = ModelInfo.CharacterToBit6(s.charAt(charcnt));
            int shift1 = 8 * (cnt + 1) - 6 * (charcnt + 1);
            if (shift1 == 0) {
                ba[cnt] = (byte)(b1 & 0xFF);
                continue;
            }
            if (shift1 <= 0) {
                ba[cnt] = (byte)(b1 >> -shift1 & 0xFF);
                continue;
            }
            ba[cnt] = (byte)(b1 << shift1 & 0xFF);
            int b2 = ModelInfo.CharacterToBit6(s.charAt(charcnt + 1));
            int shift2 = 8 * (cnt + 1) - 6 * (charcnt + 2);
            if (shift2 == 0) {
                ba[cnt] = (byte)(ba[cnt] | b2 & 0xFF);
                continue;
            }
            if (shift2 <= 0) {
                ba[cnt] = (byte)(ba[cnt] | b2 >> -shift2 & 0xFF);
                continue;
            }
            ba[cnt] = (byte)(ba[cnt] | b2 << shift2 & 0xFF);
            int b3 = ModelInfo.CharacterToBit6(s.charAt(charcnt + 2));
            int shift3 = 8 * (cnt + 1) - 6 * (charcnt + 3);
            ba[cnt] = shift3 == 0 ? (byte)(ba[cnt] | b3 & 0xFF) : (shift3 <= 0 ? (byte)(ba[cnt] | b3 >> -shift3 & 0xFF) : (byte)(ba[cnt] | b3 << shift3 & 0xFF));
        }
        return ba;
    }

    private static int CharacterToBit6(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65 + 36;
        }
        if (ch == '+') {
            return 62;
        }
        if (ch == '-') {
            return 63;
        }
        return -1;
    }

    private static String decode(String s) throws Exception {
        byte[] ba1 = ModelInfo.StringToByteArray(s);
        if (ba1.length < 2) {
            throw new IllegalArgumentException();
        }
        byte[] ba2 = new byte[ba1.length - 2];
        byte randombyte = ba1[0];
        byte checkbyte = 0;
        for (int i = 2; i < ba1.length; ++i) {
            byte b;
            checkbyte = (byte)(checkbyte + ba1[i]);
            ba2[i - 2] = b = (byte)(ba1[i] - randombyte);
        }
        if (ba1[1] != checkbyte) {
            throw new IllegalArgumentException();
        }
        String key0 = new String(ba2, "UTF-8");
        return key0;
    }

    private void a() throws Exception {
        ArrayList<String> a = new ArrayList<String>();
        TreeMap<String, String> projectMap = new TreeMap<String, String>();
        RepositoryIO.getInstance().loadProjectMap(projectMap);
        String key = (String)projectMap.get("system/@key");
        boolean success = false;
        if (key != null && key.length() > 2 && key.charAt(0) == '0' && key.charAt(1) == '1') {
            try {
                int VersionLen = 2;
                byte[] ba1 = ModelInfo.StringToByteArray(key.substring(2));
                if (ba1.length < 2) {
                    throw new IllegalArgumentException();
                }
                byte[] ba2 = new byte[ba1.length - 2];
                byte randombyte = ba1[0];
                byte checkbyte = 0;
                for (int i = 2; i < ba1.length; ++i) {
                    byte b;
                    checkbyte = (byte)(checkbyte + ba1[i]);
                    ba2[i - 2] = b = (byte)(ba1[i] - randombyte);
                }
                if (ba1[1] != checkbyte) {
                    throw new IllegalArgumentException();
                }
                String key0 = new String(ba2, "8859_1");
                Iterator<String> it = Arrays.asList(key0.split(Pattern.quote("+"))).iterator();
                while (it.hasNext()) {
                    a.add(it.next());
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!success) {
            throw new IllegalStateException(ModelInfo.decode("ssVkYwhkYxZkZ1JkZ0VkYOBkZfBkZ1JkYy1kZ0xkZ1VkYOBkYNxkYO1kZfBkZ1FkYNlkYONkZ2hkYOFo1hBkYxNlbwRn+g5kYwpkY-RkYx1m7MJobNFkYxJkYxZkYxxp6NVkYz1pbORkY-5kYwhkYxBkYLRkYxxkYLVkYyZkYwNkYMhkYvc"));
        }
        this.oa[2] = a.toArray(new String[a.size()]);
    }

    private void deleteDirectory(File dir, int max_retry_count) throws IOException {
        int retry_count = 0;
        boolean errorStatus = false;
        while (retry_count < max_retry_count) {
            try {
                log.debug("delete directory " + dir + ", retry_count=" + retry_count);
                FileUtils.deleteDirectory((File)dir);
                retry_count = Integer.MAX_VALUE;
                errorStatus = false;
            }
            catch (IOException e) {
                ++retry_count;
                errorStatus = true;
                try {
                    log.debug("Failed to delete " + dir + ", waiting...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (errorStatus) {
            throw new IOException();
        }
    }

    public static void setEcoSave(boolean b) {
        ecoSave = b;
        if (ecoSave) {
            log.info("ecoSave mode is on.");
        } else {
            log.info("ecoSave mode is off.");
        }
    }

    public static boolean getEcoSave() {
        return ecoSave;
    }

    static {
        String basedir = RepositoryIO.getRepositoryDirectory();
        String templateModelfilename = basedir + "jfcDesignerTemplateModel" + File.separator + "jfcDesignerTemplateModel.txt";
        if (new File(templateModelfilename).exists()) {
            try {
                Properties properties = RepositoryIO.loadProperties(templateModelfilename);
                Enumeration e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = properties.getProperty(key);
                    if (key.equals("system/@key") || key.equals("system/@version") || key.equals("system/@lastupdated")) continue;
                    jfcDesignerTemplateModelContent.put(key, value);
                }
            }
            catch (Exception e) {
                log.warn("Failed to read jfcDesignerTemplateModel.txt, skip eco save mode.");
                ecoSave = false;
            }
        } else {
            ecoSave = false;
        }
        jfcDesignerTemplateModelitemContent = new TreeMap();
        String templateModelitemfilename = basedir + "jfcDesignerTemplateModelitem" + File.separator + "jfcDesignerTemplateModelitem" + File.separator + "templateItem" + File.separator + "templateItem.txt";
        if (new File(templateModelitemfilename).exists()) {
            try {
                Properties properties = RepositoryIO.loadProperties(templateModelitemfilename);
                Enumeration e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = properties.getProperty(key);
                    jfcDesignerTemplateModelitemContent.put(key, value);
                }
            }
            catch (Exception e) {
                log.warn("Failed to read jfcDesignerTemplateModelitem.txt, skip eco save mode.");
                ecoSave = false;
            }
        } else {
            ecoSave = false;
        }
        String name = "";
        try {
            name = ModelInfo.decode("Qb4WgfUWckcZejURgPYShfUWdzf+bPcUdjcX-xMVcPk+gPkje3kPeNQNfz4Tdk8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger2 = LogManager.getLogger((String)name);
    }
}

