/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.XMLFormatter;
import org.w3c.dom.Document;

public class SimpleXMLFormatter
implements XMLFormatter {
    private String outputfilename_;
    private String encoding_;
    private PrintWriter writer_;

    public SimpleXMLFormatter(String outputfilename, String encoding) {
        this.outputfilename_ = outputfilename;
        this.encoding_ = encoding;
    }

    public SimpleXMLFormatter(PrintWriter writer) {
        this.writer_ = writer;
    }

    @Override
    public void format(Project project) {
        try {
            this.format(project.makeDocument());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(Document doc) {
        boolean doNotForgetToDestroyWriterFlag = false;
        try {
            if (this.writer_ == null) {
                this.writer_ = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputfilename_), this.encoding_)));
                doNotForgetToDestroyWriterFlag = true;
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            if (!doNotForgetToDestroyWriterFlag) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = null;
            result = this.writer_ != null ? new StreamResult(this.writer_) : new StreamResult(System.out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            System.err.println(doc);
        }
        finally {
            if (doNotForgetToDestroyWriterFlag && this.writer_ != null) {
                this.writer_.close();
            }
        }
    }
}

