/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.DBScriptGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspBodyGenerator_show;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayscheduleview;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.RdbSetting;
import jp.jasminesoft.jfc.gen.appschema.Rdbtypemap;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.repgen.JfcreporttemplateUtil;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.IType;
import jp.jasminesoft.jfc.tools.xls2appschema.NotnullForSelectPattern;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_conditionlist;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BUploadAction;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringCheck;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);
    private static CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();
    private static ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private static ResourceManager ropt = ResourceManager.getInstance((String)"options");
    private static Set<String> errorNotExistsRefModelitemSet = new HashSet<String>();
    public static final int MAX_NUM_UPDATEALL_BUTTON = 20;
    public static final String UPDATEALL_REPOSITORYKEY_PREFIX = "presentation/layout/panel/link/@action=UpdateAll";
    public static final String UPDATEALL_LABEL_REPOSITORYKEY_PREFIX = "presentation/layout/panel/link[@action=UpdateAll]/@label";
    public static final String BILD_DOMAIN_KEY = "project/environment/@domain";
    public static final String INVALID_CHAR_LIST = "!\"#$%&()*+,-.:;<=>?@[\\]^`{|}~/";
    public static boolean fatalFlag;
    private static Map<String, TreeSet<Integer>> wizardNumbers;
    private static Map<String, Map<Integer, String>> foreignKeyModels;
    private static final String UseCopyAtParentModelCopyKey = "action/updatelist/@use_copy_at_parent_model_copy";
    private static final String[][] dbtypes;
    private static final Map<String, String> dbtypesMap;
    private static String DEFAULT_NUMBERFORMAT;
    private static HashMap<String, HashMap<String, String>> constraintTargets;
    private static Map<String, Boolean> cachedVersionCheckMap;
    private static Map<String, Integer> customizedSearchListWindowProperties;
    private static Set<String> reservedActionCommandSet;
    private static Map<String, String[]> cachedSortByDetailDisplayOrder;
    private static Map<String, String> typemap;

    private static void errorNotExistsRefModelitem(String modelId, String name, String refModelId, String mitemname) {
        String key = modelId + ":" + name;
        if (errorNotExistsRefModelitemSet.contains(key)) {
            return;
        }
        errorNotExistsRefModelitemSet.add(key);
        log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.errorNotExistsRefModelitem", new Object[]{modelId, name, refModelId, mitemname}));
    }

    private static void errorNotExistsRefModel(String modelId, String name, String refModelId) {
        String key = modelId + ":" + name;
        if (errorNotExistsRefModelitemSet.contains(key)) {
            return;
        }
        errorNotExistsRefModelitemSet.add(key);
        log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.errorNotExistsRefModel", new Object[]{modelId, name, refModelId}));
    }

    public static final String isValidName(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int ptr = INVALID_CHAR_LIST.indexOf(Character.toString(c));
            if (ptr < 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static final boolean isSelectedValue(String s) {
        return s != null && (ropt.getValue("true").equals(s) || ropt.getValue("true2").equals(s));
    }

    public static final String isSelectedValueAsString(String s) {
        if (s != null && (ropt.getValue("true").equals(s) || ropt.getValue("true2").equals(s))) {
            return "true";
        }
        return "false";
    }

    public static final boolean isErrorValue(String s) {
        return s != null && ropt.getValue("r.selector.error").equals(s);
    }

    public static final boolean isWarnValue(String s) {
        return s != null && ropt.getValue("r.selector.warn").equals(s);
    }

    public static final boolean isErrorOrWarnValue(String s) {
        return s != null && (ropt.getValue("r.selector.error").equals(s) || ropt.getValue("r.selector.warn").equals(s));
    }

    public static final boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        boolean ret = true;
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isSelectedOrIntegerValue(String str) {
        boolean b = Utils.isSelectedValue(str);
        if (!b) {
            b = Utils.isInteger(str);
        }
        return b;
    }

    public static final boolean isIntegerGroup(String str) {
        String[] tokens;
        if (str == null) {
            return false;
        }
        if (str.indexOf(",") < 0) {
            return Utils.isInteger(str);
        }
        boolean ret = true;
        for (String token : tokens = str.split(",")) {
            if (Utils.isInteger(token)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static final String adjustLabel(String label) {
        if (label == null || label.length() == 0) {
            return "";
        }
        label = StringUtil.replaceAll((String)label, (String)"\uff1e", (String)">");
        label = StringUtil.replaceAll((String)label, (String)"\uff0a", (String)"*");
        return label;
    }

    public static final String getDetailType(String modelId, String itemname, ElementContainer con) {
        String detailType = null;
        String defType = con.getModelitemValue(modelId, itemname, "model/modelitem/@type");
        if (StringUtils.isNotBlank((CharSequence)defType)) {
            detailType = IType.getIType(defType);
        }
        if (detailType == null) {
            try {
                throw new IllegalArgumentException();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getDetailType", new Object[]{modelId, itemname}));
            }
        }
        return detailType;
    }

    public static final String convertDetailType2AppSchemaType(String detailType) {
        if (detailType == null) {
            return null;
        }
        String type = null;
        if (!detailType.startsWith("special-")) {
            type = detailType;
        } else if (detailType.startsWith("special-masterref")) {
            type = "masterref";
        } else if (detailType.startsWith("special-storeref")) {
            type = "storeref";
        } else if (detailType.equals("special-mailaddress")) {
            type = "string";
        } else if (detailType.equals("special-url")) {
            type = "string";
        } else if (detailType.equals("special-filename")) {
            type = "string";
        } else if (!detailType.equals("special-container")) {
            if (detailType.equals("special-containerid")) {
                type = "int";
            } else if (detailType.equals("special-fixed-init-dateTime")) {
                type = "dateTime";
            } else if (detailType.equals("special-fixed-init-userid")) {
                type = "string";
            } else if (detailType.equals("special-fixed-update-dateTime")) {
                type = "dateTime";
            } else if (detailType.equals("special-fixed-update-userid")) {
                type = "string";
            }
        }
        return type;
    }

    public static final int countFilenameItem(Model smodel) {
        if (smodel == null) {
            return 0;
        }
        int count = 0;
        for (IModelChoice imc : smodel.getContent()) {
            String pname;
            Modelitem p_sitem;
            Modelitem sitem;
            String name;
            if (!(imc instanceof Modelitem) || !(name = (sitem = (Modelitem)imc).getName()).endsWith("_jshfilename") || (p_sitem = AppSchemaUtil.getModelitem((String)(pname = name.substring(0, name.length() - "_jshfilename".length())), (Model)smodel)) == null) continue;
            ++count;
            break;
        }
        return count;
    }

    public static final boolean hasChartype(String modelId, String itemname, String detailType, ElementContainer con) {
        if ("special-mailaddress".equals(detailType)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, itemname, "model/modelitem/chartype"));
    }

    public static final String getProperCondition(String cond) {
        String ret = null;
        if (StringUtils.isBlank((CharSequence)cond)) {
            ret = "";
        } else if (ropt.getValue("OPTION_action_condition_cond_1_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_7_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_7_value_alt").equals(cond)) {
            ret = "GE";
        } else if (ropt.getValue("OPTION_action_condition_cond_2_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_8_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_8_value_alt").equals(cond)) {
            ret = "LE";
        } else if (ropt.getValue("OPTION_action_condition_cond_3_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_9_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_9_value_alt").equals(cond)) {
            ret = "GT";
        } else if (ropt.getValue("OPTION_action_condition_cond_4_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_10_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_10_value_alt").equals(cond)) {
            ret = "LT";
        } else if (ropt.getValue("OPTION_action_condition_cond_5_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_11_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_11_value_alt").equals(cond)) {
            ret = "EQ";
        } else if (ropt.getValue("OPTION_action_condition_cond_6_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_12_value").equals(cond) || ropt.getValue("OPTION_model_modelitem_consistency_2_12_value_alt").equals(cond)) {
            ret = "NE";
        } else if (ropt.getValue("OPTION_action_condition_cond_7_value").equals(cond) || ropt.getValue("OPTION_action_condition_cond_7_value_warn").equals(cond)) {
            ret = "LIKE";
        } else if (ropt.getValue("OPTION_action_condition_cond_8_value").equals(cond) || ropt.getValue("OPTION_action_condition_cond_8_value_warn").equals(cond)) {
            ret = "LIKE";
        } else if (ropt.getValue("OPTION_action_condition_cond_9_value").equals(cond) || ropt.getValue("OPTION_action_condition_cond_9_value_warn").equals(cond)) {
            ret = "LIKE";
        } else if (ropt.getValue("OPTION_action_condition_cond_10_value").equals(cond)) {
            ret = "LIKE";
        }
        return ret;
    }

    public static final String getProperMatchtype(String cond) {
        String ret = null;
        if (StringUtils.isBlank((CharSequence)cond)) {
            ret = "";
        } else if (ropt.getValue("OPTION_action_condition_cond_7_value").equals(cond) || ropt.getValue("OPTION_action_condition_cond_7_value_warn").equals(cond)) {
            ret = "part";
        } else if (ropt.getValue("OPTION_action_condition_cond_8_value").equals(cond) || ropt.getValue("OPTION_action_condition_cond_8_value_warn").equals(cond)) {
            ret = "pre";
        } else if (ropt.getValue("OPTION_action_condition_cond_9_value").equals(cond) || ropt.getValue("OPTION_action_condition_cond_9_value_warn").equals(cond)) {
            ret = "post";
        } else if (ropt.getValue("OPTION_action_condition_cond_10_value").equals(cond)) {
            ret = "runtime";
        }
        return ret;
    }

    public static final boolean getTransientVariable(String modelId, String name, ElementContainer con) {
        String value = con.getModelitemValue(modelId, name, "model/modelitem/@transient");
        return !Utils.isSelectedValue(value);
    }

    public static final boolean getDirectcopyForceVariable(String modelId, String name, ElementContainer con) {
        String value = con.getModelitemValue(modelId, name, "modelitem/directcopy_2");
        return !Utils.isSelectedValue(value);
    }

    public static final boolean checkExistRestrictparam(String modelId, String name, ElementContainer con) {
        boolean ret = false;
        if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source1_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source2_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source3_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source4_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source5_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source6_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source7_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source8_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source9_2"))) {
            ret = true;
        } else if (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/modelitem/relation/restrictparamlist/restrictparam/@source10_2"))) {
            ret = true;
        }
        return ret;
    }

    public static final boolean getRangeConditionVariable(String modelId, String itemname, String detailType, ElementContainer con) {
        boolean ret = false;
        if (("string".equals(detailType) || "byte".equals(detailType) || "short".equals(detailType) || "int".equals(detailType) || "long".equals(detailType) || "float".equals(detailType) || "double".equals(detailType) || "date".equals(detailType) || "dateTime".equals(detailType) || "special-mailaddress".equals(detailType) || "special-url".equals(detailType) || "special-filename".equals(detailType) || "special-containerid".equals(detailType) || "special-fixed-init-userid".equals(detailType) || "special-fixed-update-userid".equals(detailType) || "special-fixed-init-dateTime".equals(detailType) || "special-fixed-update-dateTime".equals(detailType) || "special-storeref-ref".equals(detailType)) && Utils.isSelectedValue(con.getModelitemValue(modelId, itemname, "model/modelitem/@rangeCondition"))) {
            ret = true;
        }
        if (Utils.hasCondition(modelId, itemname, con) && ret) {
            String[] names_;
            block0: for (String name_ : names_ = con.getModelitemNames(modelId)) {
                String realfields = con.getModelitemValue(modelId, name_, "model/modelitem/@realfield");
                if (!Utils.hasCondition(modelId, name_, con) || !StringUtils.isNotBlank((CharSequence)realfields)) continue;
                for (String token : realfields.split(",")) {
                    String type_;
                    if (!token.equals(itemname) || Utils.getRangeConditionVariable(modelId, name_, type_ = Utils.getDetailType(modelId, name_, con), con)) continue;
                    log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getRangeConditionVariable.1", new Object[]{modelId, itemname, name_}));
                    ret = false;
                    break block0;
                }
            }
        }
        return ret;
    }

    public static boolean isMultiple(String modelId, String itemname, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelitemValue(modelId, itemname, "model/modelitem/@multiple"));
    }

    public static String printSelectinputForDate(String combotype, String startyear) {
        StringBuilder sb = new StringBuilder();
        sb.append(combotype);
        String selectinput_type = startyear;
        if (StringUtils.isNotBlank((CharSequence)selectinput_type)) {
            sb.append(selectinput_type);
        }
        return sb.toString();
    }

    public static String printSelectinputForTime(String combotype, String starttime) {
        StringBuilder sb = new StringBuilder();
        sb.append(combotype);
        String selectinput_type = starttime;
        if (StringUtils.isNotBlank((CharSequence)selectinput_type)) {
            sb.append(selectinput_type);
        }
        return sb.toString();
    }

    public static Set<NotnullForSelectPattern> getNotnullForSelect(String modelId, String itemname, ElementContainer con) {
        HashSet<NotnullForSelectPattern> set = new HashSet<NotnullForSelectPattern>();
        String value = con.getModelitemValue(modelId, itemname, "model/modelitem/notnullForSelect");
        if (StringUtils.isBlank((CharSequence)value)) {
            return set;
        }
        if (Utils.isErrorValue(value)) {
            set.add(NotnullForSelectPattern.Single);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_2_value").equals(value)) {
            set.add(NotnullForSelectPattern.Single_Warn);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_7_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_7_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Upper);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_8_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_8_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Upper_Warn);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_9_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_9_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Lower);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_10_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_10_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Lower_Warn);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_3_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_3_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Lower);
            set.add(NotnullForSelectPattern.Upper);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_5_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_5_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Lower_Warn);
            set.add(NotnullForSelectPattern.Upper);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_6_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_6_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Lower);
            set.add(NotnullForSelectPattern.Upper_Warn);
        } else if (ropt.getValue("OPTION_model_modelitem_notnullForSelect_4_value").equals(value) || ropt.getValue("OPTION_model_modelitem_notnullForSelect_4_value_R6").equals(value)) {
            set.add(NotnullForSelectPattern.Lower_Warn);
            set.add(NotnullForSelectPattern.Upper_Warn);
        }
        return set;
    }

    public static final String getAcl_dataacl_groupmanager(String modelId, ElementContainer con) {
        String dataacl_groupmanager = con.getModelValue(modelId, "acl/dataacl_groupmanager");
        if (StringUtils.isBlank((CharSequence)dataacl_groupmanager)) {
            dataacl_groupmanager = "RW";
        }
        return dataacl_groupmanager;
    }

    public static final String getAcl_dataaclpattern(String modelId, ElementContainer con) {
        String ret = null;
        String value = con.getModelValue(modelId, "acl/dataaclpattern");
        ret = ropt.getValue("OPTION_acl_dataaclpattern_1_value").equals(value) ? "RW-N-N-" : (ropt.getValue("OPTION_acl_dataaclpattern_2_value").equals(value) ? "RW-R-N-" : (ropt.getValue("OPTION_acl_dataaclpattern_3_value").equals(value) ? "RW-RW-N-" : (ropt.getValue("OPTION_acl_dataaclpattern_4_value").equals(value) ? "RW-R-R-" : (ropt.getValue("OPTION_acl_dataaclpattern_5_value").equals(value) ? "RW-RW-R-" : (ropt.getValue("OPTION_acl_dataaclpattern_6_value").equals(value) ? "RW-RW-RW-" : "RW-RW-RW-")))));
        return ret + Utils.getAcl_dataacl_groupmanager(modelId, con);
    }

    public static final Map<Groupdateitemtype, List<String>> createGroupdateitemtypeMap(String modelId, ElementContainer con) {
        String[] mitemNames = con.getModelitemNames(modelId);
        EnumMap<Groupdateitemtype, List<String>> rmap = new EnumMap<Groupdateitemtype, List<String>>(Groupdateitemtype.class);
        rmap.put(Groupdateitemtype.username, new ArrayList());
        rmap.put(Groupdateitemtype.jgroupid, new ArrayList());
        for (String mitemName : mitemNames) {
            Groupdateitemtype type = Utils.getGroupdateitemtype(modelId, mitemName, con);
            if (type == null) continue;
            List set = (List)rmap.get((Object)type);
            set.add(mitemName);
        }
        return rmap;
    }

    public static final Groupdateitemtype getGroupdateitemtype(String modelId, String mitemName, ElementContainer con) {
        String groupdateitemtype_str = con.getModelitemValue(modelId, mitemName, "action/condition/groupdateitemtype");
        if (StringUtils.isNotBlank((CharSequence)groupdateitemtype_str)) {
            if (ropt.getValue("OPTION_action_condition_groupdateitemtype_1_value").equals(groupdateitemtype_str)) {
                return Groupdateitemtype.username;
            }
            if (ropt.getValue("OPTION_action_condition_groupdateitemtype_2_value").equals(groupdateitemtype_str)) {
                return Groupdateitemtype.jgroupid;
            }
        }
        return null;
    }

    public static final boolean isMultipartModel(String modelId, ElementContainer con) {
        for (String name : con.getModelitemNames(modelId)) {
            if (!Utils.isDisplayitemType(modelId, name, con, "file")) continue;
            return true;
        }
        return false;
    }

    private static synchronized void initWizardNumbers(ElementContainer con) {
        wizardNumbers = new HashMap<String, TreeSet<Integer>>();
        for (String modelId : con.getAllStoreModelId()) {
            TreeSet<Integer> numbers = new TreeSet<Integer>();
            for (String name : con.getModelitemNames(modelId)) {
                String wizardNum = con.getModelitemValue(modelId, name, "model/modelitem/@wizard");
                if (!Utils.isInteger(wizardNum)) continue;
                numbers.add(Integer.valueOf(wizardNum));
            }
            if (numbers.size() <= 1) continue;
            wizardNumbers.put(modelId, numbers);
        }
    }

    public static final boolean isWizardModel(String modelId, ElementContainer con) {
        if (wizardNumbers == null) {
            Utils.initWizardNumbers(con);
        }
        return wizardNumbers.containsKey(modelId);
    }

    public static final boolean isPresentationShowListOneScreen(String modelId, ElementContainer con) {
        if (Utils.isSmartPhone(modelId, con)) {
            return true;
        }
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return true;
        }
        if (Utils.isShowListDisplayTypeGrid(modelId, con) || Utils.isShowListDisplayTypeSpreadsheet(modelId, con)) {
            return true;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@presentationShowListOnescreen"));
    }

    public static final Map<Integer, List<String>> getWizardModelitemMap(String modelId, ElementContainer con) {
        String[] names;
        TreeMap<Integer, List<String>> wizardMap = new TreeMap<Integer, List<String>>();
        for (String name : names = con.getModelitemNames(modelId)) {
            Integer wizard_num = null;
            String wizard_str = con.getModelitemValue(modelId, name, "model/modelitem/@wizard");
            wizard_num = Utils.isInteger(wizard_str) ? Integer.valueOf(wizard_str) : Integer.valueOf(0);
            ArrayList<String> modelitemNameList = (ArrayList<String>)wizardMap.get(wizard_num);
            if (modelitemNameList == null) {
                modelitemNameList = new ArrayList<String>();
                wizardMap.put(wizard_num, modelitemNameList);
            }
            modelitemNameList.add(name);
        }
        return wizardMap;
    }

    public static final Model[] getForeignkeyModel(String modelId, Project project) {
        ArrayList<Model> mlist = new ArrayList<Model>();
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)modelId);
        if (smodel == null) {
            return null;
        }
        block0: for (IProjectChoice ipc : project.getContent()) {
            Model target;
            ForeignKey[] fkeys;
            if (!(ipc instanceof Model) || (fkeys = AppSchemaUtil.getForeignKey((Model)(target = (Model)ipc))) == null || fkeys.length == 0) continue;
            for (ForeignKey fkey : fkeys) {
                if (!modelId.equals(fkey.getIdref())) continue;
                mlist.add(target);
                continue block0;
            }
        }
        return mlist.toArray(new Model[0]);
    }

    public static final Model[] getUpdatelistForeignkeyModel(String modelId, Project project, ElementContainer con_) {
        ArrayList<Model> mlist = new ArrayList<Model>();
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)modelId);
        if (smodel == null) {
            return null;
        }
        String dbtype = Utils.getDatabaseType(con_);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey((Model)smodel);
        if (pkeys == null || pkeys.length == 0) {
            return null;
        }
        HashSet<String> pkeynameSet = new HashSet<String>();
        for (PrimaryKey primaryKey : pkeys) {
            pkeynameSet.add(primaryKey.getName());
        }
        block1: for (PrimaryKey primaryKey : project.getContent()) {
            ForeignKey[] fkeys;
            boolean updateListForForeignmodel;
            Model target;
            String fmodelid;
            boolean updateListPage;
            if (!(primaryKey instanceof Model) || !(updateListPage = Utils.isSelectedValue(con_.getModelValue(fmodelid = (target = (Model)primaryKey).getId(), "action/@updateListPage"))) || !(updateListForForeignmodel = Utils.isUpdateListForForeignmodel(fmodelid, con_)) || (fkeys = AppSchemaUtil.getForeignKey((Model)target)) == null || fkeys.length == 0) continue;
            HashSet<ForeignKey> foreignkeySet = new HashSet<ForeignKey>();
            for (ForeignKey foreignKey : fkeys) {
                if (!foreignKey.getIdref().equals(modelId)) continue;
                foreignkeySet.add(foreignKey);
            }
            if (foreignkeySet.size() == 0) continue;
            for (String pkey : pkeynameSet) {
                Modelitem modelitem;
                boolean hasConditionModel;
                ForeignKey fkey2 = null;
                for (ForeignKey _fkey : foreignkeySet) {
                    if (!pkey.equals(AppSchemaUtil.getForeignKeyTargetItemName((ForeignKey)_fkey))) continue;
                    fkey2 = _fkey;
                }
                if (fkey2 == null || !(hasConditionModel = Utils.isSelectedOrIntegerValue(con_.getModelitemValue(fmodelid, (modelitem = AppSchemaUtil.getModelitem((String)fkey2.getName(), (Model)target)).getName(), "model/modelitem/@hasConditionModel")))) continue block1;
                Condition condition = BActionElement_conditionlist.createCondition(fmodelid, target, modelitem, dbtype, hasConditionModel, con_, null);
                if (condition == null || condition.getCond().equals("EQ")) {
                    mlist.add(target);
                    continue block1;
                }
                String detailType = Utils.getDetailType(fmodelid, modelitem.getName(), con_);
                boolean rangeCondition = Utils.getRangeConditionVariable(modelId, modelitem.getName(), detailType, con_);
                if (!rangeCondition) continue;
                mlist.add(target);
                continue block1;
            }
        }
        return mlist.toArray(new Model[0]);
    }

    public static final String printItemView(String value) {
        String ret = null;
        if (ropt.getValue("LABEL_action_view_item_name_1_value").equals(value)) {
            ret = "date";
        } else if (ropt.getValue("LABEL_action_view_item_name_0_value").equals(value)) {
            ret = "calendartype";
        } else if (ropt.getValue("LABEL_action_view_item_name_4_value").equals(value)) {
            ret = "starttime";
        } else if (ropt.getValue("LABEL_action_view_item_name_5_value").equals(value)) {
            ret = "endtime";
        } else if (ropt.getValue("LABEL_action_view_item_name_4_value_alt1").equals(value)) {
            ret = "starthour";
        } else if (ropt.getValue("LABEL_action_view_item_name_4_value_alt2").equals(value)) {
            ret = "startminute";
        } else if (ropt.getValue("LABEL_action_view_item_name_5_value_alt1").equals(value)) {
            ret = "endhour";
        } else if (ropt.getValue("LABEL_action_view_item_name_5_value_alt2").equals(value)) {
            ret = "endminute";
        } else if (ropt.getValue("LABEL_action_view_item_name_3_value").equals(value) || ropt.getValue("LABEL_action_view_item_name_2_value").equals(value)) {
            ret = "title";
        } else if (ropt.getValue("LABEL_action_view_item_name_7_value").equals(value)) {
            ret = "place";
        } else if (ropt.getValue("LABEL_action_view_item_name_6_value").equals(value)) {
            ret = "staff";
        } else if (ropt.getValue("LABEL_action_view_item_name_8_value").equals(value)) {
            ret = "note";
        } else if (ropt.getValue("LABEL_action_view_item_name_9_value").equals(value)) {
            ret = "url";
        } else if (ropt.getValue("LABEL_action_view_item_name_10_value").equals(value)) {
            ret = "allDay";
        }
        return ret;
    }

    public static final boolean isInsertPage(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@insertPage"));
    }

    public static final boolean isUpdatePage(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@updatePage"));
    }

    public static final boolean isShowPage(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@showPage"));
    }

    public static final boolean isPrintScreenPage(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        if (!Utils.isShowPage(modelId, con)) {
            return false;
        }
        if (!con.existsKeyInModel(modelId, "action/@printScreen")) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)con.getModelValue(modelId, "action/@printScreen"));
    }

    public static final boolean isPrintListScreenPage(String modelId, ElementContainer con) {
        if (!con.existsKeyInModel(modelId, "action/@printListScreen")) {
            return false;
        }
        if (!Utils.isShowListPage(modelId, con)) {
            return false;
        }
        if (Utils.isSelectedValue(con.getModelValue(modelId, "action/@printListScreen"))) {
            return true;
        }
        String showcondition = Utils.convertProperShowconditionForShow(modelId, con, "action/@printListScreen");
        return !StringUtils.isBlank((CharSequence)showcondition) && !"false".equals(showcondition);
    }

    public static final boolean isShowListPage(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@showListPage"));
    }

    public static final boolean isUpdateListPage(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@updateListPage"));
    }

    public static final boolean isUpdateListForForeignmodel(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@updateListForForeignmodel"));
    }

    public static final boolean isReportListPage(String modelId, ElementContainer con) {
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@reportListPage"));
    }

    public static final boolean isCsvOutput(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@csvOutput"));
    }

    public static final boolean isUploadUpdateOutput(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@uploadupdateOutput"));
    }

    public static final boolean isCalendarOutput(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@calendarOutput"));
    }

    public static final boolean isMapviewOutput(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@mapviewOutput"));
    }

    public static final boolean isTotalviewOutput(String modelId, ElementContainer con) {
        String[] keys;
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        for (String key : keys = con.getKeysByModelAndKeyPrefix(modelId, "model/@totalviewOutput")) {
            if (!Utils.isSelectedValue(con.getModelValue(modelId, key))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isScheduleviewOutput(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con) || Utils.isMobile(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@scheduleviewOutput"));
    }

    public static final String getScheduleviewType(String modelId, ElementContainer con) {
        String type = con.getModelValue(modelId, "presentation/scheduleviewOutput/@type");
        if (StringUtils.isBlank((CharSequence)type)) {
            return "timeline";
        }
        return type;
    }

    public static void setSchedleviewHeight(String modelId, Displayscheduleview displayscheduleview, ElementContainer con) {
        String height = con.getModelValue(modelId, "presentation/scheduleviewOutput/@height");
        if (StringUtils.isNotBlank((CharSequence)height)) {
            displayscheduleview.setHeight(height);
        }
    }

    public static final boolean isUpdateShowList(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        String showcondition = Utils.convertProperShowconditionForUpdateshowlist(modelId, con, "model/@updateshowlist");
        return !"false".equals(showcondition);
    }

    public static final boolean isUseJumplinkForShowList(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "presentation/layout/panel/movebutton/@useJumplinkForShowList"));
    }

    public static final boolean isUseJumplinkForUpdateList(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "presentation/layout/panel/movebutton/@useJumplinkForUpdateList"));
    }

    public static final boolean isMoveResultForShow(String modelId, ElementContainer con) {
        return StringUtils.isNotBlank((CharSequence)con.getModelValue(modelId, "action/@isMoveResultForShow"));
    }

    public static final String getForeignKey(String modelId, String itemname, ElementContainer con) {
        return con.getModelitemValue(modelId, itemname, "model/modelitem/@outsideKey");
    }

    private static synchronized void initForeignKeyModels(ElementContainer con) {
        foreignKeyModels = new TreeMap<String, Map<Integer, String>>();
        Integer menuOrder = null;
        for (String modelId : con.getAllStoreModelId()) {
            for (String name : con.getModelitemNames(modelId)) {
                String foreignkeyModel = Utils.getForeignKey(modelId, name, con);
                try {
                    menuOrder = Integer.valueOf(con.getModelValue(modelId, "model/@menuorder"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (menuOrder == null) {
                    menuOrder = 100;
                }
                if (!StringUtils.isNotBlank((CharSequence)foreignkeyModel)) continue;
                Map<Integer, String> models = foreignKeyModels.get(foreignkeyModel);
                if (models == null) {
                    models = new TreeMap<Integer, String>();
                }
                if (models.containsKey(menuOrder)) {
                    while (models.containsKey(menuOrder = Integer.valueOf(menuOrder + 10))) {
                    }
                }
                models.put(menuOrder, modelId);
                foreignKeyModels.put(foreignkeyModel, models);
            }
        }
    }

    public static final boolean isForeignKeyDefined(String modelId, ElementContainer con) {
        if (foreignKeyModels == null) {
            Utils.initForeignKeyModels(con);
        }
        return foreignKeyModels.containsKey(modelId);
    }

    public static final String[] getForeignKeyModels(String modelId, ElementContainer con) {
        Map<Integer, String> fmodels;
        if (foreignKeyModels == null) {
            Utils.initForeignKeyModels(con);
        }
        if ((fmodels = foreignKeyModels.get(modelId)) != null) {
            return fmodels.values().toArray(new String[0]);
        }
        return new String[0];
    }

    public static final String[] getForeignKeyModelsConsideringTabposition(String modelId, ElementContainer con) {
        ArrayList<Object> fmodelIds = new ArrayList<Object>();
        HashSet<String> processedModelIdSet = new HashSet<String>();
        TreeMap<Integer, String> sortOrderForeignModelId = new TreeMap<Integer, String>();
        for (String fmodelId : Utils.getForeignKeyModels(modelId, con)) {
            String[] tokens;
            String _value;
            if (processedModelIdSet.contains(fmodelId) || !con.existsKeyInModel(fmodelId, "model/foreignkey/display/@tabposition") || !StringUtils.isNotBlank((CharSequence)(_value = con.getModelValue(fmodelId, "model/foreignkey/display/@tabposition")))) continue;
            for (String token : tokens = _value.split(",")) {
                int max;
                Optional maxCandidate;
                int tmp;
                String idx;
                int ptr = token.trim().indexOf(":");
                if (ptr <= 0) continue;
                String mid = token.substring(0, ptr).trim();
                String rest = token.substring(ptr + 1);
                if (mid == null || !mid.equals(modelId)) continue;
                int ptr2 = rest.indexOf(":");
                if (ptr2 > 0) {
                    idx = rest.substring(ptr2 + 1);
                    tmp = NumberUtils.toInt((String)idx);
                    if (tmp <= 0) continue;
                    if (sortOrderForeignModelId.containsKey(tmp)) {
                        maxCandidate = sortOrderForeignModelId.keySet().stream().max(Comparator.naturalOrder());
                        max = maxCandidate.orElse(999998) + 1;
                        log.warn("Duplicate tab position " + tmp + " has detected in fmodel " + fmodelId + ". Change position " + tmp + " to " + max);
                        tmp = max;
                    }
                    sortOrderForeignModelId.put(tmp, fmodelId);
                    processedModelIdSet.add(fmodelId);
                    continue;
                }
                idx = rest;
                tmp = NumberUtils.toInt((String)idx);
                if (tmp <= 0) continue;
                if (sortOrderForeignModelId.containsKey(tmp)) {
                    maxCandidate = sortOrderForeignModelId.keySet().stream().max(Comparator.naturalOrder());
                    max = maxCandidate.orElse(999998) + 1;
                    log.warn("Duplicate tab position " + tmp + " has detected in fmodel " + fmodelId + ". Change position " + tmp + " to " + max);
                    tmp = max;
                }
                sortOrderForeignModelId.put(tmp, fmodelId);
                processedModelIdSet.add(fmodelId);
            }
        }
        fmodelIds.addAll(sortOrderForeignModelId.values());
        for (String fmodelId : Utils.getForeignKeyModels(modelId, con)) {
            if (fmodelIds.contains(fmodelId) || processedModelIdSet.contains(fmodelId)) continue;
            fmodelIds.add(fmodelId);
            processedModelIdSet.add(fmodelId);
        }
        return fmodelIds.toArray(new String[0]);
    }

    public static final String[] getOutsideKeys(String modelId, ElementContainer con) {
        ArrayList<String> outsideKeys = new ArrayList<String>();
        for (String name : con.getModelitemNamesByKey(modelId, "model/modelitem/@outsideKey")) {
            String outsideKey = con.getModelitemValue(modelId, name, "model/modelitem/@outsideKey");
            if (!StringUtils.isNotBlank((CharSequence)outsideKey)) continue;
            outsideKeys.add(outsideKey);
        }
        return outsideKeys.toArray(new String[0]);
    }

    public static final int countWizardModelitem(String modelId, ElementContainer con) {
        String[] names;
        int count = 0;
        for (String name : names = con.getModelitemNames(modelId)) {
            String w_value;
            if (StringUtils.isBlank((CharSequence)name) || !StringUtils.isNotBlank((CharSequence)(w_value = con.getModelitemValue(modelId, name, "model/modelitem/@wizard"))) || !Utils.isInteger(w_value)) continue;
            ++count;
        }
        return count;
    }

    public static final String getSearchtype(String modelId, String itemname, ElementContainer con) {
        String searchtype = null;
        String value = con.getModelitemValue(modelId, itemname, "model/modelitem/searchtype");
        if (ropt.getValue("OPTION_model_modelitem_searchtype_1_value").equals(value)) {
            searchtype = "combo";
        } else if (ropt.getValue("OPTION_model_modelitem_searchtype_3_value").equals(value)) {
            searchtype = "radio";
        } else if (ropt.getValue("OPTION_model_modelitem_searchtype_2_value").equals(value)) {
            searchtype = "check";
        }
        return searchtype;
    }

    public static final boolean isCsvoutput(String modelId, ElementContainer con) {
        if (Utils.isCsvDownloadJobOrScreen(modelId, con)) {
            return true;
        }
        return Utils.isUploadUpdateJobOrScreen(modelId, con);
    }

    public static final boolean isCsvDownloadJobOrScreen(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        if (Utils.isCsvOutput(modelId, con)) {
            return true;
        }
        return BJob.isUseDownloadJob(con, modelId);
    }

    public static final boolean isUploadUpdateJobOrScreen(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        if (Utils.isUploadUpdateOutput(modelId, con)) {
            return true;
        }
        return BJob.isUseUploadUpdateJob(con, modelId);
    }

    public static final String printLinkPosition(String position) {
        String ret = null;
        ret = ropt.getValue("OPTION_action_linkposition_1_value").equals(position) ? "upper" : (ropt.getValue("OPTION_action_linkposition_2_value").equals(position) ? "lower" : (ropt.getValue("OPTION_action_linkposition_3_value").equals(position) ? "both" : "upper"));
        return ret;
    }

    public static final boolean useFieldSet(String modelId, ElementContainer con) {
        boolean ret = true;
        String value = con.getModelValue(modelId, "presentation/displaymodel/@useFieldSet");
        if (ropt.getValue("OPTION_presentation_displaymodel_useFieldSet_1_value").equals(value)) {
            ret = true;
        } else if (ropt.getValue("OPTION_presentation_displaymodel_useFieldSet_2_value").equals(value)) {
            ret = false;
        }
        return ret;
    }

    public static final boolean hasConditionModel(String modelId, ElementContainer con) {
        if (Utils.isStaticSelectedModel(modelId, con)) {
            return false;
        }
        for (String name : con.getModelitemNames(modelId)) {
            if (Utils.isLayoutOnly(modelId, name, con) || !Utils.isSelectedOrIntegerValue(con.getModelitemValue(modelId, name, "model/modelitem/@hasConditionModel"))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isModelitemType(String modelId, String name, ElementContainer con, String type) {
        String detailType = Utils.getDetailType(modelId, name, con);
        return "storeref".equals(Utils.convertDetailType2AppSchemaType(detailType)) && Utils.isRelationType(modelId, name, con, "ref") ? type.equals(Utils.getModelitemTypeRefRelation(modelId, name, con, new ArrayList<String>())) : type.equals(detailType);
    }

    public static final boolean isRefModelitemType(String modelId, String name, ElementContainer con, String type) {
        String detailType = Utils.getDetailType(modelId, name, con);
        return "storeref".equals(Utils.convertDetailType2AppSchemaType(detailType)) && Utils.isRelationType(modelId, name, con, "ref") ? type.equals(Utils.getRefModelitemType(modelId, name, con, new ArrayList<String>())) : type.equals(detailType);
    }

    public static final String getModelitemType(String modelId, String name, ElementContainer con) {
        String refModelId;
        String detailType = Utils.getDetailType(modelId, name, con);
        if ("storeref".equals(Utils.convertDetailType2AppSchemaType(detailType))) {
            if (Utils.isRelationType(modelId, name, con, "ref")) {
                return Utils.getModelitemTypeRefRelation(modelId, name, con, new ArrayList<String>());
            }
        } else if ("masterref".equals(Utils.convertDetailType2AppSchemaType(detailType)) && con.getKeysByModel(refModelId = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref")).length == 0) {
            Utils.errorNotExistsRefModel(modelId, name, refModelId);
        }
        return Utils.getAppSchemaType(modelId, name, con);
    }

    private static final String getModelitemTypeRefRelation(String modelId, String name, ElementContainer con, List<String> recursiveCheckList) {
        String detailtype;
        if (fatalFlag) {
            return "string";
        }
        if (!Utils.isRelationType(modelId, name, con, "ref")) {
            return Utils.convertDetailType2AppSchemaType(Utils.getDetailType(modelId, name, con));
        }
        String refModelId = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref");
        String mitemname = con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@rolecontent");
        if (StringUtils.isBlank((CharSequence)refModelId)) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.1", new Object[]{modelId, name}));
        }
        if (StringUtils.isBlank((CharSequence)mitemname)) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.2", new Object[]{modelId, name}));
        }
        if ((detailtype = Utils.getDetailType(refModelId, mitemname, con)) == null) {
            if (con.getKeysByModel(refModelId).length > 0) {
                Utils.errorNotExistsRefModelitem(modelId, name, refModelId, mitemname);
            } else {
                Utils.errorNotExistsRefModel(modelId, name, refModelId);
            }
            return "string";
        }
        if ("storeref".equals(Utils.convertDetailType2AppSchemaType(detailtype))) {
            if (modelId.equals(refModelId) && name.equals(mitemname)) {
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.3", new Object[]{modelId, name}));
                throw new RuntimeException(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.3", new Object[]{modelId, name}));
            }
            String current = " '" + modelId + "'.'" + name + "'";
            for (String pair : recursiveCheckList) {
                if (!pair.equals(current)) continue;
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.4", new Object[]{modelId, name, recursiveCheckList}));
                fatalFlag = true;
                throw new RuntimeException(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.4", new Object[]{modelId, name, recursiveCheckList}));
            }
            recursiveCheckList.add(current);
            return Utils.getModelitemTypeRefRelation(refModelId, mitemname, con, recursiveCheckList);
        }
        return Utils.getModelitemType(refModelId, mitemname, con);
    }

    private static final String getRefModelitemType(String modelId, String name, ElementContainer con, List<String> recursiveCheckList) {
        String detailtype;
        if (!Utils.isRelationType(modelId, name, con, "ref")) {
            return Utils.getDetailType(modelId, name, con);
        }
        String refModelId = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref");
        String mitemname = con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@rolecontent");
        if (StringUtils.isBlank((CharSequence)refModelId)) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.1", new Object[]{modelId, name}));
        }
        if (StringUtils.isBlank((CharSequence)mitemname)) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.2", new Object[]{modelId, name}));
        }
        if ((detailtype = Utils.getDetailType(refModelId, mitemname, con)) == null) {
            if (con.getKeysByModel(refModelId).length > 0) {
                Utils.errorNotExistsRefModelitem(modelId, name, refModelId, mitemname);
            } else {
                Utils.errorNotExistsRefModel(modelId, name, refModelId);
            }
            return null;
        }
        String current = rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getRefModelitemType", new Object[]{modelId, name});
        for (String pair : recursiveCheckList) {
            if (!pair.equals(current)) continue;
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.4", new Object[]{modelId, name, recursiveCheckList}));
            return "string";
        }
        recursiveCheckList.add(current);
        return Utils.getRefModelitemType(refModelId, mitemname, con, recursiveCheckList);
    }

    public static final String getDisplayitemType(String modelId, String name, ElementContainer con) {
        if (Utils.isDetailType(modelId, name, con, "special-filename")) {
            return "file";
        }
        if (Utils.isDetailType(modelId, name, con, "special-url")) {
            return "url";
        }
        if (Utils.isDetailType(modelId, name, con, "special-mailaddress")) {
            return "email";
        }
        if (Utils.isDetailType(modelId, name, con, "zipcode")) {
            return "zipcode";
        }
        String displayitemType = IType.getIType(con.getModelitemValue(modelId, name, "presentation/displayitem/@type"));
        if (StringUtils.isNotBlank((CharSequence)displayitemType)) {
            return displayitemType;
        }
        if (Utils.isDetailType(modelId, name, con, "special-storeref-ref") || Utils.isDetailType(modelId, name, con, "ref")) {
            return Utils.getDisplayitemTypeRefRelation(modelId, name, con, new ArrayList<String>());
        }
        return "";
    }

    private static final String getDisplayitemTypeRefRelation(String modelId, String name, ElementContainer con, List<String> recursiveCheckList) {
        String detailtype;
        if (!Utils.isRelationType(modelId, name, con, "ref")) {
            return Utils.getDisplayitemType(modelId, name, con);
        }
        String refModelId = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref");
        String mitemname = con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@rolecontent");
        if (StringUtils.isBlank((CharSequence)refModelId)) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.1", new Object[]{modelId, name}));
        }
        if (StringUtils.isBlank((CharSequence)mitemname)) {
            log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.2", new Object[]{modelId, name}));
        }
        if ((detailtype = Utils.getDetailType(refModelId, mitemname, con)) == null) {
            if (con.getKeysByModel(refModelId).length > 0) {
                Utils.errorNotExistsRefModelitem(modelId, name, refModelId, mitemname);
            } else {
                Utils.errorNotExistsRefModel(modelId, name, refModelId);
            }
            return "string";
        }
        if ("storeref".equals(Utils.convertDetailType2AppSchemaType(detailtype))) {
            if (modelId.equals(refModelId) && name.equals(mitemname)) {
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.3", new Object[]{modelId, name}));
                return "string";
            }
            String current = "\u30e2\u30c7\u30eb '" + modelId + "' \u306e\u9805\u76ee '" + name + "'";
            for (String pair : recursiveCheckList) {
                if (!pair.equals(current)) continue;
                log.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.getModelitemTypeRefRelation.4", new Object[]{modelId, name, recursiveCheckList}));
                return "string";
            }
            recursiveCheckList.add(current);
            return Utils.getDisplayitemTypeRefRelation(refModelId, mitemname, con, recursiveCheckList);
        }
        return Utils.getDisplayitemType(refModelId, mitemname, con);
    }

    public static final boolean isDisplayitemType(String modelId, String name, ElementContainer con, String type) {
        return type.equals(Utils.getDisplayitemType(modelId, name, con));
    }

    public static final boolean isDisplayitemDisplay(String modelId, String name, int wizNum, ElementContainer con) {
        if (Utils.isDetailType(modelId, name, con, "special-container")) {
            return false;
        }
        return Utils.isDisplayitemDisplayOnWizardPage(modelId, name, wizNum, con);
    }

    public static final boolean isDisplayitemDisplayOnWizardPage(String modelId, String name, int wizNum, ElementContainer con) {
        String srcName;
        if (!Utils.isWizardModel(modelId, con)) {
            return true;
        }
        String wizardNum = con.getModelitemValue(modelId, name, "model/modelitem/@wizard");
        if (StringUtils.isBlank((CharSequence)wizardNum)) {
            return false;
        }
        if (wizardNum.equals(String.valueOf(wizNum)) || "all".equals(wizardNum)) {
            return true;
        }
        return Utils.isConstraintTarget(modelId, name, con) && Utils.isConstraintSrcDisplayWizardPage(modelId, srcName = Utils.getConstraintSrcName(modelId, name, con), wizNum, con);
    }

    public static final boolean isDetailType(String modelId, String name, ElementContainer con, String type) {
        String detailType = IType.getIType(con.getModelitemValue(modelId, name, "model/modelitem/@type"));
        return type.equals(detailType);
    }

    public static final boolean isPrimaryKey(String modelId, String name, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@primaryKey"));
    }

    public static final boolean isAutoId(String modelId, String name, ElementContainer con) {
        return StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "model/primaryKey/@autoid"));
    }

    public static final boolean isBranchId(String modelId, String name, ElementContainer con) {
        boolean isBranch = false;
        if (con.existsKeyInModelitem(modelId, name, "model/primaryKey/@branch")) {
            isBranch = Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/primaryKey/@branch"));
        }
        return isBranch;
    }

    public static final boolean isAutoCalcType(String modelId, String name, ElementContainer con, String type) {
        String autocalctype = con.getModelitemValue(modelId, name, "model/modelitem/autocalc");
        return type.equals(IType.getIType(autocalctype));
    }

    public static final boolean isWizardAttr(String modelId, String name, ElementContainer con, String type) {
        return type.equals(con.getModelitemValue(modelId, name, "model/modelitem/@wizard"));
    }

    public static final String getRelationType(String modelId, String name, ElementContainer con) {
        String MASTER_REF = "special-masterref-";
        String STORE_REF = "special-storeref-";
        String detailType = IType.getIType(con.getModelitemValue(modelId, name, "model/modelitem/@type"));
        if (detailType.startsWith(MASTER_REF)) {
            return StringUtils.substringAfter((String)detailType, (String)MASTER_REF);
        }
        if (detailType.startsWith(STORE_REF)) {
            return StringUtils.substringAfter((String)detailType, (String)STORE_REF);
        }
        if ("string".equals(detailType) && Utils.isAutocalcBarcodeDefined(modelId, name, con)) {
            return "barcode";
        }
        return "";
    }

    public static final boolean isRelationType(String modelId, String name, ElementContainer con, String type) {
        return Utils.getRelationType(modelId, name, con).equals(type);
    }

    public static final boolean isClear(String modelId, String name, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@clear"));
    }

    public static final String getLinkPosition(String modelId, ElementContainer con, String method) {
        StringBuilder positionKey = new StringBuilder();
        positionKey.append("presentation/linkpositionFor");
        String methodType = "copy".equals(method) ? "insert" : method;
        positionKey.append(StringUtils.capitalize((String)methodType));
        String linkPosition = con.getModelValue(modelId, positionKey.toString());
        return Utils.printLinkPosition(linkPosition);
    }

    public static final boolean isLinkPosition(String modelId, ElementContainer con, String method, String position) {
        if (Utils.isMobile(modelId, con) && "show".equals(method)) {
            return true;
        }
        if (("updateList".equals(method) || "updateListInParent".equals(method)) && "upper".equals(position)) {
            return true;
        }
        String linkPosition = Utils.getLinkPosition(modelId, con, method);
        return position.equals(linkPosition) || "both".equals(linkPosition);
    }

    public static final boolean isForeignKeyModel(String modelId, ElementContainer con) {
        if (!Utils.isForeignKeyDefined(modelId, con)) {
            return false;
        }
        for (String fmodelId : Utils.getForeignKeyModels(modelId, con)) {
            if (!Utils.isUpdateListPage(fmodelId, con) || !Utils.isUpdateListForForeignmodel(fmodelId, con)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isButtonAllClearInsert(String modelId, ElementContainer con) {
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "presentation[@idref=insert]/link/allclearbutton"));
    }

    public static final boolean isButtonAllClearUpdate(String modelId, ElementContainer con) {
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "presentation[@idref=update]/link/allclearbutton"));
    }

    public static final boolean isSendmailInsertButton(String modelId, ElementContainer con) {
        return Utils.isShowSendmailButton(modelId, con, "insert");
    }

    public static final boolean isSendmailUpdateButton(String modelId, ElementContainer con) {
        return Utils.isShowSendmailButton(modelId, con, "update");
    }

    public static final boolean isSendmailShowButton(String modelId, ElementContainer con) {
        return Utils.isShowSendmailButton(modelId, con, "show");
    }

    private static final boolean isShowSendmailButton(String modelId, ElementContainer con, String occasion) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/sendmail/" + occasion + "/@send")) && !ropt.getValue("OPTION_model_sendmail_insert_newbutton_0_value").equals(con.getModelValue(modelId, "model/sendmail/" + occasion + "/@newbutton")) && !ropt.getValue("OPTION_model_sendmail_insert_newbutton_1_value").equals(con.getModelValue(modelId, "model/sendmail/" + occasion + "/@newbutton"));
    }

    public static final TreeSet<Integer> getWizardNumbers(String modelId, ElementContainer con) {
        if (wizardNumbers == null) {
            Utils.initWizardNumbers(con);
        }
        return wizardNumbers.get(modelId);
    }

    public static final int getMinWizardNumber(String modelId, ElementContainer con) {
        TreeSet<Integer> numbers = Utils.getWizardNumbers(modelId, con);
        if (numbers != null) {
            return numbers.first();
        }
        return -1;
    }

    public static final int getMaxWizardNumber(String modelId, ElementContainer con) {
        TreeSet<Integer> numbers = Utils.getWizardNumbers(modelId, con);
        if (numbers != null) {
            return numbers.last();
        }
        return -1;
    }

    public static final boolean isDisplayMapItem(String modelId, ElementContainer con) {
        for (String name : con.getModelitemNamesByKey(modelId, "presentation/displaymap/item")) {
            if (!StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "presentation/displaymap/item"))) continue;
            return true;
        }
        return false;
    }

    public static final String getAppSchemaType(String modelId, String name, ElementContainer con) {
        return Utils.convertDetailType2AppSchemaType(Utils.getDetailType(modelId, name, con));
    }

    public static final boolean isWizardPrevNextLinkLocation(String modelId, ElementContainer con, String position) {
        if (position == null) {
            return false;
        }
        return position.equals(Utils.getWizardPrevNextLinkLocation(modelId, con));
    }

    public static final String getModelitemRelationType(String modelId, String name, ElementContainer con) {
        if ("storeref".equals(Utils.convertDetailType2AppSchemaType(con.getModelitemValue(modelId, name, "model/modelitem/@type"))) && Utils.isRelationType(modelId, name, con, "ref")) {
            return Utils.getModelitemRelationTypeRefRelation(modelId, name, con);
        }
        return Utils.getRelationType(modelId, name, con);
    }

    public static final String getModelitemRelationTypeRefRelation(String modelId, String name, ElementContainer con) {
        String refModelId = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref");
        String mitemname = Utils.isRelationType(modelId, name, con, "ref") ? name : con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@roleid_2");
        String modelitemType = Utils.getModelitemType(modelId, name, con);
        if (!"ref".equals(modelitemType)) {
            return modelitemType;
        }
        if ("storeref".equals(Utils.convertDetailType2AppSchemaType(con.getModelitemValue(refModelId, mitemname, "model/modelitem/@type")))) {
            return Utils.getModelitemRelationTypeRefRelation(refModelId, mitemname, con);
        }
        return Utils.getModelitemType(refModelId, mitemname, con);
    }

    public static final boolean isNotnullForSelect(String modelId, String name, ElementContainer con) {
        return Utils.isErrorValue(con.getModelitemValue(modelId, name, "model/modelitem/notnullForSelect"));
    }

    public static final boolean isRangeCondition(String modelId, String name, ElementContainer con) {
        String type = Utils.convertDetailType2AppSchemaType(Utils.getDetailType(modelId, name, con));
        if ("string".equals(type) || "byte".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "date".equals(type) || "dateTime".equals(type) || Utils.isDetailType(modelId, name, con, "special-storeref-ref")) {
            return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@rangeCondition"));
        }
        return false;
    }

    public static final boolean isSearchType(String modelId, String name, ElementContainer con, String type) {
        return type.equals(Utils.getSearchtype(modelId, name, con));
    }

    public static final boolean isReadonlyForEdit(String modelId, String name, String method, int wizNum, ElementContainer con) {
        String autoCalc = con.getModelitemValue(modelId, name, "model/modelitem/autocalc_2");
        String relationtype = con.getModelitemValue(modelId, name, "presentation/displayitem/@storerefdisplay");
        return "update".equals(method) && (Utils.isPrimaryKey(modelId, name, con) || StringUtils.isNotBlank((CharSequence)Utils.getLocknames(modelId, name, con))) || Utils.isAutoId(modelId, name, con) || Utils.isDisplayitemReadonly(modelId, name, method, con) && (StringUtils.isNotBlank((CharSequence)relationtype) || !"search".equals(IType.getIType(relationtype))) || StringUtils.isNotBlank((CharSequence)autoCalc) && !Utils.isAutoCalcType(modelId, name, con, "padding") || Utils.isWizardAttr(modelId, name, con, "all") && wizNum != Utils.getMinWizardNumber(modelId, con);
    }

    private static String getLocknames(String modelId, String name, ElementContainer con) {
        if (!Utils.isPessimisticLockRelatedMainSubModel(modelId, con)) {
            return "";
        }
        return con.getModelitemValue(modelId, name, "model/datalock/@name");
    }

    public static final boolean isReadonlyForPrint(String modelId, String name, String idreftype, ElementContainer con) {
        String autoCalc = con.getModelitemValue(modelId, name, "model/modelitem/autocalc_2");
        String relationtype = con.getModelitemValue(modelId, name, "presentation/displayitem/@storerefdisplay");
        String foreignKey = con.getModelitemValue(modelId, name, "model/modelitem/@outsideKey");
        return ("updateList".equals(idreftype) || "updateListInParent".equals(idreftype)) && Utils.isReadonlyUpdateList(modelId, name, con) || Utils.isAutoId(modelId, name, con) || Utils.isDisplayitemReadonly(modelId, name, con) && (StringUtils.isNotBlank((CharSequence)relationtype) || !"search".equals(IType.getIType(relationtype))) || StringUtils.isNotBlank((CharSequence)foreignKey) || StringUtils.isNotBlank((CharSequence)autoCalc) && !Utils.isAutoCalcType(modelId, name, con, "padding");
    }

    public static final boolean isReadonlyForShow(String modelId, String name, ElementContainer con) {
        String autoCalc = con.getModelitemValue(modelId, name, "model/modelitem/autocalc_2");
        String relationtype = con.getModelitemValue(modelId, name, "presentation/displayitem/@storerefdisplay");
        String foreignKey = con.getModelitemValue(modelId, name, "model/modelitem/@outsideKey");
        return Utils.isAutoId(modelId, name, con) || Utils.isDisplayitemReadonly(modelId, name, con) && (StringUtils.isNotBlank((CharSequence)relationtype) || !"search".equals(IType.getIType(relationtype))) || StringUtils.isNotBlank((CharSequence)foreignKey) || StringUtils.isNotBlank((CharSequence)autoCalc) && !Utils.isAutoCalcType(modelId, name, con, "padding");
    }

    public static final boolean isReadonlyForSearch(String modelId, String name, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@readonlyForSearch"));
    }

    public static final boolean isReadonlyUpdateList(String modelId, String name, ElementContainer con) {
        boolean isRejectReadonlyUpdatelist = Utils.isRejectReadonlyUpdateList(modelId, name, con);
        if (!isRejectReadonlyUpdatelist) {
            return false;
        }
        boolean isRejectUpdateList = !Utils.isDetailType(modelId, name, con, "zipcode") && (StringUtils.isBlank((CharSequence)Utils.getRelationType(modelId, name, con)) || Utils.isRelationType(modelId, name, con, "combo") || Utils.isRelationType(modelId, name, con, "radio") || Utils.isRelationType(modelId, name, con, "check") || Utils.isRelationType(modelId, name, con, "search")) && !Utils.isDetailType(modelId, name, con, "special-filename") && !"pkey".equals(IType.getIType(con.getModelitemValue(modelId, name, "presentation/displayitem/@type"))) && !Utils.isReadonly(modelId, name, con) && StringUtils.isBlank((CharSequence)Utils.getOutsidekey(modelId, name, con)) && StringUtils.isBlank((CharSequence)Utils.getLocknames(modelId, name, con));
        return !isRejectUpdateList;
    }

    private static String getOutsidekey(String modelId, String name, ElementContainer con) {
        String foreignKey = con.getModelitemValue(modelId, name, "model/modelitem/@outsideKey");
        if (StringUtils.isNotBlank((CharSequence)foreignKey)) {
            return foreignKey;
        }
        foreignKey = con.getModelitemValue(modelId, name, "model/modelitem/@foreignKey");
        if (StringUtils.isNotBlank((CharSequence)foreignKey)) {
            return foreignKey;
        }
        return null;
    }

    private static boolean isReadonly(String modelId, String name, ElementContainer con) {
        String detailType = IType.getIType(con.getModelitemValue(modelId, name, "model/modelitem/@type"));
        boolean readonly = Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@readonly")) || detailType.startsWith("special-fixed") || "special-containerid".equals(detailType);
        return readonly;
    }

    public static final boolean isDisplayitemReadonly(String modelId, String name, ElementContainer con) {
        return Utils.isDisplayitemReadonly(modelId, name, null, con);
    }

    public static final boolean isDisplayitemReadonly(String modelId, String name, String methodName, ElementContainer con) {
        String repkey = "presentation/displayitem/@readonly";
        String repkey_value = con.getModelitemValue(modelId, name, repkey);
        String repkey2 = repkey + (String)(methodName != null ? "_" + methodName : "");
        String repkey2_value = con.getModelitemValue(modelId, name, repkey2);
        return Utils.isSelectedValue(repkey_value) || Utils.isSelectedValue(repkey2_value) || Utils.getDetailType(modelId, name, con) != null && Utils.getDetailType(modelId, name, con).startsWith("special-fixed") || Utils.isDetailType(modelId, name, con, "special-containerid");
    }

    public static final String getTargetSuffix(String modelId, String name, ElementContainer con, String modelitem) {
        String targetSuffix = con.getModelitemValue(modelId, name, modelitem);
        if (ropt.getValue("OPTION_action_condition_targetsuffix_lower").equals(targetSuffix)) {
            return "1jshparam";
        }
        if (ropt.getValue("OPTION_action_condition_targetsuffix_upper").equals(targetSuffix)) {
            return "2jshparam";
        }
        return "";
    }

    public static final boolean isResetOnly(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "presentation/layout/panel/displaycondition/@resetOnly"));
    }

    public static final boolean isSearchListmodelitem(Project project, String modelId, ElementContainer con_) {
        if ("juser".equals(modelId)) {
            return true;
        }
        for (IProjectChoice ipc : project.getContent()) {
            if (!(ipc instanceof Model)) continue;
            Model rplModel = (Model)ipc;
            for (IModelChoice imc : rplModel.getContent()) {
                Modelitem rplModelitem;
                if (!(imc instanceof Modelitem) || !"storeref".equals((rplModelitem = (Modelitem)imc).getType())) continue;
                Relation rplrel = AppSchemaUtil.getRelationTypeExceptRef((Modelitem)rplModelitem);
                if (rplrel != null && "search".equals(rplrel.getType()) && rplrel.getIdref().equals(modelId)) {
                    return true;
                }
                if (rplrel == null || !"check".equals(rplrel.getType()) || !rplrel.getIdref().equals(modelId) || !"search".equals(con_.getModelitemValue(rplModel.getId(), rplModelitem.getName(), "model/modelitem/relation_storeref/@ui"))) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isSearchListmodelitemForRefgroup(Project project, String modelId, ElementContainer con_) {
        if ("juser".equals(modelId)) {
            return true;
        }
        for (String t_modelid : con_.getAllStoreModelId()) {
            String representation_registration = con_.getModelValue(t_modelid, "acl/representation_registration");
            if (!ropt.getValue("OPTION_acl_representation_registration_1_value").equals(representation_registration)) continue;
            for (String t_name : con_.getModelitemNames(t_modelid)) {
                Groupdateitemtype groupdateitemtype = Utils.getGroupdateitemtype(t_modelid, t_name, con_);
                if (!Groupdateitemtype.username.equals((Object)groupdateitemtype) || !modelId.equals(con_.getModelitemValue(t_modelid, t_name, "model/modelitem/relation/@idref")) || !"special-storeref-search".equals(Utils.getDetailType(t_modelid, t_name, con_))) continue;
                return true;
            }
        }
        return false;
    }

    public static final String getCapid(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.startsWith("_")) {
            return Utils.getCapid(StringUtils.substringAfter((String)value, (String)"_"));
        }
        String capid = StringUtils.capitalize((String)value);
        if (capid.contains("_")) {
            return StringUtils.substringBefore((String)capid, (String)"_") + Utils.getCapid(StringUtils.substringAfter((String)capid, (String)"_"));
        }
        return capid;
    }

    public static final boolean isUpdateAll(String modelId, ElementContainer con) {
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        Object buttonRepositoryKey = UPDATEALL_REPOSITORYKEY_PREFIX;
        if (Utils.isUpdateAll(modelId, (String)buttonRepositoryKey, con)) {
            return true;
        }
        for (int i = 2; i <= 20; ++i) {
            buttonRepositoryKey = UPDATEALL_REPOSITORYKEY_PREFIX + i;
            if (!Utils.isUpdateAll(modelId, (String)buttonRepositoryKey, con)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isUpdateAll(String modelId, String repositoryKey, ElementContainer con) {
        if (Utils.isSelectedValue(con.getModelValue(modelId, repositoryKey))) {
            return true;
        }
        String showcondition = Utils.convertProperShowconditionForShow(modelId, con, repositoryKey);
        return !StringUtils.isBlank((CharSequence)showcondition) && !"false".equals(showcondition);
    }

    public static final boolean isSelectable(String modelId, ElementContainer con) {
        if (Utils.isSelectedValue(con.getModelValue(modelId, "model/@selectable"))) {
            return true;
        }
        String showcondition = Utils.convertProperShowconditionForShow(modelId, con, "model/@selectable");
        return !StringUtils.isBlank((CharSequence)showcondition) && !"false".equals(showcondition);
    }

    public static final boolean isSendmail(String modelId, ElementContainer con, String type) {
        StringBuilder key = new StringBuilder();
        if ("insert".equals(type) || "update".equals(type) || "delete".equals(type) || "show".equals(type) || "showlist".equals(type) || "download".equals(type)) {
            key.append("model/sendmail/");
            key.append(type);
            key.append("/@send");
            return Utils.isSelectedValue(con.getModelValue(modelId, key.toString()));
        }
        if ("all".equals(type)) {
            if (Utils.isMobile(modelId, con)) {
                return false;
            }
            key.append("presentation/layout/panel/link/@action=SendMailAll");
            String value = Utils.convertProperShowconditionForShow(con.getModelValue(modelId, key.toString()));
            return !"false".equals(value);
        }
        return false;
    }

    public static final String getWizardPrevNextLinkLocation(String modelId, ElementContainer con) {
        String linkLocation = con.getModelValue(modelId, "presentation/wizardPrevNextLinkLocation");
        if (ropt.getValue("OPTION_presentation_wizardPrevNextLinkLocation_1_value").equals(linkLocation)) {
            return "upper";
        }
        if (ropt.getValue("OPTION_presentation_wizardPrevNextLinkLocation_2_value").equals(linkLocation)) {
            return "lower";
        }
        if (ropt.getValue("OPTION_presentation_wizardPrevNextLinkLocation_3_value").equals(linkLocation)) {
            return "none";
        }
        return "upper";
    }

    public static final boolean getWizardLabelShowcondition(String modelId, ElementContainer con) {
        String showcondition = con.getModelValue(modelId, "model/wizardLabel/@showcondition");
        return ropt.getValue("true").equals(showcondition);
    }

    public static final boolean isWizardButton(String modelId, ElementContainer con) {
        if (!con.existsKeyInModel(modelId, "model/wizardLabel/@showcondition")) {
            return true;
        }
        return Utils.getWizardLabelShowcondition(modelId, con);
    }

    public static final boolean isAutocomplete(ElementContainer con) {
        return Utils.isSelectedValue(con.getProjectValue("project/customize/autocomplete"));
    }

    public static final boolean isAutoTips(String modelId, String name, ElementContainer con, String type) {
        String appschemaType = Utils.convertDetailType2AppSchemaType(Utils.getDetailType(modelId, name, con));
        if (!("date".equals(appschemaType) || "dateTime".equals(appschemaType) || "time".equals(appschemaType) || Utils.isDetailType(modelId, name, con, "zipcode"))) {
            return false;
        }
        StringBuffer key = new StringBuffer();
        key.append("presentation/displayitem/@autotips");
        if ("update".equals(type)) {
            key.append("ForUpdate");
        } else if ("search".equals(type)) {
            key.append("ForSearch");
        } else if ("show".equals(type)) {
            key.append("ForShow");
        }
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, key.toString()));
    }

    public static final String getDisplayitemTips(String modelId, String name, ElementContainer con, String type) {
        return Utils.getDisplayitemTips0(modelId, name, con, type, "presentation/displayitem/@tips");
    }

    private static final String getDisplayitemTips0(String modelId, String name, ElementContainer con, String type, String keyheader) {
        StringBuffer key = new StringBuffer();
        key.append(keyheader);
        if ("update".equals(type)) {
            key.append("ForUpdate");
        } else if ("search".equals(type)) {
            key.append("ForSearch");
        }
        String s = con.getModelitemValue(modelId, name, key.toString());
        if (StringUtils.isNotBlank((CharSequence)s)) {
            s = WebStringEncodeUtilities.replaceCR2BRTag((String)s);
        }
        return s;
    }

    public static final boolean isSetValueToOpener(String modelId, String name, ElementContainer con) {
        for (String relationModel : con.getAllStoreModelId()) {
            for (String r_name : con.getModelitemNamesByKey(relationModel, "model/modelitem/relation/@idref")) {
                if (!Utils.isDetailType(relationModel, r_name, con, "special-storeref-search")) continue;
                String relationIdref = con.getModelitemValue(relationModel, r_name, "model/modelitem/relation/@idref");
                String rolecontent = con.getModelitemValue(relationModel, r_name, "model/modelitem/relation_storeref/@rolecontent");
                if (!modelId.equals(relationIdref) || !name.equals(rolecontent)) continue;
                return true;
            }
        }
        return "jfcworkflow_setting".equals(modelId) && "participants".equals(name);
    }

    public static final boolean isSelectInput(String modelId, String name, ElementContainer con) {
        String calendarinput = con.getModelitemValue(modelId, name, "model/modelitem/@calendarinput");
        String timeinput = con.getModelitemValue(modelId, name, "model/modelitem/@selectinput=Hm");
        String appschemaType = Utils.convertDetailType2AppSchemaType(Utils.getDetailType(modelId, name, con));
        if (("date".equals(appschemaType) || "dateTime".equals(appschemaType)) && calendarinput != null && calendarinput.startsWith(ropt.getValue("OPTION_model_modelitem_calendarinput_combobox"))) {
            return true;
        }
        return Utils.isDetailType(modelId, name, con, "time") && timeinput != null && timeinput.startsWith(ropt.getValue("OPTION_model_modelitem_calendarinput_combobox"));
    }

    public static final boolean isCalendarinputUseCalendar(String modelId, String name, ElementContainer con) {
        if (!Utils.isDetailType(modelId, name, con, "date") && !Utils.isDetailType(modelId, name, con, "special-storeref-ref")) {
            return false;
        }
        String calendarinput = con.getModelitemValue(modelId, name, "model/modelitem/@calendarinput");
        return StringUtils.isNotBlank((CharSequence)calendarinput) && ropt.getValue("OPTION_model_modelitem_calendarinput_calendar").equals(calendarinput);
    }

    public static final boolean isDualInput(String modelId, String name, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@dualinputmethod"));
    }

    public static final boolean isDualSelectInput(String modelId, String name, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@dualSelectInput"));
    }

    public static final boolean isConstraintTargetHidden(String modelId, String name, int wiznum, ElementContainer con) {
        if (!Utils.isWizardModel(modelId, con)) {
            return false;
        }
        String wizard = con.getModelitemValue(modelId, name, "model/modelitem/@wizard");
        if (StringUtils.isBlank((CharSequence)wizard)) {
            return false;
        }
        return !wizard.equals(String.valueOf(wiznum)) && !"all".equals(wizard);
    }

    public static final boolean isHidden(String modelId, String name, String method, ElementContainer con) {
        String old_type_expr = IType.getIType(con.getModelitemValue(modelId, name, "presentation/displayitem/@type"));
        if ("hidden".equals(old_type_expr)) {
            return true;
        }
        return "insert".equals(method) ? Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden_insert")) || Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden")) : ("update".equals(method) ? Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden_update")) || Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden")) : ("copy".equals(method) ? Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden_copy")) || Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden")) : StringUtils.isBlank((CharSequence)method) && Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@hidden"))));
    }

    public static final String[] getGroupBeforeContainer(String modelId, ElementContainer con) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String name : con.getModelitemNames(modelId)) {
            if (Utils.isDetailType(modelId, name, con, "special-container")) break;
            groups.add(name);
        }
        return groups.toArray(new String[0]);
    }

    public static final String[] getGroupAfterContainer(String modelId, ElementContainer con) {
        int i;
        ArrayList<String> groups = new ArrayList<String>();
        String[] groupNames = con.getModelitemNames(modelId);
        for (i = 0; i < groupNames.length && !Utils.isDetailType(modelId, groupNames[i], con, "special-container"); ++i) {
        }
        while (i < groupNames.length) {
            groups.add(groupNames[i]);
            ++i;
        }
        return groups.toArray(new String[0]);
    }

    public static final boolean isLabelAlign(String modelId, String name, ElementContainer con, String type) {
        String labelalign = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelalign");
        return Utils.isLabelAlignValue(labelalign, type);
    }

    public static final boolean isLabelAlignValue(String labelalign, String type) {
        return ropt.getValue("OPTION_presentation_displayitem_labelalign_1_value").equals(labelalign) ? "rows".equals(type) : ropt.getValue("OPTION_presentation_displayitem_labelalign_2_value").equals(labelalign) && "column".equals(type);
    }

    public static final boolean isCopyAction(String modelId, ElementContainer con_) {
        boolean isCopyInsertShow = Utils.isCopyInsertShow(modelId, con_);
        boolean isCopyInsertShowList = Utils.isCopyInsertShowList(modelId, con_);
        boolean isUpdateListUseCopyButton = Utils.isUpdateListUseCopyButton(modelId, con_);
        boolean isUpdateListUseCopyAtParentModelCopy = Utils.isUpdateListUseCopyAtParentModelCopy(modelId, con_);
        return isCopyInsertShow || isCopyInsertShowList || isUpdateListUseCopyButton || isUpdateListUseCopyAtParentModelCopy;
    }

    public static final boolean isCopyPresentation(String modelId, ElementContainer con_) {
        boolean isCopyInsertShow = Utils.isCopyInsertShow(modelId, con_);
        boolean isCopyInsertShowList = Utils.isCopyInsertShowList(modelId, con_);
        return isCopyInsertShow || isCopyInsertShowList;
    }

    public static final int getCopyPageNum(String modelId, ElementContainer con_) {
        if (!Utils.isCopyAction(modelId, con_)) {
            return 0;
        }
        int num_show = Utils.getCopyInsertShowLabels(modelId, con_).length;
        int num_showlist = Utils.getCopyInsertShowListLabels(modelId, con_).length;
        if (num_show > 1 || num_showlist > 1) {
            if (num_show > num_showlist) {
                return num_show;
            }
            return num_showlist;
        }
        return 1;
    }

    public static final boolean isUpdateListUseCopyButton(String modelId, ElementContainer con) {
        if (!con.existsKeyInModel(modelId, UseCopyAtParentModelCopyKey)) {
            boolean isCopyinsertshow;
            boolean isCopyinsertshowlist = Utils.getCopyInsertShowListLabels(modelId, con).length > 0;
            boolean bl = isCopyinsertshow = Utils.getCopyInsertShowLabels(modelId, con).length > 0;
            if (!isCopyinsertshowlist && !isCopyinsertshow) {
                return false;
            }
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@updateListPage")) && StringUtils.isNotBlank((CharSequence)con.getModelValue(modelId, "action/updatelist/@use_copy"));
    }

    public static final boolean isUpdateListUseCopyAtParentModelCopy(String modelId, ElementContainer con_) {
        boolean isUseCopyAtParentModelCopy = con_.existsKeyInModel(modelId, UseCopyAtParentModelCopyKey) ? Utils.isSelectedValue(con_.getModelValue(modelId, "action/@updateListPage")) && Utils.isSelectedValue(con_.getModelValue(modelId, UseCopyAtParentModelCopyKey)) : Utils.isUpdateListUseCopyButton(modelId, con_);
        return isUseCopyAtParentModelCopy;
    }

    public static final boolean isCopyInsertShow(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@showPage")) && StringUtils.isNotBlank((CharSequence)con.getModelValue(modelId, "model/@copyinsertshow"));
    }

    public static final String[] getCopyInsertShowLabels(String modelId, ElementContainer con) {
        String showLabel = con.getModelValue(modelId, "model/@copyinsertshow");
        if (StringUtils.isBlank((CharSequence)showLabel)) {
            return new String[0];
        }
        if (showLabel.contains(",")) {
            return showLabel.split(",");
        }
        return new String[]{showLabel};
    }

    public static final Map<Integer, String> getCopyConditionMap(String modelId, String element, ElementContainer con) {
        String condition = con.getModelValue(modelId, element);
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return new HashMap<Integer, String>();
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        StringBuilder buf = new StringBuilder();
        boolean isQuote = false;
        int length = condition.length();
        int _index = 1;
        for (int i = 0; i < length; ++i) {
            char c = condition.charAt(i);
            buf.append(c);
            if (!isQuote) {
                if (c == '\"') {
                    isQuote = true;
                    continue;
                }
                if (c != ',') continue;
                String value = buf.substring(0, buf.length() - 1);
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                map.put(_index, Utils.convertProperShowconditionForShow(value));
                buf = new StringBuilder();
                ++_index;
                continue;
            }
            if (c != '\"' || i <= 0) continue;
            char cb = condition.charAt(i - 1);
            if (cb == '\\') {
                String tmp = buf.substring(0, buf.length() - 2);
                buf = new StringBuilder(tmp);
                buf.append("\"");
                continue;
            }
            isQuote = false;
        }
        if (buf.length() > 0) {
            String value = buf.toString().trim();
            if (StringUtils.isEmpty((CharSequence)value)) {
                if (con.existsKeyInModel(modelId, "model/@copyForShow")) {
                    map.put(_index, Utils.convertProperShowconditionForShow(value));
                }
            } else {
                if (value.endsWith(",")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                map.put(_index, Utils.convertProperShowconditionForShow(value));
            }
        }
        return map;
    }

    public static final String[] getCopyInsertShowListLabels(String modelId, ElementContainer con) {
        String showListLabel = con.getModelValue(modelId, "model/@copyinsertshowlist");
        if (StringUtils.isNotBlank((CharSequence)showListLabel)) {
            return showListLabel.split(",");
        }
        return new String[0];
    }

    public static final boolean isCopyInsertShowList(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@showListPage")) && StringUtils.isNotBlank((CharSequence)con.getModelValue(modelId, "model/@copyinsertshowlist"));
    }

    public static final boolean isPrintAll(String modelId, ElementContainer con) {
        if (Utils.isMobile(modelId, con)) {
            return false;
        }
        if (Utils.isSelectedValue(con.getModelValue(modelId, "presentation/layout/panel/link/@action=PrintAll"))) {
            return true;
        }
        String showcondition = Utils.convertProperShowconditionForShow(modelId, con, "presentation/layout/panel/link/@action=PrintAll");
        return !StringUtils.isBlank((CharSequence)showcondition) && !"false".equals(showcondition);
    }

    public static final boolean isPrintlayoutType(String modelId, ElementContainer con, String type) {
        for (String key : con.getKeysByModelAndKeyPrefix(modelId, "printlayout/filename")) {
            if (!Utils.isPrintlayoutType(modelId, key, con, type) || !StringUtils.isNotBlank((CharSequence)Utils.getPrintlayoutFileName(modelId, key, con))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isPrintlayoutType(String modelId, String key, ElementContainer con, String type) {
        String value = con.getModelValue(modelId, key + "_2");
        if (value == null) {
            return false;
        }
        if ("showlist".equals(type)) {
            if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_2_value_prefix"))) {
                return true;
            }
        } else if ("reportlist".equals(type)) {
            if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_3_value"))) {
                return true;
            }
        } else if ("show".equals(type)) {
            if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_2_value_prefix"))) {
                return false;
            }
            if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_1_value"))) {
                return true;
            }
        } else if ("insert".equals(type) ? value.startsWith(ropt.getValue("OPTION_printlayout_screentype_4_value")) : ("copy".equals(type) ? value.startsWith(ropt.getValue("OPTION_printlayout_screentype_5_value")) : "update".equals(type) && value.startsWith(ropt.getValue("OPTION_printlayout_screentype_6_value")))) {
            return true;
        }
        return false;
    }

    public static final String getPrintlayoutType(String modelId, String key, ElementContainer con) {
        String value = con.getModelValue(modelId, key + "_2");
        if (value == null) {
            return "";
        }
        if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_2_value_prefix"))) {
            return "showlist";
        }
        if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_3_value"))) {
            return "reportlist";
        }
        if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_1_value"))) {
            return "show";
        }
        if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_4_value"))) {
            return "insert";
        }
        if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_5_value"))) {
            return "copy";
        }
        if (value.startsWith(ropt.getValue("OPTION_printlayout_screentype_6_value"))) {
            return "update";
        }
        return "show";
    }

    public static final String getPrintlayoutFileType(String modelId, String key, ElementContainer con) {
        String value = con.getModelValue(modelId, key + "_2");
        if (value != null && value.contains("PDF[JasperReports")) {
            return "pdf";
        }
        if (value != null && value.contains("RTF[JasperReports")) {
            return "rtf";
        }
        return "excel";
    }

    public static final String getPrintlayoutLibraryType(String modelId, String key, ElementContainer con) {
        String value = con.getModelValue(modelId, key + "_2");
        if (value == null) {
            return "poi";
        }
        if (value.contains("PDF[JasperReports") || value.contains("RTF[JasperReports")) {
            return "jasperreports";
        }
        if (value.contains("Excel[POI]")) {
            return "poi";
        }
        if (value.contains("Excel[JExcelAPI]")) {
            return "jexcelapi";
        }
        return "poi";
    }

    public static final boolean isPrintlayoutFileType(String modelId, String key, ElementContainer con, String type) {
        return Utils.getPrintlayoutFileType(modelId, key, con).equals(type);
    }

    public static final String getPrintlayoutFileName(String modelId, String key, ElementContainer con) {
        String filename = con.getModelValue(modelId, key);
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            filename = StringUtil.replace((String)filename, (String)"*", (String)"__AsTeRiSk__");
        }
        return filename;
    }

    public static final String getPrintlayoutTemplateFileName(String filename) {
        return JfcreporttemplateUtil.getPrintlayoutTemplateFileName((String)filename);
    }

    public static final String getPrintlayoutDisplayname(String modelId, String key, ElementContainer con) {
        return con.getModelValue(modelId, key + "_2");
    }

    public static final String getPrintlayoutLabel(String modelId, String key, ElementContainer con) {
        return con.getModelValue(modelId, key + "_3");
    }

    public static String getPrintLayoutId(String modelId, String filename, String type, String filetype) {
        String printtype;
        if ("show".equals(type)) {
            printtype = "printShow";
        } else if ("showlist".equals(type)) {
            printtype = "printshowList";
        } else if ("reportlist".equals(type)) {
            printtype = "printreportList";
        } else if ("insert".equals(type)) {
            printtype = "printInsert";
        } else if ("copy".equals(type)) {
            printtype = "printCopy";
        } else if ("update".equals(type)) {
            printtype = "printUpdate";
        } else {
            log.error("Unknown type " + type);
            printtype = "printUnknown";
        }
        String id = printtype + JavaSourceGenerator.capFirst((String)modelId) + "_" + (String)("excel".equals(filetype) ? "" : filetype + "_") + filename;
        return id;
    }

    public static final boolean useJasperReports(ElementContainer con) {
        for (String modelId : con.getAllStoreModelId()) {
            for (String key : con.getKeysByModelAndKeyPrefix(modelId, "printlayout/filename")) {
                if (!"jasperreports".equals(Utils.getPrintlayoutLibraryType(modelId, key, con))) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean hasListModel(String modelId, String name, ElementContainer con) {
        return Utils.hasListModel(modelId, name, con, "model/modelitem/@hasListModel");
    }

    public static final boolean hasListModel(String modelId, String name, ElementContainer con, String key) {
        return !Utils.isLayoutOnly(modelId, name, con) && Utils.isSelectedOrIntegerValue(con.getModelitemValue(modelId, name, key));
    }

    public static final boolean hasRepeatContainer(String modelId, ElementContainer con) {
        for (String name : con.getModelitemNames(modelId)) {
            if (!Utils.isModelitemType(modelId, name, con, "special-container")) continue;
            return true;
        }
        return false;
    }

    public static final boolean isDisplaycontrol(String modelId, String name, ElementContainer con) {
        if (Utils.hasListModel(modelId, name, con)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@displaycontrol"));
    }

    public static final String getDescription(String modelId, ElementContainer con) {
        String desc = con.getModelValue(modelId, "model/@description");
        if (StringUtils.isBlank((CharSequence)desc)) {
            desc = con.getModelValue(modelId, "model/@id");
        }
        return desc;
    }

    public static final boolean isRejectReadonlyUpdateList(String modelId, String name, ElementContainer con) {
        return !Utils.isDualInput(modelId, name, con) && !Utils.isMultiple(modelId, name, con) && !Utils.isDetailType(modelId, name, con, "special-container") && !Utils.isDetailType(modelId, name, con, "special-containerid") && !name.contains("/");
    }

    public static final boolean hasUpdateListModel(String modelId, String name, ElementContainer con) {
        return Utils.hasListModel(modelId, name, con) && Utils.isRejectReadonlyUpdateList(modelId, name, con);
    }

    public static String getDeployname(Project project) {
        String ret = null;
        String webappname = project.getWebappname();
        ret = StringUtils.isBlank((CharSequence)webappname) ? "ROOT" : webappname;
        return ret;
    }

    public static String getMainmodelidref(String modelId, ElementContainer con) {
        return con.getModelValue(modelId, "model/@mainmodelidref");
    }

    public static boolean isMainModel(String modelId, ElementContainer con) {
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return false;
        }
        for (String _modelId : con.getAllStoreModelId()) {
            String mainmodelidref = Utils.getMainmodelidref(_modelId, con);
            if (!modelId.equals(mainmodelidref)) continue;
            return true;
        }
        return false;
    }

    public static String[] getModelIdsRelatedMainSubModel(String modelId, ElementContainer con) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return list.toArray(new String[0]);
        }
        String mainmodelidref = Utils.getMainmodelidref(modelId, con);
        for (String t_modelId : con.getAllStoreModelId()) {
            if (modelId.equals(t_modelId) || StringUtils.isBlank((CharSequence)t_modelId)) continue;
            String t_mainmodelidref = Utils.getMainmodelidref(t_modelId, con);
            if (StringUtils.isNotBlank((CharSequence)t_mainmodelidref) && (t_mainmodelidref.equals(modelId) || t_mainmodelidref.equals(mainmodelidref))) {
                list.add(t_modelId);
                continue;
            }
            if (!t_modelId.equals(mainmodelidref)) continue;
            list.add(t_modelId);
        }
        return list.toArray(new String[0]);
    }

    public static boolean needsUseridjshparam(String[] modelIds, ElementContainer con) {
        for (String modelId : modelIds) {
            if (!Utils.needsUseridjshparam(modelId, con)) continue;
            return true;
        }
        return false;
    }

    public static boolean needsUseridjshparam(String modelId, ElementContainer con) {
        return !"RW-RW-RW-RW".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !Utils.existsGroupdataItemType(modelId, con);
    }

    public static boolean needsJgroupidjshparam(String[] modelIds, ElementContainer con) {
        for (String modelId : modelIds) {
            if (!Utils.needsJgroupidjshparam(modelId, con)) continue;
            return true;
        }
        return false;
    }

    public static boolean needsJgroupidjshparam(String modelId, ElementContainer con) {
        return !"RW-N-N-N".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-R-R-R".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-RW-RW-RW".equals(Utils.getAcl_dataaclpattern(modelId, con));
    }

    public static boolean needsGroupManager(String[] modelIds, ElementContainer con) {
        for (String modelId : modelIds) {
            if (!Utils.needsGroupManager(modelId, con)) continue;
            return true;
        }
        return false;
    }

    public static boolean needsGroupManager(String modelId, ElementContainer con) {
        return !"RW-N-N-N".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-R-N-R".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-R-R-R".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-RW-N-RW".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-RW-R-RW".equals(Utils.getAcl_dataaclpattern(modelId, con)) && !"RW-RW-RW-RW".equals(Utils.getAcl_dataaclpattern(modelId, con));
    }

    public static boolean existsGroupdataItemType(String modelId, ElementContainer con) {
        String[] names;
        for (String name : names = con.getModelitemNamesByKey(modelId, "action/condition/groupdateitemtype")) {
            if (!StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "action/condition/groupdateitemtype"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferencedGroupdataItemTypeJgroupid(String modelId, String name, ElementContainer con) {
        if ("juser".equals(modelId) && "jgroupid".equals(name)) {
            return true;
        }
        for (String t_modelid : con.getAllStoreModelId()) {
            if (modelId.equals(t_modelid)) continue;
            for (String t_name : con.getModelitemNames(t_modelid)) {
                String detailType;
                if (!ropt.getValue("OPTION_action_condition_groupdateitemtype_2_value").equals(con.getModelitemValue(t_modelid, t_name, "action/condition/groupdateitemtype")) || !modelId.equals(con.getModelitemValue(t_modelid, t_name, "model/modelitem/relation/@idref"))) continue;
                String type = con.getModelitemValue(t_modelid, t_name, "model/modelitem/@type");
                String string = detailType = StringUtils.isNotBlank((CharSequence)type) ? IType.getIType(type) : null;
                if (!"special-storeref-ref".equals(detailType) || !name.equals(con.getModelitemValue(t_modelid, t_name, "model/modelitem/relation_storeref/@rolecontent"))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUseridjshparamNullable(String modelId, ElementContainer con) {
        String key = "acl/dataaclUseridNullable";
        if (!con.existsKeyInModel(modelId, key)) {
            return false;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, key));
    }

    public static boolean isCreatetableAttribute(String modelId, ElementContainer con_) {
        if (!con_.existsKeyInModel(modelId, "model/@createtable")) {
            return true;
        }
        return Utils.isSelectedValue(con_.getModelValue(modelId, "model/@createtable"));
    }

    public static boolean isLazyinitAttribute(ElementContainer con_) {
        String value = con_.getProjectValue("project/customize/@lazyinit");
        return !Utils.isSelectedValue(value);
    }

    public static boolean isForeignKeyIsPrimaryKey(String modelId, String itemName, String refname, ElementContainer con_) {
        String f_model = Utils.getForeignKey(modelId, itemName, con_);
        return StringUtils.isNotBlank((CharSequence)f_model) && Utils.isPrimaryKey(f_model, refname, con_);
    }

    public static String getDatabaseType(ElementContainer con_) {
        String value = con_.getProjectValue("environment/database/@database");
        String dbtype = dbtypesMap.get(value);
        if (dbtype == null) {
            return "unknown";
        }
        return dbtype;
    }

    public static final boolean isModelitemSpecialFixed(String modelId, String name, ElementContainer con) {
        String detailType = Utils.getDetailType(modelId, name, con);
        return detailType.startsWith("special-fixed");
    }

    public static boolean existsModelitem(String modelId, String itemname, ElementContainer con) {
        return con.getModelitemValue(modelId, itemname, "model/modelitem/@name") != null;
    }

    public static String getModelitemLabel(String modelId, String name, ElementContainer con) {
        String label = Utils.getModelitemLabelIncludingLayout(modelId, name, con);
        if (StringUtils.isNotBlank((CharSequence)label)) {
            if (label.indexOf(">") > -1) {
                label = label.substring(label.lastIndexOf(">") + 1);
            }
            return label;
        }
        return name;
    }

    public static String getModelitemLabelIncludingLayout(String modelId, String name, ElementContainer con) {
        return Utils.adjustLabel(con.getModelitemValue(modelId, name, "model/modelitem/@label"));
    }

    public static final String getModelitemLabelWithoutLayout(String modelId, String name, ElementContainer con) {
        String label = con.getModelitemValue(modelId, name, "model/modelitem/@label");
        if (StringUtils.isBlank((CharSequence)label)) {
            return con.getModelitemValue(modelId, name, "model/modelitem/@name");
        }
        if (label == null || !label.contains(">")) {
            return label;
        }
        return StringUtils.substringAfterLast((String)label, (String)">");
    }

    public static String getImeAttribute(String modelId, String name, ElementContainer con) {
        String ime = con.getModelitemValue(modelId, name, "presentation/displayitem/@ime");
        return Utils.getImeAttributeValue(ime);
    }

    public static String getImeAttributeValue(String ime) {
        if (ropt.getValue("OPTION_presentation_displayitem_ime_1_value").equals(ime)) {
            return "active";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_ime_2_value").equals(ime)) {
            return "inactive";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_ime_3_value").equals(ime)) {
            return "disabled";
        }
        return null;
    }

    public static String getSortButtonAttribute(String modelId, String name, ElementContainer con) {
        String sortbutton = con.getModelitemValue(modelId, name, "presentation/displayitem/@sortbutton");
        if (!name.contains("/") || ropt.getValue("OPTION_presentation_displayitem_sortbutton_1_value").equals(sortbutton) || Utils.isDetailType(modelId, name, con, "special-containerid")) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)sortbutton)) {
            return "none";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_sortbutton_2_value").equals(sortbutton)) {
            return "forward";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_sortbutton_3_value").equals(sortbutton)) {
            return "descend";
        }
        return "both";
    }

    public static final String getEnterkeyActionValue(String enterKey) {
        if (ropt.getValue("OPTION_presentation_displayitem_enterKeyAction_2_value").equals(enterKey)) {
            return "changetab";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_enterKeyAction_3_value").equals(enterKey)) {
            return "default";
        }
        return null;
    }

    public static final String getEnterkeyAction(String modelId, String name, ElementContainer con) {
        String enterkeyAction = Utils.getEnterkeyActionValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@enterKeyAction"));
        if (Utils.isDetailType(modelId, name, con, "special-storeref-combo") && "default".equals(enterkeyAction)) {
            return null;
        }
        return enterkeyAction;
    }

    public static final String getEnterkeyActionForSearch(String modelId, String name, ElementContainer con) {
        String enterkeyAction = Utils.getEnterkeyActionValue(con.getModelitemValue(modelId, name, "presentation/displayitem/@enterKeyActionForSearch"));
        if (Utils.isDetailType(modelId, name, con, "special-storeref-combo") && "default".equals(enterkeyAction)) {
            return null;
        }
        return enterkeyAction;
    }

    public static final boolean isPageLayoutDefined(String modelId, ElementContainer con) {
        return con.getLayoutLabels(modelId).length > 0;
    }

    public static boolean isAlloption(String modelId, String name, ElementContainer con) {
        String detailtype = Utils.getDetailType(modelId, name, con);
        if (detailtype.startsWith("special-masterref") || detailtype.startsWith("special-storeref")) {
            return Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@alloption"));
        }
        return false;
    }

    public static boolean isZipcodetype(ElementContainer con) {
        boolean useAddressNormalization = false;
        for (String modelId : con.getAllStoreModelId()) {
            for (String modelitemName : con.getModelitemNames(modelId)) {
                String type = con.getModelitemValue(modelId, modelitemName, "model/modelitem/@type");
                if (!ropt.getValue("OPTION_model_modelitem_typeDetail_string_2_value").equals(type)) continue;
                useAddressNormalization = true;
                break;
            }
            if (useAddressNormalization) break;
        }
        return useAddressNormalization;
    }

    public static boolean isCalendarview(ElementContainer con) {
        String[] storeModelss;
        boolean useCalendarview = false;
        for (String storeModel : storeModelss = con.getAllStoreModelId()) {
            String value = con.getModelValue(storeModel, "model/@calendarOutput");
            if (!Utils.isSelectedValue(value)) continue;
            useCalendarview = true;
            break;
        }
        return useCalendarview;
    }

    public static boolean isCreateEditpage(ElementContainer con) {
        boolean createEditpage = false;
        Object[] storeModelss = con.getAllMasterModelId();
        for (Object masterModel : storeModelss = (String[])ArrayUtils.addAll((Object[])storeModelss, (Object[])con.getAllStoreModelId())) {
            String value = con.getModelValue((String)masterModel, "createEditpage");
            if (!Utils.isSelectedValue(value)) continue;
            createEditpage = true;
            break;
        }
        return createEditpage;
    }

    public static boolean isIncludesListMode(String modelId, String name, ElementContainer con_) {
        if ("special-container".equals(Utils.getDetailType(modelId, name, con_))) {
            return false;
        }
        boolean hasListModel = !Utils.isLayoutOnly(modelId, name, con_) && Utils.isSelectedOrIntegerValue(con_.getModelitemValue(modelId, name, "model/modelitem/@hasListModel"));
        boolean displaycontrol = !Utils.isLayoutOnly(modelId, name, con_) && Utils.isSelectedValue(con_.getModelitemValue(modelId, name, "presentation/displayitem/@displaycontrol"));
        return hasListModel || displaycontrol;
    }

    public static boolean isReferencedStorerefSearch(String modelId, String name, ElementContainer con) {
        for (String _modelId : con.getAllStoreModelId()) {
            for (String _name : con.getModelitemNamesByKey(_modelId, "model/modelitem/relation/@idref")) {
                if (!modelId.equals(con.getModelitemValue(_modelId, _name, "model/modelitem/relation/@idref")) || !name.equals(con.getModelitemValue(_modelId, _name, "model/modelitem/relation_storeref/@rolecontent")) || !"special-storeref-search".equals(Utils.getDetailType(_modelId, _name, con))) continue;
                return true;
            }
        }
        return "jfcworkflow_setting".equals(modelId) && "participants".equals(name);
    }

    public static boolean isOutputConstraint(String modelId, String name, ElementContainer con) {
        boolean isMultiple = Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@multiple"));
        String detailType = Utils.getDetailType(modelId, name, con);
        if ("special-container".equals(detailType) || "special-containerid".equals(detailType) || isMultiple) {
            return false;
        }
        String constraint_disabled = con.getModelitemValue(modelId, name, "model/modelitem/constraint/@type=disabled");
        String constraint_enabled = con.getModelitemValue(modelId, name, "model/modelitem/constraint/@type=enabled");
        return !StringUtils.isBlank((CharSequence)constraint_disabled) || !StringUtils.isBlank((CharSequence)constraint_enabled);
    }

    public static boolean isNoOutputModel(String modelId, ElementContainer con) {
        String type;
        if ("jprincipal".equals(modelId) || "seq".equals(modelId)) {
            return true;
        }
        if ("hour_m".equals(modelId) || "jpermission_m".equals(modelId) || "minute_m".equals(modelId) || "movestep_m".equals(modelId)) {
            return true;
        }
        if (!(!"jfclockobject".equals(modelId) && !"jfclockforall_m".equals(modelId) || Utils.isCluster(con) || Utils.isAutoScaling(con) || Utils.isDblockmanager(con))) {
            return true;
        }
        return "jfcfilestatus".equals(modelId) ? (type = con.getProjectValue("project/environment/filestore/@type")) == null || !type.equals("jfcfilestatus") : modelId.startsWith("jfcDesigner");
    }

    public static String adjustProperMenuref(String menuref) {
        if (StringUtils.isBlank((CharSequence)menuref)) {
            menuref = rman.getValue("r.project.menu.appmenu");
        }
        String v_menuref0 = menuref.replaceAll("<br/>", "\\\\r");
        v_menuref0 = v_menuref0.replace(">", "$MENUSEP$");
        Object v_menuref1 = null;
        v_menuref1 = rman.getValue("r.project.menu.admin").equals(v_menuref0) ? "admin" : (rman.getValue("r.project.menu.mastermenu").equals(v_menuref0) ? "mastermenu" : (rman.getValue("r.project.menu.appmenu").equals(v_menuref0) ? "appmenu" : (rman.getValue("r.project.menu.common").equals(v_menuref0) ? "common" : (v_menuref0.startsWith(rman.getValue("r.project.menu.admin") + "$MENUSEP$") ? "admin$MENUSEP$" + v_menuref0.substring(rman.getValue("r.project.menu.admin").length() + "$MENUSEP$".length()) : (v_menuref0.startsWith(rman.getValue("r.project.menu.mastermenu") + "$MENUSEP$") ? "mastermenu$MENUSEP$" + v_menuref0.substring(rman.getValue("r.project.menu.mastermenu").length() + "$MENUSEP$".length()) : (v_menuref0.startsWith(rman.getValue("r.project.menu.appmenu") + "$MENUSEP$") ? "appmenu$MENUSEP$" + v_menuref0.substring(rman.getValue("r.project.menu.appmenu").length() + "$MENUSEP$".length()) : (v_menuref0.startsWith(rman.getValue("r.project.menu.common") + "$MENUSEP$") ? "common$MENUSEP$" + v_menuref0.substring(rman.getValue("r.project.menu.common").length() + "$MENUSEP$".length()) : v_menuref0)))))));
        return v_menuref1;
    }

    public static final String getCalendarMoveType(String modelId, ElementContainer con) {
        String calendarMoveType = con.getModelValue(modelId, "presentation/layout/panel/displaycondition/@calendarMoveType");
        if (StringUtils.isBlank((CharSequence)calendarMoveType) || ropt.getValue("OPTION_presentation_layout_panel_displaycondition_calendarMoveType_1_value").equals(calendarMoveType)) {
            return "step";
        }
        return null;
    }

    public static final boolean isCluster(ElementContainer con) {
        return Utils.isSelectedValue(con.getProjectValue("project/environment/cluster/@use_cluster"));
    }

    public static final boolean isDblockmanager(ElementContainer con) {
        return Utils.isSelectedValue(con.getProjectValue("project/environment/dblockmanager/@use"));
    }

    public static final String getNumberFormatInShow(String modelId, String name, ElementContainer con) {
        return Utils.getNumberFormat0(modelId, name, con, false);
    }

    public static final String getNumberFormat(String modelId, String name, ElementContainer con) {
        return Utils.getNumberFormat0(modelId, name, con, true);
    }

    private static final String getNumberFormat0(String modelId, String name, ElementContainer con, boolean isChase) {
        String numberFormat = con.getModelitemValue(modelId, name, "presentation/displayitem/@numberformat");
        String numberFormatCombo = con.getModelitemValue(modelId, name, "presentation/displayitem/@numberformatCombo");
        if (StringUtils.isNotBlank((CharSequence)numberFormat)) {
            return numberFormat;
        }
        if (StringUtils.isNotBlank((CharSequence)numberFormatCombo)) {
            return numberFormatCombo;
        }
        if (Utils.isDetailType(modelId, name, con, "float") || Utils.isDetailType(modelId, name, con, "double")) {
            return DEFAULT_NUMBERFORMAT;
        }
        if (Utils.isDetailType(modelId, name, con, "special-storeref-ref") && isChase) {
            String refitem;
            String refid;
            String reftype;
            String detailType;
            String ret = null;
            while ((detailType = IType.getIType(reftype = con.getModelitemValue(refid = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref"), refitem = con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@rolecontent"), "model/modelitem/@type"))).equals("special-storeref-ref")) {
                modelId = refid;
                name = refitem;
            }
            if (detailType.equals("double") || detailType.equals("float")) {
                ret = DEFAULT_NUMBERFORMAT;
            }
            return ret;
        }
        return null;
    }

    public static final String getOverflow(String modelId, ElementContainer con) {
        if (Utils.isSelectedValue(con.getModelValue(modelId, "presentation/displaymodel/@overflowForshowList"))) {
            return "auto";
        }
        return null;
    }

    public static final String getOverflowContainer(String modelId, String name, ElementContainer con) {
        if (Utils.isSelectedValue(con.getModelitemValue(modelId, name, "presentation/displaymodel/@overflowForContainer"))) {
            return "auto";
        }
        return null;
    }

    public static final String getThAlign(String modelId, String name, ElementContainer con) {
        String align = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelalignForShow");
        return Utils.getAlignValue(align);
    }

    public static final String getThAlignForShowList(String modelId, String name, ElementContainer con) {
        String align = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelalignForShowList");
        return Utils.getAlignValue(align);
    }

    public static final String getLabelwidthForShowList(String modelId, String name, ElementContainer con) {
        return Utils.createProperWidthHeightString(con.getModelitemValue(modelId, name, "presentation/displayitem/@labelwidthForShowList"));
    }

    public static final String getLabelheightForShowList(String modelId, String name, ElementContainer con) {
        return Utils.createProperWidthHeightString(con.getModelitemValue(modelId, name, "presentation/displayitem/@labelheightForShowList"));
    }

    public static final String getAlign(String modelId, String name, ElementContainer con) {
        String align = con.getModelitemValue(modelId, name, "presentation/displayitem/@align");
        return Utils.getAlignValue(align);
    }

    public static final String getAlignForShowList(String modelId, String name, ElementContainer con) {
        String align = con.existsKeyInModelitem(modelId, name, "presentation/displayitem/@alignForShowList") ? con.getModelitemValue(modelId, name, "presentation/displayitem/@alignForShowList") : con.getModelitemValue(modelId, name, "presentation/displayitem/@align");
        return Utils.getAlignValue(align);
    }

    public static final String getAlignValue(String value) {
        if (ropt.getValue("OPTION_presentation_displayitem_alignForEdit_1_value").equals(value)) {
            return "left";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_alignForEdit_2_value").equals(value)) {
            return "center";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_alignForEdit_3_value").equals(value)) {
            return "right";
        }
        return null;
    }

    public static final String getCursorPosition(String value) {
        if (ropt.getValue("OPTION_presentation_displayitem_cursorPosition_1_value").equals(value)) {
            return "left";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_cursorPosition_2_value").equals(value)) {
            return "right";
        }
        return null;
    }

    public static final String getThVAlign(String modelId, String name, ElementContainer con) {
        String valign = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelvalignForShow");
        return Utils.getVAlignValue(valign);
    }

    public static final String getThVAlignForShowList(String modelId, String name, ElementContainer con) {
        String valign = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelvalignForShowList");
        return Utils.getVAlignValue(valign);
    }

    public static final String getVAlign(String modelId, String name, ElementContainer con) {
        String valign = con.getModelitemValue(modelId, name, "presentation/displayitem/@valign");
        return Utils.getVAlignValue(valign);
    }

    public static final String getVAlignForShowList(String modelId, String name, ElementContainer con) {
        String valign = con.getModelitemValue(modelId, name, "presentation/displayitem/@valignForShowList");
        return Utils.getVAlignValue(valign);
    }

    public static final String getVAlignValue(String value) {
        if (ropt.getValue("OPTION_presentation_displayitem_valignForEdit_1_value").equals(value)) {
            return "top";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_valignForEdit_2_value").equals(value)) {
            return "middle";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_valignForEdit_3_value").equals(value)) {
            return "bottom";
        }
        return null;
    }

    public static final String getLabelwidthForSearch(String modelId, String name, ElementContainer con) {
        return Utils.createProperWidthHeightString(con.getModelitemValue(modelId, name, "presentation/displayitem/@labelwidthForSearch"));
    }

    public static final String getLabelheightForSearch(String modelId, String name, ElementContainer con) {
        return Utils.createProperWidthHeightString(con.getModelitemValue(modelId, name, "presentation/displayitem/@labelheightForSearch"));
    }

    public static final String getLabelVAlignForSearch(String modelId, String name, ElementContainer con) {
        String valign = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelvalignForSearch");
        return Utils.getVAlignValue(valign);
    }

    public static final String getLabelAlignForSearch(String modelId, String name, ElementContainer con) {
        String valign = con.getModelitemValue(modelId, name, "presentation/displayitem/@labelalignForSearch");
        return Utils.getAlignValue(valign);
    }

    public static final String getSubformat(String modelId, String name, String key, ElementContainer con) {
        String subformat = con.getModelitemValue(modelId, name, key);
        if (StringUtils.isBlank((CharSequence)subformat)) {
            return null;
        }
        if (ropt.getValue("OPTION_presentation_displayitem_subformatForEdit_1_value").equals(subformat)) {
            return "\uff08ggge\u5e74\uff09";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_subformatForEdit_2_value").equals(subformat)) {
            return "\uff08ggge\u5e74M\u6708\uff09";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_subformatForEdit_3_value").equals(subformat)) {
            return "\uff08ggge\u5e74M\u6708d\u65e5\uff09";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_subformatForEdit_5_value").equals(subformat)) {
            return "\uff08aaa\uff09";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_subformatForEdit_4_value").equals(subformat)) {
            return "\uff08aaaa\uff09";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_subformatForEdit_6_value").equals(subformat)) {
            return "\uff08ggge\u5e74M\u6708d\u65e5aaaa\uff09";
        }
        return "\uff08ggge\u5e74M\u6708d\u65e5aaaa\uff09";
    }

    public static final boolean hasCondition(String modelId, String name, ElementContainer con) {
        return !Utils.isLayoutOnly(modelId, name, con) && (StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "action/condition/@cond")) || Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/selfref")));
    }

    public static boolean existsImplicitExceptPermaction(String modelId, ElementContainer con) {
        for (String name : con.getModelitemNames(modelId)) {
            String[] keys;
            for (String key : keys = Utils.getKeysImplicit(modelId, name, con)) {
                String index = key.substring("action/condition/@implicit".length());
                String permission = con.getModelitemValue(modelId, name, "action/condition/@exceptPermaction" + index);
                if (!StringUtils.isNotBlank((CharSequence)permission)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean existsImplicit(String modelId, ElementContainer con) {
        for (String name : con.getModelitemNames(modelId)) {
            String[] keys = Utils.getKeysImplicit(modelId, name, con);
            if (keys.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static String[] getKeysImplicit(String modelId, String name, ElementContainer con) {
        ArrayList<String> list = new ArrayList<String>();
        String key_prefix = "action/condition/@implicit";
        for (String key : con.getKeysByModelitemNameAndKeyPrefix(modelId, name, "action/condition/@implicit")) {
            String index = key.substring("action/condition/@implicit".length());
            if (!StringUtils.isBlank((CharSequence)index) && !NumberUtils.isCreatable((String)index) || !StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, key))) continue;
            list.add(key);
        }
        return list.toArray(new String[0]);
    }

    private static synchronized void initConstraintTargets(ElementContainer con) {
        constraintTargets = new HashMap();
        for (String modelId : con.getAllStoreModelId()) {
            HashMap<String, String> targets = new HashMap<String, String>();
            for (String name : con.getModelitemNames(modelId)) {
                String[] target;
                String constraint_enabled;
                String[] target2;
                if (!Utils.isOutputConstraint(modelId, name, con)) continue;
                String constraint_disabled = con.getModelitemValue(modelId, name, "model/modelitem/constraint/@type=disabled");
                if (StringUtils.isNotBlank((CharSequence)constraint_disabled) && constraint_disabled.contains("=") && StringUtils.isNotBlank((CharSequence)(target2 = constraint_disabled.split("="))[0])) {
                    targets.put(name, target2[0]);
                }
                if (!StringUtils.isNotBlank((CharSequence)(constraint_enabled = con.getModelitemValue(modelId, name, "model/modelitem/constraint/@type=enabled"))) || !constraint_enabled.contains("=") || !StringUtils.isNotBlank((CharSequence)(target = constraint_enabled.split("="))[0])) continue;
                targets.put(name, target[0]);
            }
            if (targets.isEmpty()) continue;
            constraintTargets.put(modelId, targets);
        }
    }

    public static final boolean isConstraintTarget(String modelId, String name, ElementContainer con) {
        if (constraintTargets == null) {
            Utils.initConstraintTargets(con);
        }
        if (!constraintTargets.containsKey(modelId)) {
            return false;
        }
        HashMap<String, String> targets = constraintTargets.get(modelId);
        return targets != null && targets.containsValue(name);
    }

    public static final String getConstraintSrcName(String modelId, String name, ElementContainer con) {
        if (constraintTargets == null) {
            Utils.initConstraintTargets(con);
        }
        if (!constraintTargets.containsKey(modelId)) {
            return null;
        }
        HashMap<String, String> targets = constraintTargets.get(modelId);
        if (targets == null) {
            return null;
        }
        Set<String> srcNames = targets.keySet();
        for (String srcName : srcNames) {
            if (!name.equals(targets.get(srcName))) continue;
            return srcName;
        }
        return null;
    }

    public static final boolean isConstraintSrcDisplayWizardPage(String modelId, String name, int wizNum, ElementContainer con) {
        if (constraintTargets == null) {
            Utils.initConstraintTargets(con);
        }
        if (!constraintTargets.containsKey(modelId)) {
            return false;
        }
        HashMap<String, String> targets = constraintTargets.get(modelId);
        if (!targets.containsKey(name)) {
            return false;
        }
        String wizardNum = con.getModelitemValue(modelId, name, "model/modelitem/@wizard");
        return StringUtils.isNotBlank((CharSequence)wizardNum) && wizardNum.equals(String.valueOf(wizNum));
    }

    public static final String getDelimiter(String type) {
        String ret = null;
        if (!StringUtils.isBlank((CharSequence)type)) {
            if ("CSV".equals(type) || "csv".equals(type)) {
                ret = "csv";
            } else if ("TSV".equals(type) || "tsv".equals(type)) {
                ret = "tsv";
            }
        }
        return ret;
    }

    public static String getRelationSortrule(String modelId, String name, ElementContainer con) {
        if (!con.existsKeyInModelitem(modelId, name, "model/modelitem/relation_storeref/@sortrule")) {
            return null;
        }
        String sortrule = null;
        String s = con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@sortrule");
        if (!StringUtils.isBlank((CharSequence)s)) {
            if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_1_value"))) {
                sortrule = "rolepriority";
            } else if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_2_value"))) {
                sortrule = "roleid";
            } else if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_3_value"))) {
                sortrule = "rolecontent";
            } else if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_4_value"))) {
                sortrule = "sortkey";
            }
        }
        return sortrule;
    }

    public static String getRelationSortorder(String modelId, String name, ElementContainer con) {
        String order = "descending";
        if (!con.existsKeyInModelitem(modelId, name, "model/modelitem/relation_storeref/@roleorder")) {
            return order;
        }
        String s = con.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@roleorder");
        if (ropt.getValue("OPTION_model_modelitem_relation_storeref_roleorder_1_value").equals(s)) {
            order = "ascending";
        }
        return order;
    }

    public static String getRelationSortruleForMasterModel(String modelId, String name, ElementContainer con) {
        if (!con.existsKeyInModelitem(modelId, name, "model/modelitem/relation_masterref/@sortrule")) {
            return null;
        }
        String sortrule = null;
        String s = con.getModelitemValue(modelId, name, "model/modelitem/relation_masterref/@sortrule");
        if (!StringUtils.isBlank((CharSequence)s)) {
            if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_1_value"))) {
                sortrule = "rolepriority";
            } else if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_2_value"))) {
                sortrule = "roleid";
            } else if (s.equals(ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_3_value"))) {
                sortrule = "rolecontent";
            }
        }
        return sortrule;
    }

    public static String getRelationSortorderForMasterModel(String modelId, String name, ElementContainer con) {
        String order = "descending";
        if (!con.existsKeyInModelitem(modelId, name, "model/modelitem/relation_masterref/@roleorder")) {
            return order;
        }
        String s = con.getModelitemValue(modelId, name, "model/modelitem/relation_masterref/@roleorder");
        if (ropt.getValue("OPTION_model_modelitem_relation_storeref_roleorder_1_value").equals(s)) {
            order = "ascending";
        }
        return order;
    }

    public static String getAuthenticationType(ElementContainer con_) {
        String value = con_.getProjectValue("project/environment/security/@authenticationType");
        String authentication_type = null;
        if (ropt.getValue("OPTION_project_environment_authenticationType_2_value").equals(value)) {
            authentication_type = "remote_user";
        }
        return authentication_type;
    }

    public static boolean isAuthenticationTypeIsRemoteUser(ElementContainer con_) {
        return "remote_user".equals(Utils.getAuthenticationType(con_));
    }

    public static String getAUTHLDAPScope(ElementContainer con_) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ropt.getValue("OPTION_project_environment_auth_LDAP_scope_1_value"), "0");
        map.put(ropt.getValue("OPTION_project_environment_auth_LDAP_scope_2_value"), "1");
        map.put(ropt.getValue("OPTION_project_environment_auth_LDAP_scope_3_value"), "2");
        return (String)map.get(con_.getProjectValue("project/environment/@auth_LDAP_scope"));
    }

    public static String convertProperShowcondition(String value) {
        String ret = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if ("false".equalsIgnoreCase(value)) {
                ret = "false";
            } else if ("true".equalsIgnoreCase(value) || ropt.getValue("true").equals(value)) {
                ret = "";
            }
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    public static String convertProperShowconditionForShow(String modelId, ElementContainer con, String key) {
        if (!con.existsKeyInModel(modelId, key)) {
            return "";
        }
        String value = con.getModelValue(modelId, key);
        return Utils.convertProperShowconditionForShow(value);
    }

    public static String convertProperShowconditionForShow(String modelId, String itemname, ElementContainer con, String key) {
        if (!con.existsKeyInModelitem(modelId, itemname, key)) {
            return "";
        }
        String value = con.getModelitemValue(modelId, itemname, key);
        return Utils.convertProperShowconditionForShow(value);
    }

    public static String convertProperShowconditionForShow(String value) {
        String ret = StringUtils.isNotBlank((CharSequence)value) ? ("false".equalsIgnoreCase(value) ? "false" : ("true".equalsIgnoreCase(value) || ropt.getValue("true").equals(value) || ropt.getValue("true2").equals(value) ? "" : value)) : "false";
        return ret;
    }

    public static String convertProperShowconditionForUpdateshowlist(String modelId, ElementContainer con, String key) {
        return Utils.convertProperShowconditionForShow(con.getModelValue(modelId, key));
    }

    public static String convertProperShowconditionForInsertForiegnModel(String modelId, ElementContainer con, String key) {
        return Utils.convertProperShowconditionForShow(con.getModelValue(modelId, key));
    }

    public static boolean isIncludeELExpr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        int ptr1 = str.indexOf("${");
        int ptr2 = str.indexOf("}");
        return ptr1 > 0 && ptr2 > 0 && ptr1 < ptr2;
    }

    public static boolean isExpr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return str.indexOf("(") >= 0;
    }

    public static boolean isTextsearchInFile(String modelId, String itemname, ElementContainer con) {
        String key = "model/modelitem/@textsearchInFile";
        String value = con.getModelitemValue(modelId, itemname, key);
        if (!con.existsKeyInModelitem(modelId, itemname, key)) {
            return false;
        }
        return ropt.getValue("true").equals(value);
    }

    public static boolean hasTextsearchInFile(String modelId, ElementContainer con) {
        boolean hasTextsearchInFile = false;
        for (String name : con.getModelitemNames(modelId)) {
            if (!Utils.isDetailType(modelId, name, con, "special-filename") || !Utils.isTextsearchInFile(modelId, name, con)) continue;
            hasTextsearchInFile = true;
            break;
        }
        return hasTextsearchInFile;
    }

    public static boolean hasTextsearchRefmodelitem(String modelId, String itemname, ElementContainer con) {
        String rmodelId = con.getModelitemValue(modelId, itemname, "model/modelitem/relation/@idref");
        String ritemname = con.getModelitemValue(modelId, itemname, "model/modelitem/relation_storeref/@rolecontent");
        if (StringUtils.isNotBlank((CharSequence)rmodelId) && StringUtils.isNotBlank((CharSequence)ritemname)) {
            return Utils.isTextSearchAvailable(con.getModelitemValue(rmodelId, ritemname, "model/modelitem/@textsearch"));
        }
        return false;
    }

    public static String createProperSeparateString(String separate) {
        if (StringUtils.isBlank((CharSequence)separate)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        int length = separate.length();
        for (int i = 0; i < length; ++i) {
            char c = separate.charAt(i);
            if (c == ',' || c == ';' || c == '\uff0c' || c == '\u3001' || c == '\uff1b') {
                String s = tmp.toString();
                if (StringCheck.isNumber((String)s)) {
                    sb.append(s);
                    sb.append("px");
                } else {
                    sb.append(s);
                }
                sb.append(",");
                tmp = new StringBuilder();
                continue;
            }
            if (c == '.') {
                tmp.append(".");
                continue;
            }
            if (c == '%' || c == '\uff05') {
                tmp.append("%");
                continue;
            }
            if (!(c != 'p' && c != 'P' || i + 1 >= length || separate.charAt(i + 1) != 'x' && separate.charAt(i + 1) != 'X')) {
                tmp.append("px");
                ++i;
                continue;
            }
            try {
                int d = Integer.parseInt(String.valueOf(c));
                tmp.append(String.valueOf(d));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tmp.length() > 0) {
            String s = tmp.toString();
            if (StringCheck.isNumber((String)s)) {
                sb.append(s);
                sb.append("px");
            } else {
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String createProperWidthHeightString(String s) {
        return Utils.createProperSeparateString(s);
    }

    public static String createProperImageWidthHeightString(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '.' || c == '.' || c == '\uff0e') {
                sb.append(".");
                continue;
            }
            if (c == '-' || c == '\u30fc' || c == '-' || c == '\u2212') {
                sb.append("-");
                continue;
            }
            if (c == '%' || c == '\uff05' || c == 'p' || c == 'P' || c == 'p' || c == '\uff30' || c == 'x' || c == 'X' || c == 'x' || c == '\uff38') continue;
            try {
                int d = Integer.parseInt(String.valueOf(c));
                sb.append(String.valueOf(d));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static final String getUniqueName(String s) {
        return StringUtil.replaceAll((String)s, (String)"_", (String)"").toUpperCase();
    }

    public static boolean isFlowStatusSearch(String modelId, String name, ElementContainer con) {
        String idref = con.getModelitemValue(modelId, name, "model/modelitem/relation/@idref");
        String string = idref = idref == null ? "" : idref;
        return Utils.isSelectedOrIntegerValue(con.getModelitemValue(modelId, name, "model/modelitem/@hasConditionModel")) && (idref.equals("jfcflowstatus_search_m") || idref.endsWith("jfcflowstatus_search_m")) && Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@flowstatussearch"));
    }

    public static boolean isFlowStatusDisplayitem(String modelId, String name, ElementContainer con) {
        String autoCalc = StringUtils.lowerCase((String)StringUtils.trim((String)con.getModelitemValue(modelId, name, "model/modelitem/autocalc_2")));
        return StringUtils.startsWith((CharSequence)autoCalc, (CharSequence)"flowstatus(");
    }

    public static boolean isWorkflowModel(String modelId, ElementContainer con) {
        if (Utils.isSelectedValue(con.getModelValue(modelId, "model/@workflow"))) {
            return true;
        }
        String mainModelId = Utils.getMainmodelidref(modelId, con);
        if (mainModelId != null) {
            return Utils.isWorkflowModel(mainModelId, con);
        }
        return false;
    }

    public static boolean isConstraintParticipant(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@workflow")) && Utils.isSelectedValue(con.getModelValue(modelId, "action/@constraintparticipant"));
    }

    public static boolean isFlowselectorSearch(String modelId, ElementContainer con) {
        String value = con.getModelValue(modelId, "presentation/workflow/displayflowselector/@inputtype");
        return ropt.getValue("OPTION_presentation_workflow_displayflowselector_inputtype_2_value").equals(value) || ropt.getValue("OPTION_presentation_workflow_displayflowselector_inputtype_2_value_alt").equals(value);
    }

    public static String getUnreadStatusSearch(String modelId, String name, ElementContainer con) {
        return con.getModelitemValue(modelId, name, "action/condition/@unreadStatusSearch");
    }

    public static boolean isGenerateParseCsvDataMethod(String modelId, ElementContainer con, Project project) {
        return BUploadAction.isValid(con, modelId, project) || BJob.isInsertFromMail(con, modelId);
    }

    public static String getStoreModelMenuref(String modelId, String keyname, ElementContainer con_) {
        String menuref = con_.getModelValue(modelId, keyname);
        if (StringUtils.isBlank((CharSequence)menuref)) {
            menuref = con_.getModelValue(modelId, "model/@menuref");
            if (Utils.isMobile(modelId, con_) && StringUtils.isBlank((CharSequence)menuref)) {
                return "jfcNoneOfMenuCategory";
            }
        }
        return Utils.adjustProperMenuref(menuref);
    }

    public static Integer getStoreModelMenuorder(String modelId, String keyname, ElementContainer con_) {
        String menuorder = con_.getModelValue(modelId, keyname);
        if (!Utils.isInteger(menuorder)) {
            menuorder = con_.getModelValue(modelId, "model/@menuorder");
        }
        if (!Utils.isInteger(menuorder)) {
            return null;
        }
        return Integer.valueOf(menuorder);
    }

    public static String getMasterModelMenuref(String modelId, ElementContainer con_) {
        String menuref = con_.getModelValue(modelId, "model/@menuref");
        if (StringUtils.isBlank((CharSequence)menuref)) {
            menuref = rman.getValue("r.project.menu.mastermenu");
        }
        return Utils.adjustProperMenuref(menuref);
    }

    public static Integer getMasterModelMenuorder(String modelId, ElementContainer con_) {
        String menuorder = con_.getModelValue(modelId, "model/@menuorder");
        if (!Utils.isInteger(menuorder)) {
            return null;
        }
        return Integer.valueOf(menuorder);
    }

    public static boolean isBeforeDefFileVersion(String target, String version) {
        Boolean ret;
        String key;
        if (StringUtils.isBlank((CharSequence)target)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            version = "999";
        }
        if (cachedVersionCheckMap.containsKey(key = target + ":" + version) && (ret = cachedVersionCheckMap.get(key)) != null) {
            return ret;
        }
        String[] target_tokens = Utils.separateTokenVersion(target);
        String[] version_tokens = Utils.separateTokenVersion(version);
        boolean isBefore = false;
        int length = Math.max(target_tokens.length, version_tokens.length);
        for (int i = 0; i < length; ++i) {
            String v_token;
            String t_token = target_tokens.length > i ? target_tokens[i] : null;
            String string = v_token = version_tokens.length > i ? version_tokens[i] : null;
            if (v_token == null) {
                isBefore = false;
                break;
            }
            if (t_token == null) {
                isBefore = true;
                break;
            }
            try {
                int t_num = Integer.parseInt(t_token);
                int v_num = Integer.parseInt(v_token);
                if (t_num == v_num) continue;
                if (t_num < v_num) {
                    isBefore = true;
                    break;
                }
                isBefore = false;
            }
            catch (NumberFormatException e) {
                if (t_token.compareTo(v_token) == 0) continue;
                if (t_token.compareTo(v_token) < 0) {
                    isBefore = true;
                    break;
                }
                isBefore = false;
            }
            break;
        }
        cachedVersionCheckMap.put(key, isBefore);
        return isBefore;
    }

    private static String[] separateTokenVersion(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            list.add(token);
        }
        return list.toArray(new String[0]);
    }

    public static final boolean isDateComboForSearch(String modelId, String name, ElementContainer con) {
        String value = con.getModelitemValue(modelId, name, "model/modelitem/@calendarinputForSearch");
        return !StringUtils.isBlank((CharSequence)value) && !ropt.getValue("OPTION_model_modelitem_calendarinput_1_value").equals(value);
    }

    public static final boolean hasTextSearchModelitem(String modelId, ElementContainer con) {
        String itemname;
        String[] itemnames;
        boolean hasTextSearch = false;
        String[] stringArray = itemnames = con.getModelitemNames(modelId);
        int n = stringArray.length;
        for (int i = 0; i < n && !(hasTextSearch = Utils.isSelectedValue(con.getModelitemValue(modelId, itemname = stringArray[i], "model/modelitem/@textsearch"))); ++i) {
        }
        return hasTextSearch;
    }

    public static final boolean hasTextSearchOrSuggestModelitem(String modelId, ElementContainer con) {
        String itemname;
        String[] itemnames;
        boolean hasTextSearch = false;
        String[] stringArray = itemnames = con.getModelitemNames(modelId);
        int n = stringArray.length;
        for (int i = 0; i < n && !(hasTextSearch = Utils.isTextSearchAvailable(con.getModelitemValue(modelId, itemname = stringArray[i], "model/modelitem/@textsearch"))); ++i) {
        }
        return hasTextSearch;
    }

    public static String getStyleInfo(String modelId, String name, String key, ElementContainer con) {
        String style = con.getModelitemValue(modelId, name, key);
        return Utils.getStyleInfoValue(style);
    }

    public static String getStyleInfoValue(String style) {
        if (StringUtils.isNotBlank((CharSequence)style)) {
            if ("HIDE".equals(style = StringUtil.removePreAndPostWhitespaceWithoutInside((String)style))) {
                return "";
            }
            if (((String)style).startsWith("\"") && ((String)style).endsWith("\"")) {
                style = ((String)style).substring(1, ((String)style).length() - 1);
            }
            if (!((String)style).endsWith(";")) {
                style = (String)style + ";";
            }
        }
        return style;
    }

    public static String getStylePlace(String modelId, String name, String key, ElementContainer con) {
        String s = con.getModelitemValue(modelId, name, key);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return Utils.getStylePlaceValue(s);
    }

    public static String getStylePlaceValue(String s) {
        if (ropt.getValue("OPTION_presentation_displayitem_style_inputall_2_1_value").equals(s)) {
            return "centerfield";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_style_inputall_2_2_value").equals(s)) {
            return "around";
        }
        if (ropt.getValue("OPTION_presentation_displayitem_style_inputall_2_3_value").equals(s)) {
            return "all";
        }
        return null;
    }

    public static String getMobile(String modelId, ElementContainer con_) {
        String value = con_.getModelValue(modelId, "presentation/@mobile");
        if ("smartPhone".equals(value) || Utils.isSelectedValue(value)) {
            return "smartPhone";
        }
        return value;
    }

    public static boolean isSmartPhone(String modelId, ElementContainer con_) {
        return "smartPhone".equals(Utils.getMobile(modelId, con_));
    }

    public static boolean isMobile(String modelId, ElementContainer con_) {
        return Utils.isSmartPhone(modelId, con_);
    }

    public static boolean isContainerIncludingRelationTypeIsRef(String modelId, String name, String detailType, ElementContainer con_) {
        if ("special-container".equals(detailType)) {
            String[] itemnames;
            for (String itemname : itemnames = con_.getModelitemNames(modelId)) {
                String rolecontent;
                String roleid;
                String _item_detailType;
                if (!itemname.startsWith(name + "/") || !(_item_detailType = Utils.getDetailType(modelId, itemname, con_)).startsWith("special-storeref")) continue;
                String roleid_type = con_.getModelitemValue(modelId, itemname, "model/modelitem/relation_storeref/@roleid");
                if (!ropt.getValue("OPTION_model_modelitem_relation_storeref_roleid_2_value").equals(roleid_type) || (roleid = con_.getModelitemValue(modelId, itemname, "model/modelitem/relation_storeref/@roleid_2")) == null || roleid.startsWith(name + "/") || (rolecontent = con_.getModelitemValue(modelId, itemname, "model/modelitem/relation_storeref/@rolecontent")) == null || rolecontent.indexOf("/") <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String getTypeExt(String modelId, String name, ElementContainer con) {
        String type = IType.getIType(con.getModelitemValue(modelId, name, "presentation/displayitem/@type_ext"));
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        if ("special-mailaddress".equals(type)) {
            return "email";
        }
        if ("special-url".equals(type)) {
            return "url";
        }
        if ("number".equals(type)) {
            return "int";
        }
        return type;
    }

    public static void setTypeExt(String modelId, String name, Displayitem displayitem, ElementContainer con) {
        if (!Utils.isMobile(modelId, con)) {
            return;
        }
        if ("hidden".equals(displayitem.getType()) || displayitem.getReadonly()) {
            return;
        }
        String typeExt = Utils.getTypeExt(modelId, name, con);
        if (StringUtils.isNotBlank((CharSequence)typeExt)) {
            displayitem.setType(typeExt);
        }
    }

    public static final boolean isTextSearchAvailable(String s) {
        boolean b = Utils.isSelectedValue(s);
        if (!b && ropt.getValue("OPTION_model_modelitem_textsearch_2_value").equals(s)) {
            b = true;
        }
        return b;
    }

    public static boolean isCalendarButtonTypeIcon(ElementContainer con) {
        String calendarButtonType = con.getProjectValue("project/customize/@calendarButtonType");
        return StringUtils.isNotBlank((CharSequence)calendarButtonType) && (ropt.getValue("OPTION_project_environment_customize_calendarbuttontype_icon").equals(calendarButtonType) || Utils.isSelectedValue(calendarButtonType));
    }

    public static String getCalendarButtonType(ElementContainer con) {
        String calendarButtonType = con.getProjectValue("project/customize/@calendarButtonType");
        if (StringUtils.isBlank((CharSequence)calendarButtonType) || ropt.getValue("OPTION_project_environment_customize_calendarbuttontype_button").equals(calendarButtonType)) {
            return "button";
        }
        if (Utils.isCalendarButtonTypeIcon(con)) {
            return "icon";
        }
        if (ropt.getValue("OPTION_project_environment_customize_calendarbuttontype_focus").equals(calendarButtonType)) {
            return "focus";
        }
        return "";
    }

    public static String getLabelName(String modelId, String name, ElementContainer con, String type) {
        String key = null;
        key = "showlist".equals(type = type.toLowerCase()) ? "presentation/displayitem/@labelnameForShowList" : ("search".equals(type) ? "presentation/displayitem/@labelnameForSearch" : ("totalview".equals(type) ? "presentation/displayitem/@labelnameForShowListTotalView" : "presentation/displayitem/@labelnameForShow"));
        return con.getModelitemValue(modelId, name, key);
    }

    public static String getLabelStyle(String modelId, String name, ElementContainer con, String type) {
        String key = null;
        key = "showlist".equals(type = type.toLowerCase()) ? "presentation/displayitem/@labelstyleForShowList" : ("search".equals(type) ? "presentation/displayitem/@labelstyleForSearch" : ("totalview".equals(type) ? "presentation/displayitem/@labelstyleForShowListTotalView" : "presentation/displayitem/@labelstyleForShow"));
        return con.getModelitemValue(modelId, name, key);
    }

    public static Map<String, Integer> getCustomizedSearchListWindowProperties(ElementContainer con) {
        if (customizedSearchListWindowProperties != null) {
            return customizedSearchListWindowProperties;
        }
        customizedSearchListWindowProperties = new HashMap<String, Integer>();
        Integer height = null;
        Integer width = null;
        try {
            width = Integer.valueOf(con.getProjectValue("project/customize/@searchListWindowWidthHeight_2"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            height = Integer.valueOf(con.getProjectValue("project/customize/@searchListWindowWidthHeight"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        customizedSearchListWindowProperties.put("width", width);
        customizedSearchListWindowProperties.put("height", height);
        return customizedSearchListWindowProperties;
    }

    public static final Integer getSearchListWindowWidth(String refModelId, ElementContainer con) {
        Integer width = null;
        try {
            width = Integer.valueOf(con.getModelValue(refModelId, "presentation/layout/@searchListWindowWidthHeight_2"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (width != null) {
            return width;
        }
        Map<String, Integer> searchListWindowProperties = Utils.getCustomizedSearchListWindowProperties(con);
        if (searchListWindowProperties != null) {
            return searchListWindowProperties.get("width");
        }
        return null;
    }

    public static final Integer getSearchListWindowHeight(String refModelId, ElementContainer con) {
        Integer height = null;
        try {
            height = Integer.valueOf(con.getModelValue(refModelId, "presentation/layout/@searchListWindowWidthHeight"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (height != null) {
            return height;
        }
        Map<String, Integer> searchListWindowProperties = Utils.getCustomizedSearchListWindowProperties(con);
        if (searchListWindowProperties != null) {
            return searchListWindowProperties.get("height");
        }
        return null;
    }

    public static String getDefaultWidth(String modelId, String name, ElementContainer con, String style) {
        return Utils.getDefaultWidth(modelId, name, con, style, "");
    }

    public static String getDefaultWidth(String modelId, String name, ElementContainer con, String style, String action) {
        boolean isHTMLTable;
        if (StringUtils.contains((CharSequence)style, (CharSequence)"width") || StringUtils.isNotBlank((CharSequence)con.getModelitemValue(modelId, name, "presentation/displayitem/@size")) || Utils.isMobile(modelId, con) || !JspBodyGenerator_show.isOnlyCssStatement((String)style) || Utils.isCalendarinputUseCalendar(modelId, name, con)) {
            return "";
        }
        String defaultWidth = "";
        boolean bl = isHTMLTable = !Utils.isCSSLayout(modelId, con);
        if ((Utils.isDetailType(modelId, name, con, "string") && Utils.isTextareaInCondition(modelId, name, action, con) && !Utils.isDualInput(modelId, name, con) || Utils.isDetailType(modelId, name, con, "int") || Utils.isDetailType(modelId, name, con, "byte") || Utils.isDetailType(modelId, name, con, "short") || Utils.isDetailType(modelId, name, con, "long") || Utils.isDetailType(modelId, name, con, "float") || Utils.isDetailType(modelId, name, con, "double") || Utils.isDetailType(modelId, name, con, "special-mailaddress") || Utils.isDetailType(modelId, name, con, "special-url") || name.contains("/") && Utils.isDetailType(modelId, name, con, "special-storeref-search") || Utils.isDetailType(modelId, name, con, "special-storeref-ref") && !"textarea".equals(IType.getIType(con.getModelitemValue(modelId, name, "presentation/displayitem/@type"))) && !"rtextarea".equals(IType.getIType(con.getModelitemValue(modelId, name, "presentation/displayitem/@type"))) && (!"showlist".equals(action) && !Utils.isReadonly(modelId, name, con) || "showlist".equals(action) && !Utils.isReadonlyForSearch(modelId, name, con)) && ("string".equals(Utils.getModelitemType(modelId, name, con)) || "int".equals(Utils.getModelitemType(modelId, name, con)) || "byte".equals(Utils.getModelitemType(modelId, name, con)) || "short".equals(Utils.getModelitemType(modelId, name, con)) || "long".equals(Utils.getModelitemType(modelId, name, con)) || "float".equals(Utils.getModelitemType(modelId, name, con)) || "double".equals(Utils.getModelitemType(modelId, name, con))) && !Utils.isRefModelitemType(modelId, name, con, "special-storeref-radio") && !Utils.isRefModelitemType(modelId, name, con, "special-storeref-check")) && !Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/selfref"))) {
            if (isHTMLTable) {
                defaultWidth = "width:100%;";
            } else if (name.contains("/") || "showlist".equals(action) || "updatelist".equals(action)) {
                if (isHTMLTable) {
                    defaultWidth = "width:100%;";
                }
            } else if (isHTMLTable) {
                defaultWidth = "width:99%;display:inline;";
            } else {
                String prestring = con.getModelitemValue(modelId, name, "presentation/displayitem/@prestring");
                String poststring = con.getModelitemValue(modelId, name, "presentation/displayitem/@poststring");
                if (StringUtils.isBlank((CharSequence)prestring) && StringUtils.isBlank((CharSequence)poststring)) {
                    String autoCalc = con.getModelitemValue(modelId, name, "model/modelitem/autocalc_2");
                    String relationtype = con.getModelitemValue(modelId, name, "presentation/displayitem/@storerefdisplay");
                    if (!("update".equals(action) && (Utils.isPrimaryKey(modelId, name, con) || StringUtils.isNotBlank((CharSequence)Utils.getLocknames(modelId, name, con))) || Utils.isAutoId(modelId, name, con) || Utils.isDisplayitemReadonly(modelId, name, action, con) && (StringUtils.isNotBlank((CharSequence)relationtype) || !"search".equals(IType.getIType(relationtype))) || StringUtils.isNotBlank((CharSequence)autoCalc) && !Utils.isAutoCalcType(modelId, name, con, "padding") || !isHTMLTable)) {
                        defaultWidth = "width:99%;";
                    }
                }
            }
        }
        return defaultWidth;
    }

    private static boolean isTextareaInCondition(String modelId, String name, String action, ElementContainer con) {
        if ("showlist".equals(action) && (Utils.isDisplayitemType(modelId, name, con, "textarea") || Utils.isDisplayitemType(modelId, name, con, "rtextarea"))) {
            return true;
        }
        return !Utils.isDisplayitemType(modelId, name, con, "textarea") && !Utils.isDisplayitemType(modelId, name, con, "rtextarea");
    }

    public static boolean isDetailTypeListBox(String modelId, String name, ElementContainer con, String action) {
        return Utils.isDetailType(modelId, name, con, "special-storeref-combo") || Utils.isDetailType(modelId, name, con, "special-masterref-combo") || "showlist".equals(action) && Utils.isDualInput(modelId, name, con) || "showlist".equals(action) && Utils.isSearchType(modelId, name, con, "combo");
    }

    public static boolean isReservedActionCommand(String buttonAction) {
        return reservedActionCommandSet.contains(buttonAction);
    }

    public static void reset() {
        errorNotExistsRefModelitemSet = null;
        errorNotExistsRefModelitemSet = new HashSet<String>();
        wizardNumbers = null;
        foreignKeyModels = null;
        constraintTargets = null;
        cachedVersionCheckMap = new HashMap<String, Boolean>();
        customizedSearchListWindowProperties = null;
        cachedSortByDetailDisplayOrder = new HashMap<String, String[]>();
    }

    public static boolean isPessimisticLock(String modelId, ElementContainer con) {
        String key = "model/@pessimisticLock";
        String dtype = con.getModelValue(modelId, "presentation/displaymodel/@updateListDisplayType");
        if (dtype != null && dtype.equals("spreadsheet")) {
            return false;
        }
        if (!con.existsKeyInModel(modelId, key)) {
            return true;
        }
        return Utils.isSelectedValue(con.getModelValue(modelId, key));
    }

    public static boolean isPessimisticLockRelatedMainSubModel(String modelId, ElementContainer con) {
        Object[] modelIds = Utils.getModelIdsRelatedMainSubModel(modelId, con);
        for (Object relatedModelId : modelIds = (String[])ArrayUtils.add((Object[])modelIds, (Object)modelId)) {
            if (Utils.isPessimisticLock((String)relatedModelId, con)) continue;
            return false;
        }
        return true;
    }

    public static String getOptimisticLock(String modelId, ElementContainer con) {
        String columnName = con.getModelValue(modelId, "model/@optimisticLock");
        if (StringUtils.isBlank((CharSequence)columnName)) {
            return null;
        }
        return columnName;
    }

    public static String getOptimisticLockRelatedMainSubModel(String modelId, ElementContainer con) {
        Object[] modelIds = Utils.getModelIdsRelatedMainSubModel(modelId, con);
        modelIds = (String[])ArrayUtils.add((Object[])modelIds, (Object)modelId);
        Arrays.sort(modelIds);
        for (Object relatedModelId : modelIds) {
            String columnName = Utils.getOptimisticLock((String)relatedModelId, con);
            if (!StringUtils.isNotBlank((CharSequence)columnName)) continue;
            return columnName;
        }
        return null;
    }

    public static boolean isCalendarTypeClassic(String modelId, ElementContainer con) {
        return "classic".equals(Utils.getCalendarType(modelId, con));
    }

    public static String getCalendarType(String modelId, ElementContainer con) {
        String calendarType = con.getModelValue(modelId, "presentation/calendarOutput/@type");
        if (StringUtils.isBlank((CharSequence)calendarType)) {
            return "classic";
        }
        return calendarType;
    }

    public static boolean useTabLayoutForeignKey(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/foreignkey/display/@usetab"));
    }

    public static boolean isStaticSelectedModel(String modelId, ElementContainer con) {
        File savedir = con.getInitialDataSaveDir(modelId);
        boolean isStatic = Utils.isSelectedValue(con.getModelValue(modelId, "model/@static"));
        return savedir != null && isStatic;
    }

    public static boolean isShowListDisplayTypeGrid(String modelId, ElementContainer con) {
        String showListDisplayType = con.getModelValue(modelId, "presentation/displaymodel/@showListDisplayType");
        return Utils.isSelectedValue(showListDisplayType) || "grid".equals(showListDisplayType) || Utils.isMobile(modelId, con);
    }

    public static boolean isShowListDisplayTypeSpreadsheet(String modelId, ElementContainer con) {
        return "spreadsheet".equals(con.getModelValue(modelId, "presentation/displaymodel/@showListDisplayType"));
    }

    public static boolean isUpdateListDisplayTypeGrid(String modelId, ElementContainer con) {
        String updateListDisplayType = con.getModelValue(modelId, "presentation/displaymodel/@updateListDisplayType");
        return Utils.isSelectedValue(updateListDisplayType) || "grid".equals(updateListDisplayType);
    }

    public static boolean isUpdateListDisplayTypeSpreadsheet(String modelId, ElementContainer con) {
        return "spreadsheet".equals(con.getModelValue(modelId, "presentation/displaymodel/@updateListDisplayType"));
    }

    public static String addPostfixString(String desc, String value) {
        Locale loc;
        if (value == null || value.length() == 0) {
            return desc;
        }
        if (value.charAt(0) != ' ' && (loc = Locale.getDefault()) != null && (loc.getLanguage().equals("ja") || loc.getLanguage().equals("en"))) {
            return desc + " " + value;
        }
        return desc + value;
    }

    public static String getProperSpace() {
        Locale loc = Locale.getDefault();
        if (loc != null && loc.getLanguage().equals("en")) {
            return " ";
        }
        return "";
    }

    public static String[] sortByDetailDisplayOrder(String modelId, String[] modelitemNames, ElementContainer con) {
        boolean _d = false;
        if (cachedSortByDetailDisplayOrder.containsKey(modelId)) {
            return cachedSortByDetailDisplayOrder.get(modelId);
        }
        String[] c_modelitemNames = new String[modelitemNames.length];
        System.arraycopy(modelitemNames, 0, c_modelitemNames, 0, modelitemNames.length);
        String name = null;
        int processed = 0;
        int bias = 0;
        TreeMap<Integer, String> orderedNamesMap = new TreeMap<Integer, String>();
        for (int i = 0; i < c_modelitemNames.length; ++i) {
            name = c_modelitemNames[i];
            String nstr = con.getModelitemValue(modelId, name, "model/modelitem/@detailDisplayOrder");
            if (!StringUtils.isNotEmpty((CharSequence)nstr)) continue;
            int index = NumberUtils.toInt((String)nstr);
            if (index > 0) {
                while (orderedNamesMap.containsKey(index + bias)) {
                    log.warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.sortByDetailDisplayOrder.duplicateindex", new Object[]{modelId, name, nstr}));
                    ++bias;
                }
                orderedNamesMap.put(index + bias, name);
                c_modelitemNames[i] = null;
                ++processed;
                bias = 0;
                continue;
            }
            log.warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.sortByDetailDisplayOrder.invalidindex", new Object[]{modelId, name, nstr}));
        }
        int idx = 0;
        Object[] orderedNames = new String[orderedNamesMap.size()];
        for (Integer key : orderedNamesMap.keySet()) {
            String name_ = (String)orderedNamesMap.get(key);
            if (name_ == null) continue;
            orderedNames[idx++] = name_;
        }
        if (processed == 0) {
            cachedSortByDetailDisplayOrder.put(modelId, modelitemNames);
            return modelitemNames;
        }
        if (processed != c_modelitemNames.length) {
            for (int i = 0; i < c_modelitemNames.length; ++i) {
                name = c_modelitemNames[i];
                if (name == null) continue;
                orderedNames = (String[])ArrayUtils.add((Object[])orderedNames, (Object)name);
            }
        }
        cachedSortByDetailDisplayOrder.put(modelId, (String[])orderedNames);
        return orderedNames;
    }

    public static final boolean isShowListScrollTypeFixColumn(String modelId, ElementContainer con) {
        String value = con.getModelValue(modelId, "presentation/displaymodel/@showListScrollType");
        return "fixColumns".equals(value) || "fixHeaderAndColumns".equals(value);
    }

    public static boolean isUseRest(String modelId, ElementContainer con) {
        if ("jfcportal".equals(modelId) || "jfcportlet".equals(modelId) || "jnews".equals(modelId) || "jfccspreferenceitem".equals(modelId) || Utils.isMobile(modelId, con)) {
            return true;
        }
        String mv = con.getModelValue(modelId, "action/@rest");
        if (mv != null) {
            if (Utils.isSelectedValue(mv)) {
                return true;
            }
            if (mv.equals("")) {
                return false;
            }
        }
        return false;
    }

    public static String escapeString(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return s;
        }
        return WebStringEncodeUtilities.replaceCR2BRTag((String)StringUtil.escapeString((String)s, (char)'\\'));
    }

    public static boolean isUiSearch(String modelId, String name, ElementContainer con_) {
        return "search".equals(con_.getModelitemValue(modelId, name, "model/modelitem/relation_storeref/@ui"));
    }

    public static final String getImagesizeunit(String modelId, String name, String repositoryKey, ElementContainer con) {
        String value = con.getModelitemValue(modelId, name, repositoryKey);
        if (StringUtils.isBlank((CharSequence)value)) {
            return "px";
        }
        return value;
    }

    public static final boolean isAutocalcBarcodeDefined(String modelId, String name, ElementContainer con_) {
        return "calc".equals(con_.getModelitemValue(modelId, name, "model/modelitem/autocalc")) && StringUtils.startsWith((CharSequence)con_.getModelitemValue(modelId, name, "model/modelitem/autocalc_2"), (CharSequence)"BARCODE(");
    }

    public static boolean isAutoScaling(ElementContainer con_) {
        return Utils.isSelectedValue(con_.getProjectValue("project/environment/@autoscaling"));
    }

    public static boolean isLayoutOnly(String modelId, String name, ElementContainer con) {
        boolean isLayoutOnly = false;
        String isLayoutOnlyStr = con.getModelitemValue(modelId, name, "model/modelitem/@layout");
        if (StringUtils.isNotBlank((CharSequence)isLayoutOnlyStr) && Boolean.valueOf(isLayoutOnlyStr).booleanValue()) {
            isLayoutOnly = true;
        }
        return isLayoutOnly;
    }

    public static boolean isMicroservice(ElementContainer con) {
        return Utils.isSelectedValue(con.getProjectValue("project/environment/@microservice"));
    }

    public static int[] getDomain(String modelId, ElementContainer con) {
        String values = con.getModelValue(modelId, "model/@domain");
        if (StringUtils.isBlank((CharSequence)values)) {
            return new int[0];
        }
        return Stream.of(values.split(",")).mapToInt(Integer::parseInt).toArray();
    }

    public static void setDomainCreateTableAttribute(String modelId, Model smodel, Project project, ElementContainer con) {
        String id = Utils.getBuildDomain(con);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        if (ArrayUtils.contains((Object[])DBScriptGenerator.CROSS_DOMAIN_MODELS, (Object)modelId)) {
            return;
        }
        if (smodel.getStatic()) {
            return;
        }
        int[] domain = AppSchemaUtil.getDomains((Model)smodel, (Project)project);
        if (ArrayUtils.isEmpty((int[])domain)) {
            domain = Utils.getDomain(modelId, con);
        }
        if (ArrayUtils.contains((int[])domain, (int)1) || ArrayUtils.contains((int[])domain, (int)2)) {
            if (!"1000".equals(id)) {
                smodel.setCreatetable(false);
            }
            return;
        }
        int min = Arrays.stream(domain).min().orElseThrow(() -> new IllegalStateException("model " + modelId + " must belong to at least one domain." + smodel));
        if (!id.equals(String.valueOf(min))) {
            smodel.setCreatetable(false);
        }
    }

    public static String getBuildDomain(ElementContainer con) {
        return con.getProjectValue(BILD_DOMAIN_KEY);
    }

    public static boolean isCSSLayout(String modelId, ElementContainer con) {
        if (Utils.isMobile(modelId, con) || Utils.isCalendarOutput(modelId, con) && "classic".equals(Utils.getCalendarType(modelId, con))) {
            return false;
        }
        String outputmethod = con.getModelValue(modelId, "presentation/layout/@outputmethod");
        if (JFCUtils.isSystemModel((String)modelId)) {
            return "CSSLayout".equals(outputmethod);
        }
        Object key = "jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.BPresentationTemplate.outputmethod";
        if (compatibilityManager.containsKey1((String)(key = (String)key + "." + modelId))) {
            String value = compatibilityManager.getStringValue((String)key);
            if (!"HTMLTable".equals(value) && !"CSSLayout".equals(value)) {
                value = "CSSLayout";
            }
            return "CSSLayout".equals(value);
        }
        return "CSSLayout".equals(outputmethod);
    }

    public static String getLayoutType(String modelId, ElementContainer con) {
        if (Utils.isCSSLayout(modelId, con)) {
            return "thymeleaf";
        }
        return "tiles:classic2";
    }

    public static String getProperGenId(String modelId, String gid) {
        if (StringUtils.isBlank((CharSequence)gid)) {
            gid = !modelId.toLowerCase().startsWith("jsh") ? "JSH" + modelId + "GEN" : modelId + "GEN";
        }
        return gid;
    }

    public static String getModelName(String modelId, ElementContainer con) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)con.getModelValue(modelId, "model/@description"), (CharSequence)modelId);
    }

    public static Map<String, String> getDefaultRdbdatatypeMap(Project project) {
        if (typemap == null) {
            Database database = AppSchemaUtil.getDatabase((Environment)project.getEnvironment());
            RdbSetting rdbSetting = database.getRdbSetting();
            Rdbtypemap[] rdbtypemaps = rdbSetting != null ? rdbSetting.getRdbtypemap() : null;
            typemap = rdbtypemaps != null && rdbtypemaps.length > 0 ? Arrays.stream(rdbtypemaps).collect(Collectors.toMap(Rdbtypemap::getType, Rdbtypemap::getContent)) : Collections.emptyMap();
        }
        return typemap;
    }

    public static boolean isRestV3(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "model/@restV3"));
    }

    public static final boolean isCreateSubwindow(String modelId, ElementContainer con) {
        return Utils.isSelectedValue(con.getModelValue(modelId, "action/@subwindow"));
    }

    public static boolean isStringTypeOrLookup(String modelId, String name, ElementContainer con) {
        String detailType = IType.getIType(con.getModelitemValue(modelId, name, "model/modelitem/@type"));
        return "string".equals(detailType) || "zipcode".equals(detailType) || "special-mailaddress".equals(detailType) || "special-url".equals(detailType) || "special-filename".equals(detailType) || "special-storeref-ref".equals(detailType);
    }

    public static boolean hasHtmlTag(String s) {
        String[] htmltags;
        for (String tag : htmltags = new String[]{"br", "div", "span", "p"}) {
            String token1 = "<" + tag;
            String token2 = "<" + tag.toUpperCase();
            if (s.indexOf(token1) < 0 && s.indexOf(token2) < 0) continue;
            return true;
        }
        return false;
    }

    static {
        wizardNumbers = null;
        foreignKeyModels = null;
        dbtypes = new String[][]{{ropt.getValue("OPTION_project_environment_database_database_1"), "hsqldb"}, {ropt.getValue("OPTION_project_environment_database_database_2"), "postgresql"}, {ropt.getValue("OPTION_project_environment_database_database_3"), "oracle"}, {ropt.getValue("OPTION_project_environment_database_database_4"), "oracle"}, {ropt.getValue("OPTION_project_environment_database_database_5"), "oracle"}, {ropt.getValue("OPTION_project_environment_database_database_6"), "sqlserver2005"}, {ropt.getValue("OPTION_project_environment_database_database_7"), "db2"}, {ropt.getValue("OPTION_project_environment_database_database_8"), "db2400"}, {ropt.getValue("OPTION_project_environment_database_database_9"), "mysql"}, {ropt.getValue("OPTION_project_environment_database_database_10"), "mysql"}, {ropt.getValue("OPTION_project_environment_database_database_11"), "dbmaster"}};
        dbtypesMap = new HashMap<String, String>();
        for (String[] dbtype : dbtypes) {
            dbtypesMap.put(dbtype[0], dbtype[1]);
        }
        DEFAULT_NUMBERFORMAT = "##0.0#####";
        String s = compatibilityManager.getStringValue("jp.jasminesoft.jfc.tools.xls2appschema.Utils.DEFAULT_NUMBERFORMAT");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            DEFAULT_NUMBERFORMAT = s;
        }
        constraintTargets = null;
        cachedVersionCheckMap = new HashMap<String, Boolean>();
        customizedSearchListWindowProperties = null;
        reservedActionCommandSet = new HashSet<String>();
        String[] cmd = new String[]{"Show", "New", "Update", "Search", "Search_Condition", "Sort", "Next", "Prev", "First", "Last", "Jump", "WizNext", "WizPrev", "WizChange", "JFCPrintScreen", "Print", "Restore", "DeleteAll", "SendMailAll", "PrintAll", "UpdateAll", "ProcessAll", "Zipcode", "GetXml", "GetJson", "ChangePreference"};
        reservedActionCommandSet.addAll(Arrays.asList(cmd));
        cachedSortByDetailDisplayOrder = new HashMap<String, String[]>();
        typemap = null;
    }

    public static enum Groupdateitemtype {
        username,
        jgroupid;

    }
}

