/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.gen.appschema.Jfcdomain;
import jp.jasminesoft.jfc.tools.repository.RepositoryUtil;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipal;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipalCategory;
import jp.jasminesoft.jfc.tools.xls2appschema.CacheFileManager;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.MessageListener;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelInfo;
import jp.jasminesoft.jfc.tools.xls2appschema.ModelitemInfo;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc;
import jp.jasminesoft.util.ResourceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="elementContainer")
public class WagbyR6DefElementContainer
implements ElementContainer {
    protected Logger log = LogManager.getLogger(WagbyR6DefElementContainer.class);
    private ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private ResourceManager ropt = ResourceManager.getInstance((String)"options");
    private static boolean debug = false;
    private Map<String, String> projectMap;
    private Map<String, String> projectMap4Domain;
    private Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap;
    private Map<Integer, AuthorityPrincipalCategory> authorityPrincipalCategoryMap;
    private Map<Integer, Jfcdomain> domainMap;
    private Map<String, ModelInfo> modelMap;
    private Map<String, String> modelVersionMap;
    private Map<String, String> menuMap = new HashMap<String, String>();
    private Map<String, String[]> cachedModelitemNameMap;
    private Map<String, TreeMap<ModelitemInfo, String>> cachedModelitemInfoKeyBaseMap;
    private Map<String, TreeMap<ModelitemInfo, String>> cachedModelitemInfoNameBaseMap;
    private Map<String, Map<String, Map<String, String>>> cachedLayoutInfoLabelBaseMap;
    private Map<String, Map<String, Map<String, String>>> cachedPrincipalInfoPrincipalIdBaseMap;
    private Map<String, Map<String, Map<String, String>>> cachedPermissionInfoPermissionActionBaseMap;
    private Map<String, Map<String, List<String>>> cachedAclMappingInfPrincipalIdBaseMap;
    private Map<String, String[]> cachedAllModelIdMap;
    private HashMap<String, Map<String, String>> tempLineMap;
    private Map<Integer, Map<Integer, String>> rowMap = new TreeMap<Integer, Map<Integer, String>>();
    @Autowired(required=true)
    private MessageListener messageListener_;
    @Autowired(required=true)
    private CacheFileManager cacheFileManager_;
    private static boolean initProcessFlag = false;
    private Map<String, List<String>> zombieItemMap;
    private String customizeDirectory = "../customize";
    private Integer domainId;
    private static Set<String> oldTargetModelIdSet;
    private boolean needsCheckRelatedModelSet = true;
    private static Set<String> _oldset;
    private final int PROJECT_MAX_VALUE_COLUMN = 6;
    private final int MODEL_MAX_VALUE_COLUMN = 5;
    private static final String[] relatedKeys;
    private static Set<String> relatedKeySet;

    public void setCustomizeDirectory(String dir) {
        this.customizeDirectory = dir;
    }

    public String getCustomizeDirectory() {
        return this.customizeDirectory;
    }

    public void setDomainId(Integer domainId) {
        this.domainId = domainId;
    }

    public void setTargetModelIdSet(Set<String> targetModelIdSet) {
        this.needsCheckRelatedModelSet = true;
        if (targetModelIdSet == null || targetModelIdSet.size() == 0) {
            oldTargetModelIdSet = null;
            _oldset = null;
            this.log.info("clear oldTargetModelIdSet.");
            return;
        }
        if (oldTargetModelIdSet == null) {
            oldTargetModelIdSet = targetModelIdSet.stream().collect(Collectors.toSet());
            _oldset = null;
            this.log.info("copy oldTargetModelIdSet.");
            return;
        }
        if (oldTargetModelIdSet != null && targetModelIdSet != null && oldTargetModelIdSet.size() == targetModelIdSet.size()) {
            boolean isMatch = true;
            for (String s : oldTargetModelIdSet) {
                if (targetModelIdSet.contains(s)) continue;
                isMatch = false;
                break;
            }
            if (isMatch) {
                this.log.info("skip to check related model.");
                this.needsCheckRelatedModelSet = false;
                return;
            }
        }
        oldTargetModelIdSet = targetModelIdSet.stream().collect(Collectors.toSet());
        _oldset = null;
        this.log.info("needs check related model.");
    }

    public WagbyR6DefElementContainer() {
        this.projectMap = new TreeMap<String, String>();
        if (this.domainId != null) {
            this.projectMap4Domain = new TreeMap<String, String>();
        }
        this.authorityPrincipalInfoMap = new TreeMap<Integer, AuthorityPrincipal>();
        this.authorityPrincipalCategoryMap = new TreeMap<Integer, AuthorityPrincipalCategory>();
        this.domainMap = new TreeMap<Integer, Jfcdomain>();
        this.modelMap = new TreeMap<String, ModelInfo>();
        this.modelVersionMap = new TreeMap<String, String>();
        this.cachedModelitemNameMap = new HashMap<String, String[]>();
        this.cachedModelitemInfoKeyBaseMap = new HashMap<String, TreeMap<ModelitemInfo, String>>();
        this.cachedModelitemInfoNameBaseMap = new HashMap<String, TreeMap<ModelitemInfo, String>>();
        this.cachedLayoutInfoLabelBaseMap = new HashMap<String, Map<String, Map<String, String>>>();
        this.cachedPrincipalInfoPrincipalIdBaseMap = new HashMap<String, Map<String, Map<String, String>>>();
        this.cachedPermissionInfoPermissionActionBaseMap = new HashMap<String, Map<String, Map<String, String>>>();
        this.cachedAclMappingInfPrincipalIdBaseMap = new HashMap<String, Map<String, List<String>>>();
        this.zombieItemMap = new HashMap<String, List<String>>();
    }

    @Override
    public void init() {
        this.cacheFileManager_.setElementContainer(this);
        this.cachedAllModelIdMap = null;
        if (!initProcessFlag) {
            if (this.cacheFileManager_.getUseCache()) {
                if (debug) {
                    System.out.println("*** Read cache !!");
                }
                if (!this.projectMap.isEmpty()) {
                    this.projectMap = new TreeMap<String, String>();
                    this.authorityPrincipalInfoMap = new TreeMap<Integer, AuthorityPrincipal>();
                    this.authorityPrincipalCategoryMap = new TreeMap<Integer, AuthorityPrincipalCategory>();
                    this.domainMap = new TreeMap<Integer, Jfcdomain>();
                    this.modelMap = new TreeMap<String, ModelInfo>();
                    this.modelVersionMap = new TreeMap<String, String>();
                    this.menuMap = new HashMap<String, String>();
                }
                if (this.domainId == null) {
                    this.cacheFileManager_.loadProjectMap(this.projectMap);
                } else {
                    this.cacheFileManager_.loadProjectMap(this.projectMap, this.domainId);
                }
                this.cacheFileManager_.loadAuthorityPrincipalInfoMap(this.authorityPrincipalInfoMap);
                this.cacheFileManager_.loadAuthorityPrincipalCategoryMap(this.authorityPrincipalCategoryMap);
                this.cacheFileManager_.loadDomainMap(this.domainMap);
                this.cacheFileManager_.loadModelMap(this.modelMap);
                this.cacheFileManager_.loadModelVersionMap(this.modelVersionMap);
                if (!this.cacheFileManager_.loadMenuMap(this.menuMap)) {
                    this.menuMap = null;
                } else {
                    for (Map.Entry<String, String> e : this.menuMap.entrySet()) {
                        String key = e.getKey();
                        if (key != null && (key.startsWith("model/@menu") || key.startsWith("action/@menu"))) continue;
                        this.projectMap.put(e.getKey(), e.getValue());
                    }
                }
                if (debug) {
                    System.out.println("*** Done.");
                }
            }
            this.addCommonModelInfoToModelMap();
            this.modelMap.remove("jfcDesignerTemplateCollection");
            this.modelMap.remove("jfcDesignerTemplateModel");
            this.modelMap.remove("jfcDesignerTemplateModelitem");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem1");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem2");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem3");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem4");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem5");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem6");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem7");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem8");
            this.modelMap.remove("jfcDesignerUserTemplateModelitem9");
            this.modelMap.remove("jfcDesignerTemplateInsertUpdateInfo");
            this.modelMap.remove("jfcDesignerTemplateGmapPointTemplate");
            this.modelMap.remove("jfcDesignerTemplateWfEventHistory");
            this.modelMap.remove("jfcMenu");
            initProcessFlag = true;
            if (debug) {
                System.out.println("projectMap=" + this.projectMap.keySet());
            }
            if (debug) {
                System.out.println("modelMap=" + this.modelMap.keySet());
            }
            if (debug) {
                System.out.println("** after load cache," + this.modelVersionMap);
            }
        }
    }

    protected void clearCacheByModelId(String modelId) {
        this.cachedModelitemNameMap.remove(modelId);
        this.cachedModelitemInfoKeyBaseMap.remove(modelId);
        this.cachedModelitemInfoNameBaseMap.remove(modelId);
        this.cachedLayoutInfoLabelBaseMap.remove(modelId);
        this.cachedPrincipalInfoPrincipalIdBaseMap.remove(modelId);
        this.cachedPermissionInfoPermissionActionBaseMap.remove(modelId);
        this.cachedAclMappingInfPrincipalIdBaseMap.remove(modelId);
        this.modelVersionMap.remove(modelId);
        this.cachedAllModelIdMap = null;
    }

    private void addCommonModelInfoToModelMap() {
        this.addJprincipalModelInfoToModelMap();
        this.addJcategoryModelInfoToModelMap();
        this.addHourMModelInfoToModelMap();
        this.addJpermissionMModelInfoToModelMap();
        this.addMinuteMInfoToModelMap();
        this.addMovestepMModelInfoToModelMap();
    }

    private void addJprincipalModelInfoToModelMap() {
        ModelInfo minfo = this.createNewModelMap("jprincipal");
        this.modelMap.put("jprincipal", minfo);
        SortedMap<String, String> modelInfoMap = minfo.getModelInfoMap();
        modelInfoMap.put("model/@id", "jprincipal");
        modelInfoMap.put("model/@type", "model");
        Map<ModelitemInfo, String> modelitemInfoMap = minfo.getModelitemInfoMap();
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "id"), "1");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "id"), "id");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "id"), "id");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@primaryKey", "id"), this.ropt.getValue("r.selector"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "id"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_number_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "priority"), "2");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "priority"), this.ropt.getValue("OPTION_model_modelitem_relation_storeref_sortrule_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "priority"), "priority");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "priority"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_number_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "valid"), "3");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "valid"), "valid");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "valid"), "valid");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "valid"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_string_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "name"), "4");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "name"), "name");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "name"), "name");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "name"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_string_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "content"), "5");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "content"), "name");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "content"), "content");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "content"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_string_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "jpermissionId"), "6");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "jpermissionId"), "jpermissionId");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "jpermissionId"), "jpermissionId");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "jpermissionId"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_ref_7_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/relation/@idref", "jpermissionId"), "jpermission_m");
    }

    private void addJcategoryModelInfoToModelMap() {
        ModelInfo minfo = this.createNewModelMap("jcategory");
        this.modelMap.put("jcategory", minfo);
        SortedMap<String, String> modelInfoMap = minfo.getModelInfoMap();
        modelInfoMap.put("model/@id", "jcategory");
        modelInfoMap.put("model/@type", "model");
        Map<ModelitemInfo, String> modelitemInfoMap = minfo.getModelitemInfoMap();
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "id"), "1");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "id"), "id");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "id"), "id");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@primaryKey", "id"), this.ropt.getValue("r.selector"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "id"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_number_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "no"), "2");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "no"), "no");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "no"), "no");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "no"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_number_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "order"), "3");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "order"), "order");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "order"), "order");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "order"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_number_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "categoryId"), "4");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "categoryId"), "categoryId");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "categoryId"), "categoryId");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "categoryId"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_string_1_value"));
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@__linenumber", "content"), "5");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@label", "content"), "name");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@name", "content"), "content");
        modelitemInfoMap.put(new ModelitemInfo("model/modelitem/@type", "content"), this.ropt.getValue("OPTION_model_modelitem_typeDetail_string_1_value"));
    }

    private void addHourMModelInfoToModelMap() {
        ModelInfo minfo = this.createNewModelMap("hour_m");
        this.modelMap.put("hour_m", minfo);
        SortedMap<String, String> modelInfoMap = minfo.getModelInfoMap();
        modelInfoMap.put("model/@id", "hour_m");
        modelInfoMap.put("model/@type", "master");
    }

    private void addJpermissionMModelInfoToModelMap() {
        ModelInfo minfo = this.createNewModelMap("jpermission_m");
        this.modelMap.put("jpermission_m", minfo);
        SortedMap<String, String> modelInfoMap = minfo.getModelInfoMap();
        modelInfoMap.put("model/@id", "jpermission_m");
        modelInfoMap.put("model/@type", "master");
    }

    private void addMinuteMInfoToModelMap() {
        ModelInfo minfo = this.createNewModelMap("minute_m");
        this.modelMap.put("minute_m", minfo);
        SortedMap<String, String> modelInfoMap = minfo.getModelInfoMap();
        modelInfoMap.put("model/@id", "minute_m");
        modelInfoMap.put("model/@type", "master");
    }

    private void addMovestepMModelInfoToModelMap() {
        ModelInfo minfo = this.createNewModelMap("movestep_m");
        this.modelMap.put("movestep_m", minfo);
        SortedMap<String, String> modelInfoMap = minfo.getModelInfoMap();
        modelInfoMap.put("model/@id", "movestep_m");
        modelInfoMap.put("model/@type", "master");
    }

    public MessageListener getMessageListener() {
        return this.messageListener_;
    }

    @Override
    public void createRowMap() {
        this.rowMap.clear();
        this.rowMap = new TreeMap<Integer, Map<Integer, String>>();
    }

    @Override
    public void setElement(String elem, int colcnt, int rowcnt) {
        if (StringUtils.isBlank((CharSequence)elem)) {
            return;
        }
        Map<Integer, String> colMap = this.rowMap.get(rowcnt);
        if (colMap == null) {
            colMap = new TreeMap<Integer, String>();
            this.rowMap.put(rowcnt, colMap);
        }
        colMap.put(colcnt, elem);
        if (debug) {
            System.out.println(">> col:" + colcnt + " row:" + rowcnt + " " + elem);
        }
    }

    @Override
    public String createRelationMap() {
        ModelInfo minfo;
        if (debug) {
            System.out.println("** createRelationMap");
        }
        String modelname = null;
        String modelitemname = null;
        String type = null;
        String version = null;
        Map<Integer, String> colMap = this.rowMap.get(1);
        if (colMap == null) {
            return null;
        }
        for (Map.Entry<Integer, String> entry : colMap.entrySet()) {
            int col_num = entry.getKey();
            if (col_num == 2) {
                modelname = entry.getValue();
                continue;
            }
            if (col_num == 3) {
                modelitemname = entry.getValue();
                continue;
            }
            if (col_num == 6) {
                type = entry.getValue();
                continue;
            }
            if (col_num != 7) continue;
            version = entry.getValue();
        }
        if (!"repository".equals(type)) {
            return null;
        }
        if (modelname == null) {
            for (Map map : this.rowMap.values()) {
                this.createRelationMap4Project(map);
            }
            return null;
        }
        if (debug) {
            System.out.println("** modelname=" + modelname + ", modelitemname=" + modelitemname + ", type=" + type);
        }
        if (!this.modelVersionMap.containsKey(modelname)) {
            this.modelVersionMap.put(modelname, version);
        }
        if ((minfo = this.modelMap.get(modelname)) == null) {
            minfo = this.createNewModelMap(modelname);
        }
        this.tempLineMap = new HashMap();
        for (Map<Integer, String> _colMap : this.rowMap.values()) {
            this.createRelationMap4Model(_colMap, minfo, modelname);
        }
        this.buildTempLineMapIntoModelMap(modelname);
        return modelname;
    }

    private void createRelationMap4Project(Map<Integer, String> colMap) {
        String prjkey = null;
        String[] valueArray = new String[6];
        for (Map.Entry<Integer, String> col : colMap.entrySet()) {
            int col_num = col.getKey();
            String cell_value = col.getValue();
            if (cell_value != null && cell_value.startsWith("'")) {
                cell_value = cell_value.substring(1);
            }
            if (col_num == 1) {
                if (StringUtils.isNotBlank((CharSequence)cell_value)) {
                    prjkey = cell_value;
                }
            } else if (col_num != 2 && col_num <= 8) {
                valueArray[col_num - 3] = cell_value;
            }
            if (prjkey == null) continue;
            this.putValueArray(prjkey, valueArray, this.projectMap);
        }
        if (debug) {
            System.out.println("projectMap:" + this.projectMap);
        }
    }

    private void createRelationMap4Model(Map<Integer, String> colMap, ModelInfo minfo, String modelname) {
        block26: {
            Map<Object, String> map;
            String type;
            String[] valueArray;
            String column2;
            String key;
            block28: {
                block30: {
                    block29: {
                        block27: {
                            block25: {
                                key = null;
                                column2 = null;
                                valueArray = new String[5];
                                type = null;
                                for (Map.Entry<Integer, String> col : colMap.entrySet()) {
                                    int col_num = col.getKey();
                                    String cell_value = col.getValue();
                                    if (cell_value != null && cell_value.startsWith("'")) {
                                        cell_value = cell_value.substring(1);
                                    }
                                    if (col_num == 1) {
                                        if (!StringUtils.isNotBlank((CharSequence)cell_value)) continue;
                                        key = cell_value;
                                        continue;
                                    }
                                    if (col_num == 2) {
                                        column2 = cell_value;
                                        continue;
                                    }
                                    if (col_num <= 7) {
                                        valueArray[col_num - 3] = cell_value;
                                        continue;
                                    }
                                    if (col_num != 8) continue;
                                    type = cell_value;
                                }
                                if (key == null) {
                                    return;
                                }
                                if (column2 != null && !"main".equals(type)) break block25;
                                this.putValueArray(key, valueArray, minfo.getModelInfoMap());
                                break block26;
                            }
                            if (!"layout".equals(type)) break block27;
                            assert (NumberUtils.isCreatable(column2)) : "Model " + modelname + ", Invalid line number of repository in layout definition. (Not number) key : " + key + ", values : " + Arrays.asList(valueArray);
                            map = minfo.getLayoutInfoMap().get(Integer.valueOf(column2));
                            if (map == null) {
                                map = new HashMap<String, String>();
                                minfo.getLayoutInfoMap().put(Integer.valueOf(column2), map);
                            }
                            this.putValueArray(key, valueArray, map);
                            break block26;
                        }
                        if (!"acl".equals(type) && !"acl-minimal".equals(type)) break block28;
                        if (!"acl/permission/@value".equals(key)) break block29;
                        map = minfo.getAclMappingInfoMap();
                        if (valueArray[0] == null) break block26;
                        map.put(column2, valueArray[0]);
                        break block26;
                    }
                    if (!key.startsWith("acl/principal/")) break block30;
                    assert (NumberUtils.isCreatable((String)column2)) : "Model " + modelname + ", Invalid line number of repository in auth principal definition. (Not number) key : " + key + ", values : " + Arrays.asList(valueArray);
                    map = minfo.getPrincipalInfoMap().get(Integer.valueOf(column2));
                    if (map == null) {
                        map = new HashMap<String, String>();
                        minfo.getPrincipalInfoMap().put(Integer.valueOf(column2), map);
                    }
                    this.putValueArray(key, valueArray, map);
                    break block26;
                }
                if (!key.startsWith("acl/permission/")) break block26;
                assert (NumberUtils.isCreatable((String)column2)) : "Model " + modelname + ", Invalid line number of repository in auth permission definition. (Not number) key : " + key + ", values : " + Arrays.asList(valueArray);
                map = minfo.getPermissionInfoMap().get(Integer.valueOf(column2));
                if (map == null) {
                    map = new HashMap<String, String>();
                    minfo.getPermissionInfoMap().put(Integer.valueOf(column2), map);
                }
                this.putValueArray(key, valueArray, map);
                break block26;
            }
            if ("model".equals(type)) {
                assert (NumberUtils.isCreatable((String)column2)) : "Model " + modelname + ", Invalid line number of repository in model definition. (Not number) key : " + key + ", values : " + Arrays.asList(valueArray);
                this.putValueArray(key, valueArray, this.getTempLineMap(column2));
            } else if ("master".equals(type)) {
                Map<ModelitemInfo, String> itemMap = this.modelMap.get(modelname).getModelitemInfoMap();
                if (itemMap.get(new ModelitemInfo("model/modelitem/@__linenumber", column2)) == null) {
                    itemMap.put(new ModelitemInfo("model/modelitem/@__linenumber", column2), column2);
                }
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] == null && i > 0) continue;
                    Object _key = key;
                    if (i > 0) {
                        _key = (String)_key + "_" + (i + 1);
                    }
                    itemMap.put(new ModelitemInfo((String)_key, column2), valueArray[i]);
                }
            } else {
                assert (column2 != null) : "Model " + modelname + ", No item name info of repository. key : " + key + ", values : " + Arrays.asList(valueArray);
                map = minfo.getModelitemInfoMap();
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] == null && i > 0) continue;
                    Object _key = key;
                    if (i > 0) {
                        _key = (String)_key + "_" + (i + 1);
                    }
                    ModelitemInfo mikey = new ModelitemInfo((String)_key, column2);
                    if ("ref_model/modelitem/@name".equals(key) && map.containsKey(mikey)) {
                        List<String> list = this.zombieItemMap.get(modelname);
                        if (list == null) {
                            list = new ArrayList<String>();
                            this.zombieItemMap.put(modelname, list);
                        }
                        list.add(column2);
                    }
                    map.put(mikey, valueArray[i]);
                }
            }
        }
    }

    private void putValueArray(String key, String[] valueArray, Map<String, String> map) {
        for (int i = 0; i < valueArray.length; ++i) {
            if (valueArray[i] == null && i > 0) continue;
            Object _key = key;
            if (i > 0) {
                _key = (String)_key + "_" + (i + 1);
            }
            map.put((String)_key, valueArray[i]);
        }
    }

    private void buildTempLineMapIntoModelMap(String modelname) {
        Map<ModelitemInfo, String> itemMap = this.modelMap.get(modelname).getModelitemInfoMap();
        for (String line_num : this.tempLineMap.keySet()) {
            Map<String, String> map = this.tempLineMap.get(line_num);
            String mitem_name = map.get("model/modelitem/@name");
            if (mitem_name == null) continue;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                itemMap.put(new ModelitemInfo(entry.getKey(), mitem_name), entry.getValue());
            }
            itemMap.put(new ModelitemInfo("model/modelitem/@__linenumber", mitem_name), line_num);
        }
        this.tempLineMap.clear();
        this.tempLineMap = null;
    }

    private Map<String, String> getTempLineMap(String column2) {
        Map<String, String> map = this.tempLineMap.get(column2);
        if (map == null) {
            map = new HashMap<String, String>();
            this.tempLineMap.put(column2, map);
        }
        return map;
    }

    private ModelInfo createNewModelMap(String id_) {
        ModelInfo minfo = new ModelInfo(id_);
        this.modelMap.put(id_, minfo);
        return minfo;
    }

    @Override
    public void postProcess(Set<String> modelIdSet, String filename) {
        this.postProcessModelMap(modelIdSet, filename);
        if (this.domainId == null) {
            this.cacheFileManager_.saveProjectMap(this.projectMap);
        } else {
            this.cacheFileManager_.saveProjectMap(this.projectMap, this.domainId);
        }
        this.cacheFileManager_.saveModelMap(this.modelMap, modelIdSet);
        this.cacheFileManager_.saveModelVersionMap(this.modelVersionMap);
        this.modelMap.remove("jfcDesignerTemplateCollection");
        this.modelMap.remove("jfcDesignerTemplateModel");
        this.modelMap.remove("jfcDesignerTemplateModelitem");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem1");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem2");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem3");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem4");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem5");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem6");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem7");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem8");
        this.modelMap.remove("jfcDesignerUserTemplateModelitem9");
        this.modelMap.remove("jfcDesignerTemplateInsertUpdateInfo");
        this.modelMap.remove("jfcDesignerTemplateGmapPointTemplate");
        this.modelMap.remove("jfcDesignerTemplateWfEventHistory");
        if (debug) {
            System.out.println("** postProcess, file:" + filename + " contains " + modelIdSet);
        }
    }

    private void postProcessModelMap(Set<String> modelIdSet, String filename) {
        for (String modelId : modelIdSet) {
            ModelInfo minfo = this.modelMap.get(modelId);
            String[] modelInfoMap = minfo.getModelInfoMap();
            modelInfoMap.put((String)"model/@srcfilename", (String)filename);
            minfo.postProcess();
        }
        for (String modelId : modelIdSet) {
            ArrayList<String> removeList = new ArrayList<String>();
            for (String itemname : this.getModelitemNames(modelId)) {
                if (!StringUtils.isBlank((CharSequence)this.getModelitemValue(modelId, itemname, "model/modelitem/@__linenumber"))) continue;
                removeList.add(itemname);
            }
            if (removeList.size() <= 0) continue;
            this.log.warn("CAUTION: Unexisted items " + removeList + " is found in model " + modelId);
            ModelInfo minfo = this.modelMap.get(modelId);
            Map<ModelitemInfo, String> itemMap = minfo.getModelitemInfoMap();
            for (String itemname : removeList) {
                for (String key : this.getKeysByModelitemName(modelId, itemname)) {
                    itemMap.remove(new ModelitemInfo(key, itemname));
                }
            }
            this.clearCacheByModelId(modelId);
        }
    }

    @Override
    public String getProjectValue(String key) {
        return this.projectMap.get(key);
    }

    @Override
    public Map<String, String> getProjectRepositoryAsMap() {
        return Collections.unmodifiableMap(this.projectMap);
    }

    @Override
    public String getWagbyDefFileVersion(String modelname) {
        return this.modelVersionMap.get(modelname);
    }

    @Override
    public String[] getAllStoreModelId() {
        return this.getAllModelIdByType("model");
    }

    @Override
    public String[] getAllMasterModelId() {
        return this.getAllModelIdByType("master");
    }

    @Override
    public boolean existsModel(String id) {
        return this.modelMap.containsKey(id);
    }

    private String[] getAllModelIdByType(String mtype) {
        if (this.cachedAllModelIdMap != null) {
            String[] cached = this.cachedAllModelIdMap.get(mtype);
            if (cached != null) {
                return cached;
            }
        } else {
            this.cachedAllModelIdMap = new HashMap<String, String[]>();
        }
        boolean isSelectBuildTarget = false;
        Set<Object> set = new HashSet();
        for (String modelId : this.modelMap.keySet()) {
            ModelInfo minfo = this.modelMap.get(modelId);
            String string = (String)minfo.getModelInfoMap().get("model/@type");
            if (!mtype.equals(string)) continue;
            if (!minfo.getModelInfoMap().containsKey("model/@build")) {
                set.add(modelId);
                continue;
            }
            String isBuild = (String)minfo.getModelInfoMap().get("model/@build");
            if (this.ropt.getValue("r.selector").equals(isBuild) || RepositoryUtil.isSystemModel(modelId)) {
                set.add(modelId);
                continue;
            }
            isSelectBuildTarget = true;
            this.log.info("model/@build is false, " + modelId);
        }
        if (isSelectBuildTarget) {
            if (this.needsCheckRelatedModelSet) {
                if ("model".equals(mtype)) {
                    this.log.info("Scanning model relationship...");
                }
                HashSet<String> set2 = new HashSet<String>();
                for (String string : set) {
                    if (!RepositoryUtil.isSystemModel(string)) {
                        this.log.info("add build target '" + string + "'");
                    }
                    set2.add(string);
                    this.getRelatedModelSet(string, set2);
                }
                set = set2;
                _oldset = set.stream().collect(Collectors.toSet());
            } else if (_oldset != null) {
                set = _oldset.stream().collect(Collectors.toSet());
                if ("model".equals(mtype)) {
                    this.log.info("use previous build set information.");
                }
            }
        }
        String[] ret = set.toArray(new String[0]);
        if ("model".equals(mtype)) {
            this.log.info("The number of target models is " + ret.length);
        }
        this.cachedAllModelIdMap.put(mtype, ret);
        return ret;
    }

    private void getRelatedModelSet(String modelId, Set<String> set) {
        Map<ModelitemInfo, String> itemInfoMap;
        ModelInfo minfo = this.modelMap.get(modelId);
        String mainmodelid = (String)minfo.getModelInfoMap().get("model/@mainmodelidref");
        if (StringUtils.isNotBlank((CharSequence)mainmodelid) && !set.contains(mainmodelid)) {
            Iterator<ModelitemInfo> type;
            ModelInfo minfo2 = this.modelMap.get(mainmodelid);
            Iterator<ModelitemInfo> iterator = type = minfo2 != null ? (String)minfo2.getModelInfoMap().get("model/@type") : null;
            if ("model".equals(type)) {
                set.add(mainmodelid);
                if (!RepositoryUtil.isSystemModel(mainmodelid)) {
                    this.log.info("add mainmodel '" + mainmodelid + "' in model " + modelId);
                }
                this.getRelatedModelSet(mainmodelid, set);
            }
        }
        if ((itemInfoMap = minfo.getModelitemInfoMap()) == null) {
            return;
        }
        for (ModelitemInfo mitem : itemInfoMap.keySet()) {
            ModelInfo minfo2;
            String type;
            String key = mitem.getKey();
            if (!relatedKeySet.contains(key)) continue;
            String value = itemInfoMap.get(mitem);
            if ("model/modelitem/autocalc_2".equals(key)) {
                BStoreModelitem_autocalc.Varlist varlist = BStoreModelitem_autocalc.createVarlist(value);
                for (String s : varlist.list) {
                    String f_modelId = null;
                    if (s.endsWith("_lp")) {
                        f_modelId = s.substring(0, s.length() - "_lp".length());
                    }
                    if (s.indexOf("_lp.") > 0) {
                        int ptr = s.indexOf("_lp.");
                        f_modelId = s.substring(0, ptr);
                    }
                    if (f_modelId == null) continue;
                    value = f_modelId;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)value) || set.contains(value) || !"model".equals(type = (minfo2 = this.modelMap.get(value)) != null ? (String)minfo2.getModelInfoMap().get("model/@type") : null)) continue;
            if (!RepositoryUtil.isSystemModel(value)) {
                this.log.info("add related model '" + value + "' in " + modelId + "." + mitem.getModelitemName());
            }
            set.add(value);
            this.getRelatedModelSet(value, set);
        }
        for (String _modelId : this.modelMap.keySet()) {
            String _build;
            ModelInfo _minfo = this.modelMap.get(_modelId);
            String _mainmodelid = _minfo != null ? (String)_minfo.getModelInfoMap().get("model/@mainmodelidref") : null;
            String string = _build = _minfo != null ? (String)_minfo.getModelInfoMap().get("model/@build") : null;
            if (modelId.equals(_mainmodelid) && "true".equals(_build) && !set.contains(_modelId)) {
                set.add(_modelId);
                this.getRelatedModelSet(_modelId, set);
            }
            Map<ModelitemInfo, String> _itemInfoMap = _minfo.getModelitemInfoMap();
            if (itemInfoMap == null) continue;
            for (ModelitemInfo _mitem : _itemInfoMap.keySet()) {
                String _value;
                String _key = _mitem.getKey();
                if (!"model/modelitem/@outsideKey".equals(_key) || !StringUtils.isNotBlank((CharSequence)(_value = _itemInfoMap.get(_mitem))) || !modelId.equals(_value)) continue;
                if (!_modelId.startsWith("jfc")) {
                    this.log.info("add foreign model '" + _modelId + "' to '" + modelId + "'");
                }
                set.add(_modelId);
                this.getRelatedModelSet(_modelId, set);
            }
        }
    }

    SortedMap<String, String> getModelInfoMap(String modelId) {
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        return minfo.getModelInfoMap();
    }

    @Override
    public File getInitialDataSaveDir(String modelId) {
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        return minfo.getInitialDataSaveDir();
    }

    @Override
    public boolean existsKeyInProject(String key) {
        return this.projectMap.containsKey(key);
    }

    @Override
    public boolean existsKeyInModel(String modelId, String key) {
        assert (StringUtils.isNotBlank((CharSequence)key)) : "You must set the key," + key;
        if (this.menuMap != null && key != null && (key.startsWith("model/@menu") || key.startsWith("action/@menu"))) {
            return this.menuMap.containsKey(modelId + "/" + key);
        }
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return false;
        }
        return minfo.existsKeyInModel(modelId, key);
    }

    @Override
    public String getModelValue(String modelId, String key) {
        if (this.menuMap != null && key != null && (key.startsWith("model/@menu") || key.startsWith("action/@menu"))) {
            return this.menuMap.get(modelId + "/" + key);
        }
        SortedMap<String, String> map = this.getModelInfoMap(modelId);
        assert (StringUtils.isNotBlank((CharSequence)key)) : "You must set the key," + key;
        if (map == null) {
            return null;
        }
        return (String)map.get(key);
    }

    @Override
    public String[] getKeysByModel(String modelId) {
        SortedMap<String, String> map = this.getModelInfoMap(modelId);
        if (map == null) {
            return new String[0];
        }
        return map.keySet().toArray(new String[0]);
    }

    @Override
    public String[] getKeysByModelAndKeyPrefix(String modelId, String keyprefix) {
        if (StringUtils.isBlank((CharSequence)keyprefix)) {
            return this.getKeysByModel(modelId);
        }
        SortedMap<String, String> map = this.getModelInfoMap(modelId);
        if (map == null) {
            return new String[0];
        }
        SortedMap<String, String> submap = map.subMap(keyprefix, WagbyR6DefElementContainer.createToKey(keyprefix));
        if (submap == null || submap.size() == 0) {
            return new String[0];
        }
        return submap.keySet().toArray(new String[0]);
    }

    static String createToKey(String fromKey) {
        if (fromKey == null) {
            return null;
        }
        char c = fromKey.charAt(fromKey.length() - 1);
        StringBuilder toKey = new StringBuilder();
        toKey.append(fromKey.substring(0, fromKey.length() - 1));
        toKey.append(Character.valueOf((char)(c + '\u0001')));
        return toKey.toString();
    }

    private Map<String, Map<String, String>> getCachedLineBaseMap(String modelId, CacheType type) {
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        Map<String, Map<String, String>> _map = null;
        if (type == CacheType.Layout) {
            _map = this.cachedLayoutInfoLabelBaseMap.get(modelId);
        } else if (type == CacheType.Principal) {
            _map = this.cachedPrincipalInfoPrincipalIdBaseMap.get(modelId);
        } else if (type == CacheType.Permission) {
            _map = this.cachedPermissionInfoPermissionActionBaseMap.get(modelId);
        }
        if (_map != null) {
            return _map;
        }
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        Map<Integer, Map<String, String>> layoutAclMap = null;
        if (type == CacheType.Layout) {
            layoutAclMap = minfo.getLayoutInfoMap();
        } else if (type == CacheType.Principal) {
            layoutAclMap = minfo.getPrincipalInfoMap();
        } else if (type == CacheType.Permission) {
            layoutAclMap = minfo.getPermissionInfoMap();
        }
        if (layoutAclMap == null) {
            return null;
        }
        LinkedHashMap<String, Map<String, String>> cachedMap = new LinkedHashMap<String, Map<String, String>>();
        for (Integer line_num : layoutAclMap.keySet()) {
            Map<String, String> map = layoutAclMap.get(line_num);
            String mapKey = null;
            if (type == CacheType.Layout) {
                mapKey = map.get("model/displayitemgroup/@label");
                map.put("model/displayitemgroup/@__linenumber", line_num.toString());
            } else if (type == CacheType.Principal) {
                mapKey = map.get("acl/principal/@id");
                map.put("acl/principal/@__linenumber", line_num.toString());
            } else if (type == CacheType.Permission) {
                mapKey = map.get("acl/permission/@action");
                map.put("acl/permission/@__linenumber", line_num.toString());
            }
            cachedMap.put(mapKey, map);
        }
        if (type == CacheType.Layout) {
            this.cachedLayoutInfoLabelBaseMap.put(modelId, cachedMap);
        } else if (type == CacheType.Principal) {
            this.cachedPrincipalInfoPrincipalIdBaseMap.put(modelId, cachedMap);
        } else if (type == CacheType.Permission) {
            this.cachedPermissionInfoPermissionActionBaseMap.put(modelId, cachedMap);
        }
        return cachedMap;
    }

    private String[] getNamesFromLineBaseMap(String modelId, CacheType type) {
        Map<String, Map<String, String>> map = this.getCachedLineBaseMap(modelId, type);
        if (map == null) {
            return new String[0];
        }
        return map.keySet().toArray(new String[0]);
    }

    private String[] getKeysByName(String modelId, String label, CacheType type) {
        Map<String, Map<String, String>> map = this.getCachedLineBaseMap(modelId, type);
        if (map == null) {
            return new String[0];
        }
        Map<String, String> layoutMap = map.get(label);
        if (layoutMap == null) {
            return new String[0];
        }
        return layoutMap.keySet().toArray(new String[0]);
    }

    private String getLineBaseMapValue(String modelId, String label, String key, CacheType type) {
        Map<String, Map<String, String>> map = this.getCachedLineBaseMap(modelId, type);
        if (map == null) {
            return null;
        }
        assert (StringUtils.isNotBlank((CharSequence)label)) : "You must set the 2nd parameter," + label;
        assert (StringUtils.isNotBlank((CharSequence)key)) : "You must set the repository key, " + key;
        Map<String, String> layoutMap = map.get(label);
        if (layoutMap == null) {
            for (String s : map.keySet()) {
                String prefix;
                int ptr = s.indexOf(":");
                if (ptr <= 0 || !(prefix = s.substring(0, ptr) + "]").equals(label)) continue;
                layoutMap = map.get(s);
                return layoutMap != null ? layoutMap.get(key) : null;
            }
            return null;
        }
        return layoutMap.get(key);
    }

    @Override
    public String[] getLayoutLabels(String modelId) {
        return this.getNamesFromLineBaseMap(modelId, CacheType.Layout);
    }

    @Override
    public String[] getKeysByLayoutLabel(String modelId, String label) {
        return this.getKeysByName(modelId, label, CacheType.Layout);
    }

    @Override
    public String getLayoutValue(String modelId, String label, String key) {
        return this.getLineBaseMapValue(modelId, label, key, CacheType.Layout);
    }

    public Map<Integer, AuthorityPrincipal> getAuthorityPrincipalInfoMap() {
        return this.authorityPrincipalInfoMap;
    }

    public Map<Integer, AuthorityPrincipalCategory> getAuthorityPrincipalCategoryMap() {
        return this.authorityPrincipalCategoryMap;
    }

    @Override
    public String[] getPrincipals(String modelId) {
        return this.getNamesFromLineBaseMap(modelId, CacheType.Principal);
    }

    @Override
    public String[] getKeysByPrincipal(String modelId, String principal) {
        return this.getKeysByName(modelId, principal, CacheType.Principal);
    }

    @Override
    public String getPrincipalValue(String modelId, String principal, String key) {
        return this.getLineBaseMapValue(modelId, principal, key, CacheType.Principal);
    }

    @Override
    public String[] getPermissions(String modelId) {
        return this.getNamesFromLineBaseMap(modelId, CacheType.Permission);
    }

    @Override
    public String[] getKeysByPermission(String modelId, String permission) {
        return this.getKeysByName(modelId, permission, CacheType.Principal);
    }

    @Override
    public String getPermissionValue(String modelId, String permission, String key) {
        return this.getLineBaseMapValue(modelId, permission, key, CacheType.Permission);
    }

    private Map<String, List<String>> getCachedAclMappingInfPrincipalIdBaseMap(String modelId) {
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        Map<String, List<String>> map = this.cachedAclMappingInfPrincipalIdBaseMap.get(modelId);
        if (map != null) {
            return map;
        }
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        Map<String, String> aclMap = minfo.getAclMappingInfoMap();
        if (aclMap == null) {
            return null;
        }
        HashMap<String, List<String>> cachedAclMap = new HashMap<String, List<String>>();
        for (String mapping : aclMap.keySet()) {
            String permission;
            String principal;
            if (!Utils.isSelectedValue(aclMap.get(mapping))) continue;
            String[] points = mapping.split(",");
            if (points == null || points.length != 2 || StringUtils.isBlank((CharSequence)points[0]) || StringUtils.isBlank((CharSequence)points[1])) {
                assert (false) : "Invalid acl/permission/@value.modelId=" + modelId + " , acl/permission/@value=" + mapping;
                continue;
            }
            Integer pcpl_line = Integer.valueOf(points[0]);
            Map<String, String> pcpl_map = minfo.getPrincipalInfoMap().get(pcpl_line);
            if (pcpl_map == null || StringUtils.isBlank((CharSequence)(principal = pcpl_map.get("acl/principal/@id")))) continue;
            Integer perm_line = Integer.valueOf(points[1]);
            Map<String, String> perm_map = minfo.getPermissionInfoMap().get(perm_line);
            if (perm_map == null || StringUtils.isBlank((CharSequence)(permission = perm_map.get("acl/permission/@action")))) continue;
            ArrayList<String> perm_list = (ArrayList<String>)cachedAclMap.get(principal);
            if (perm_list == null) {
                perm_list = new ArrayList<String>();
                cachedAclMap.put(principal, perm_list);
            }
            perm_list.add(permission);
        }
        this.cachedAclMappingInfPrincipalIdBaseMap.put(modelId, cachedAclMap);
        return cachedAclMap;
    }

    @Override
    public String[] getPermissionsByPrincipal(String modelId, String principalId) {
        Map<String, List<String>> map = this.getCachedAclMappingInfPrincipalIdBaseMap(modelId);
        if (map == null) {
            return new String[0];
        }
        assert (StringUtils.isNotBlank((CharSequence)principalId)) : "You must set the principal ID," + principalId;
        List<String> list = map.get(principalId);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getModelitemNames(String modelId) {
        String[] ret = this.cachedModelitemNameMap.get(modelId);
        if (ret != null) {
            return ret;
        }
        TreeMap<ModelitemInfo, String> map = this.getModelitemInfoMap(modelId, true);
        if (map == null || map.size() == 0) {
            return new String[0];
        }
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        TreeSet<ModelitemInfo> set = new TreeSet<ModelitemInfo>(new ModelitemInfoNameOnlyComparator(modelId, this));
        set.addAll(map.keySet());
        ArrayList<String> list = new ArrayList<String>();
        for (ModelitemInfo iteminfo : set) {
            list.add(iteminfo.getModelitemName());
        }
        ret = list.toArray(new String[0]);
        this.cachedModelitemNameMap.put(modelId, ret);
        return ret;
    }

    private TreeMap<ModelitemInfo, String> getModelitemInfoMap(String modelId, boolean isNameBase) {
        TreeMap<ModelitemInfo, String> map;
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        Map<ModelitemInfo, String> itemInfoMap = minfo.getModelitemInfoMap();
        if (itemInfoMap == null) {
            return null;
        }
        TreeMap<ModelitemInfo, String> treeMap = map = isNameBase ? this.cachedModelitemInfoNameBaseMap.get(modelId) : this.cachedModelitemInfoKeyBaseMap.get(modelId);
        if (map == null) {
            Comparator<ModelitemInfo> comparator = isNameBase ? new ModelitemInfoNameBaseComparator(modelId, this) : new ModelitemInfoKeyBaseComparator(modelId, this);
            map = new TreeMap(comparator);
            map.putAll(itemInfoMap);
            if (isNameBase) {
                this.cachedModelitemInfoNameBaseMap.put(modelId, map);
            } else {
                this.cachedModelitemInfoKeyBaseMap.put(modelId, map);
            }
        }
        return map;
    }

    private TreeMap<ModelitemInfo, String> getModelitemInfoNameBaseMap(String modelId) {
        return this.getModelitemInfoMap(modelId, true);
    }

    private TreeMap<ModelitemInfo, String> getModelitemInfoKeyBaseMap(String modelId) {
        return this.getModelitemInfoMap(modelId, false);
    }

    private String[] getModelitemNamesByKeyRange(String modelId, String fromKey, String toKey) {
        TreeMap<ModelitemInfo, String> map = this.getModelitemInfoKeyBaseMap(modelId);
        if (map == null) {
            return new String[0];
        }
        assert (StringUtils.isNotBlank((CharSequence)fromKey)) : "You must set th repository key," + fromKey;
        SortedMap<ModelitemInfo, String> submap = map.subMap(new ModelitemInfo(fromKey, String.valueOf('\u0000')), new ModelitemInfo(toKey, String.valueOf('\u0000')));
        if (submap == null || submap.size() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ModelitemInfo iteminfo : submap.keySet()) {
            list.add(iteminfo.getModelitemName());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getModelitemNamesByKey(String modelId, String key) {
        return this.getModelitemNamesByKeyRange(modelId, key, key + String.valueOf('\u0000'));
    }

    @Override
    public String[] getModelitemNamesByKeyPrefix(String modelId, String keyprefix) {
        return this.getModelitemNamesByKeyRange(modelId, keyprefix, WagbyR6DefElementContainer.createToKey(keyprefix));
    }

    String[] getKeyRangeByModelitemName(String modelId, String itemname, String toKey, String fromKey) {
        TreeMap<ModelitemInfo, String> map = this.getModelitemInfoNameBaseMap(modelId);
        if (map == null) {
            return new String[0];
        }
        assert (StringUtils.isNotBlank((CharSequence)itemname)) : "You must set the item name," + itemname;
        SortedMap<ModelitemInfo, String> submap = map.subMap(new ModelitemInfo(toKey, itemname), new ModelitemInfo(fromKey, itemname));
        if (submap == null || submap.size() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ModelitemInfo iteminfo : submap.keySet()) {
            list.add(iteminfo.getKey());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getKeysByModelitemName(String modelId, String itemname) {
        return this.getKeyRangeByModelitemName(modelId, itemname, String.valueOf('\u0000'), String.valueOf('\uffff'));
    }

    @Override
    public String[] getKeysByModelitemNameAndKeyPrefix(String modelId, String itemname, String keyprefix) {
        return this.getKeyRangeByModelitemName(modelId, itemname, keyprefix, WagbyR6DefElementContainer.createToKey(keyprefix));
    }

    @Override
    public boolean existsKeyInModelitem(String modelId, String itemname, String key) {
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        assert (StringUtils.isNotBlank((CharSequence)itemname)) : "You must set the item name," + itemname;
        assert (StringUtils.isNotBlank((CharSequence)key)) : "You must set the repository key," + key;
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return false;
        }
        return minfo.existsKeyInModelitem(modelId, itemname, key);
    }

    @Override
    public String getModelitemValue(String modelId, String itemname, String key) {
        assert (StringUtils.isNotBlank((CharSequence)modelId)) : "You must set the modelId," + modelId;
        assert (StringUtils.isNotBlank((CharSequence)itemname)) : "You must set the item name," + itemname;
        assert (StringUtils.isNotBlank((CharSequence)key)) : "You must set the repository key," + key;
        ModelInfo minfo = this.modelMap.get(modelId);
        if (minfo == null) {
            return null;
        }
        Map<ModelitemInfo, String> map = minfo.getModelitemInfoMap();
        if (map == null) {
            return null;
        }
        return map.get(new ModelitemInfo(key, itemname));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.modelMap);
        return sb.toString();
    }

    @Override
    public boolean checkError() {
        boolean hasErrorFlag = false;
        if (this.checkError_existZombieItem()) {
            hasErrorFlag = true;
        }
        return hasErrorFlag;
    }

    private boolean checkError_existZombieItem() {
        boolean hasErrorFlag = this.zombieItemMap.size() > 0;
        for (Map.Entry<String, List<String>> e : this.zombieItemMap.entrySet()) {
            String modelname = e.getKey();
            for (String value : e.getValue()) {
                this.getMessageListener().error(this.rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefElementContainer.checkError_existZombieItem", new Object[]{modelname, value}));
            }
        }
        return hasErrorFlag;
    }

    @Override
    public void removeModelId(String modelId) {
        this.modelMap.remove(modelId);
        this.modelVersionMap.remove(modelId);
    }

    @Override
    public void setUserRule(TreeMap<String, TreeMap<String, Set<String>>> udMap, Map<String, Map<String, String>> udRuleMap) {
        if (udMap == null || udMap.size() == 0) {
            return;
        }
        for (String ruleId : udMap.keySet()) {
            Map targets = udMap.get(ruleId);
            for (String modelId : targets.keySet()) {
                Map<ModelitemInfo, String> itemInfoMap;
                ModelInfo minfo;
                Set items = (Set)targets.get(modelId);
                Map<String, String> rules = udRuleMap.get(ruleId);
                if (rules == null || rules.isEmpty() || (minfo = this.modelMap.get(modelId)) == null || (itemInfoMap = minfo.getModelitemInfoMap()) == null) continue;
                HashMap<ModelitemInfo, String> n_itemInfoMap = null;
                HashSet<String> processedRules = null;
                for (ModelitemInfo mitem : itemInfoMap.keySet()) {
                    for (String targetmodelitem : items) {
                        if (!mitem.getModelitemName().equals(targetmodelitem)) continue;
                        for (Map.Entry<String, String> entry : rules.entrySet()) {
                            String itemRuleValue;
                            ModelitemInfo n_mitem;
                            if (StringUtils.isBlank((CharSequence)entry.getKey())) continue;
                            if (mitem.getKey().equals(entry.getKey())) {
                                n_mitem = new ModelitemInfo(entry.getKey(), mitem.getModelitemName());
                                itemRuleValue = this.getUserRuleValue(itemInfoMap, n_mitem, modelId, entry.getKey(), entry.getValue());
                                if (n_itemInfoMap == null) {
                                    n_itemInfoMap = new HashMap<ModelitemInfo, String>();
                                }
                                n_itemInfoMap.put(n_mitem, itemRuleValue);
                                if (processedRules == null) {
                                    processedRules = new HashSet<String>();
                                }
                                processedRules.add(entry.getKey());
                            }
                            if (processedRules != null && processedRules.contains(entry.getKey())) continue;
                            n_mitem = new ModelitemInfo(entry.getKey(), mitem.getModelitemName());
                            itemRuleValue = this.getUserRuleValue(itemInfoMap, n_mitem, modelId, entry.getKey(), entry.getValue());
                            if (n_itemInfoMap == null) {
                                n_itemInfoMap = new HashMap();
                            }
                            n_itemInfoMap.put(n_mitem, itemRuleValue);
                            if (processedRules == null) {
                                processedRules = new HashSet();
                            }
                            processedRules.add(entry.getKey());
                        }
                        processedRules = null;
                    }
                }
                if (n_itemInfoMap != null) {
                    itemInfoMap.putAll(n_itemInfoMap);
                }
                this.clearCacheByModelId(modelId);
            }
        }
    }

    private String getUserRuleValue(Map<ModelitemInfo, String> itemInfoMap, ModelitemInfo mitem, String modelId, String repositoryKey, String itemRuleValue) {
        if (!"model/modelitem/@label".equals(repositoryKey)) {
            return itemRuleValue;
        }
        String label = itemInfoMap.get(mitem);
        String labelWithoutLayout = this.getModelitemValue(modelId, mitem.getModelitemName(), "model/modelitem/@labelWithoutLayout");
        return StringUtils.replace((String)label, (String)labelWithoutLayout, (String)itemRuleValue);
    }

    public static void reset() {
        initProcessFlag = false;
    }

    public Map<Integer, Jfcdomain> getDomainMap() {
        return this.domainMap;
    }

    static {
        relatedKeys = new String[]{"model/modelitem/@outsideKey", "model/modelitem/relation/@idref", "model/modelitem/autocalc_2"};
        relatedKeySet = new HashSet<String>();
        Collections.addAll(relatedKeySet, relatedKeys);
    }

    static enum CacheType {
        Layout,
        Principal,
        Permission;

    }

    class ModelitemInfoNameOnlyComparator
    implements Comparator<ModelitemInfo> {
        private String modelId;
        private ElementContainer con;

        public ModelitemInfoNameOnlyComparator(String modelId, ElementContainer con) {
            this.modelId = modelId;
            this.con = con;
        }

        @Override
        public int compare(ModelitemInfo iteminfo1, ModelitemInfo iteminfo2) {
            String name2;
            String name1 = iteminfo1.getModelitemName();
            if (!name1.equals(name2 = iteminfo2.getModelitemName())) {
                String line_num1 = this.con.getModelitemValue(this.modelId, name1, "model/modelitem/@__linenumber");
                String line_num2 = this.con.getModelitemValue(this.modelId, name2, "model/modelitem/@__linenumber");
                int ret = NumberUtils.toInt((String)line_num1) - NumberUtils.toInt((String)line_num2);
                if (ret == 0) {
                    return name1.compareTo(name2);
                }
                return ret;
            }
            return 0;
        }
    }

    class ModelitemInfoNameBaseComparator
    implements Comparator<ModelitemInfo> {
        private String modelId;
        private ElementContainer con;

        public ModelitemInfoNameBaseComparator(String modelId, ElementContainer con) {
            this.modelId = modelId;
            this.con = con;
        }

        @Override
        public int compare(ModelitemInfo iteminfo1, ModelitemInfo iteminfo2) {
            String key2;
            String name2;
            String name1 = iteminfo1.getModelitemName();
            if (!name1.equals(name2 = iteminfo2.getModelitemName())) {
                String line_num1 = this.con.getModelitemValue(this.modelId, name1, "model/modelitem/@__linenumber");
                String line_num2 = this.con.getModelitemValue(this.modelId, name2, "model/modelitem/@__linenumber");
                int ret = NumberUtils.toInt((String)line_num1) - NumberUtils.toInt((String)line_num2);
                if (ret == 0) {
                    return name1.compareTo(name2);
                }
                return ret;
            }
            String key1 = iteminfo1.getKey();
            if (!key1.equals(key2 = iteminfo2.getKey())) {
                return key1.compareTo(key2);
            }
            return 0;
        }
    }

    class ModelitemInfoKeyBaseComparator
    implements Comparator<ModelitemInfo> {
        private String modelId;
        private ElementContainer con;

        public ModelitemInfoKeyBaseComparator(String modelId, ElementContainer con) {
            this.modelId = modelId;
            this.con = con;
        }

        @Override
        public int compare(ModelitemInfo iteminfo1, ModelitemInfo iteminfo2) {
            String name2;
            String key2;
            String key1 = iteminfo1.getKey();
            if (!key1.equals(key2 = iteminfo2.getKey())) {
                return key1.compareTo(key2);
            }
            String name1 = iteminfo1.getModelitemName();
            if (!name1.equals(name2 = iteminfo2.getModelitemName())) {
                String line_num1 = this.con.getModelitemValue(this.modelId, name1, "model/modelitem/@__linenumber");
                String line_num2 = this.con.getModelitemValue(this.modelId, name2, "model/modelitem/@__linenumber");
                int ret = NumberUtils.toInt((String)line_num1) - NumberUtils.toInt((String)line_num2);
                if (ret == 0) {
                    return name1.compareTo(name2);
                }
                return ret;
            }
            return 0;
        }
    }
}

