/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.appschema.Filteritem;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.tools.xls2appschema.CacheFileManager;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectFilterContainer;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectFilterContainer")
public class WagbyR6ProjectFilterContainer
implements ProjectFilterContainer {
    protected Logger log = LogManager.getLogger(WagbyR6ProjectFilterContainer.class);
    private static ResourceManager rman = ResourceManager.getInstance((String)"x2aj");
    private static boolean debug = false;
    private Map<Integer, Map<Integer, String>> rowMap = new TreeMap<Integer, Map<Integer, String>>();
    @Autowired(required=true)
    private CacheFileManager cacheFileManager_;
    private static boolean initProcessFlag = false;
    private Map<String, Filterlist> filterlistMap = new HashMap<String, Filterlist>();

    @Override
    public void init() {
    }

    @Override
    public void createRowMap() {
        this.rowMap.clear();
        this.rowMap = new TreeMap<Integer, Map<Integer, String>>();
    }

    @Override
    public void setElement(String elem, int colcnt, int rowcnt) {
        if (StringUtils.isBlank((CharSequence)elem)) {
            return;
        }
        Map<Integer, String> colMap = this.rowMap.get(rowcnt);
        if (colMap == null) {
            colMap = new TreeMap<Integer, String>();
            this.rowMap.put(rowcnt, colMap);
        }
        colMap.put(colcnt, elem);
    }

    @Override
    public void postProcess() {
        if (this.filterlistMap == null || this.filterlistMap.size() == 0) {
            return;
        }
        this.cacheFileManager_.saveProjectFilter(this.filterlistMap);
    }

    @Override
    public void process() {
        if (this.filterlistMap.size() > 0) {
            return;
        }
        Map<Integer, String> colMap = this.rowMap.get(1);
        if (colMap == null) {
            return;
        }
        String type = null;
        for (Map.Entry<Integer, String> entry : colMap.entrySet()) {
            int col_num = entry.getKey();
            if (col_num != 6) continue;
            type = entry.getValue();
        }
        if (!"filter".equals(type)) {
            return;
        }
        colMap = this.rowMap.get(2);
        if (colMap == null) {
            return;
        }
        int size = colMap.size();
        String[] elementTypeArray = new String[size - 1];
        for (Map.Entry<Integer, String> entry : colMap.entrySet()) {
            if (entry.getKey() == 1) continue;
            elementTypeArray[entry.getKey().intValue() - 2] = entry.getValue();
        }
        ArrayList<FilterDefinition> fdList = new ArrayList<FilterDefinition>();
        int startRow = 4;
        block2: while ((colMap = this.rowMap.get(startRow)) != null) {
            FilterDefinition fd = null;
            for (Map.Entry<Integer, String> entry : colMap.entrySet()) {
                if ("itemend".equals(entry.getValue())) break block2;
                if (fd == null) {
                    fd = new FilterDefinition(elementTypeArray.length);
                }
                if (entry.getKey() == 1) {
                    fd.id = this.getIdByName(entry.getValue());
                    continue;
                }
                fd.orders[entry.getKey().intValue() - 2] = StringUtil.intValue((String)entry.getValue());
            }
            fdList.add(fd);
            ++startRow;
        }
        for (FilterDefinition _fd : fdList) {
            Filterlist filterlist = this.createFilterlist(_fd.id);
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            for (int i = 0; i < _fd.orders.length; ++i) {
                int value = _fd.orders[i];
                if (value <= 0) continue;
                map.put(value, elementTypeArray[i]);
            }
            if (map.size() > 0) {
                for (String elementType : map.values()) {
                    filterlist.addFilteritem(this.createFilteritem(elementType));
                }
            }
            this.filterlistMap.put(filterlist.getId(), filterlist);
            if (!debug) continue;
            System.out.println(">>>> " + filterlist.getId() + ", " + filterlist);
        }
    }

    private Filterlist createFilterlist(String id) {
        Filterlist list = new Filterlist();
        list.setId(id);
        return list;
    }

    private String getIdByName(String s) {
        String ret = null;
        ret = rman.getValue("filter.type.commonfilter").equals(s) ? "commonfilter" : (rman.getValue("filter.type.minimalfilter.alt").equals(s) ? "minimalfilter" : (rman.getValue("filter.type.intfilter").equals(s) ? "intfilter" : (rman.getValue("filter.type.datefilter").equals(s) ? "datefilter" : (rman.getValue("filter.type.h2zfilter").equals(s) ? "h2zfilter" : (rman.getValue("filter.type.kanafilter").equals(s) ? "kanafilter" : (rman.getValue("filter.type.h2zspacefilter").equals(s) ? "h2zspacefilter" : (rman.getValue("filter.type.z2hfilter").equals(s) ? "z2hfilter" : (rman.getValue("filter.type.z2hspacefilter").equals(s) ? "z2hspacefilter" : (rman.getValue("filter.type.masterfilter").equals(s) ? "masterfilter" : s)))))))));
        return ret;
    }

    private Filteritem createFilteritem(String type) {
        Filteritem item = new Filteritem();
        if ("decodeXmlChar".equals(type)) {
            item.setType(type);
        } else if ("removeSpace".equals(type)) {
            item.setType(type);
            item.setContent("prepost");
        } else if ("crlf".equals(type)) {
            item.setType(type);
        } else if (type.startsWith("z2h-") || type.startsWith("h2z-") || type.startsWith("normalize-")) {
            int ptr = type.indexOf("-");
            item.setType(type.substring(0, ptr));
            item.setContent(type.substring(ptr + 1));
        }
        return item;
    }

    @Override
    public Filterlist getFilterlistById(String id) {
        return this.filterlistMap.get(id);
    }

    @Override
    public String[] getAllFilterlistIds() {
        return this.filterlistMap.keySet().toArray(new String[0]);
    }

    public String toString() {
        return this.filterlistMap.toString();
    }

    public static void reset() {
        initProcessFlag = false;
    }

    class FilterDefinition {
        String id;
        int[] orders;

        public FilterDefinition(int orderSize) {
            this.orders = new int[orderSize];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.id).append("|");
            for (int i = 0; i < this.orders.length; ++i) {
                sb.append(i + 1).append("=").append(this.orders[i]).append(",");
            }
            return sb.toString();
        }
    }
}

