/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.tools.xls2appschema.CacheFileManager;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectOuterlinkContainer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectOuterlinkContainer")
public class WagbyR6ProjectOuterlinkContainer
implements ProjectOuterlinkContainer {
    protected Logger log = LogManager.getLogger(WagbyR6ProjectOuterlinkContainer.class);
    private Map<Integer, Map<String, String>> outerLinkMap = new TreeMap<Integer, Map<String, String>>();
    private Map<Integer, Map<Integer, Map<String, String>>> principalInfoMap = new TreeMap<Integer, Map<Integer, Map<String, String>>>();
    private Map<Integer, Map<Integer, String>> rowMap = new TreeMap<Integer, Map<Integer, String>>();
    @Autowired(required=true)
    private CacheFileManager cacheFileManager_;
    private HashMap<String, String> tempLinkMap;
    private static boolean initProcessFlag = false;
    private final int OUTERLINK_MAX_VALUE_COLUMN = 1;
    private final int PRINCIPAL_MAX_VALUE_COLUMN = 1;

    @Override
    public void init() {
        if (!initProcessFlag) {
            this.cacheFileManager_.loadProjectOuterlink(this.outerLinkMap, this.principalInfoMap);
            initProcessFlag = true;
        }
    }

    @Override
    public void createRowMap() {
        this.rowMap.clear();
        this.rowMap = new TreeMap<Integer, Map<Integer, String>>();
    }

    @Override
    public void setElement(String elem, int colcnt, int rowcnt) {
        if (StringUtils.isBlank((CharSequence)elem)) {
            return;
        }
        Map<Integer, String> colMap = this.rowMap.get(rowcnt);
        if (colMap == null) {
            colMap = new TreeMap<Integer, String>();
            this.rowMap.put(rowcnt, colMap);
        }
        colMap.put(colcnt, elem);
    }

    @Override
    public void postProcess() {
        if (this.outerLinkMap == null || this.outerLinkMap.size() == 0) {
            return;
        }
        this.cacheFileManager_.saveProjectOuterlink(this.outerLinkMap, this.principalInfoMap);
    }

    @Override
    public void process() {
        Map<Integer, String> colMap = this.rowMap.get(1);
        if (colMap == null) {
            return;
        }
        String linkaction_id = null;
        String type = null;
        for (Map.Entry<Integer, String> entry : colMap.entrySet()) {
            int col_num = entry.getKey();
            if (col_num == 3) {
                linkaction_id = entry.getValue();
                continue;
            }
            if (col_num != 6) continue;
            type = entry.getValue();
        }
        if (!"repository".equals(type)) {
            return;
        }
        if (StringUtils.isBlank(linkaction_id)) {
            for (Map map : this.rowMap.values()) {
                this.createOuterLinkMap(map);
            }
            return;
        }
        this.tempLinkMap = new HashMap();
        for (Map map : this.rowMap.values()) {
            this.createPrincipalMapl(map, linkaction_id);
        }
        this.buildTempLinkMapIntoPrincipalMap(linkaction_id);
    }

    private void buildTempLinkMapIntoPrincipalMap(String linkaction_id) {
        Map<Integer, Map<String, String>> linkPrincipalMap = this.principalInfoMap.get(Integer.valueOf(linkaction_id));
        for (Map<String, String> map : linkPrincipalMap.values()) {
            map.putAll(this.tempLinkMap);
        }
    }

    private void createOuterLinkMap(Map<Integer, String> colMap) {
        String key = null;
        String column2 = null;
        String[] valueArray = new String[1];
        for (Map.Entry<Integer, String> col : colMap.entrySet()) {
            int col_num = col.getKey();
            String cell_value = col.getValue();
            if (cell_value != null && cell_value.startsWith("'")) {
                cell_value = cell_value.substring(1);
            }
            if (col_num == 1) {
                if (!StringUtils.isNotBlank((CharSequence)cell_value)) continue;
                key = cell_value;
                continue;
            }
            if (col_num == 2) {
                column2 = cell_value;
                continue;
            }
            if (col_num > 3) continue;
            valueArray[col_num - 3] = cell_value;
        }
        if (key == null) {
            return;
        }
        assert (NumberUtils.isNumber(column2)) : "Invalid line number of repository in project outerlink definition. (Not number) key : " + key + ", values : " + Arrays.asList(valueArray);
        Map<String, String> map = this.outerLinkMap.get(Integer.valueOf(column2));
        if (map == null) {
            map = new HashMap<String, String>();
            this.outerLinkMap.put(Integer.valueOf(column2), map);
        }
        if (map.get("menulinkaction/@__linenumber") == null) {
            map.put("menulinkaction/@__linenumber", column2);
        }
        this.putValueArray(key, valueArray, map);
    }

    private void createPrincipalMapl(Map<Integer, String> colMap, String linkaction_id) {
        Map<Integer, Map<String, String>> linkPrincipalMap = this.principalInfoMap.get(Integer.valueOf(linkaction_id));
        if (linkPrincipalMap == null) {
            linkPrincipalMap = new TreeMap<Integer, Map<String, String>>();
            this.principalInfoMap.put(Integer.valueOf(linkaction_id), linkPrincipalMap);
        }
        String key = null;
        String column2 = null;
        String[] valueArray = new String[1];
        for (Map.Entry<Integer, String> col : colMap.entrySet()) {
            int col_num = col.getKey();
            String cell_value = col.getValue();
            if (cell_value != null && cell_value.startsWith("'")) {
                cell_value = cell_value.substring(1);
            }
            if (col_num == 1) {
                if (!StringUtils.isNotBlank((CharSequence)cell_value)) continue;
                key = cell_value;
                continue;
            }
            if (col_num == 2) {
                column2 = cell_value;
                continue;
            }
            if (col_num > 3) continue;
            valueArray[col_num - 3] = cell_value;
        }
        if (key == null) {
            return;
        }
        if (column2 == null) {
            this.putValueArray(key, valueArray, this.tempLinkMap);
            return;
        }
        assert (NumberUtils.isNumber(column2)) : "Invalid line number of repository in project outerlink auth definition. (Not number) key : " + key + ", values : " + Arrays.asList(valueArray);
        Map<String, String> map = linkPrincipalMap.get(Integer.valueOf(column2));
        if (map == null) {
            map = new HashMap<String, String>();
            linkPrincipalMap.put(Integer.valueOf(column2), map);
        }
        if (map.get("menulinkaction/@__linenumber") == null) {
            map.put("menulinkaction/@__linenumber", column2);
        }
        this.putValueArray(key, valueArray, map);
    }

    private void putValueArray(String key, String[] valueArray, Map<String, String> map) {
        for (int i = 0; i < valueArray.length; ++i) {
            if (valueArray[i] == null) continue;
            Object _key = key;
            if (i > 0) {
                _key = (String)_key + "_" + (i + 1);
            }
            map.put((String)_key, valueArray[i]);
        }
    }

    @Override
    public Collection<Map<String, String>> getOuterlinkInfoMaps() {
        return this.outerLinkMap.values();
    }

    @Override
    public Collection<Map<String, String>> getPrincipalInfoMapsByLine(Integer line) {
        Map<Integer, Map<String, String>> linkPrincipalMap = this.principalInfoMap.get(line);
        if (linkPrincipalMap == null || linkPrincipalMap.size() == 0) {
            return null;
        }
        return linkPrincipalMap.values();
    }

    public static void reset() {
        initProcessFlag = false;
    }
}

