/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Forward;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.Mapping;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_sendmail_show;
import org.apache.commons.lang3.StringUtils;

public abstract class BActionElement_forward
extends BActionElement {
    private Set<String> patternSet_ = new LinkedHashSet<String>();

    public BActionElement_forward() {
        this.init();
    }

    public abstract void init();

    protected void addPattern(String pattern) {
        this.patternSet_.add(pattern);
    }

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        this.create(modelId, actionType, action, project, 0);
    }

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project, int num) {
        Forward forward = new Forward();
        for (String pattern : this.patternSet_) {
            if (pattern.equals("noData")) {
                this.addMapping_noData(forward);
            }
            if (pattern.equals("Sendmail")) {
                this.addMapping_Sendmail(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("Show")) {
                this.addMapping_Show(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("Copyinsertshowlist")) {
                this.addMapping_Copyinsertshowlist(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("Updateshowlist")) {
                this.addMapping_Updateshowlist(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("normal:show")) {
                this.addMapping_normal(modelId, ActionType.show, action, forward, project);
            }
            if (pattern.equals("normal:showList")) {
                this.addMapping_normal(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("normal:delete")) {
                this.addMapping_normal_delete(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("calendar")) {
                this.addMapping_calendarview(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("cancel:show")) {
                this.addMapping_cancel(modelId, ActionType.show, action, forward, project);
            }
            if (pattern.equals("cancel:showList")) {
                this.addMapping_cancel(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("wizard")) {
                this.addMapping_wizard(modelId, actionType, action, forward, project, num);
            }
            if (pattern.equals("lock_error")) {
                this.addMapping_lock_error(modelId, ActionType.show, action, forward, project);
            }
            if (pattern.equals("lock_error:showList")) {
                this.addMapping_lock_error(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("lock_error:mainMenu")) {
                this.addMapping_lock_error("mainMenu", forward);
            }
            if (pattern.equals("error:showList")) {
                this.addMapping_error(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("PrintScreen")) {
                this.addMapping_printScreen(modelId, ActionType.show, action, forward, project);
            }
            if (pattern.equals("PrintListScreen")) {
                this.addMapping_printListScreen(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("jfcworkstate") && "jfcworkstate".equals(modelId)) {
                this.addMapping_forWorkflow(modelId, ActionType.showList, action, forward, project);
            }
            if (pattern.equals("confirm")) {
                this.addMapping_confirm(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("updatenext")) {
                this.addMapping_updatenext(modelId, actionType, action, forward, project);
            }
            if (pattern.equals("SubWindowShow")) {
                this.addMapping_subWindowShow(modelId, ActionType.show, action, forward, project);
            }
            if (!pattern.equals("schedule")) continue;
            this.addMapping_scheduleview(modelId, actionType, action, forward, project);
        }
        action.addContent((IActionChoice)forward);
    }

    private void addMapping_confirm(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        if (actionType != ActionType.insert && actionType != ActionType.copy && actionType != ActionType.update) {
            return;
        }
        if (actionType == ActionType.insert || actionType == ActionType.copy ? !Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@confirmInsert")) : !Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@confirmUpdate"))) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.setType("confirm");
        StringBuilder sb = new StringBuilder();
        sb.append("confirm");
        if (actionType == ActionType.insert) {
            sb.append("Insert");
        } else if (actionType == ActionType.copy) {
            sb.append("Copy");
        } else if (actionType == ActionType.update) {
            sb.append("Update");
        }
        sb.append(SourceGenerator.capFirst((String)modelId));
        mapping.setContent(sb.toString());
        forward.addMapping(mapping);
    }

    protected void addMapping_noData(Forward forward) {
        Mapping mapping = new Mapping();
        mapping.setType("no_data");
        mapping.setContent("noData");
        forward.addMapping(mapping);
    }

    protected void addMapping_Sendmail(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = null;
        boolean isValid = BActionElement_sendmail_show.isValid(modelId, actionType, this.con_);
        boolean isNewbutton = BActionElement_sendmail_show.checkNewButton(modelId, actionType, this.con_);
        if (isValid && isNewbutton) {
            mapping = new Mapping();
            mapping.setPattern("Sendmail");
            mapping.setType("cmd");
            mapping.setContent(this.createSendmailMappingContent(modelId, actionType));
        }
        if (mapping != null) {
            forward.addMapping(mapping);
        }
    }

    protected void addMapping_printScreen(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = null;
        if (actionType == ActionType.show && Utils.isPrintScreenPage(modelId, this.con_)) {
            mapping = new Mapping();
            mapping.setType("printScreen");
            mapping.setContent(this.createPrintScreenMappingContent(modelId, actionType));
        }
        if (mapping != null) {
            forward.addMapping(mapping);
        }
    }

    protected void addMapping_printListScreen(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = null;
        if (actionType == ActionType.showList && Utils.isPrintListScreenPage(modelId, this.con_)) {
            mapping = new Mapping();
            mapping.setType("printListScreen");
            mapping.setContent(this.createPrintListScreenMappingContent(modelId, actionType));
        }
        if (mapping != null) {
            forward.addMapping(mapping);
        }
    }

    protected void addMapping_Show(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        mapping.setPattern("Show");
        mapping.setType("cmd");
        String id = this.con_.getModelValue(modelId, "model/showshowlist/@mapping");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            if (this.con_.existsModel(id)) {
                modelId = id;
            } else {
                this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_forward.addMapping_Show", new Object[]{modelId, id}));
            }
        }
        StringBuffer content = new StringBuffer();
        content.append("show").append(SourceGenerator.capFirst((String)modelId));
        if (Utils.isWizardModel(modelId, this.con_)) {
            content.append("P");
        }
        mapping.setContent(content.toString());
        forward.addMapping(mapping);
    }

    protected void addMapping_Copyinsertshowlist(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        boolean isCopyInsertShowList = Utils.isCopyInsertShowList(modelId, this.con_);
        if (!isCopyInsertShowList) {
            return;
        }
        String[] labels = Utils.getCopyInsertShowListLabels(modelId, this.con_);
        if (labels.length <= 1) {
            Mapping mapping = new Mapping();
            mapping.setPattern("Copy1");
            mapping.setType("cmd");
            mapping.setContent("copy" + SourceGenerator.capFirst((String)modelId) + "C1");
            forward.addMapping(mapping);
        } else {
            for (int count = 1; count <= labels.length; ++count) {
                Mapping mapping = new Mapping();
                mapping.setPattern("Copy" + count);
                mapping.setType("cmd");
                mapping.setContent("copy" + SourceGenerator.capFirst((String)modelId) + "C" + count);
                forward.addMapping(mapping);
            }
        }
    }

    protected void addMapping_Updateshowlist(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        String updateshowlist = this.con_.getModelValue(modelId, "model/@updateshowlist");
        if (!(Utils.isSelectedValue(updateshowlist) || updateshowlist != null && updateshowlist.indexOf("(") >= 0)) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.setPattern("Update");
        mapping.setType("cmd");
        StringBuffer content = new StringBuffer();
        content.append("update").append(SourceGenerator.capFirst((String)modelId));
        if (Utils.isWizardModel(modelId, this.con_)) {
            content.append("P");
        }
        mapping.setContent(content.toString());
        forward.addMapping(mapping);
    }

    protected void addMapping_normal(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        mapping.setType("normal");
        mapping.setContent(this.printForward(modelId, actionType, action, project));
        forward.addMapping(mapping);
    }

    protected void addMapping_normal_delete(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        mapping.setRedirect(true);
        mapping.setType("normal");
        mapping.setContent(this.printForward(modelId, actionType, action, project));
        forward.addMapping(mapping);
    }

    protected void addMapping_calendarview(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        boolean isCalendarView = Utils.isCalendarOutput(modelId, this.con_);
        if (!isCalendarView) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.setType("calendar");
        mapping.setContent("showList" + SourceGenerator.capFirst((String)modelId) + "Calendarview");
        forward.addMapping(mapping);
    }

    protected void addMapping_cancel(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        mapping.setType("cancel");
        mapping.setContent(this.printForward(modelId, actionType, action, project));
        forward.addMapping(mapping);
    }

    protected void addMapping_wizard(String modelId, ActionType actionType, Action action, Forward forward, Project project, int num) {
        if (!Utils.isWizardModel(modelId, this.con_)) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.setType("wizardFirstpageInput");
        mapping.setContent("wizardFirstpageInput");
        forward.addMapping(mapping);
        Map<Integer, List<String>> wizardMap = Utils.getWizardModelitemMap(modelId, this.con_);
        for (int pagenum : wizardMap.keySet()) {
            if (pagenum <= 0) continue;
            mapping = new Mapping();
            mapping.setType("wizard");
            mapping.setPagenum(pagenum);
            mapping.setContent(this.createWizardMappingContent(modelId, actionType, num));
            forward.addMapping(mapping);
        }
    }

    protected void addMapping_lock_error(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        if ("update".equals(action.getType()) && !Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@showPage"))) {
            mapping.setAction("Search");
        }
        mapping.setType("lock_error");
        mapping.setContent(this.printForward(modelId, actionType, action, project));
        forward.addMapping(mapping);
    }

    protected void addMapping_lock_error(String content, Forward forward) {
        Mapping mapping = new Mapping();
        mapping.setType("lock_error");
        mapping.setContent(content);
        forward.addMapping(mapping);
    }

    protected void addMapping_error(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        mapping.setType("error");
        mapping.setContent(this.printForward(modelId, actionType, action, project));
        forward.addMapping(mapping);
    }

    private void addMapping_forWorkflow(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        for (String workflowModelName : AppSchemaUtil.getWorkflowModelNames((Project)project)) {
            String forwardName = "show" + SourceGenerator.capFirst((String)workflowModelName);
            if (Utils.isWizardModel(workflowModelName, this.con_)) {
                forwardName = forwardName + "P";
            }
            Mapping mapping = new Mapping();
            mapping.setRedirect(true);
            mapping.setName(workflowModelName);
            mapping.setContent(forwardName);
            forward.addMapping(mapping);
        }
    }

    protected void addMapping_updatenext(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        Mapping mapping = new Mapping();
        mapping.setType("updatenext");
        mapping.setContent(this.printForward(modelId, actionType, action, project));
        forward.addMapping(mapping);
    }

    protected void addMapping_subWindowShow(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        if (actionType != ActionType.show || !Utils.isCreateSubwindow(modelId, this.con_)) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.setType("subWindowShow");
        mapping.setContent(this.createSubWindowShowMappingContent(modelId, actionType));
        forward.addMapping(mapping);
    }

    private String printForward(String modelId, ActionType actionType, Action action, Project project) {
        boolean isShowPage = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@showPage"));
        boolean isShowListPage = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@showListPage"));
        boolean isShowListOnescreen = Utils.isPresentationShowListOneScreen(modelId, this.con_);
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)modelId);
        if (smodel.getStatic()) {
            isShowPage = false;
            isShowListPage = true;
            isShowListOnescreen = true;
        }
        StringBuilder sb = new StringBuilder();
        if (actionType == ActionType.show) {
            if (isShowPage) {
                sb.append("show");
                sb.append(SourceGenerator.capFirst((String)modelId));
                if (Utils.isWizardModel(modelId, this.con_)) {
                    sb.append("P");
                }
            } else if (isShowListPage) {
                sb.append("showList");
                sb.append(SourceGenerator.capFirst((String)modelId));
                if (!isShowListOnescreen) {
                    sb.append("$2");
                }
            } else if (Utils.isMobile(modelId, this.con_)) {
                sb.append("mobileMenu");
            } else {
                sb.append("mainMenu");
            }
        } else if (actionType == ActionType.showList) {
            if (isShowListPage) {
                sb.append("showList");
                sb.append(SourceGenerator.capFirst((String)modelId));
                if (!isShowListOnescreen) {
                    sb.append("$2");
                }
            } else if (Utils.isMobile(modelId, this.con_)) {
                sb.append("mobileMenu");
            } else {
                sb.append("mainMenu");
            }
        } else {
            sb.append((Object)actionType);
            sb.append(SourceGenerator.capFirst((String)modelId));
        }
        return sb.toString();
    }

    private String createSendmailMappingContent(String modelId, ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        if (actionType == ActionType.show) {
            sb.append("show");
        } else if (actionType == ActionType.insert || actionType == ActionType.copy) {
            sb.append("insert");
        } else if (actionType == ActionType.update) {
            sb.append("update");
        }
        sb.append(SourceGenerator.capFirst((String)modelId));
        if ((actionType == ActionType.insert || actionType == ActionType.copy || actionType == ActionType.update || actionType == ActionType.show) && Utils.isWizardModel(modelId, this.con_)) {
            sb.append("P");
        }
        return sb.toString();
    }

    private String createPrintScreenMappingContent(String modelId, ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        sb.append("printScreen");
        sb.append(SourceGenerator.capFirst((String)modelId));
        if (Utils.isWizardModel(modelId, this.con_)) {
            sb.append("P");
        }
        sb.append(".page");
        return sb.toString();
    }

    private String createPrintListScreenMappingContent(String modelId, ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        sb.append("printListScreen");
        sb.append(SourceGenerator.capFirst((String)modelId));
        sb.append(".page");
        return sb.toString();
    }

    private String createWizardMappingContent(String modelId, ActionType actionType, int num) {
        StringBuilder sb = new StringBuilder();
        if (actionType == ActionType.insert) {
            sb.append("insert");
        } else if (actionType == ActionType.copy) {
            sb.append("copy");
        } else if (actionType == ActionType.update) {
            sb.append("update");
        } else if (actionType == ActionType.show) {
            sb.append("show");
        }
        sb.append(SourceGenerator.capFirst((String)modelId));
        if (actionType == ActionType.copy) {
            sb.append("C");
            sb.append(num);
        }
        sb.append("P");
        return sb.toString();
    }

    private String createSubWindowShowMappingContent(String modelId, ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        sb.append("subWindowShow").append(SourceGenerator.capFirst((String)modelId)).append(".page");
        return sb.toString();
    }

    protected void addMapping_scheduleview(String modelId, ActionType actionType, Action action, Forward forward, Project project) {
        if (!Utils.isScheduleviewOutput(modelId, this.con_)) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.setType("scheduleview");
        mapping.setContent("showList" + SourceGenerator.capFirst((String)modelId) + "Scheduleview");
        forward.addMapping(mapping);
    }
}

