/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Script;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="script")
public class BActionElement_script
extends BActionElement {
    private Map<ActionType, String[]> patternMap = new HashMap<ActionType, String[]>();

    public BActionElement_script() {
        this.init();
    }

    private void init() {
        this.patternMap.put(ActionType.show, new String[]{"beforeShow", "beforeShowInInsert", "beforeShowInUpdate", "beforeDelete", "calc", "s2p", "p2s", "doAfterPrint", "logicalDelete", "replaceMapHelper", "DownloadFile_beforeDownload", "groupSelection", "afterCommittedDeletion"});
        this.patternMap.put(ActionType.showList, new String[]{"initializeInSearch", "calc", "doUpdateRule", "beforeShowInShowList", "doAfterPrintList", "inputCheckInSearch", "filterInSearch", "criteriaConverter", "searchListCriteriaConverter", "calendarViewCriteriaConverter", "reportListCriteriaConverter", "downloadCriteriaConverter", "beforeSearch", "replaceMapHelper", "DownloadFile_beforeDownload", "cs2p", "cp2s", "groupSelection"});
        this.patternMap.put(ActionType.insert, new String[]{"beforeInsert", "beforeShowInInsert", "initialize", "inputCheck", "filter", "calc", "s2p", "p2s", "DownloadFile_beforeDownload", "UpdateFile_afterUpload", "groupSelection", "afterCommittedInsertion"});
        this.patternMap.put(ActionType.update, new String[]{"readUpdate", "beforeUpdate", "beforeShowInUpdate", "inputCheck", "filter", "calc", "s2p", "p2s", "DownloadFile_beforeDownload", "UpdateFile_afterUpload", "groupSelection", "afterCommittedUpdation"});
        this.patternMap.put(ActionType.copy, new String[]{"beforeInsert", "beforeShowInInsert", "initialize", "inputCheck", "filter", "calc", "copy", "s2p", "p2s", "DownloadFile_beforeDownload", "UpdateFile_afterUpload", "afterCommittedInsertion"});
        this.patternMap.put(ActionType.updateList, new String[]{"inputCheckInUpdateList", "filterInUpdateList", "beforeDelete", "logicalDelete", "calc", "DownloadFile_beforeDownload", "UpdateFile_afterUpload", "updateListCriteriaConverter"});
        this.patternMap.put(ActionType.download, new String[]{"downloadStart", "downloadEnd", "downloadOutputCsv"});
        this.patternMap.put(ActionType.uploadUpdate, new String[]{"uploadUpdateStart", "uploadUpdateEnd", "uploadUpdateAfterRead", "uploadUpdateAfterUpdate", "beforeShowInUploadUpdate", "calc", "s2p", "p2s", "beforeDelete", "logicalDelete", "UpdateFile_afterUpload", "uploadUpdateReadHeader", "uploadUpdateReadRowDataInFileProcessor", "afterCommittedInsertion", "afterCommittedUpdation", "afterCommittedDeletion"});
        this.patternMap.put(ActionType.reportList, new String[]{"initializeInSearch", "filterInSearch", "criteriaConverter", "searchListCriteriaConverter", "reportListCriteriaConverter", "beforeSearch", "replaceMapHelper"});
        this.patternMap.put(ActionType.calendar, new String[]{"initializeInSearch", "filterInSearch", "criteriaConverter", "searchListCriteriaConverter", "calendarViewCriteriaConverter", "beforeSearch", "replaceMapHelper"});
        this.patternMap.put(ActionType.totalview, new String[]{"initializeInSearch", "filterInSearch", "criteriaConverter", "searchListCriteriaConverter", "beforeSearch", "replaceMapHelper"});
    }

    @Override
    public void create(String modelId, ActionType actionType, Action action, Project project) {
        String[] patterns = this.patternMap.get((Object)actionType);
        if (patterns != null) {
            for (String pattern : patterns) {
                boolean isCalcScript = false;
                if ("calc".equals(pattern)) {
                    Action[] _actions;
                    block1: for (Action _action : _actions = AppSchemaUtil.getActionByModelId((Project)project, (String)modelId, (boolean)false)) {
                        Script[] _scripts;
                        for (Script _script : _scripts = AppSchemaUtil.getScript((Action)_action)) {
                            if (!_script.getType().equals("calc")) continue;
                            isCalcScript = true;
                            break block1;
                        }
                    }
                }
                if (isCalcScript) continue;
                this.addScriptElement(modelId, action, pattern);
            }
        }
        String[] keys = this.con_.getKeysByModel(modelId);
        if (actionType == ActionType.copy) {
            actionType = ActionType.insert;
        }
        Object prefix = "action/script/@controller_" + StringUtil.capFirst((String)actionType.toString());
        for (String key : keys) {
            if (!key.startsWith((String)prefix)) continue;
            this.addScriptElement(modelId, action, key.substring("action/script/@".length()));
        }
        if (actionType == ActionType.show) {
            prefix = "action/script/@controller_Delete";
            for (String key : keys) {
                if (!key.startsWith((String)prefix)) continue;
                this.addScriptElement(modelId, action, key.substring("action/script/@".length()));
            }
        }
    }

    private void addScriptElement(String modelId, Action action, String pattern) {
        if (pattern == null) {
            return;
        }
        String s = this.con_.getModelValue(modelId, "action/script/@" + pattern);
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        Script script = new Script();
        script.setType(pattern);
        script.setContent(s);
        action.addContent((IActionChoice)script);
    }
}

