/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import java.util.List;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Hookitem;
import jp.jasminesoft.jfc.gen.appschema.Hookparam;
import jp.jasminesoft.jfc.gen.appschema.IHookitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.BaseConverter;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement;
import org.apache.commons.lang3.StringUtils;

public abstract class BActionTemplate
extends BaseConverter {
    private List<BActionElement> bActionElementList_;

    public void setBActionElement(List<BActionElement> list) {
        this.bActionElementList_ = list;
    }

    public List<BActionElement> getBActionElement() {
        return this.bActionElementList_;
    }

    public abstract ActionType getType();

    public boolean isValid(String modelId, Project project) {
        return true;
    }

    public boolean hasScript(String modelId, Project project) {
        return this.hasScript0(modelId, project, new String[0]);
    }

    protected boolean hasScript0(String modelId, Project project, String[] keys) {
        boolean hasScript = false;
        for (String key : keys) {
            if (!StringUtils.isNotBlank((CharSequence)this.con_.getModelValue(modelId, key))) continue;
            hasScript = true;
            break;
        }
        return hasScript;
    }

    public void setActionAttribute(String modelId, Action action, Project project, int num) {
    }

    public void setActionElement(String modelId, String modelId_ref, Action action, Project project, int num) {
        List<BActionElement> list = this.getBActionElement();
        if (list == null) {
            return;
        }
        for (BActionElement element : list) {
            if (!element.isValid(modelId, this.getType(), action, project)) continue;
            this.setActionElement0(element, modelId, modelId_ref, action, project, num);
        }
    }

    protected void setActionElement0(BActionElement element, String modelId, String modelId_ref, Action action, Project project, int num) {
        if (num > 0) {
            element.create(modelId, this.getType(), action, project, num);
        } else {
            element.create(modelId, this.getType(), action, project);
        }
    }

    public void setHooklist(String modelId, Action action, Project project) {
    }

    protected Hookitem createHookitem(String position) {
        return this.createHookitem(position, null);
    }

    protected Hookitem createHookitem(String position, Hookparam hookparam) {
        Hookitem hookitem = new Hookitem();
        if (StringUtils.isNotBlank((CharSequence)position)) {
            hookitem.setPosition(position);
        }
        if (hookparam != null) {
            hookitem.setContent((IHookitemChoice)hookparam);
        }
        return hookitem;
    }

    protected Hookparam createHookparam(String type, String content) {
        return this.createHookparam(type, content, null);
    }

    protected Hookparam createHookparam(String type, String content, String modelId) {
        Hookparam hookparam = new Hookparam();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            hookparam.setType(type);
        }
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            hookparam.setModelid(modelId);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            hookparam.setContent(content);
        }
        return hookparam;
    }

    public String getId(String modelId, int num) {
        return this.getType() + SourceGenerator.capFirst((String)modelId);
    }

    public void create(String modelId, Project project) {
        this.create(modelId, modelId, project, -1);
    }

    public void create(String modelId, String modelId_ref, Project project) {
        this.create(modelId, modelId_ref, project, -1);
    }

    public void create(String modelId, Project project, int num) {
        this.create(modelId, modelId, project, num);
    }

    public void create(String modelId, String modelId_ref, Project project, int num) {
        boolean hasScript = false;
        boolean isValid = this.isValid(modelId, project);
        if (!isValid && !(hasScript = this.hasScript(modelId, project))) {
            return;
        }
        Action action = new Action();
        if (!isValid) {
            action.setValid(false);
        }
        action.setId(this.getId(modelId, num));
        action.setIdref(modelId_ref);
        action.setType(BActionTemplate.getProperAppSchemaActionType(this.getType()));
        boolean rest = this.isUseRest(modelId);
        if (action.getRest() != rest) {
            action.setRest(rest);
        }
        this.setActionAttribute(modelId, action, project, num);
        this.setActionElement(modelId, modelId_ref, action, project, num);
        project.addContent((IProjectChoice)action);
    }

    public boolean isUseRest(String modelId) {
        return Utils.isUseRest(modelId, this.con_);
    }

    public static final String getProperAppSchemaActionType(ActionType actionType) {
        String ret = null;
        if (actionType == ActionType.show) {
            ret = "show";
        } else if (actionType == ActionType.showList) {
            ret = "showList";
        } else if (actionType == ActionType.updateList) {
            ret = "showList";
        } else if (actionType == ActionType.reportList) {
            ret = "showList";
        } else if (actionType == ActionType.searchList) {
            ret = "showList";
        } else if (actionType == ActionType.searchListForRefgroup) {
            ret = "showList";
        } else if (actionType == ActionType.insert) {
            ret = "insert";
        } else if (actionType == ActionType.copy) {
            ret = "copy";
        } else if (actionType == ActionType.update) {
            ret = "update";
        } else if (actionType == ActionType.delete) {
            ret = "delete";
        } else if (actionType == ActionType.download) {
            ret = "download";
        } else if (actionType == ActionType.uploadUpdate) {
            ret = "uploadUpdate";
        }
        return ret;
    }

    public static String replaceBRTagToLF(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return value.replaceAll("<br/>", "\n");
    }

    protected void setMenuAttribute(Action action) {
        this.setMenuAttribute(action, null);
    }

    protected void setMenuAttribute(Action action, String repositoryKeySuffix) {
        if (action == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)repositoryKeySuffix)) {
            repositoryKeySuffix = StringUtils.capitalize((String)action.getType().toString());
        }
        StringBuilder tooltipRepositoryKey = new StringBuilder();
        tooltipRepositoryKey.append("action/@menuTooltip").append(repositoryKeySuffix);
        if (this.con_.existsKeyInModel(action.getIdref(), tooltipRepositoryKey.toString())) {
            action.setMenuTooltip(this.con_.getModelValue(action.getIdref(), tooltipRepositoryKey.toString()));
        }
        StringBuilder imgSrcRepositoryKey = new StringBuilder();
        imgSrcRepositoryKey.append("action/@menuImgSrc").append(repositoryKeySuffix);
        if (this.con_.existsKeyInModel(action.getIdref(), imgSrcRepositoryKey.toString())) {
            action.setMenuImgSrc(this.con_.getModelValue(action.getIdref(), imgSrcRepositoryKey.toString()));
        }
        StringBuilder imgStyleRepositoryKey = new StringBuilder();
        imgStyleRepositoryKey.append("action/@menuImgStyle").append(repositoryKeySuffix);
        if (this.con_.existsKeyInModel(action.getIdref(), imgStyleRepositoryKey.toString())) {
            action.setMenuImgStyle(this.con_.getModelValue(action.getIdref(), imgStyleRepositoryKey.toString()));
        }
        StringBuilder iconClassRepositoryKey = new StringBuilder();
        iconClassRepositoryKey.append("action/@menuIconClass").append(repositoryKeySuffix);
        if (this.con_.existsKeyInModel(action.getIdref(), iconClassRepositoryKey.toString())) {
            action.setMenuIconClass(this.con_.getModelValue(action.getIdref(), iconClassRepositoryKey.toString()));
        }
    }

    protected String getProperSpace() {
        return Utils.getProperSpace();
    }

    protected void setDescription(Action action, String modelId, String pagetitleRepositoryKey, String messageKey) {
        String pagetitle = this.con_.getModelValue(modelId, pagetitleRepositoryKey);
        if (StringUtils.isBlank((CharSequence)pagetitle)) {
            String description = this.con_.getModelValue(modelId, "model/@description");
            if (StringUtils.isBlank((CharSequence)description)) {
                description = modelId;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(description).append(this.getProperSpace()).append(rman.getValue(messageKey));
            pagetitle = sb.toString();
        }
        action.setDescription(pagetitle);
    }
}

