/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.action;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Download;
import jp.jasminesoft.jfc.gen.appschema.DownloadLocal;
import jp.jasminesoft.jfc.gen.appschema.Hooklist;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionTemplate;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob;
import org.apache.commons.lang3.StringUtils;

public class BDownloadAction
extends BActionTemplate {
    @Override
    public ActionType getType() {
        return ActionType.download;
    }

    @Override
    public boolean isValid(String modelId, Project project) {
        return BDownloadAction.isValid(this.con_, modelId, project);
    }

    public static boolean isValid(ElementContainer con_, String modelId, Project project) {
        Model smodel = AppSchemaUtil.getModel((Project)project, (String)modelId);
        if (smodel.getStatic()) {
            return false;
        }
        return BDownloadAction.isDownloadPage(con_, modelId) || BDownloadAction.isDownloadJob(con_, modelId);
    }

    @Override
    public boolean hasScript(String modelId, Project project) {
        return false;
    }

    public static boolean isGenerateStrutsclass(ElementContainer con_, String modelId) {
        return BDownloadAction.isDownloadPage(con_, modelId);
    }

    private static boolean isDownloadPage(ElementContainer con_, String modelId) {
        return Utils.isSelectedValue(con_.getModelValue(modelId, "model/@csvOutput"));
    }

    private static boolean isDownloadJob(ElementContainer con_, String modelId) {
        return BJob.isUseDownloadJob(con_, modelId);
    }

    @Override
    public void setActionAttribute(String modelId, Action action, Project project, int num) {
        String menulabelcolordownload;
        String menucolordownload;
        String descriptionDownload;
        action.setProcessBean("Download" + SourceGenerator.capFirst((String)modelId) + "ProcessBean");
        boolean isSingleModel = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@singleModel"));
        if (!isSingleModel) {
            action.setSingleModel(true);
        }
        boolean isMenurefDownload = true;
        if (this.con_.existsKeyInModel(modelId, "action/@menurefDownload")) {
            isMenurefDownload = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@menurefDownload"));
        }
        if (isMenurefDownload) {
            action.setMenuref(Utils.getStoreModelMenuref(modelId, "action/@menuNameDownload", this.con_));
            Integer order = Utils.getStoreModelMenuorder(modelId, "action/@menuorderDownload", this.con_);
            if (order != null) {
                action.setMenuorder(order);
            }
            this.setMenuAttribute(action);
        }
        if (!BDownloadAction.isGenerateStrutsclass(this.con_, modelId)) {
            action.setStrutsclassgen(false);
        }
        if (StringUtils.isNotBlank((CharSequence)(descriptionDownload = this.con_.getModelValue(modelId, "action/@descriptiondownload")))) {
            action.setMenutitle(BDownloadAction.replaceBRTagToLF(descriptionDownload));
        }
        this.setDescription(action, modelId, "model/@csvPagetitle", "r.project.message.title.download.defaultValue");
        boolean isStrutsClasstype = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@strutsclasstype"));
        if (isStrutsClasstype) {
            action.setStrutsclasstype("MyDownload" + SourceGenerator.capFirst((String)modelId) + "Action");
        }
        if (StringUtils.isNotBlank((CharSequence)(menucolordownload = this.con_.getModelValue(modelId, "action/@menucolordownload_2")))) {
            action.setMenucolor(menucolordownload);
        }
        if (StringUtils.isNotBlank((CharSequence)(menulabelcolordownload = this.con_.getModelValue(modelId, "action/@menucolordownload_3")))) {
            action.setMenulabelcolor(menulabelcolordownload);
        }
    }

    @Override
    public void setActionElement(String modelId, String modelId_ref, Action action, Project project, int num) {
        Download download;
        boolean isStrutsClasstype = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/@strutsclasstype"));
        if (isStrutsClasstype) {
            this.setHooklist(modelId, action, project);
        }
        if ((download = BDownloadAction.createDownload(this.con_, modelId)) != null) {
            action.addContent((IActionChoice)download);
        }
        super.setActionElement(modelId, modelId_ref, action, project, num);
    }

    public static Download createDownload(ElementContainer con_, String modelId) {
        boolean isDisableCsvDataHeader;
        String storetype;
        String csv_encoding;
        Download download = new Download();
        String delimiter = con_.getModelValue(modelId, "action/download/@type");
        delimiter = StringUtils.isBlank((CharSequence)delimiter) ? "csv".toLowerCase() : delimiter.toLowerCase();
        String csvquot = con_.getModelValue(modelId, "action/download/@type_2");
        if (delimiter.equals("csv".toLowerCase())) {
            download.setType("csv");
        } else if (delimiter.equals("tsv".toLowerCase())) {
            download.setType("tsv");
        } else if (delimiter.equals("xls".toLowerCase()) || delimiter.equals(ropt.getValue("OPTION_action_download_type_3_value_alt")) || delimiter.equals(ropt.getValue("OPTION_action_download_type_3_value"))) {
            download.setType("xls");
        } else if (delimiter.equals("xlsx".toLowerCase()) || delimiter.equals(ropt.getValue("OPTION_action_download_type_4_value"))) {
            download.setType("xlsx");
        } else if (delimiter.equals(ropt.getValue("OPTION_action_download_type_5_value"))) {
            download.setType("csv");
            download.setTypeSelectable(true);
        } else {
            download = null;
        }
        if (download != null) {
            if (ropt.getValue("OPTION_action_download_type_2_2_value").equals(csvquot)) {
                download.setCsvquot("empty");
            } else if ("\"".equals(csvquot)) {
                download.setCsvquot("double-quotation");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(csv_encoding = con_.getModelValue(modelId, "action/download/@csv_encoding")))) {
            download.setCsvEncoding(csv_encoding);
        }
        if ((storetype = con_.getModelValue(modelId, "action/download/@storetype")) != null && storetype.equals("local")) {
            String outputfilenametype;
            String outputdir;
            download.setStoretype("local");
            DownloadLocal downloadLocal = new DownloadLocal();
            String outputfilename = con_.getModelValue(modelId, "action/download/download_local/@outputfilename");
            if (StringUtils.isNotBlank((CharSequence)outputfilename)) {
                downloadLocal.setOutputfilename(outputfilename);
            }
            if (StringUtils.isNotBlank((CharSequence)(outputdir = con_.getModelValue(modelId, "action/download/download_local/@outputdir")))) {
                downloadLocal.setOutputdir(outputdir);
            }
            if (StringUtils.isNotBlank((CharSequence)(outputfilenametype = con_.getModelValue(modelId, "action/download/download_local/@outputfilenametype"))) && (outputfilenametype.equals("temp") || outputfilenametype.equals("filename") || outputfilenametype.equals("ext"))) {
                downloadLocal.setOutputfilenametype(outputfilenametype);
            }
            download.setDownloadLocal(downloadLocal);
        }
        if (isDisableCsvDataHeader = Utils.isSelectedValue(con_.getModelValue(modelId, "action/download/@disable_csv_data_header"))) {
            download.setDisableCsvDataHeader(true);
        }
        return download;
    }

    @Override
    public void setHooklist(String modelId, Action action, Project project) {
        Hooklist hooklist = new Hooklist();
        hooklist.addHookitem(this.createHookitem("getCommand:first"));
        hooklist.addHookitem(this.createHookitem("getCommand:finish"));
        hooklist.addHookitem(this.createHookitem("retrieveData:first"));
        hooklist.addHookitem(this.createHookitem("retrieveData:finish"));
        hooklist.addHookitem(this.createHookitem("do_preprocess:first"));
        hooklist.addHookitem(this.createHookitem("do_preprocess:finish"));
        hooklist.addHookitem(this.createHookitem("do_condition:first"));
        hooklist.addHookitem(this.createHookitem("do_condition:after_preprocess"));
        hooklist.addHookitem(this.createHookitem("do_condition:before_setcondition"));
        hooklist.addHookitem(this.createHookitem("do_condition:after_setcondition"));
        hooklist.addHookitem(this.createHookitem("do_condition:finish"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:first"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:ready_pbean"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:before_do_condition"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:after_do_condition"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:before_setparameter"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:after_setparameter"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:before_pbean", this.createHookparam("ProcessBean", "pbean")));
        hooklist.addHookitem(this.createHookitem("do_downloadData:after_pbean"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:finish_pbean"));
        hooklist.addHookitem(this.createHookitem("do_downloadData:finish"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:first"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_preprocess"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_gettargetobj"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_gettargetobj"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_filtering"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_filtering"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_p2s_helper"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_p2s_helper"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_calc_helper"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_calc_helper"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_inputcheck"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_inputcheck"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_s2p_helper"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_s2p_helper"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:before_zipsync"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:after_zipsync"));
        hooklist.addHookitem(this.createHookitem("do_zipCode:finish"));
        action.addContent((IActionChoice)hooklist);
    }
}

