/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.job;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JobGeneratorUtil;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Filestore;
import jp.jasminesoft.jfc.gen.appschema.IJobChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Init;
import jp.jasminesoft.jfc.gen.appschema.Job;
import jp.jasminesoft.jfc.gen.appschema.Jobdesc;
import jp.jasminesoft.jfc.gen.appschema.Jobparam;
import jp.jasminesoft.jfc.gen.appschema.Jobrule;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Param;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Usebean;
import jp.jasminesoft.jfc.tools.xls2appschema.ActionType;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_messagejob;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.action.BActionElement_uploadupdate;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(value="BJob")
public class BJob
extends AppSchemaBuilder {
    private static final String[][] ReceiveMailProtocol = new String[][]{{"POP3", "pop3"}, {"IMAP", "imap"}, {"pop3s", "pop3s"}, {"imaps", "imaps"}, {"POP3 over SSL", "pop3s"}, {"IMAP over SSL", "imaps"}};
    public static final String SEND_MAIL_PROTOCOL_SMTP = "SMTP";
    public static final String SEND_MAIL_PROTOCOL_SMTPS = "SMTP over SSL";
    public static final String SEND_MAIL_PROTOCOL_STARTTLS = "STARTTLS";
    private static final String[][] SendMailProtocol = new String[][]{{"SMTP", "smtp"}, {"SMTP over SSL", "smtps"}, {"STARTTLS", "starttls"}};
    private static final Map<String, String> ReceiveMailProtocolMap = new HashMap<String, String>();
    public static final Map<String, String> SendMailProtocolMap = new HashMap<String, String>();
    private Set<String> differentDomainModelIdSet;
    private static final String UploadUpdateJobRepositoryKeyBase = "model/uploadupdate/job";
    private static final String DownloadJobRepositoryKeyBase = "model/download/job";
    private static final String ReportListJobRepositoryKeyBase = "model/reportlist/job";
    private static final Logger logger;

    public void setDifferentDomainModelIdSet(Set<String> differentDomainModelIdSet) {
        this.differentDomainModelIdSet = differentDomainModelIdSet;
    }

    @Override
    public void process(Project project) {
        List<Job> jobs = this.createJobs(project, this.differentDomainModelIdSet);
        project.addContent((IProjectChoice[])jobs.toArray(new Job[0]));
    }

    public List<Job> createJobs(Project project, Set<String> differentDomainModelIdSet) {
        ArrayList<Job> list = new ArrayList<Job>();
        String[] modelIds = this.getElementContainer().getAllStoreModelId();
        HashSet<String> jobNameSet = new HashSet<String>();
        for (String modelId : modelIds) {
            if (differentDomainModelIdSet != null && differentDomainModelIdSet.contains(modelId)) continue;
            this.process_sendMailJob(modelId, jobNameSet, project, list);
            this.process_receiveMailJob(modelId, jobNameSet, project, list);
            this.process_callsql(modelId, jobNameSet, project, list);
            this.process_uploadUpdateJob(modelId, jobNameSet, project, list);
            this.process_downloadJob(modelId, jobNameSet, project, list);
            this.process_reportListJob(modelId, jobNameSet, project, list);
        }
        this.process_importJob(project, list);
        this.process_exportJob(project, list);
        this.process_processExecJob(project, list);
        this.process_zipArchiveJob(project, list);
        this.process_zipArchiveKeepFileJob(project, list);
        this.process_removeFileJob(project, list);
        this.process_copyFileJob(project, list);
        this.process_moveFileJob(project, list);
        this.process_optimizeIndex4TextSearchJob(project, list);
        this.process_alertMailJob(project, list);
        this.process_amazonS3FilestoreUploadJob(project, list);
        this.process_checkDiskJob(project, list);
        this.process_scriptCodeRunnerJob(project, list);
        this.process_maintenanceJob(project, list);
        this.process_springbatch(project, list);
        this.process_sendJobExecutionMessageJob(project, list);
        this.process_customize(project, list);
        return list;
    }

    private void process_springbatch(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("BatchJobLauncher");
        job.setClassname("jp.jasminesoft.jfc.job.SpringBatchSimpleJobLauncher");
        job.setType("batchJobLauncher");
        this.addJobdesc(rman.getValue("r.job.batchJobLauncher.title"), job);
        list.add(job);
    }

    private void process_dataMaintenanceJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("DataMaintenance");
        job.setClassname("jp.jasminesoft.jfc.job.DataMaintenanceJob");
        job.setType("dataMaintenance");
        this.addJobdesc(rman.getValue("r.job.DataMaintenance.title"), job);
        list.add(job);
    }

    private void process_maintenanceJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("Maintenance");
        job.setClassname("jp.jasminesoft.jfc.job.MaintenanceModeJob");
        job.setType("maintenance");
        this.addJobdesc(rman.getValue("r.job.Maintenance.title"), job);
        list.add(job);
    }

    private void process_scriptCodeRunnerJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("ScriptCodeRunner");
        job.setClassname("jp.jasminesoft.jfc.job.ScriptCodeRunnerJob");
        job.setType("script");
        this.addJobdesc(rman.getValue("r.job.ScriptCodeRunner.title"), job);
        list.add(job);
    }

    private void process_checkDiskJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("CheckDisk");
        job.setClassname("jp.jasminesoft.jfc.job.CheckDiskJob");
        job.setType("checkdisk");
        this.addJobdesc(rman.getValue("r.job.CheckDisk.title"), job);
        list.add(job);
    }

    private void process_amazonS3FilestoreUploadJob(Project project, List<Job> list) {
        Environment env = project.getEnvironment();
        Filestore filestore = AppSchemaUtil.getFilestore((Environment)env);
        if (filestore == null || filestore.getType() == null || !filestore.getType().equals("s3")) {
            return;
        }
        Job job = this.createJob(project);
        job.setName("AmazonS3FilestoreUpload");
        job.setClassname("jp.jasminesoft.jfc.job.AmazonS3FilestoreUploadJob");
        job.setType("amazons3filestoreupload");
        this.addJobdesc("Amazon S3 \u3078\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9", job);
        Usebean usebean = new Usebean();
        usebean.setId("AmazonS3FilestoreUploadInitializeSchedulerListener");
        usebean.setClassname("jp.jasminesoft.jfc.job.AmazonS3FilestoreUploadInitializeSchedulerListener");
        job.addContent((IJobChoice)usebean);
        list.add(job);
    }

    private void process_optimizeIndex4TextSearchJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("OptimizeIndex4TextSearch");
        job.setClassname("jp.jasminesoft.jfc.job.OptimizeIndex4TextSearchJob");
        job.setType("optimizeindex");
        this.addJobdesc(rman.getValue("r.job.OptimizeIndex4TextSearch.title"), job);
        list.add(job);
    }

    private void process_removeFileJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("RemoveFile");
        job.setClassname("jp.jasminesoft.jfc.job.RemoveFileJob");
        job.setType("removefile");
        this.addJobdesc(rman.getValue("r.job.RemoveFile.title"), job);
        list.add(job);
    }

    private void process_copyFileJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("CopyFile");
        job.setClassname("jp.jasminesoft.jfc.job.CopyFileJob");
        job.setType("copyfile");
        this.addJobdesc(rman.getValue("r.job.CopyFile.title"), job);
        list.add(job);
    }

    private void process_moveFileJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("MoveFile");
        job.setClassname("jp.jasminesoft.jfc.job.MoveFileJob");
        job.setType("movefile");
        this.addJobdesc(rman.getValue("r.job.MoveFile.title"), job);
        list.add(job);
    }

    private void process_zipArchiveJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("ZipArchive");
        job.setClassname("jp.jasminesoft.jfc.job.ZipArchiveJob");
        job.setType("ziparchive");
        this.addJobdesc(rman.getValue("r.job.ZipArchive.title"), job);
        list.add(job);
    }

    private void process_zipArchiveKeepFileJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("ZipArchiveKeepFile");
        job.setClassname("jp.jasminesoft.jfc.job.ZipArchiveKeepFileJob");
        job.setType("ziparchive_keepfile");
        this.addJobdesc(rman.getValue("r.job.ZipArchiveKeepFile.title"), job);
        list.add(job);
    }

    private void process_importJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("RegularImport");
        job.setClassname("jp.jasminesoft.jfc.job.ImportJob");
        job.setType("import");
        this.addJobdesc(rman.getValue("r.job.RegularImport.title"), job);
        list.add(job);
    }

    private void process_exportJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("RegularExport");
        job.setClassname("jp.jasminesoft.jfc.job.ExportJob");
        job.setType("export");
        this.addJobdesc(rman.getValue("r.job.RegularExport.title"), job);
        list.add(job);
    }

    private void process_processExecJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("ProcessExec");
        job.setClassname("jp.jasminesoft.jfc.job.ProcessExecJob");
        job.setType("processexec");
        this.addJobdesc(rman.getValue("r.job.ProcessExec.title"), job);
        list.add(job);
    }

    private void process_sendJobExecutionMessageJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("SendJobExecutionMessage");
        job.setClassname("jp.jasminesoft.jfc.job.SendJobExecutionMessageJob");
        job.setType("sendJobExecutionMessage");
        this.addJobdesc(rman.getValue("r.job.SendJobExecutionMessage.title"), job);
        list.add(job);
    }

    public static boolean isInsertFromMail(ElementContainer con_, String modelId) {
        String base = "model/recievemail/job1";
        String jobname = con_.getModelValue(modelId, base + "/@name");
        return !StringUtils.isBlank((CharSequence)jobname);
    }

    private void process_receiveMailJob(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
        String _value;
        String subpackagename = project.getPackage() + ".app." + modelId;
        String base = "model/recievemail/job1";
        String jobname = this.con_.getModelValue(modelId, base + "/@name");
        if (jobNameSet.contains(jobname)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.duplicate", new Object[]{jobname}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)jobname)) {
            return;
        }
        String jobdesc = this.con_.getModelValue(modelId, base + "/jobdesc");
        String jobrule_fire = this.con_.getModelValue(modelId, base + "/jobrule/@type=fire");
        String jobrule_success = this.con_.getModelValue(modelId, base + "/jobrule/@type=success");
        String jobrule_fail = this.con_.getModelValue(modelId, base + "/jobrule/@type=fail");
        String p_mailhost = this.con_.getModelValue(modelId, base + "/@mailhost");
        String p_user = this.con_.getModelValue(modelId, base + "/@user");
        String p_password = this.con_.getModelValue(modelId, base + "/@password");
        boolean p_apop = Utils.isSelectedValue(this.con_.getModelValue(modelId, base + "/@apop"));
        String p_protocol = this.con_.getModelValue(modelId, base + "/@protocol");
        String p_accept_address = this.con_.getModelValue(modelId, base + "/@acceptaddress");
        String p_subject = this.con_.getModelValue(modelId, base + "/@subject");
        String p_from = this.con_.getModelValue(modelId, base + "/@from");
        String p_to = this.con_.getModelValue(modelId, base + "/@to");
        String p_cc = this.con_.getModelValue(modelId, base + "/@cc");
        String p_date = this.con_.getModelValue(modelId, base + "/@date");
        String p_body = this.con_.getModelValue(modelId, base + "/@body");
        String p_attachment = this.con_.getModelValue(modelId, base + "/@attachment");
        String p_dataStartChar = this.con_.getModelValue(modelId, base + "/@dataStartChar");
        String p_dataEndChar = this.con_.getModelValue(modelId, base + "/@dataEndChar");
        String p_targetitems = this.con_.getModelValue(modelId, base + "/@targetitems");
        String jobclassname = subpackagename + "." + JobGeneratorUtil.getProcessorName((String)jobname);
        boolean isAnalyzeMailBody = false;
        isAnalyzeMailBody = !this.con_.existsKeyInModel(modelId, base + "/@isAnalyzeMailBody") ? true : Utils.isSelectedValue(this.con_.getModelValue(modelId, base + "/@isAnalyzeMailBody"));
        boolean zenkakuHankakuEqualFlag = false;
        if (this.con_.existsKeyInModel(modelId, base + "/@zenkakuHankakuEqualFlag") && StringUtils.isNotEmpty((CharSequence)(_value = this.con_.getModelValue(modelId, base + "/@zenkakuHankakuEqualFlag")))) {
            zenkakuHankakuEqualFlag = true;
        }
        Job job = new Job();
        job.setName(jobname);
        job.setClassname(jobclassname);
        job.setType("insertFromMail");
        job.setModel(modelId);
        this.addJobparam("mailhost", p_mailhost, job);
        this.addJobparam("user", p_user, job);
        this.addJobparam("password", p_password, job);
        if (p_apop) {
            this.addJobparam("APOP", "true", job);
        }
        if (p_protocol != null && StringUtils.isNotBlank((CharSequence)p_protocol)) {
            String protocol = ReceiveMailProtocolMap.get(p_protocol.toLowerCase());
            if (protocol != null) {
                this.addJobparam("protocol", protocol, job);
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.2", new Object[]{jobname, p_protocol}));
            }
        }
        this.addJobparam("allowFromAddress", p_accept_address, job);
        this.addJobrule("fire", jobrule_fire, job);
        this.addJobrule("success", jobrule_success, job);
        this.addJobrule("fail", jobrule_fail, job);
        this.addJobparam("analyzeBody", Boolean.toString(isAnalyzeMailBody), job);
        this.addJobparam("zenkakuHankakuEqualFlag", Boolean.toString(zenkakuHankakuEqualFlag), job);
        if (StringUtils.isNotBlank((CharSequence)p_dataStartChar)) {
            this.addJobparam("dataStartChar", p_dataStartChar, job);
        }
        if (StringUtils.isNotBlank((CharSequence)p_dataEndChar)) {
            this.addJobparam("dataEndChar", p_dataEndChar, job);
        }
        if (StringUtils.isNotBlank((CharSequence)p_targetitems)) {
            this.addJobparam("targetitems", p_targetitems, job);
        }
        this.addJobdesc(jobdesc, job);
        Model smodel = AppSchemaUtil.getStoreModel((Model)AppSchemaUtil.getModel((Project)project, (String)modelId));
        if (smodel == null) {
            list.add(job);
            return;
        }
        Model pmodel = AppSchemaUtil.getPresentationModel((Project)project, (Model)smodel);
        if (StringUtils.isNotBlank((CharSequence)p_from)) {
            Modelitem mitem_from = AppSchemaUtil.getModelitem((String)p_from, (Model)smodel);
            Modelitem pitem_from = AppSchemaUtil.getModelitem((String)p_from, (Model)pmodel);
            if (mitem_from == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.3", new Object[]{jobname, p_from}));
            } else if (!JavaSourceGenerator.isStringType((String)mitem_from.getType())) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.4", new Object[]{jobname, p_from}));
            } else if (!mitem_from.getMultiple()) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.5", new Object[]{jobname, p_from}));
            } else {
                this.addJobrule4setMail(SetMailContentType.FROM, pitem_from, job);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)p_to)) {
            Modelitem mitem_to = AppSchemaUtil.getModelitem((String)p_to, (Model)smodel);
            Modelitem pitem_to = AppSchemaUtil.getModelitem((String)p_to, (Model)pmodel);
            if (mitem_to == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.6", new Object[]{jobname, p_to}));
            } else if (!JavaSourceGenerator.isStringType((String)mitem_to.getType())) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.7", new Object[]{jobname, p_to}));
            } else if (!mitem_to.getMultiple()) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.8", new Object[]{jobname, p_to}));
            } else {
                this.addJobrule4setMail(SetMailContentType.TO, pitem_to, job);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)p_cc)) {
            Modelitem mitem_cc = AppSchemaUtil.getModelitem((String)p_cc, (Model)smodel);
            Modelitem pitem_cc = AppSchemaUtil.getModelitem((String)p_cc, (Model)pmodel);
            if (mitem_cc == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.9", new Object[]{jobname, p_cc}));
            } else if (!JavaSourceGenerator.isStringType((String)mitem_cc.getType())) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.10", new Object[]{jobname, p_cc}));
            } else if (!mitem_cc.getMultiple()) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.11", new Object[]{jobname, p_cc}));
            } else {
                this.addJobrule4setMail(SetMailContentType.CC, pitem_cc, job);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)p_date)) {
            Modelitem mitem_date = AppSchemaUtil.getModelitem((String)p_date, (Model)smodel);
            Modelitem pitem_date = AppSchemaUtil.getModelitem((String)p_date, (Model)pmodel);
            if (mitem_date == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.12", new Object[]{jobname, p_date}));
            } else if (mitem_date.getType().equals("date")) {
                this.addJobrule4setMail(SetMailContentType.SENTDATE, pitem_date, job);
            } else if (mitem_date.getType().equals("dateTime")) {
                this.addJobrule4setMail(SetMailContentType.SENTDATETIME, pitem_date, job);
            } else if (mitem_date.getType().equals("time")) {
                this.addJobrule4setMail(SetMailContentType.SENTTIME, pitem_date, job);
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.13", new Object[]{jobname, p_date}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)p_subject)) {
            Modelitem mitem_subject = AppSchemaUtil.getModelitem((String)p_subject, (Model)smodel);
            Modelitem pitem_subject = AppSchemaUtil.getModelitem((String)p_subject, (Model)pmodel);
            if (mitem_subject == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.14", new Object[]{jobname, p_subject}));
            } else if (!JavaSourceGenerator.isStringType((String)mitem_subject.getType())) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.15", new Object[]{jobname, p_subject}));
            } else {
                this.addJobrule4setMail(SetMailContentType.SUBJECT, pitem_subject, job);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)p_body)) {
            Modelitem mitem_body = AppSchemaUtil.getModelitem((String)p_body, (Model)smodel);
            Modelitem pitem_body = AppSchemaUtil.getModelitem((String)p_body, (Model)pmodel);
            if (mitem_body == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.16", new Object[]{jobname, p_body}));
            } else if (!JavaSourceGenerator.isStringType((String)mitem_body.getType())) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.17", new Object[]{jobname, p_body}));
            } else if (AppSchemaUtil.detectRichTextArea((Modelitem)mitem_body, (Model)smodel, (Project)project)) {
                this.addJobrule4setMail(SetMailContentType.BODY_RICH, pitem_body, job);
            } else {
                this.addJobrule4setMail(SetMailContentType.BODY, pitem_body, job);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)p_attachment)) {
            Modelitem mitem_attachment = AppSchemaUtil.getModelitem((String)p_attachment, (Model)smodel);
            Modelitem pitem_attachment = AppSchemaUtil.getModelitem((String)p_attachment, (Model)pmodel);
            String jshfilename_footer = "_jshfilename";
            Modelitem mitem_attachmentjshfilename = AppSchemaUtil.getModelitem((String)(p_attachment + "_jshfilename"), (Model)smodel);
            Modelitem pitem_attachmentjshfilename = AppSchemaUtil.getModelitem((String)(p_attachment + "_jshfilename"), (Model)pmodel);
            if (mitem_attachment == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.18", new Object[]{jobname, p_attachment}));
            } else if (!mitem_attachment.getType().equals("string") || mitem_attachmentjshfilename == null || !mitem_attachmentjshfilename.getType().equals("string") || pitem_attachmentjshfilename == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_receiveMailJob.error.19", new Object[]{jobname, p_attachment}));
            } else {
                this.addJobrule4setMail(SetMailContentType.ATTACHMENT, pitem_attachment, job);
                this.addJobrule4setMail(SetMailContentType.ATTACHMENTJSHFILENAME, pitem_attachmentjshfilename, job);
            }
        }
        list.add(job);
    }

    private void process_sendMailJob(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
        String subpackagename = project.getPackage() + ".app." + modelId;
        for (int i = 1; i <= 10; ++i) {
            String p_waitTime;
            String base = "model/sendmail/job" + i;
            String jobname = this.con_.getModelValue(modelId, base + "/@name");
            if (jobNameSet.contains(jobname)) {
                this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.duplicate", new Object[]{jobname}));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)jobname)) continue;
            jobNameSet.add(jobname);
            String jobdesc = this.con_.getModelValue(modelId, base + "/jobdesc");
            String jobrule_fire = this.con_.getModelValue(modelId, base + "/jobrule/@type=fire");
            String jobrule_success = this.con_.getModelValue(modelId, base + "/jobrule/@type=success");
            String jobrule_fail = this.con_.getModelValue(modelId, base + "/jobrule/@type=fail");
            String p_to = this.con_.getModelValue(modelId, base + "/@to");
            String jobclassname = subpackagename + "." + JobGeneratorUtil.getProcessorName((String)jobname);
            Job job = new Job();
            job.setName(jobname);
            job.setClassname(jobclassname);
            job.setType("sendMail");
            job.setModel(modelId);
            String mid = null;
            mid = StringUtils.isNotBlank((CharSequence)p_to) && p_to.startsWith("TEMPLATE(\"") && p_to.endsWith("\")") ? p_to.substring("TEMPLATE(\"".length(), p_to.length() - "\")".length()).trim() : jobname;
            this.addJobparam("mid", mid, job);
            this.addJobrule("fire", jobrule_fire, job);
            this.addJobrule("success", jobrule_success, job);
            this.addJobrule("fail", jobrule_fail, job);
            this.addJobdesc(jobdesc, job);
            String p_waitCount = this.con_.getModelValue(modelId, base + "/@waitCount");
            if (StringUtils.isNotBlank((CharSequence)p_waitCount)) {
                if (StringUtils.isNumeric((CharSequence)p_waitCount)) {
                    this.addJobparam("waitCount", p_waitCount, job);
                } else {
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_sendMailJob.error.2", new Object[]{jobname}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(p_waitTime = this.con_.getModelValue(modelId, base + "/@waitTime")))) {
                if (StringUtils.isNumeric((CharSequence)p_waitTime)) {
                    int __waitTime = StringUtil.intValue((String)p_waitTime);
                    this.addJobparam("waitTime", String.valueOf(__waitTime *= 1000), job);
                } else {
                    this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_sendMailJob.error.3", new Object[]{jobname}));
                }
            }
            list.add(job);
        }
    }

    private void process_callsql(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
    }

    private void process_alertMailJob(Project project, List<Job> list) {
        Job job = this.createJob(project);
        job.setName("AlertMailFromLog");
        job.setClassname("jp.jasminesoft.jfc.job.AlertMailFromLogJob");
        job.setType("alertmail");
        this.addJobdesc(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.process_alertMailJob"), job);
        list.add(job);
    }

    public static String getUploadUpdateJobname(ElementContainer con_, String modelId) {
        String base = UploadUpdateJobRepositoryKeyBase;
        String jobenable = con_.getModelValue(modelId, UploadUpdateJobRepositoryKeyBase);
        Object jobname = StringUtils.isNotBlank((CharSequence)jobenable) ? "UploadUpdate" + StringUtil.capFirst((String)modelId) + "Job" : (Utils.isUploadUpdateOutput(modelId, con_) && (Utils.isAutoScaling(con_) || Utils.isMicroservice(con_)) ? "UploadUpdate" + StringUtil.capFirst((String)modelId) + "Job" : con_.getModelValue(modelId, "model/uploadupdate/job/@name"));
        return jobname;
    }

    public static boolean isUseUploadUpdateJob(ElementContainer con_, String modelId) {
        String jobname = BJob.getUploadUpdateJobname(con_, modelId);
        return !StringUtils.isBlank((CharSequence)jobname);
    }

    private void process_uploadUpdateJob(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
        String jobname;
        if (Utils.isUploadUpdateOutput(modelId, this.con_) && !BActionElement_messagejob.isEnableUploadUpdate(this.con_, modelId, ActionType.uploadUpdate)) {
            this.process_uploadUpdateJobThread(modelId, jobNameSet, project, list);
        }
        if (StringUtils.isNotBlank((CharSequence)(jobname = BJob.getUploadUpdateJobname(this.con_, modelId)))) {
            this.process_uploadUpdateJobSchedule(modelId, jobNameSet, project, list, jobname);
        }
    }

    private void process_uploadUpdateJobThread(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
        String jobname = AppSchemaUtil.getProcessBeanRunnableClassname((String)modelId, (String)"uploadUpdate", null, (Project)project);
        if (jobNameSet.contains(jobname)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.duplicate", new Object[]{jobname}));
            return;
        }
        jobNameSet.add(jobname);
        Job job = new Job();
        job.setName(jobname);
        job.setClassname("");
        job.setType("uploadUpdateThread");
        job.setModel(modelId);
        list.add(job);
    }

    private void process_uploadUpdateJobSchedule(String modelId, Set<String> jobNameSet, Project project, List<Job> list, String jobname) {
        String base = UploadUpdateJobRepositoryKeyBase;
        if (jobNameSet.contains(jobname)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.duplicate", new Object[]{jobname}));
            return;
        }
        jobNameSet.add(jobname);
        String jobdesc = this.con_.getModelValue(modelId, "model/uploadupdate/job/jobdesc");
        String jobclassname = "jp.jasminesoft.jfc.job.UploadUpdateJob";
        Job job = new Job();
        job.setName(jobname);
        job.setClassname(jobclassname);
        job.setType("uploadUpdate");
        job.setModel(modelId);
        this.addJobdesc(jobdesc, job);
        boolean isLockModel = this.isLockModel(modelId);
        this.addJobparam("isLockModel", Boolean.toString(isLockModel), job);
        this.addJobparam("status", "uploadUpdate" + StringUtil.capFirst((String)modelId), job);
        this.addJobparam("modelId", modelId, job);
        this.addJobparam("monitorBeanId", "UploadUpdate" + StringUtil.capFirst((String)modelId) + "ProcessBeanRunnable", job);
        this.addJobparamValueRef("errorManager", "errorManager", job);
        list.add(job);
    }

    private boolean isLockModel(String modelId) {
        return !BActionElement_uploadupdate.isLocktypeRecord(this.con_, modelId);
    }

    public static String getDownloadJobname(ElementContainer con_, String modelId) {
        String base = DownloadJobRepositoryKeyBase;
        String jobenable = con_.getModelValue(modelId, DownloadJobRepositoryKeyBase);
        Object jobname = StringUtils.isNotBlank((CharSequence)jobenable) ? "Download" + StringUtil.capFirst((String)modelId) + "Job" : con_.getModelValue(modelId, "model/download/job/@name");
        return jobname;
    }

    public static boolean isUseDownloadJob(ElementContainer con_, String modelId) {
        String jobname = BJob.getDownloadJobname(con_, modelId);
        return !StringUtils.isBlank((CharSequence)jobname);
    }

    private void process_downloadJob(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
        String base = DownloadJobRepositoryKeyBase;
        String jobname = BJob.getDownloadJobname(this.con_, modelId);
        if (StringUtils.isBlank((CharSequence)jobname)) {
            return;
        }
        if (jobNameSet.contains(jobname)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.duplicate", new Object[]{jobname}));
            return;
        }
        jobNameSet.add(jobname);
        String jobdesc = this.con_.getModelValue(modelId, "model/download/job/jobdesc");
        String jobclassname = "jp.jasminesoft.jfc.job.DownloadJob";
        Job job = new Job();
        job.setName(jobname);
        job.setClassname(jobclassname);
        job.setType("download");
        job.setModel(modelId);
        this.addJobdesc(jobdesc, job);
        this.addJobparam("processBeanId", "Download" + StringUtil.capFirst((String)modelId) + "ProcessBean", job);
        list.add(job);
    }

    public static String getReportListJobname(ElementContainer con_, String modelId) {
        String base = ReportListJobRepositoryKeyBase;
        String jobenable = con_.getModelValue(modelId, ReportListJobRepositoryKeyBase);
        Object jobname = StringUtils.isNotBlank((CharSequence)jobenable) ? "ReportList" + StringUtil.capFirst((String)modelId) + "Job" : con_.getModelValue(modelId, "model/reportlist/job/@name");
        return jobname;
    }

    public static boolean isUseReportListJob(ElementContainer con_, String modelId) {
        String jobname = BJob.getReportListJobname(con_, modelId);
        return !StringUtils.isBlank((CharSequence)jobname);
    }

    private void process_reportListJob(String modelId, Set<String> jobNameSet, Project project, List<Job> list) {
        String base = ReportListJobRepositoryKeyBase;
        String jobname = BJob.getReportListJobname(this.con_, modelId);
        if (StringUtils.isBlank((CharSequence)jobname)) {
            return;
        }
        if (jobNameSet.contains(jobname)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.job.BJob.duplicate", new Object[]{jobname}));
            return;
        }
        jobNameSet.add(jobname);
        String jobdesc = this.con_.getModelValue(modelId, "model/reportlist/job/jobdesc");
        String jobclassname = "jp.jasminesoft.jfc.job.ReportListJob";
        Job job = new Job();
        job.setName(jobname);
        job.setClassname(jobclassname);
        job.setType("reportList");
        job.setModel(modelId);
        this.addJobdesc(jobdesc, job);
        this.addJobparam("reportListServiceBeanId", StringUtil.capFirst((String)modelId) + "ReportListService", job);
        list.add(job);
    }

    private Job createJob(Project project) {
        Param[] params;
        Job job = new Job();
        Environment env = project.getEnvironment();
        Init init = AppSchemaUtil.getInit((Environment)env);
        for (Param param : params = init.getParam()) {
            String key = param.getKey();
            if (!"mailhost".equals(key)) continue;
            this.addJobparam("mail:host", param.getValue(), job);
        }
        return job;
    }

    private void addJobparam(String key, String content, Job job) {
        this.addJobparam(key, content, job, true);
    }

    private void addJobparam(String key, String content, Job job, boolean useSpringContext) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        Jobparam jobparam = new Jobparam();
        jobparam.setKey(key);
        jobparam.setContent(content);
        if (!useSpringContext) {
            jobparam.setUseSpringContext(false);
        }
        job.addContent((IJobChoice)jobparam);
    }

    private void addJobparamValueRef(String key, String valueRef, Job job) {
        if (StringUtils.isBlank((CharSequence)valueRef)) {
            return;
        }
        Jobparam jobparam = new Jobparam();
        jobparam.setKey(key);
        jobparam.setValueRef(valueRef);
        job.addContent((IJobChoice)jobparam);
    }

    private void addJobrule(String type, String content, Job job) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        Jobrule jobrule = new Jobrule();
        jobrule.setType(type);
        jobrule.setContent(content);
        job.addContent((IJobChoice)jobrule);
    }

    private void addJobrule4setMail(SetMailContentType type, Modelitem pitem, Job job) {
        Object name;
        Object object = name = pitem != null ? pitem.getName() : null;
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        Jobrule jobrule = new Jobrule();
        jobrule.setType("init");
        if (!((String)name).startsWith("${")) {
            name = "${" + (String)name;
        }
        if (!((String)name).endsWith("}")) {
            name = (String)name + "}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)name);
        sb.append("=");
        sb.append("MAIL.");
        sb.append((Object)type);
        if (type == SetMailContentType.SUBJECT || type == SetMailContentType.BODY || type == SetMailContentType.BODY_RICH || type == SetMailContentType.FROM || type == SetMailContentType.TO || type == SetMailContentType.CC || type == SetMailContentType.BCC || type == SetMailContentType.ATTACHMENT || type == SetMailContentType.ATTACHMENTJSHFILENAME) {
            sb.append("-").append(pitem.getFilter());
        }
        jobrule.setContent(sb.toString());
        job.addContent((IJobChoice)jobrule);
    }

    private void addJobdesc(String content, Job job) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        Jobdesc jobdesc = new Jobdesc();
        jobdesc.setContent(content);
        job.addContent((IJobChoice)jobdesc);
    }

    private void process_customize(Project project, List<Job> list) {
        try {
            this._process_customize(project, list);
        }
        catch (IOException e) {
            logger.error("failed read customize dir", (Throwable)e);
        }
    }

    private void _process_customize(Project project, List<Job> list) throws IOException {
        String customizedir = ((WagbyR6DefElementContainer)this.getElementContainer()).getCustomizeDirectory();
        Path customizejavapath = Paths.get(customizedir, "java");
        HashSet<String> existsBeanId = new HashSet<String>();
        HashSet<String> existsJobClass = new HashSet<String>();
        this.getExistsCustomizeBean(customizedir, existsBeanId, existsJobClass);
        String _package = project.getPackage();
        logger.debug("_package " + _package);
        String[] packagedir = _package.split("\\.");
        Path jobpath = customizejavapath;
        for (String path2 : packagedir) {
            jobpath = jobpath.resolve(path2);
        }
        if (!Files.isDirectory(jobpath = jobpath.resolve("job"), new LinkOption[0])) {
            logger.debug("not directory " + jobpath.toString());
            return;
        }
        Files.list(jobpath).filter(path -> {
            if (path.getFileName().toString().endsWith("Job.java")) {
                logger.debug("true path " + path);
                return true;
            }
            logger.debug("false path " + path);
            return false;
        }).forEach(path -> {
            String jobname = path.getFileName().toString().replace(".java", "");
            String jobclassname = _package + ".job." + jobname;
            if (existsBeanId.contains(jobname)) {
                return;
            }
            if (existsJobClass.contains(jobclassname)) {
                return;
            }
            Job job = new Job();
            job.setName(jobname);
            job.setClassname(jobclassname);
            job.setType("customize");
            String taskfilename = path.getFileName().toString().replace("Job.java", "Task.java");
            Path taskfile = path.getParent().resolve(taskfilename);
            if (Files.exists(taskfile, new LinkOption[0])) {
                String taskname = taskfilename.replace(".java", "");
                Jobparam jobparam = new Jobparam();
                jobparam.setKey(taskname);
                jobparam.setValueRef(taskname);
                job.addContent((IJobChoice)jobparam);
                if (!existsBeanId.contains(jobname)) {
                    String taskclassname = _package + ".job." + taskname;
                    Usebean usebean = new Usebean();
                    usebean.setId(taskname);
                    usebean.setClassname(taskclassname);
                    job.addContent((IJobChoice)usebean);
                }
            }
            logger.debug("job " + job);
            list.add(job);
        });
    }

    private void getExistsCustomizeBean(String customizedir, Set<String> existsBeanId, Set<String> existsJobClass) throws IOException {
        DocumentBuilder db;
        Path customizeappctxpath = Paths.get(customizedir, "webapp", "WEB-INF", "applicationContext");
        if (!Files.isDirectory(customizeappctxpath, new LinkOption[0])) {
            logger.debug("not directory customize appctx path " + customizeappctxpath.toString());
            return;
        }
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("parse configuration error", (Throwable)e);
            return;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        String xpathStrBeanId = "//bean/@id";
        String xpathStrJobClass = "//bean/property[@name=\"jobClass\"]/value/text()";
        Files.list(customizeappctxpath).filter(path -> {
            if (path.getFileName().toString().endsWith(".xml")) {
                logger.debug("true path " + path);
                return true;
            }
            logger.debug("false path " + path);
            return false;
        }).forEach(path -> {
            Node node;
            int i;
            NodeList nlJobClass;
            NodeList nlBeanId;
            try {
                Document doc = db.parse(path.toFile());
                nlBeanId = (NodeList)xpath.evaluate("//bean/@id", doc, XPathConstants.NODESET);
                nlJobClass = (NodeList)xpath.evaluate("//bean/property[@name=\"jobClass\"]/value/text()", doc, XPathConstants.NODESET);
            }
            catch (Exception e) {
                logger.error("xml parse error", (Throwable)e);
                return;
            }
            int num = nlBeanId.getLength();
            for (i = 0; i < num; ++i) {
                node = nlBeanId.item(i);
                if (node.getNodeType() != 2) continue;
                logger.debug("bean id value " + node.getNodeValue());
                existsBeanId.add(node.getNodeValue());
            }
            num = nlJobClass.getLength();
            for (i = 0; i < num; ++i) {
                node = nlJobClass.item(i);
                if (node.getNodeType() != 3) continue;
                logger.debug("jobClass value " + node.getNodeValue());
                existsJobClass.add(node.getNodeValue());
            }
        });
    }

    static {
        for (String[] p : ReceiveMailProtocol) {
            ReceiveMailProtocolMap.put(p[0].toLowerCase(), p[1]);
        }
        for (String[] p : SendMailProtocol) {
            SendMailProtocolMap.put(p[0].toLowerCase(), p[1]);
        }
        logger = LogManager.getLogger(BJob.class);
    }

    public static enum SetMailContentType {
        FROM,
        TO,
        CC,
        BCC,
        SENTDATE,
        SENTTIME,
        SENTDATETIME,
        SUBJECT,
        BODY,
        BODY_RICH,
        ATTACHMENT,
        ATTACHMENTJSHFILENAME;

    }
}

