/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.model;

import java.util.List;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Buttonfield;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.BaseConverter;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PUtils;
import org.springframework.stereotype.Component;

@Component(value="BButtonfield")
public class BButtonfield
extends BaseConverter {
    public void create(String modelId, Model lpmodel, Project project) {
        if (lpmodel.getId().endsWith("_lp")) {
            this.setButtonfieldShowList(modelId, lpmodel);
        } else if (lpmodel.getId().endsWith("_ulp")) {
            this.setButtonfieldUpdateList(modelId, lpmodel);
        }
    }

    private void setButtonfieldShowList(String modelId, Model lpmodel) {
        List<Link> links = PUtils.getLinkShowListRows(modelId, this.con_);
        int origcnt = 1;
        for (Link link : links) {
            if (link.getAction() == null || link.getType() == null || !"button".equals(link.getType()) && !"action".equals(link.getType())) continue;
            Buttonfield bf = new Buttonfield();
            if (link.getOriginal()) {
                bf.setName("jfcButtonFieldOriginal" + origcnt++);
            } else {
                bf.setName("jfcButtonField" + link.getAction());
            }
            bf.setLink(link);
            lpmodel.addContent((IModelChoice)bf);
        }
    }

    private void setButtonfieldUpdateList(String modelId, Model ulpmodel) {
        Buttonfield bf;
        Link link;
        String capitalizedModelId = SourceGenerator.capFirst((String)modelId);
        if (this.isUpdateListUseCopyButton(modelId)) {
            link = new Link();
            link.setType("button");
            link.setAction("Copy");
            link.setForward("copy" + capitalizedModelId);
            link.setLabel("\u30b3\u30d4\u30fc");
            link.setIconClass("dijitIconCopy");
            bf = new Buttonfield();
            bf.setName("jfcButtonFieldCopy");
            bf.setLink(link);
            ulpmodel.addContent((IModelChoice)bf);
        }
        if (this.isUpdateListUseInsert(modelId)) {
            link = new Link();
            link.setType("button");
            link.setAction("Insert");
            link.setForward("insert" + capitalizedModelId);
            link.setLabel("\u767b\u9332");
            link.setIconClass("dijitIconNewTask");
            bf = new Buttonfield();
            bf.setName("jfcButtonFieldInsert");
            bf.setLink(link);
            ulpmodel.addContent((IModelChoice)bf);
        }
    }

    protected boolean isUpdateListUseInsert(String modelId) {
        boolean isUseInsert = Utils.isSelectedValue(this.con_.getModelValue(modelId, "action/updatelist/@use_insert"));
        return isUseInsert;
    }

    protected boolean isUpdateListUseCopyButton(String modelId) {
        boolean isUseCopyButton = Utils.isUpdateListUseCopyButton(modelId, this.con_);
        return isUseCopyButton;
    }
}

