/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.KeyRule;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.BaseConverter;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.IType;
import jp.jasminesoft.jfc.tools.xls2appschema.MessageListener;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;

@Component(value="BPrimaryKey")
public class BPrimaryKey
extends BaseConverter {
    private static final Logger logger = LogManager.getLogger(BPrimaryKey.class);
    private static final Integer DEFAULT_AUTOID_START = 1000;
    private static final String ID_XPATH_EXPR = "/*/id/text()";

    public void create(String modelId, Model smodel, Project project) {
        String[] names;
        boolean findPrimaryKeyFlag = false;
        for (String name : names = this.con_.getModelitemNames(modelId)) {
            String mainmodelidref;
            String pkey = this.con_.getModelitemValue(modelId, name, "model/modelitem/@primaryKey");
            if (StringUtils.isBlank((CharSequence)pkey) || !BPrimaryKey.check(smodel, modelId, name, this.con_, this.getMessageListener(), rman.getValue("r.model.modelitem.primaryKey"))) continue;
            Modelitem sitem = AppSchemaUtil.getModelitem((String)name, (Model)smodel);
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setName(name);
            boolean isBranch = Utils.isBranchId(modelId, name, this.con_);
            if (isBranch) {
                primaryKey.setBranch(true);
            }
            if (StringUtils.isNotBlank((CharSequence)(mainmodelidref = this.con_.getModelValue(modelId, "model/@mainmodelidref")))) {
                this.setAutoidSettings(mainmodelidref, name, primaryKey, sitem, false);
            } else {
                this.setAutoidSettings(modelId, name, primaryKey, sitem, true);
            }
            this.printKeyRuleForPrimaryKey(primaryKey, modelId, name);
            int ptr = 0;
            int size = smodel.sizeContent();
            for (int i = 0; i < size; ++i) {
                IModelChoice imc = smodel.getContent(i);
                if (imc instanceof PrimaryKey) continue;
                ptr = i;
                break;
            }
            smodel.addContent(ptr, (IModelChoice)primaryKey);
            findPrimaryKeyFlag = true;
        }
        if (!findPrimaryKeyFlag) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.create", new Object[]{modelId}));
        }
    }

    public static boolean check(Model smodel, String modelId, String name, ElementContainer con, MessageListener msglistener, String desc) {
        String type = con.getModelitemValue(modelId, name, "model/modelitem/@type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String detailType = IType.getIType(type);
            if ("special-container".equals(detailType)) {
                msglistener.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.check.1", new Object[]{modelId, desc, name}));
                return false;
            }
            if ("special-containerid".equals(detailType)) {
                msglistener.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.check.2", new Object[]{modelId, desc, name}));
                return false;
            }
        }
        if (AppSchemaUtil.hasChildPart((String)name)) {
            msglistener.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.check.3", new Object[]{modelId, desc, name, AppSchemaUtil.getParentPart((String)name)}));
            return false;
        }
        Modelitem sitem = AppSchemaUtil.getModelitem((String)name, (Model)smodel);
        if (sitem != null && sitem.getMultiple()) {
            msglistener.error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.check.4", new Object[]{modelId, desc, name}));
            return false;
        }
        return !Utils.isSelectedValue(con.getModelitemValue(modelId, name, "model/modelitem/@generation"));
    }

    private void setAutoidSettings(String modelId, String name, PrimaryKey primaryKey, Modelitem sitem, boolean isOutputErrMsg) {
        String start;
        boolean autoid = Utils.isSelectedValue(this.con_.getModelitemValue(modelId, name, "model/primaryKey/@autoid"));
        if (autoid) {
            String f_model = Utils.getForeignKey(modelId, name, this.con_);
            if (StringUtils.isNotBlank((CharSequence)f_model)) {
                this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.setAutoidSettings.1", new Object[]{modelId, name, f_model}));
                return;
            }
            String sitem_type = sitem.getType();
            if (!JavaSourceGenerator.isBasicType((String)sitem_type) && !"string".equals(sitem_type)) {
                if (isOutputErrMsg) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.setAutoidSettings.2", new Object[]{modelId, name}));
                }
            } else {
                boolean useNotAutoidAtCopy;
                primaryKey.setAutoid(true);
                primaryKey.setUseseq(modelId + "_" + name + "_seq");
                Integer start2 = this.getAutoidStart(modelId, name);
                if (start2 == null) {
                    if (isOutputErrMsg) {
                        this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BPrimaryKey.setAutoidSettings.3", new Object[]{modelId, name, start2}));
                    }
                } else {
                    primaryKey.setStart(start2);
                }
                if (useNotAutoidAtCopy = Utils.isSelectedValue(this.con_.getModelitemValue(modelId, name, "model/primaryKey/@notUseAutoidAtCopyInsert"))) {
                    primaryKey.setUseAutoidAtCopy(false);
                }
            }
        }
        if (!autoid && primaryKey.getBranch() && StringUtils.isNotBlank((CharSequence)(start = this.con_.getModelitemValue(modelId, name, "model/primaryKey/@start"))) && Utils.isInteger(start)) {
            int start_ = StringUtil.intValue((String)start);
            if (Utils.isBeforeDefFileVersion(this.con_.getWagbyDefFileVersion(modelId), "6.6.Update09")) {
                if (start_ == 1000) {
                    primaryKey.setStart(1);
                } else {
                    primaryKey.setStart(start_);
                }
            } else {
                primaryKey.setStart(start_);
            }
        }
    }

    private Integer getAutoidStart(String modelId, String name) {
        int audoidstart;
        File savedir = this.con_.getInitialDataSaveDir(modelId);
        int initdatamaxid = Integer.MIN_VALUE;
        if (savedir != null) {
            try {
                initdatamaxid = this.getMaxIdInInitdata(savedir) + 1;
            }
            catch (XPathExpressionException e) {
                logger.error("XPathExpressionException", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                logger.error("IOException", (Throwable)e);
                return null;
            }
        }
        int pkeystart = Integer.MIN_VALUE;
        String start = this.con_.getModelitemValue(modelId, name, "model/primaryKey/@start");
        if (StringUtils.isNotBlank((CharSequence)start)) {
            if (!Utils.isInteger(start)) {
                logger.error("failed not integer " + start);
                return null;
            }
            pkeystart = StringUtil.intValue((String)start);
        }
        if ((audoidstart = Math.max(initdatamaxid, pkeystart)) == Integer.MIN_VALUE) {
            return DEFAULT_AUTOID_START;
        }
        return audoidstart;
    }

    private int getMaxIdInInitdata(File src) throws XPathExpressionException, IOException {
        if (!src.isDirectory()) {
            throw new RuntimeException("File " + src + " is not directory");
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(ID_XPATH_EXPR);
        try (Stream<Path> stream = Files.list(src.toPath());){
            int n = stream.mapToInt(srcFile -> {
                try {
                    String value = expr.evaluate(new InputSource(srcFile.toString()));
                    return Integer.parseInt(value);
                }
                catch (XPathExpressionException e) {
                    logger.debug("XPathExpressionException", (Throwable)e);
                    return Integer.MIN_VALUE;
                }
                catch (IllegalArgumentException e) {
                    logger.debug("IllegalArgumentException", (Throwable)e);
                    return Integer.MIN_VALUE;
                }
            }).max().orElse(Integer.MIN_VALUE);
            return n;
        }
    }

    private void printKeyRuleForPrimaryKey(PrimaryKey primaryKey, String modelId, String name) {
        KeyRule keyRule;
        String detailType;
        String type = this.con_.getModelitemValue(modelId, name, "model/modelitem/@type");
        if (StringUtils.isNotBlank((CharSequence)type) && !"string".equals(detailType = IType.getIType(type)) && !detailType.startsWith("special-")) {
            return;
        }
        String format = this.con_.getModelitemValue(modelId, name, "model/primaryKey/keyRule/@format");
        String formatUserSetting = this.con_.getModelitemValue(modelId, name, "model/primaryKey/keyRule/@formatUserSetting");
        String prefix = this.con_.getModelitemValue(modelId, name, "model/primaryKey/keyRule/@type=prefix");
        if (prefix == null) {
            prefix = "";
        }
        String yearkind = this.con_.getModelitemValue(modelId, name, "model/primaryKey/keyRule/yearkind");
        String formatSeparator = this.con_.getModelitemValue(modelId, name, "model/primaryKey/keyRule/@formatSeparator");
        if (formatSeparator == null) {
            formatSeparator = "";
        }
        String padding = this.con_.getModelitemValue(modelId, name, "model/primaryKey/keyRule/@type=padding");
        if (StringUtils.isBlank((CharSequence)prefix) && StringUtils.isBlank((CharSequence)padding) && StringUtils.isBlank((CharSequence)format) && StringUtils.isNotBlank((CharSequence)formatUserSetting)) {
            keyRule = new KeyRule();
            keyRule.setType("free");
            keyRule.setContent(formatUserSetting);
            primaryKey.setKeyRule(keyRule);
        } else if (StringUtils.isNotBlank((CharSequence)formatUserSetting)) {
            keyRule = new KeyRule();
            keyRule.setType("prefix");
            keyRule.setFormat(formatUserSetting);
            keyRule.setContent(this.printYearkind(yearkind));
            primaryKey.setKeyRule(keyRule);
        } else if (StringUtils.isNotBlank((CharSequence)format)) {
            keyRule = new KeyRule();
            keyRule.setType("prefix");
            if (ropt.getValue("OPTION_model_primaryKey_keyRule_format_1_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_6_value").equals(format)) {
                keyRule.setContent(prefix + formatSeparator);
            } else if (ropt.getValue("OPTION_model_primaryKey_keyRule_format_3_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_8_value").equals(format)) {
                keyRule.setFormat("{6}{1,number,integer}" + formatSeparator);
            } else if (ropt.getValue("OPTION_model_primaryKey_keyRule_format_2_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_7_value").equals(format)) {
                keyRule.setFormat("{5}{1,number,integer}" + formatSeparator);
            } else if (ropt.getValue("OPTION_model_primaryKey_keyRule_format_4_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_9_value").equals(format)) {
                keyRule.setFormat("{7}{1,number,integer}" + formatSeparator);
            } else if (ropt.getValue("OPTION_model_primaryKey_keyRule_format_5_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_10_value").equals(format)) {
                keyRule.setFormat("yyyy" + formatSeparator);
            } else {
                keyRule.setFormat("{6}{1,number,integer}-");
            }
            if (ropt.getValue("OPTION_model_primaryKey_keyRule_format_3_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_8_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_2_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_7_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_4_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_9_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_5_value").equals(format) || ropt.getValue("OPTION_model_primaryKey_keyRule_format_10_value").equals(format)) {
                keyRule.setContent(this.printYearkind(yearkind));
            }
            primaryKey.addKeyRule(keyRule);
        }
        if (StringUtils.isNotBlank((CharSequence)padding)) {
            keyRule = new KeyRule();
            keyRule.setType("padding");
            keyRule.setContent(padding);
            primaryKey.addKeyRule(keyRule);
        }
    }

    private String printYearkind(String yearkind) {
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_yearkind_1_value").equals(yearkind)) {
            return "fiscalYear";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_1_value").equals(yearkind)) {
            return "fiscalYear:1";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_2_value").equals(yearkind)) {
            return "fiscalYear:2";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_3_value").equals(yearkind)) {
            return "fiscalYear:3";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_4_value").equals(yearkind)) {
            return "fiscalYear:4";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_5_value").equals(yearkind)) {
            return "fiscalYear:5";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_6_value").equals(yearkind)) {
            return "fiscalYear:6";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_7_value").equals(yearkind)) {
            return "fiscalYear:7";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_8_value").equals(yearkind)) {
            return "fiscalYear:8";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_9_value").equals(yearkind)) {
            return "fiscalYear:9";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_10_value").equals(yearkind)) {
            return "fiscalYear:10";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_11_value").equals(yearkind)) {
            return "fiscalYear:11";
        }
        if (ropt.getValue("OPTION_model_primaryKey_keyRule_fiscalYear_12_value").equals(yearkind)) {
            return "fiscalYear:12";
        }
        return "normalYear";
    }
}

