/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Autocalc;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BModelitemProcessor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="autocalc")
public class BStoreModelitem_autocalc
extends BModelitemProcessor {
    private static String[] funcnames = new String[]{"sum", "count", "avg", "max", "min", "first", "last", "join", "slice", "djoin", "ddjoin", "isnoselection", "collect"};

    @Override
    public void process(String modelId, String detailType, Modelitem sitem, Model smodel, Project project) {
        String autocalc_type = this.con_.getModelitemValue(modelId, sitem.getName(), "model/modelitem/autocalc");
        Object autocalc_text = this.con_.getModelitemValue(modelId, sitem.getName(), "model/modelitem/autocalc_2");
        if (StringUtils.isBlank((CharSequence)autocalc_type) || StringUtils.isBlank((CharSequence)autocalc_text)) {
            return;
        }
        String type = sitem.getType();
        String errmsg = null;
        Autocalc autocalc = new Autocalc();
        if (ropt.getValue("OPTION_model_modelitem_autocalc_1_value").equals(autocalc_type)) {
            autocalc.setType("operation");
        } else if (ropt.getValue("OPTION_model_modelitem_autocalc_2_value").equals(autocalc_type)) {
            autocalc.setType("operation");
            autocalc_text = "DATEDIF(${" + (String)autocalc_text + "}, TODAY() ,\"Y\")";
            if (!JavaSourceGenerator.isBasicType((String)type) && !"storeref".equals(type)) {
                errmsg = new CreateErrorMsg(modelId, sitem.getName(), (String)autocalc_text){

                    @Override
                    protected String getReason() {
                        return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.process.1");
                    }
                }.process();
            }
        } else if (ropt.getValue("OPTION_model_modelitem_autocalc_3_value").equals(autocalc_type)) {
            String[] tokens = ((String)autocalc_text).split(",");
            if (tokens != null && tokens.length == 2) {
                autocalc.setType("operation");
                autocalc_text = "BETWEENTIME(${" + tokens[0] + "}, ${" + tokens[1] + "})";
            } else {
                errmsg = new CreateErrorMsg(modelId, sitem.getName(), (String)autocalc_text){

                    @Override
                    protected String getReason() {
                        return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.process.2");
                    }
                }.process();
                autocalc_text = null;
            }
            if (!JavaSourceGenerator.isDateOrTimeType((String)type) && !"storeref".equals(type)) {
                errmsg = new CreateErrorMsg(modelId, sitem.getName(), (String)autocalc_text){

                    @Override
                    protected String getReason() {
                        return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.process.3");
                    }
                }.process();
            }
        } else if (ropt.getValue("OPTION_model_modelitem_autocalc_4_value").equals(autocalc_type)) {
            autocalc.setType("padding");
            if (!JavaSourceGenerator.isStringType((String)type) && !"storeref".equals(type)) {
                errmsg = new CreateErrorMsg(modelId, sitem.getName(), (String)autocalc_text){

                    @Override
                    protected String getReason() {
                        return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.process.4");
                    }
                }.process();
            }
        }
        autocalc.setContent(this.forceTypeConversion(type, (String)autocalc_text));
        if (this.isValidExpresssion(modelId, sitem, autocalc, smodel, project)) {
            sitem.addContent((IModelitemChoice)autocalc);
        }
        if (errmsg != null) {
            this.getMessageListener().error(errmsg);
        }
    }

    private String forceTypeConversion(String type, String expr) {
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return expr;
        }
        if ("string".equals(type) || "zipcode".equals(type)) {
            expr = "TOSTR(" + (String)expr + ")";
        } else if ("int".equals(type)) {
            expr = "TOINTW(" + (String)expr + ")";
        } else if ("long".equals(type)) {
            expr = "TOLONGW(" + (String)expr + ")";
        } else if ("double".equals(type)) {
            expr = "TODOUBLEW(" + (String)expr + ")";
        } else if ("date".equals(type)) {
            expr = "TODATE(" + (String)expr + ")";
        } else if ("time".equals(type)) {
            expr = "TOTIME(" + (String)expr + ")";
        } else if ("dateTime".equals(type)) {
            expr = "TODATETIME(" + (String)expr + ")";
        } else if ("float".equals(type)) {
            expr = "TOFLOATW(" + (String)expr + ")";
        } else if ("short".equals(type)) {
            expr = "TOSHORTW(" + (String)expr + ")";
        } else if ("byte".equals(type)) {
            expr = "TOBYTEW(" + (String)expr + ")";
        } else if ("boolean".equals(type)) {
            expr = "TOBOOLEANW(" + (String)expr + ")";
        }
        return expr;
    }

    private boolean isValidExpresssion(String modelId, Modelitem sitem, Autocalc autocalc, Model model, Project project) {
        String cnt = autocalc.getContent();
        String type = autocalc.getType();
        String errmsg = null;
        if (StringUtils.isBlank((CharSequence)type)) {
            errmsg = new CreateErrorMsg(modelId, sitem.getName(), cnt){

                @Override
                protected String getReason() {
                    return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpresssion.1");
                }
            }.process();
        }
        if (StringUtils.isBlank((CharSequence)cnt)) {
            errmsg = new CreateErrorMsg(modelId, sitem.getName(), cnt){

                @Override
                protected String getReason() {
                    return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpresssion.2");
                }
            }.process();
        }
        if (errmsg != null) {
            this.getMessageListener().error(errmsg);
            return false;
        }
        if ("padding".equals(type)) {
            return this.isValidExpression_padding(modelId, sitem, autocalc);
        }
        if ("operation".equals(type)) {
            return this.isValidExpression_operation(modelId, sitem, autocalc, model, project);
        }
        return true;
    }

    private boolean isValidExpression_operation(String modelId, Modelitem sitem, Autocalc autocalc, Model model, Project project) {
        String cnt = autocalc.getContent();
        String errmsg = null;
        Varlist varlist = BStoreModelitem_autocalc.createVarlist(cnt);
        Set<String> nameSet = this.createItemNameSet(modelId);
        HashSet<String> wrongNameSet = new HashSet<String>();
        HashMap wrongNameMapByFid = new HashMap();
        for (String s : varlist.list) {
            int ptr;
            String f_modelId = null;
            String f_name = null;
            if (s.endsWith("_lp")) {
                f_modelId = s.substring(0, s.length() - "_lp".length());
            }
            if (s.indexOf("_lp.") > 0) {
                int ptr2 = s.indexOf("_lp.");
                f_modelId = s.substring(0, ptr2);
                f_name = s.substring(ptr2 + "_lp.".length());
            }
            if (f_modelId != null) {
                HashSet<String> wrongNameSetByFid;
                Set<String> fnameSet = this.createItemNameSet(f_modelId);
                if (!StringUtils.isNotBlank(f_name) || fnameSet.contains(f_name) || (wrongNameSetByFid = (HashSet<String>)wrongNameMapByFid.get(f_modelId)) != null) continue;
                wrongNameSetByFid = new HashSet<String>();
                wrongNameSetByFid.add(f_name);
                continue;
            }
            if (s.indexOf("#id") > 0) {
                s = s.substring(0, s.indexOf("#id"));
            } else if (s.indexOf("#content") > 0) {
                s = s.substring(0, s.indexOf("#content"));
            }
            if (nameSet.contains(s)) continue;
            boolean isMatch = false;
            while ((ptr = s.lastIndexOf("_")) > 0) {
                if (!nameSet.contains(s = s.substring(0, ptr))) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            wrongNameSet.add(s);
        }
        if (wrongNameSet.size() > 0) {
            errmsg = new CreateErrorMsg(modelId, sitem.getName(), cnt, wrongNameSet.toArray(new String[0])){

                @Override
                protected String getReason() {
                    return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpression_operation.1", new Object[]{this.getWrongNames()});
                }
            }.process();
        } else if (varlist.beginPar != varlist.endPar) {
            errmsg = new CreateErrorMsg(modelId, sitem.getName(), cnt){

                @Override
                protected String getReason() {
                    return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpression_operation.2");
                }
            }.process();
        }
        if (wrongNameMapByFid.size() > 0) {
            for (String f_modelId : wrongNameMapByFid.keySet()) {
                Set wrongNameSetByFid = (Set)wrongNameMapByFid.get(f_modelId);
                if (wrongNameSetByFid.size() <= 0) continue;
                errmsg = new CreateErrorMsg(f_modelId, sitem.getName(), cnt, wrongNameSetByFid.toArray(new String[0])){

                    @Override
                    protected String getReason() {
                        return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpression_operation.3", new Object[]{this.getWrongNames(), this.getModelId()});
                    }
                }.process();
                break;
            }
        }
        if (errmsg != null) {
            this.getMessageListener().error(errmsg);
            return false;
        }
        return true;
    }

    public static int countJavaString(String cnt, int i) {
        char sep = cnt.charAt(i);
        ++i;
        while (i < cnt.length()) {
            char c = cnt.charAt(i);
            if (c == '\\' ? ++i >= cnt.length() : c == sep) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static Varlist createVarlist(String cnt) {
        int length = cnt.length();
        boolean varMode = false;
        StringBuilder var = null;
        int beginPar = 0;
        int endPar = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            if (c == '\"' || c == '\'') {
                ++beginPar;
                if ((i = BStoreModelitem_autocalc.countJavaString(cnt, i)) >= length) break;
                ++endPar;
                continue;
            }
            if (c == '$') {
                if (i + 1 >= length || cnt.charAt(i + 1) != '{') continue;
                varMode = true;
                ++i;
                continue;
            }
            if (c == '}' && varMode && var != null) {
                String itemname = var.toString();
                String funcname = BStoreModelitem_autocalc.findFunction(itemname = BStoreModelitem_autocalc.removeAllSpace(itemname));
                if (funcname != null) {
                    itemname = BStoreModelitem_autocalc.removeFunction(itemname, funcname);
                }
                if (itemname.indexOf(",") > 0) {
                    itemname = itemname.substring(0, itemname.indexOf(","));
                }
                if (itemname.endsWith("#id")) {
                    itemname = itemname.substring(0, itemname.length() - "#id".length());
                } else if (itemname.endsWith("#content")) {
                    itemname = itemname.substring(0, itemname.length() - "#content".length());
                } else if (itemname.endsWith("#array")) {
                    itemname = itemname.substring(0, itemname.length() - "#array".length());
                }
                list.add(itemname);
                varMode = false;
                var = null;
                continue;
            }
            if (varMode) {
                if (var == null) {
                    var = new StringBuilder();
                }
                var.append(c);
                continue;
            }
            if (c == '(') {
                ++beginPar;
                continue;
            }
            if (c != ')') continue;
            ++endPar;
        }
        return new Varlist(list, beginPar, endPar);
    }

    private static String findFunction(String itemname) {
        String b_funcname = null;
        for (String funcname : funcnames) {
            String prefix = funcname + "(";
            if (!itemname.startsWith(prefix)) continue;
            b_funcname = funcname;
            break;
        }
        return b_funcname;
    }

    private static String removeFunction(String itemname, String funcname) {
        if (itemname.indexOf(",") > 0) {
            itemname = itemname.substring(0, itemname.indexOf(","));
        }
        String prefix = funcname + "(";
        String suffix = ")";
        if (itemname.startsWith(prefix)) {
            int endptr = itemname.length();
            if (itemname.endsWith(suffix)) {
                endptr -= suffix.length();
            }
            itemname = itemname.substring(prefix.length(), endptr);
        }
        return itemname;
    }

    private static String removeAllSpace(String itemname) {
        StringBuilder sb = new StringBuilder();
        int length = itemname.length();
        for (int i = 0; i < length; ++i) {
            char c = itemname.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private Set<String> createItemNameSet(String modelId) {
        String[] targets;
        HashSet<String> nameSet = new HashSet<String>();
        for (String s : targets = this.con_.getModelitemNames(modelId)) {
            nameSet.add(s);
        }
        return Collections.unmodifiableSet(nameSet);
    }

    private boolean isValidExpression_padding(String modelId, Modelitem sitem, Autocalc autocalc) {
        String cnt = autocalc.getContent();
        String errmsg = null;
        String[] tokens = cnt.split(",");
        if (tokens == null || tokens.length != 2) {
            errmsg = new CreateErrorMsg(modelId, sitem.getName(), cnt){

                @Override
                protected String getReason() {
                    return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpression_padding.1");
                }
            }.process();
        } else {
            try {
                int dummy1 = Integer.parseInt(tokens[0]);
                int n = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException e) {
                errmsg = new CreateErrorMsg(modelId, sitem.getName(), cnt){

                    @Override
                    protected String getReason() {
                        return rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.isValidExpression_padding.2");
                    }
                }.process();
            }
        }
        if (errmsg != null) {
            this.getMessageListener().error(errmsg);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String s = "FINDRE(\"^[A-Za-z0-9!\\\"?$&()^~\\\\[\\\\].{};:\\\\\\\\+_/-]{8,}$\", ${passwd}) > 0";
        Varlist varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
        s = "FINDRE(\"^[A-Za-z0-9!\\\\\"?$&()^~\\\\[\\\\].{};:\\\\\\\\+_/-]{8,}$\", ${passwd}) > 0";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ng");
        s = "FINDRE(\"^[A-Za-z0-9!\\\\\\\"?$&()^~\\\\[\\\\].{};:\\\\\\\\+_/-]{8,}$\", ${passwd}) > 0";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
        s = "\"\\\"\"";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
        s = "\"\\\\\"\"";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ng");
        s = "\"\\\\\\\"\"";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
        s = "\"\\\\\\\\\"\"";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ng");
        s = "'";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ng");
        s = "'a'";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
        s = "'\"'";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
        s = "'\\\"'";
        varlist = BStoreModelitem_autocalc.createVarlist(s);
        System.out.println(s + " " + varlist.beginPar + "," + varlist.endPar + " ok");
    }

    public static class Varlist {
        public List<String> list;
        public int beginPar = 0;
        public int endPar = 0;

        public Varlist(List<String> list, int beginPar, int endPar) {
            this.list = list;
            this.beginPar = beginPar;
            this.endPar = endPar;
        }

        public String toString() {
            if (this.list != null) {
                return this.list.toString();
            }
            return "";
        }
    }

    static abstract class CreateErrorMsg {
        private String modelId;
        private String modelitemName;
        private String cnt;
        private String[] wrongItemNames;

        public CreateErrorMsg(String modelId, String modelitemName, String cnt) {
            this(modelId, modelitemName, cnt, null);
        }

        public CreateErrorMsg(String modelId, String modelitemName, String cnt, String[] wrongItemNames) {
            this.modelId = modelId;
            this.modelitemName = modelitemName;
            this.cnt = cnt;
            this.wrongItemNames = wrongItemNames;
        }

        protected String getModelId() {
            return this.modelId;
        }

        private String getHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.CreateErrorMsg.getHeader", new Object[]{this.modelId, this.modelitemName}));
            return sb.toString();
        }

        private String getFooter() {
            StringBuilder sb = new StringBuilder();
            sb.append(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_autocalc.CreateErrorMsg.getHeader", new Object[]{this.cnt}));
            return sb.toString();
        }

        protected String getWrongNames() {
            if (this.wrongItemNames == null || this.wrongItemNames.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.wrongItemNames.length; ++i) {
                sb.append(this.wrongItemNames[i]);
                if (i >= this.wrongItemNames.length - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        protected abstract String getReason();

        public String process() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getHeader());
            sb.append(this.getReason());
            sb.append(this.getFooter());
            return sb.toString();
        }
    }
}

