/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Format;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BModelitemProcessor;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="format")
public class BStoreModelitem_format
extends BModelitemProcessor {
    private Map<String, String> outputFormatJudgeMap = null;
    private List<String> inputFormatCandidateList4Date = null;
    private List<String> inputFormatCandidateList4DateTime = null;
    private List<String> inputFormatCandidateList4Time = null;
    private final int MAX_FORMAT_PATTERN = 99;
    private final int MAX_FORMAT_DATE_PATTERN = 99;
    private final int MAX_FORMAT_DATETIME_PATTERN = 399;
    private final int MAX_FORMAT_TIME_PATTERN = 99;

    @Override
    public void process(String modelId, String detailType, Modelitem sitem, Model smodel, Project project) {
        ArrayList<String> outputFormatList = new ArrayList<String>();
        ArrayList<String> inputFormatList = new ArrayList<String>();
        if ("date".equals(detailType) || "time".equals(detailType) || "dateTime".equals(detailType) || "special-fixed-init-dateTime".equals(detailType) || "special-fixed-update-dateTime".equals(detailType) || "special-storeref-ref".equals(detailType)) {
            this.setInputOutputFormatList(modelId, detailType, sitem, inputFormatList, outputFormatList, project);
        }
        for (String content : outputFormatList) {
            sitem.addContent((IModelitemChoice)this.createFormatObject(content));
        }
        for (String content : inputFormatList) {
            if (outputFormatList.contains(content)) continue;
            sitem.addContent((IModelitemChoice)this.createFormatObject(content));
        }
        if (outputFormatList.size() == 0) {
            if ("special-storeref-ref".equals(detailType)) {
                sitem.addContent((IModelitemChoice)this.createFormatObject(""));
            } else {
                String type = Utils.getModelitemType(modelId, sitem.getName(), this.con_);
                if ("date".equals(type)) {
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy-MM-dd"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy/MM/dd"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy.MM.dd"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyyMMdd"));
                } else if ("time".equals(type)) {
                    sitem.addContent((IModelitemChoice)this.createFormatObject("HH:mm:ss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("HH:mm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("HHmmss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("HHmm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("HH"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("H:m:s"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("H:m"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject(":m"));
                } else if ("dateTime".equals(type)) {
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy-MM-dd HH:mm:ss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy-MM-dd HH:mm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy-MM-dd HHmmss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy-MM-dd HHmm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy-MM-dd"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy/MM/dd HH:mm:ss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy/MM/dd HH:mm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy/MM/dd HHmmss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy/MM/dd HHmm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy/MM/dd"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy.MM.dd HH:mm:ss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy.MM.dd HH:mm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy.MM.dd HHmmss"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy.MM.dd HHmm"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyy.MM.dd"));
                    sitem.addContent((IModelitemChoice)this.createFormatObject("yyyyMMdd"));
                }
            }
        }
    }

    private Format createFormatObject(String content) {
        Format format = new Format();
        format.setContent(StringUtil.replaceAll((String)content, (String)"\"", (String)"\\\""));
        return format;
    }

    private void setInputOutputFormatList(String modelId, String detailType, Modelitem sitem, List<String> inputFormatList, List<String> outputFormatList, Project project) {
        String format;
        Relation rel;
        String itemname = sitem.getName();
        String tmp_format = this.con_.getModelitemValue(modelId, itemname, "model/modelitem/format");
        String tmp_formatUserSetting = this.con_.getModelitemValue(modelId, itemname, "model/modelitem/formatUserSetting");
        String pkey = this.con_.getModelitemValue(modelId, itemname, "model/modelitem/@primaryKey");
        if (StringUtils.isNotBlank((CharSequence)pkey) && "date".equals(detailType) && (StringUtils.isNotEmpty((CharSequence)tmp_format) && !"yyyy-MM-dd".equals(tmp_format) || StringUtils.isNotEmpty((CharSequence)tmp_formatUserSetting))) {
            tmp_format = null;
            tmp_formatUserSetting = null;
            this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.model.BStoreModelitem_format.date_and_pkey", new Object[]{modelId, itemname}));
        }
        if (StringUtils.isBlank((CharSequence)tmp_format) && StringUtils.isBlank((CharSequence)tmp_formatUserSetting) && "special-storeref-ref".equals(detailType) && (rel = AppSchemaUtil.getRelationTypeIsRef((Modelitem)sitem)) != null) {
            modelId = rel.getIdrefAsString();
            itemname = rel.getName();
            tmp_format = this.con_.getModelitemValue(modelId, itemname, "model/modelitem/format");
            tmp_formatUserSetting = this.con_.getModelitemValue(modelId, itemname, "model/modelitem/formatUserSetting");
        }
        if (StringUtils.isNotBlank((CharSequence)tmp_formatUserSetting)) {
            outputFormatList.add(tmp_formatUserSetting);
        } else {
            if (this.outputFormatJudgeMap == null) {
                this.outputFormatJudgeMap = new LinkedHashMap<String, String>();
                int index = 1;
                while (true) {
                    String input_format = ropt.getValue("OPTION_model_modelitem_format_" + index + "_value");
                    String wa_format = ropt.getValue("OPTION_model_modelitem_format_" + index + "wa_value");
                    if (StringUtils.isBlank((CharSequence)input_format) || StringUtils.isBlank((CharSequence)wa_format)) {
                        if (index > 99) break;
                        ++index;
                        continue;
                    }
                    this.outputFormatJudgeMap.put(input_format, wa_format);
                    ++index;
                }
            }
            boolean isMatch = false;
            for (String key : this.outputFormatJudgeMap.keySet()) {
                if (!key.equals(tmp_format)) continue;
                String fmt = this.outputFormatJudgeMap.get(key);
                outputFormatList.add(fmt);
                isMatch = true;
                break;
            }
            if (!isMatch) {
                if ("date".equals(detailType)) {
                    outputFormatList.add("yyyy-MM-dd");
                } else if ("dateTime".equals(detailType) || "special-fixed-init-dateTime".equals(detailType) || "special-fixed-update-dateTime".equals(detailType)) {
                    outputFormatList.add("yyyy-MM-dd HH:mm:ss");
                } else if ("time".equals(detailType)) {
                    outputFormatList.add("HH:mm:ss");
                }
            }
        }
        if (this.inputFormatCandidateList4Date == null) {
            this.inputFormatCandidateList4Date = new ArrayList<String>();
            int index = 1;
            while (true) {
                if (StringUtils.isBlank((CharSequence)(format = rman.getValue("r.model.modelitem.format.date." + index)))) {
                    if (index > 99) break;
                    ++index;
                    continue;
                }
                this.inputFormatCandidateList4Date.add(format);
                ++index;
            }
        }
        if (this.inputFormatCandidateList4DateTime == null) {
            this.inputFormatCandidateList4DateTime = new ArrayList<String>();
            int index = 1;
            while (true) {
                if (StringUtils.isBlank((CharSequence)(format = rman.getValue("r.model.modelitem.format.datetime." + index)))) {
                    if (index > 399) break;
                    ++index;
                    continue;
                }
                this.inputFormatCandidateList4DateTime.add(format);
                ++index;
            }
        }
        if (this.inputFormatCandidateList4Time == null) {
            this.inputFormatCandidateList4Time = new ArrayList<String>();
            int index = 1;
            while (true) {
                if (StringUtils.isBlank((CharSequence)(format = rman.getValue("r.model.modelitem.format.time." + index)))) {
                    if (index > 99) break;
                    ++index;
                    continue;
                }
                this.inputFormatCandidateList4Time.add(format);
                ++index;
            }
        }
        if ("date".equals(detailType)) {
            inputFormatList.addAll(this.inputFormatCandidateList4Date);
        } else if ("dateTime".equals(detailType) || "special-fixed-init-dateTime".equals(detailType) || "special-fixed-update-dateTime".equals(detailType)) {
            inputFormatList.addAll(this.inputFormatCandidateList4DateTime);
        } else if ("time".equals(detailType)) {
            inputFormatList.addAll(this.inputFormatCandidateList4Time);
        }
    }
}

