/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation;

import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.CreatePanel;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PanelType;
import jp.jasminesoft.jfc.tools.xls2appschema.builder.presentation.PresentationType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="CreatePanelFactory")
public class CreatePanelFactory {
    @Autowired
    private ApplicationContext context_;

    public Panel create(PanelType type, String modelId, PresentationType ptype, Action action, Project project, int num, int copyIndex) {
        CreatePanel creator = null;
        try {
            String componentName = this.getPanelComponentName(type, modelId, ptype, action);
            if (StringUtils.isNotBlank((CharSequence)componentName)) {
                creator = (CreatePanel)this.context_.getBean(componentName);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            e.printStackTrace();
        }
        return creator != null ? creator.create(modelId, ptype, action, project, num, copyIndex) : null;
    }

    public String getPanelComponentName(PanelType type, String modelId, PresentationType ptype, Action action) {
        if (type == PanelType.header) {
            return "CreatePanel_header";
        }
        if (type == PanelType.pagetitle) {
            return "CreatePanel_pagetitle";
        }
        if (type == PanelType.errormsg) {
            return "CreatePanel_errormsg";
        }
        if (type == PanelType.submenu) {
            return "CreatePanel_submenu";
        }
        if (type == PanelType.sidebar) {
            return "CreatePanel_sidebar";
        }
        if (type == PanelType.pankuzu) {
            return "CreatePanel_pankuzu";
        }
        if (type == PanelType.navigationbar) {
            if (ptype != PresentationType.show) {
                if (ptype == PresentationType.showList) {
                    return "CreatePanel_navigationbar_showList";
                }
                if (ptype == PresentationType.calendar) {
                    return "CreatePanel_navigationbar_calendarview";
                }
                if (ptype == PresentationType.totalview) {
                    return "CreatePanel_navigationbar_totalview";
                }
                if (ptype == PresentationType.scheduleview) {
                    return "CreatePanel_navigationbar_scheduleview";
                }
            }
        } else {
            if (type == PanelType.description) {
                return "CreatePanel_description";
            }
            if (type == PanelType.body) {
                if (ptype == PresentationType.show) {
                    return "CreatePanel_body_show";
                }
                if (ptype == PresentationType.showList || ptype == PresentationType.searchList || ptype == PresentationType.searchListMobile || ptype == PresentationType.searchListForRefgroup) {
                    return "CreatePanel_body_showList";
                }
                if (ptype == PresentationType.calendar) {
                    return "CreatePanel_body_calendar";
                }
                if (ptype == PresentationType.totalview) {
                    return "CreatePanel_body_totalview";
                }
                if (ptype == PresentationType.scheduleview) {
                    return "CreatePanel_body_scheduleview";
                }
                if (ptype == PresentationType.reportList) {
                    return "CreatePanel_body_reportList";
                }
                if (ptype == PresentationType.insert) {
                    return "CreatePanel_body_insert";
                }
                if (ptype == PresentationType.confirmInsert) {
                    return "CreatePanel_body_confirmInsert";
                }
                if (ptype == PresentationType.update) {
                    return "CreatePanel_body_update";
                }
                if (ptype == PresentationType.confirmUpdate) {
                    return "CreatePanel_body_confirmUpdate";
                }
                if (ptype == PresentationType.copy) {
                    return "CreatePanel_body_copy";
                }
                if (ptype == PresentationType.updateList) {
                    return "CreatePanel_body_updateList";
                }
                if (ptype == PresentationType.download) {
                    return "CreatePanel_body_download";
                }
                if (ptype == PresentationType.uploadUpdate) {
                    return "CreatePanel_body_upload";
                }
                if (ptype == PresentationType.printScreen || ptype == PresentationType.printListScreen) {
                    return "CreatePanel_body_printScreen";
                }
                if (ptype == PresentationType.subWindowShow) {
                    return "CreatePanel_body_subWindow";
                }
            } else {
                if (type == PanelType.footer) {
                    return "CreatePanel_footer";
                }
                if (type == PanelType.endbody) {
                    return "CreatePanel_endbody";
                }
                if (type == PanelType.closewindow) {
                    return "CreatePanel_closewindow";
                }
            }
        }
        return "";
    }
}

