/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.gen.appschema.Acl;
import jp.jasminesoft.jfc.gen.appschema.Category;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.Principal;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipal;
import jp.jasminesoft.jfc.tools.xls2appschema.AuthorityPrincipalCategory;
import jp.jasminesoft.jfc.tools.xls2appschema.PermissionComparator;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectOuterlinkContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefElementContainer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="BAcl")
public class BAcl
extends AppSchemaBuilder {
    public static final String JgroupManagerPermname = "jgroup";
    public static final String JgroupManagerPermaction = "manager";
    public static final String JgroupProxyPermname = "jgroup";
    public static final String JgroupProxyPermaction = "proxy";
    public static final String AdminAllPermname = "admin";
    public static final String AdminAllPermaction = "all";
    public static final String All_PRINCIPAL = "all";
    protected Logger log = LogManager.getLogger(BAcl.class);
    @Autowired(required=true)
    protected ProjectOuterlinkContainer pcon_;
    private Map<Integer, AuthorityPrincipal> authorityPrincipalInfoMap;
    private Map<Integer, AuthorityPrincipalCategory> authorityPrincipalCategoryMap;
    private Set<String> differentDomainModelIdSet;

    public void setDifferentDomainModelIdSet(Set<String> differentDomainModelIdSet) {
        this.differentDomainModelIdSet = differentDomainModelIdSet;
    }

    @Override
    public void process(Project project) {
        String[] nids;
        Object pri;
        String nid;
        String perm_action;
        String perm_name;
        String id;
        this.authorityPrincipalInfoMap = ((WagbyR6DefElementContainer)this.con_).getAuthorityPrincipalInfoMap();
        this.authorityPrincipalCategoryMap = ((WagbyR6DefElementContainer)this.con_).getAuthorityPrincipalCategoryMap();
        this.log.debug("authorityPrincipalInfoMap=" + this.authorityPrincipalInfoMap);
        this.log.debug("authorityPrincipalCategoryMap=" + this.authorityPrincipalCategoryMap);
        LinkedHashMap<String, AuthorityPrincipal> principalMap = new LinkedHashMap<String, AuthorityPrincipal>();
        LinkedHashMap<String, Collection<Permission>> permissionMap = new LinkedHashMap<String, Collection<Permission>>();
        this.getPermissionForStore(principalMap, permissionMap);
        this.getPermissionForMaster(principalMap, permissionMap);
        this.getPermissionForOuterlink(principalMap, permissionMap);
        if (Utils.isCreateEditpage(this.con_)) {
            id = "jshparam_master";
            perm_name = "jshparam_master";
            perm_action = "update";
            this.createDefaultPrincipal(principalMap, permissionMap, id, perm_name, perm_action);
        }
        this.createDefaultPrincipal(principalMap, permissionMap, "jshparam_jholiday", "jholiday", "select,showlist,insert,update,delete,menu");
        if (this.isJshparamGroupmanager()) {
            id = "jshparam_juser";
            perm_name = "juser";
            perm_action = "showlist";
            this.createDefaultPrincipal(principalMap, permissionMap, id, perm_name, perm_action);
        }
        if (this.isJgroupManager()) {
            id = "jshparam_groupmanager";
            this.createDefaultPrincipal(principalMap, permissionMap, id, "jgroup", JgroupManagerPermaction);
            this.createDefaultPrincipal(principalMap, permissionMap, id, "jgroup", JgroupProxyPermaction);
            id = "jshparam_groupmanager_without_proxy";
            this.createDefaultPrincipal(principalMap, permissionMap, id, "jgroup", JgroupManagerPermaction);
        }
        LinkedHashSet<Principal> principalSet = new LinkedHashSet<Principal>();
        int no = 0;
        principalSet.add(this.createPrincipalPublic(no, principalMap, permissionMap));
        principalSet.add(this.createPrincipalDefault(++no, principalMap, permissionMap));
        principalSet.add(this.createPrincipalAll(++no, principalMap, permissionMap));
        ++no;
        String key = "jshparam_master";
        AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(key);
        if (authorityPrincipal != null && principalMap.containsKey(nid = Integer.toString(authorityPrincipal.getId()))) {
            pri = this.createPrincipal(no++, key);
            pri.addPermission(((Collection)permissionMap.get(nid)).toArray(new Permission[0]));
            principalSet.add((Principal)pri);
            principalMap.remove(nid);
            permissionMap.remove(nid);
        }
        if ((authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(key = "jshparam_jholiday")) != null && principalMap.containsKey(nid = Integer.toString(authorityPrincipal.getId()))) {
            pri = this.createPrincipal(no++, key);
            pri.addPermission(((Collection)permissionMap.get(nid)).toArray(new Permission[0]));
            principalSet.add((Principal)pri);
            principalMap.remove(nid);
            permissionMap.remove(nid);
        }
        if ((authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(key = "jshparam_juser")) != null && principalMap.containsKey(nid = Integer.toString(authorityPrincipal.getId()))) {
            pri = this.createPrincipal(no++, key);
            pri.addPermission(((Collection)permissionMap.get(nid)).toArray(new Permission[0]));
            principalSet.add((Principal)pri);
            principalMap.remove(nid);
            permissionMap.remove(nid);
        }
        ArrayList<String> nidList = new ArrayList<String>();
        for (String[] authorityPrincipal_ : principalMap.values()) {
            nidList.add(authorityPrincipal_.getPrincipalId());
        }
        for (String nid2 : nids = nidList.toArray(new String[0])) {
            Principal principal = this.createPrincipal(no++, nid2);
            this.createPermission(principalMap, permissionMap, principal, nid2);
            if (principal.sizePermission() == 0) continue;
            principalSet.add(principal);
        }
        Principal pri2 = this.createPrincipal(no++, "releaseLogonUser");
        pri2.addPermission(this.createPermission("juser", "releaseLogonUser"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "jobAccount");
        pri2.addPermission(this.createPermission("juser", "jobAccount"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "user");
        pri2.addPermission(this.createPermission("juser", "menu"));
        pri2.addPermission(this.createPermission("juser", "select"));
        pri2.addPermission(this.createPermission("juser", "showlist"));
        pri2.addPermission(this.createPermission("juser", "updatelist"));
        pri2.addPermission(this.createPermission("juser", "insert"));
        pri2.addPermission(this.createPermission("juser", "update"));
        pri2.addPermission(this.createPermission("juser", "delete"));
        pri2.addPermission(this.createPermission("juser", "download"));
        pri2.addPermission(this.createPermission("juser", "uploadUpdate"));
        pri2.addPermission(this.createPermission("juser", "reportlist"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "group");
        pri2.addPermission(this.createPermission("jgroup", "menu"));
        pri2.addPermission(this.createPermission("jgroup", "select"));
        pri2.addPermission(this.createPermission("jgroup", "showlist"));
        pri2.addPermission(this.createPermission("jgroup", "updatelist"));
        pri2.addPermission(this.createPermission("jgroup", "insert"));
        pri2.addPermission(this.createPermission("jgroup", "update"));
        pri2.addPermission(this.createPermission("jgroup", "delete"));
        pri2.addPermission(this.createPermission("jgroup", "download"));
        pri2.addPermission(this.createPermission("jgroup", "uploadUpdate"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "syslog");
        pri2.addPermission(this.createPermission("syslog", "show"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "analystics");
        pri2.addPermission(this.createPermission("analystics", "show"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "sysinfo");
        pri2.addPermission(this.createPermission("sysinfo", "show"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "impexp");
        pri2.addPermission(this.createPermission("impexp", "all"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "maintenance");
        pri2.addPermission(this.createPermission("maintenance", "all"));
        principalSet.add(pri2);
        pri2 = this.createPrincipal(no++, "webapi");
        if (pri2 != null) {
            pri2.addPermission(this.createPermission("webapi", "all"));
            principalSet.add(pri2);
        }
        this.addRemainingPrincipal(principalSet);
        Principal[] principals = principalSet.toArray(new Principal[0]);
        Arrays.sort(principals, new PrincipalComparator());
        Acl acl = new Acl();
        acl.addPrincipal(principals);
        this.addCategory(acl);
        project.setAcl(acl);
    }

    private void addCategory(Acl acl) {
        for (Map.Entry<Integer, AuthorityPrincipalCategory> entry : this.authorityPrincipalCategoryMap.entrySet()) {
            AuthorityPrincipalCategory authorityPrincipalCategory = entry.getValue();
            Category category = new Category();
            category.setId(authorityPrincipalCategory.getId());
            category.setNo(authorityPrincipalCategory.getNo());
            category.setCategoryId(authorityPrincipalCategory.getCategoryId());
            category.setOrder(authorityPrincipalCategory.getOrder());
            category.setContent(authorityPrincipalCategory.getContent());
            acl.addCategory(category);
        }
    }

    private void createDefaultPrincipal(Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap, String principalId, String perm_name, String perm_action) {
        String nid = null;
        AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(principalId);
        if (authorityPrincipal != null && !principalMap.containsKey(nid = Integer.toString(authorityPrincipal.getId()))) {
            this.log.debug("!bingo " + authorityPrincipal);
            principalMap.put(nid, authorityPrincipal);
        }
        if (nid == null) {
            this.log.warn("Principal '" + principalId + "' does not found.");
            return;
        }
        Collection<Object> permissionSet = null;
        permissionSet = !permissionMap.containsKey(nid) ? new HashSet() : permissionMap.get(nid);
        boolean sameFlag = false;
        for (Permission permission : permissionSet) {
            String p_name = permission.getName();
            String p_action = permission.getAction();
            if (!perm_name.equals(p_name) || !perm_action.equals(p_action)) continue;
            sameFlag = true;
            break;
        }
        if (!sameFlag) {
            permissionSet.add(this.createPermission(perm_name, perm_action));
            permissionMap.put(nid, permissionSet);
        }
    }

    private AuthorityPrincipal getAuthorityPrincipalById(int id) {
        for (Map.Entry<Integer, AuthorityPrincipal> entry : this.authorityPrincipalInfoMap.entrySet()) {
            AuthorityPrincipal authorityPrincipal = entry.getValue();
            if (id != authorityPrincipal.getId()) continue;
            return authorityPrincipal;
        }
        return null;
    }

    private AuthorityPrincipal getAuthorityPrincipalByPrincipalId(String id) {
        if (id == null) {
            return null;
        }
        for (Map.Entry<Integer, AuthorityPrincipal> entry : this.authorityPrincipalInfoMap.entrySet()) {
            AuthorityPrincipal authorityPrincipal = entry.getValue();
            if (!id.equals(authorityPrincipal.getPrincipalId())) continue;
            return authorityPrincipal;
        }
        return null;
    }

    private Principal createPrincipalDefault(int no, Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap) {
        Principal principal = this.createPrincipal(no, "default");
        principal.addPermission(this.createPermission("juser", "default"));
        this.createPermission(principalMap, permissionMap, principal, "default");
        return principal;
    }

    private Principal createPrincipalAll(int no, Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap) {
        HashSet<Permission> p_set = new HashSet<Permission>();
        p_set.add(this.createPermission("juser", "unlock"));
        p_set.add(this.createPermission("juser", "default"));
        p_set.add(this.createPermission("common", "default"));
        p_set.add(this.createPermission(AdminAllPermname, "all"));
        p_set.add(this.createPermission("jprincipal", "select,insert,update,delete"));
        p_set.add(this.createPermission("jpermission", "select,insert,update,delete"));
        p_set.add(this.createPermission("jgroup", JgroupManagerPermaction));
        p_set.add(this.createPermission("jgroup", JgroupProxyPermaction));
        for (String nid : permissionMap.keySet()) {
            for (Permission permission : permissionMap.get(nid)) {
                String name = permission.getName();
                String action = permission.getAction();
                boolean samePermission = false;
                for (Permission p_setPermission : p_set.toArray(new Permission[0])) {
                    String p_setName = p_setPermission.getName();
                    String p_setAction = p_setPermission.getAction();
                    if (!p_setName.equals(name) || !p_setAction.equals(action)) continue;
                    samePermission = true;
                    break;
                }
                if (samePermission) continue;
                p_set.add(permission);
            }
        }
        p_set.add(this.createPermission("juser", "releaseLogonUser"));
        p_set.add(this.createPermission("juser", "menu"));
        p_set.add(this.createPermission("juser", "select"));
        p_set.add(this.createPermission("juser", "showlist"));
        p_set.add(this.createPermission("juser", "updatelist"));
        p_set.add(this.createPermission("juser", "insert"));
        p_set.add(this.createPermission("juser", "update"));
        p_set.add(this.createPermission("juser", "delete"));
        p_set.add(this.createPermission("juser", "download"));
        p_set.add(this.createPermission("juser", "uploadUpdate"));
        p_set.add(this.createPermission("juser", "reportlist"));
        p_set.add(this.createPermission("jgroup", "menu"));
        p_set.add(this.createPermission("jgroup", "select"));
        p_set.add(this.createPermission("jgroup", "showlist"));
        p_set.add(this.createPermission("jgroup", "updatelist"));
        p_set.add(this.createPermission("jgroup", "insert"));
        p_set.add(this.createPermission("jgroup", "update"));
        p_set.add(this.createPermission("jgroup", "delete"));
        p_set.add(this.createPermission("jgroup", "download"));
        p_set.add(this.createPermission("jgroup", "uploadUpdate"));
        p_set.add(this.createPermission("syslog", "show"));
        p_set.add(this.createPermission("analystics", "show"));
        p_set.add(this.createPermission("sysinfo", "show"));
        p_set.add(this.createPermission("impexp", "all"));
        p_set.add(this.createPermission("maintenance", "all"));
        p_set.add(this.createPermission("webapi", "all"));
        Principal principal = this.createPrincipal(no, "all");
        Permission[] permissions = p_set.toArray(new Permission[0]);
        Arrays.sort(permissions, new PermissionComparator());
        principal.addPermission(permissions);
        AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId("all");
        if (authorityPrincipal != null) {
            String nid = Integer.toString(authorityPrincipal.getId());
            principalMap.remove(nid);
            permissionMap.remove(nid);
        }
        return principal;
    }

    private Principal createPrincipalPublic(int no, Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap) {
        Principal principal = this.createPrincipal(no, "public");
        principal.addPermission(this.createPermission("common", "default"));
        this.createPermission(principalMap, permissionMap, principal, "public");
        return principal;
    }

    private void createPermission(Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap, Principal principal, String principalId) {
        AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(principalId);
        String nid = null;
        if (authorityPrincipal != null) {
            nid = Integer.toString(authorityPrincipal.getId());
        }
        if (nid == null) {
            this.log.warn("Principal '" + principalId + "' does not found.");
            return;
        }
        if (principalMap.containsKey(nid)) {
            Permission[] permissions = permissionMap.get(nid).toArray(new Permission[0]);
            Arrays.sort(permissions, new PermissionComparator());
            principal.addPermission(permissions);
            principalMap.remove(nid);
            permissionMap.remove(nid);
        }
    }

    private void getPermissionForOuterlink(Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap) {
        for (Map<String, String> map : this.pcon_.getOuterlinkInfoMaps()) {
            Collection<Permission> principalSet;
            Integer __linenumber = Integer.valueOf(map.get("menulinkaction/@__linenumber"));
            Collection<Map<String, String>> principalInfoMap = this.pcon_.getPrincipalInfoMapsByLine(__linenumber);
            if (principalInfoMap != null) {
                for (Map<String, String> principal : principalInfoMap) {
                    if (principal == null) continue;
                    String principalId = principal.get("acl/principal/@id");
                    AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalById(NumberUtils.toInt((String)principalId));
                    if (authorityPrincipal == null) {
                        authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(principalId);
                    }
                    String nid = null;
                    if (authorityPrincipal != null) {
                        nid = Integer.toString(authorityPrincipal.getId());
                    }
                    if (nid == null) {
                        this.log.warn("Principal '" + principalId + "' does not found.");
                        continue;
                    }
                    if (!principalMap.containsKey(nid)) {
                        principalMap.put(nid, authorityPrincipal);
                    }
                    Collection<Object> principalSet2 = null;
                    principalSet2 = !permissionMap.containsKey(nid) ? new HashSet() : permissionMap.get(nid);
                    principalSet2.add(this.createPermission("menulinkaction_" + __linenumber.toString(), "menu"));
                    permissionMap.put(nid, principalSet2);
                }
                continue;
            }
            String principalId = "common";
            String nid = null;
            AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(principalId);
            if (authorityPrincipal != null) {
                nid = Integer.toString(authorityPrincipal.getId());
            }
            if ((principalSet = permissionMap.get(nid)) == null) {
                principalSet = new HashSet<Permission>();
            }
            principalSet.add(this.createPermission("menulinkaction_" + __linenumber.toString(), "menu"));
            permissionMap.put(nid, principalSet);
        }
    }

    private void getPermissionForMaster(Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap) {
        Object[] storeModelss = this.con_.getAllMasterModelId();
        for (Object modelId : storeModelss = (String[])ArrayUtils.addAll((Object[])storeModelss, (Object[])this.con_.getAllStoreModelId())) {
            if (this.differentDomainModelIdSet != null && this.differentDomainModelIdSet.contains(modelId)) continue;
            for (String principalId : this.con_.getPrincipals((String)modelId)) {
                if (!Utils.isSelectedValue(this.con_.getModelValue((String)modelId, "createEditpage"))) continue;
                String nid = null;
                String principalContent = null;
                AuthorityPrincipal authorityPrincipal = null;
                authorityPrincipal = NumberUtils.isDigits((String)principalId) ? this.getAuthorityPrincipalById(NumberUtils.toInt((String)principalId)) : this.getAuthorityPrincipalByPrincipalId(principalId);
                if (authorityPrincipal != null) {
                    nid = Integer.toString(authorityPrincipal.getId());
                    if (!principalMap.containsKey(nid)) {
                        principalMap.put(nid, authorityPrincipal);
                    }
                    principalContent = authorityPrincipal.getContent();
                }
                if (nid == null) {
                    this.log.warn("Principal '" + principalId + "' does not found. authorityPrincipal=" + authorityPrincipal);
                    continue;
                }
                Collection<Object> permissionSet = null;
                permissionSet = !permissionMap.containsKey(nid) ? new HashSet() : permissionMap.get(nid);
                if (principalContent.indexOf(rman.getValue("r.acl.jshparam_master")) > 0) {
                    permissionSet.add(this.createPermission((String)modelId, "select"));
                    permissionSet.add(this.createPermission((String)modelId, "showlist"));
                    permissionSet.add(this.createPermission((String)modelId, "insert"));
                    permissionSet.add(this.createPermission((String)modelId, "update"));
                    permissionSet.add(this.createPermission((String)modelId, "delete"));
                    permissionSet.add(this.createPermission((String)modelId, "updatelist"));
                    permissionSet.add(this.createPermission((String)modelId, "download"));
                    permissionSet.add(this.createPermission((String)modelId, "uploadupdate"));
                    permissionSet.add(this.createPermission((String)modelId, "reportlist"));
                    permissionSet.add(this.createPermission((String)modelId, "menu"));
                } else {
                    permissionSet.add(this.createPermission((String)modelId, "update"));
                }
                permissionMap.put(nid, permissionSet);
            }
            if (!ArrayUtils.isEmpty((Object[])this.con_.getPrincipals((String)modelId))) continue;
            this.addPermissionsToAllPrincipal(permissionMap, (String)modelId, new String[]{"update"});
        }
    }

    private void getPermissionForStore(Map<String, AuthorityPrincipal> principalMap, Map<String, Collection<Permission>> permissionMap) {
        for (String modelId : this.con_.getAllStoreModelId()) {
            if (this.differentDomainModelIdSet != null && this.differentDomainModelIdSet.contains(modelId)) continue;
            for (String principalId : this.con_.getPrincipals(modelId)) {
                if (principalId == null || Utils.isSelectedValue(this.con_.getModelValue(modelId, "createEditpage"))) continue;
                String nid = null;
                AuthorityPrincipal authorityPrincipal = null;
                if (NumberUtils.isDigits((String)principalId)) {
                    authorityPrincipal = this.getAuthorityPrincipalById(NumberUtils.toInt((String)principalId));
                }
                if (authorityPrincipal == null) {
                    authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(principalId);
                }
                if (authorityPrincipal != null && !principalMap.containsKey(nid = Integer.toString(authorityPrincipal.getId()))) {
                    principalMap.put(nid, authorityPrincipal);
                }
                if (nid == null) {
                    this.log.warn("Principal '" + principalId + "' does not found. authorityPrincipal=" + authorityPrincipal);
                    continue;
                }
                Collection<Object> permissionSet = null;
                permissionSet = !permissionMap.containsKey(nid) ? new HashSet() : permissionMap.get(nid);
                for (String permissionAction : this.con_.getPermissionsByPrincipal(modelId, principalId)) {
                    permissionSet.add(this.createPermission(modelId, permissionAction));
                }
                permissionMap.put(nid, permissionSet);
            }
            if (ArrayUtils.contains((Object[])this.con_.getPrincipals(modelId), (Object)"all")) continue;
            this.addModelPermissionsToAllPrincipal(permissionMap, modelId);
        }
    }

    private void addModelPermissionsToAllPrincipal(Map<String, Collection<Permission>> permissionMap, String modelId) {
        this.addPermissionsToAllPrincipal(permissionMap, modelId, this.con_.getPermissions(modelId));
    }

    private void addPermissionsToAllPrincipal(Map<String, Collection<Permission>> permissionMap, String modelId, String[] permActions) {
        if (ArrayUtils.isEmpty((Object[])permActions)) {
            return;
        }
        AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId("all");
        if (authorityPrincipal == null) {
            this.log.warn("Principal 'all' is not found.");
            return;
        }
        String nid = Integer.toString(authorityPrincipal.getId());
        Collection<Permission> permissionSet = permissionMap.get(nid);
        if (permissionSet == null) {
            permissionSet = new HashSet<Permission>();
            permissionMap.put(nid, permissionSet);
        }
        for (String permissionAction : permActions) {
            permissionSet.add(this.createPermission(modelId, permissionAction));
        }
    }

    private boolean isJshparamGroupmanager() {
        boolean ret = false;
        for (String modelitem : this.con_.getModelitemNames("juser")) {
            ret = Utils.isReferencedStorerefSearch("juser", modelitem, this.con_);
            if (!ret) continue;
            return ret;
        }
        for (String storeModel : this.con_.getAllStoreModelId()) {
            ret = Utils.needsGroupManager(storeModel, this.con_);
            if (!ret) continue;
            return ret;
        }
        return ret;
    }

    private boolean isJgroupManager() {
        boolean ret = false;
        for (String storeModel : this.con_.getAllStoreModelId()) {
            ret = Utils.needsGroupManager(storeModel, this.con_);
            if (!ret) continue;
            return ret;
        }
        return ret;
    }

    private Principal createPrincipal(int no, String id) {
        AuthorityPrincipal authorityPrincipal = this.getAuthorityPrincipalByPrincipalId(id);
        if (authorityPrincipal == null) {
            return null;
        }
        Principal principal = new Principal();
        principal.setId(authorityPrincipal.getId());
        principal.setNo(authorityPrincipal.getNo());
        principal.setContent(authorityPrincipal.getContent());
        principal.setPrincipalId(authorityPrincipal.getPrincipalId());
        principal.setCategory(authorityPrincipal.getCategory());
        principal.setOrder(authorityPrincipal.getOrder());
        principal.setIsShowInSelect(authorityPrincipal.isShowInSelect());
        principal.setIsEditable(authorityPrincipal.isEditable());
        return principal;
    }

    private Permission createPermission(String name, String action) {
        Permission perm = new Permission();
        perm.setName(name);
        perm.setAction(action);
        return perm;
    }

    private void addRemainingPrincipal(Collection<Principal> principalSet) {
        Set set = principalSet.stream().map(principal -> principal.getPrincipalId()).collect(Collectors.toSet());
        int no = Integer.MIN_VALUE;
        for (AuthorityPrincipal auth : this.authorityPrincipalInfoMap.values()) {
            if (set.contains(auth.getPrincipalId())) continue;
            principalSet.add(this.createPrincipal(no++, auth.getPrincipalId()));
        }
    }

    static class PrincipalComparator
    implements Comparator<Principal> {
        PrincipalComparator() {
        }

        @Override
        public int compare(Principal o1, Principal o2) {
            return o1.getNo() - o2.getNo();
        }
    }
}

