/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilderFileTemplate;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BCommon")
public class BCommon
extends AppSchemaBuilderFileTemplate {
    protected Logger log = LogManager.getLogger(BCommon.class);

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public void process(Project project) {
        this.readAppSchemaElement("model_hour_m.xml", project);
        boolean useCacheProcess = AppSchemaUtil.useCacheProcess;
        AppSchemaUtil.setCacheProcess((boolean)false);
        String modelId = "hour_m";
        Utils.setDomainCreateTableAttribute(modelId, AppSchemaUtil.getModel((Project)project, (String)modelId), project, this.con_);
        this.readAppSchemaElement("model_minute_m.xml", project);
        modelId = "minute_m";
        Utils.setDomainCreateTableAttribute(modelId, AppSchemaUtil.getModel((Project)project, (String)modelId), project, this.con_);
        this.readAppSchemaElement("model_movestep_m.xml", project);
        modelId = "movestep_m";
        Utils.setDomainCreateTableAttribute(modelId, AppSchemaUtil.getModel((Project)project, (String)modelId), project, this.con_);
        this.readAppSchemaElement("model_masterlp.xml", project);
        this.readAppSchemaElement("model_seq.xml", project);
        modelId = "seq";
        Utils.setDomainCreateTableAttribute(modelId, AppSchemaUtil.getModel((Project)project, (String)modelId), project, this.con_);
        AppSchemaUtil.setCacheProcess((boolean)useCacheProcess);
        this.createPresentation_menu(project);
        this.createPresentation_mobileMenu(project);
        this.createAction_noData(project);
        this.createPresentation_noData(project);
        this.createAction_empty(project);
        this.createPresentation_empty(project);
        this.createAction_showListLog(project);
        this.createPresentation_showListLog(project);
        this.createAction_showListLogonUsers(project);
        this.createPresentation_showListLogonUsers(project);
        this.createAction_releaseLogonUser(project);
        this.createAction_userPreference(project);
        this.createPresentation_userPreference(project);
        this.createAction_showAboutApp(project);
        this.createPresentation_showAboutApp(project);
        this.createAction_initLoader(project);
        this.createPresentation_initLoader(project);
        this.createAction_maintenance(project);
        this.createPresentation_maintenance(project);
        this.createAction_analyticsLog(project);
        this.createPresentation_analyticsLog(project);
        this.createAction_webapi(project);
        this.createPresentation_webapi(project);
        if (Utils.isCluster(this.con_) || Utils.isAutoScaling(this.con_)) {
            this.readAppSchemaElement("model_jfcreminder.xml", project);
        }
    }

    private void createPresentation_initLoader(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_initLoader.xml", replaceMap, project);
    }

    private void createAction_initLoader(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("initLoader", "1200", "admin", null, null, rman.getValue("r.project.menu.initLoader"));
        this.readAppSchemaElement("action_initLoader.xml", map, project);
    }

    private void createPresentation_showAboutApp(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_showAboutApp.xml", replaceMap, project);
    }

    private void createAction_showAboutApp(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("showAboutApp", "4900", "admin", null, null, rman.getValue("r.project.menu.showAboutApp.name.defaultValue"));
        this.readAppSchemaElement("action_showAboutApp.xml", map, project);
    }

    private void createPresentation_userPreference(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_preference.xml", replaceMap, project);
    }

    private void createAction_userPreference(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("userPreference", "4050", "common", null, null, rman.getValue("r.project.menu.userPreference"));
        String userPreferenceMenuStr = this.con_.getProjectValue("project/customize/menu/@userPreference");
        if (this.con_.existsKeyInProject("project/customize/menu/@userPreference") && !Utils.isSelectedValue(userPreferenceMenuStr)) {
            map.put("menuorder", 0);
            map.remove("menucolor");
            map.remove("menulabelcolor");
            map.remove("menutitle");
        }
        this.readAppSchemaElement("action_preference.xml", map, project);
    }

    private void createAction_releaseLogonUser(Project project) {
        this.readAppSchemaElement("action_releaseLogonUser.xml", project);
    }

    private void createPresentation_showListLogonUsers(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_showListLogonUsers.xml", replaceMap, project);
    }

    private void createAction_showListLogonUsers(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("showListLogonUsers", "1250", "admin", null, null, rman.getValue("r.project.menu.showListLogonUsers"));
        this.readAppSchemaElement("action_showListLogonUsers.xml", map, project);
    }

    private void createPresentation_showListLog(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_showListLog.xml", replaceMap, project);
    }

    private void createAction_showListLog(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("showListLog", "1300", "admin", null, null, rman.getValue("r.project.menu.showListLog"));
        this.readAppSchemaElement("action_showListLog.xml", map, project);
    }

    private void createPresentation_noData(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_noData.xml", replaceMap, project);
    }

    private void createAction_noData(Project project) {
        this.readAppSchemaElement("action_noData.xml", project);
    }

    private void createPresentation_empty(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_empty.xml", replaceMap, project);
    }

    private void createAction_empty(Project project) {
        this.readAppSchemaElement("action_empty.xml", project);
    }

    private void createPresentation_menu(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        StringBuilder sb = new StringBuilder();
        Displaymodel model = new Displaymodel();
        model.setIdref("menubar");
        model.setAliasid("__jfc_menubar");
        model.setUsefile("system/displayMenubar_12colors.jsp");
        sb.append(model);
        replaceMap.put("displaymodel", sb.toString());
        this.readAppSchemaElement("presentation_menu.xml", replaceMap, project);
    }

    private void createPresentation_maintenance(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_maintenanceApp.xml", replaceMap, project);
    }

    private void createAction_maintenance(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("maintenanceApp", "1350", "admin", null, null, rman.getValue("r.project.menu.maintenanceApp"));
        this.readAppSchemaElement("action_maintenanceApp.xml", map, project);
    }

    private void createPresentation_analyticsLog(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_analyticsLog.xml", replaceMap, project);
    }

    private void createAction_analyticsLog(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("analyticsLog", "1700", "admin", null, null, rman.getValue("r.project.menu.analyticsLog"));
        this.readAppSchemaElement("action_analyticsLog.xml", map, project);
    }

    private void createPresentation_webapi(Project project) {
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        replaceMap.put("sidebarSubmenu", Boolean.FALSE);
        this.readAppSchemaElement("presentation_webapi.xml", replaceMap, project);
    }

    private void createAction_webapi(Project project) {
        Map<String, Object> map = this.createMenuParameterMap("webapi", "1750", "admin", null, null, rman.getValue("r.project.menu.webapi"));
        this.readAppSchemaElement("action_webapi.xml", map, project);
    }

    private void createPresentation_mobileMenu(Project project) {
        if (!this.isSmartPhoneModelExists()) {
            return;
        }
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        Displaymodel displaymodel = new Displaymodel();
        displaymodel.setIdref("menubar");
        displaymodel.setAliasid("__jfc_menubar");
        displaymodel.setUsefile("system/displayMenubar_mobile.jsp");
        replaceMap.put("displaymodel", displaymodel);
        this.readAppSchemaElement("presentation_mobileMenu.xml", replaceMap, project);
    }

    private boolean isSmartPhoneModelExists() {
        for (String modelId : this.con_.getAllStoreModelId()) {
            if (!Utils.isSmartPhone(modelId, this.con_)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> createMenuParameterMap(String rkey, String default_menuorder, String default_menuref, String default_menucolor, String default_menulabelcolor, String default_description) {
        return BCommon.createMenuParameterMap(this.con_, rkey, default_menuorder, default_menuref, default_menucolor, default_menulabelcolor, default_description);
    }

    static Map<String, Object> createMenuParameterMap(ElementContainer con_, String rkey, String default_menuorder, String default_menuref, String default_menucolor, String default_menulabelcolor, String default_description) {
        String menuIconClass;
        String menulabelcolor;
        String description = null;
        String menutitle = con_.getProjectValue("project/environment/menu/" + rkey);
        if (StringUtils.isBlank((CharSequence)menutitle)) {
            description = default_description;
            menutitle = default_description;
        } else {
            description = new String(menutitle);
        }
        description = description != null ? description.replaceAll("<br/>", "") : "";
        menutitle = menutitle != null ? menutitle.replaceAll("<br/>", "&#10;") : null;
        String menuref = con_.getProjectValue("project/environment/menu/" + rkey + "_2");
        if (StringUtils.isNotBlank((CharSequence)menuref)) {
            boolean isAfterR67Flag = false;
            for (Map.Entry<String, String> e : con_.getProjectRepositoryAsMap().entrySet()) {
                String name;
                String key = e.getKey();
                if (!key.startsWith("project/environment/menu/@") || !(name = con_.getProjectValue(key)).equals(menuref)) continue;
                menuref = key.substring("project/environment/menu/@".length());
                isAfterR67Flag = true;
                break;
            }
            if (!isAfterR67Flag) {
                if (rman.getValue("r.project.menu.admin").equals(menuref)) {
                    menuref = "admin";
                } else if (rman.getValue("r.project.menu.mastermenu").equals(menuref)) {
                    menuref = "mastermenu";
                } else if (rman.getValue("r.project.menu.appmenu").equals(menuref)) {
                    menuref = "appmenu";
                } else if (rman.getValue("r.project.menu.common").equals(menuref)) {
                    menuref = "common";
                }
            }
        } else {
            menuref = default_menuref;
        }
        String menuorder = con_.getProjectValue("project/environment/menu/" + rkey + "_3");
        if (StringUtils.isBlank((CharSequence)menuorder)) {
            menuorder = default_menuorder;
        } else {
            int tmp = StringUtil.intValue((String)menuorder);
            if (tmp <= 0) {
                menuorder = default_menuorder;
            }
        }
        String menucolor = con_.getProjectValue("project/environment/menu/" + rkey + "_4");
        if (StringUtils.isBlank((CharSequence)menucolor)) {
            menucolor = default_menucolor;
        }
        if (StringUtils.isBlank((CharSequence)(menulabelcolor = con_.getProjectValue("project/environment/menu/" + rkey + "_5")))) {
            menulabelcolor = default_menulabelcolor;
        }
        if (StringUtils.isBlank((CharSequence)(menuIconClass = con_.getProjectValue("project/environment/menu/" + rkey + "_6")))) {
            menuIconClass = "fas fa-cubes";
        }
        String menuTooltip = con_.getProjectValue("project/environment/menu/" + rkey + "_7");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuorder", Integer.valueOf(menuorder));
        map.put("menuref", menuref);
        map.put("menucolor", menucolor);
        map.put("menulabelcolor", menulabelcolor);
        map.put("description", description);
        map.put("menutitle", menutitle);
        map.put("menuIconClass", menuIconClass);
        map.put("menuTooltip", menuTooltip);
        return map;
    }
}

