/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.io.File;
import java.io.FileFilter;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Jarfile;
import jp.jasminesoft.jfc.gen.appschema.Jarfilelist;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.jfc.tools.xls2appschema.WagbyR6DefElementContainer;
import jp.jasminesoft.util.PrefixSuffixFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="BJarfilelist")
public class BJarfilelist
extends AppSchemaBuilder {
    protected Logger log = LogManager.getLogger(BJarfilelist.class);

    @Override
    public void process(Project project) {
        Jarfilelist jarfilelist = new Jarfilelist();
        jarfilelist.addJarfile(this.createJarfile("wagbyapp.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("log4j-api.jar", "InitLoader UploadFilenameConverter", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("log4j-core.jar", "InitLoader UploadFilenameConverter", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("log4j-slf4j-impl.jar", "InitLoader UploadFilenameConverter", new JarfileType[0]));
        Database database = AppSchemaUtil.getDatabase((Environment)project.getEnvironment());
        File tomcatlib = new File(((WagbyR6DefElementContainer)this.con_).getCustomizeDirectory() + "/tomcat/lib");
        boolean addJDBCDriver = false;
        if (!tomcatlib.exists() || !tomcatlib.isDirectory()) {
            tomcatlib = new File(((WagbyR6DefElementContainer)this.con_).getCustomizeDirectory() + "/lib-common/");
        }
        if (!tomcatlib.exists()) {
            String base = ((WagbyR6DefElementContainer)this.con_).getCustomizeDirectory();
            tomcatlib = new File((base = base.replace("customize", "../customize")) + "/tomcat/lib");
            if (!tomcatlib.exists() || !tomcatlib.isDirectory()) {
                tomcatlib = new File(base + "/lib-common/");
            }
        }
        if (tomcatlib.exists() && tomcatlib.isDirectory()) {
            PrefixSuffixFilter filter = new PrefixSuffixFilter();
            filter.setPermitSuffix(".jar");
            File[] lists = tomcatlib.listFiles((FileFilter)filter);
            if (lists != null && lists.length > 0) {
                for (File jarfile : lists) {
                    jarfilelist.addJarfile(this.createJarfile(jarfile.getName(), "InitLoader", JarfileType.Common));
                }
                addJDBCDriver = true;
            }
        }
        if (!addJDBCDriver) {
            if ("postgresql".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("postgresql.jar", "InitLoader", JarfileType.Common));
            } else if ("sql92".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("hsqldb.jar", "InitLoader", JarfileType.Common));
            } else if ("oracle".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("ojdbc14.jar", "InitLoader", JarfileType.Common));
            } else if ("mysql".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("mysql-connector-java.jar", "InitLoader", JarfileType.Common));
            } else if ("sqlserver2000".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("sqljdbc.jar", "InitLoader", JarfileType.Common));
            } else if ("db2".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("db2jcc.jar", "InitLoader", JarfileType.Common));
                jarfilelist.addJarfile(this.createJarfile("db2jcc_license_cu.jar", "InitLoader", JarfileType.Common));
            } else if ("AdaptiveServerAnywhere".equals(database.getType())) {
                jarfilelist.addJarfile(this.createJarfile("jconn3.jar", "InitLoader", JarfileType.Common));
            }
        }
        jarfilelist.addJarfile(this.createJarfile("j_jfc.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("j_jfc_model.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("j_util.jar", "InitLoader UploadFilenameConverter", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("j_workflow.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("velocity-engine-core.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-dbcp.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-pool.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("servlet-api.jar", "InitLoader", JarfileType.Env));
        jarfilelist.addJarfile(this.createJarfile("jaas.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jakarta.activation.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jakarta.mail.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("RelaxerOrg.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-beanutils.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-codec.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-collections.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-digester.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-fileupload.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-lang3.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-io.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-validator.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("j_jfcgen.jar", JarfileType.Compileonly));
        jarfilelist.addJarfile(this.createJarfile("commons-math3.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("antlr.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("classmate.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("byte-buddy.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("hibernate-commons-annotations.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("hibernate-core.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("javax.persistence-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jboss-logging.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jboss-transaction-api_1.2_spec.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("ehcache.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("slf4j-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("slf4j-log4j.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("dom4j.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("javassist.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jsonic.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-aop.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-aspects.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-beans.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-context.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-context-support.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-core.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-expression.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-instrument.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-jcl.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-jdbc.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-jms.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-orm.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-oxm.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-tx.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-web.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-webmvc.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jackson-core.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jackson-databind.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jackson-annotations.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("quartz.jar", "InitLoader", new JarfileType[0]));
        if (Utils.useJasperReports(this.con_)) {
            jarfilelist.addJarfile(this.createJarfile("jasperreports.jar", new JarfileType[0]));
            jarfilelist.addJarfile(this.createJarfile("itext.jar", new JarfileType[0]));
            jarfilelist.addJarfile(this.createJarfile("iTextAsian.jar", new JarfileType[0]));
        }
        if (Utils.isZipcodetype(this.con_)) {
            String[] anormversion = this.con_.getProjectValue("project/customize/@anormversion");
            if ("R5".equals(anormversion)) {
                jarfilelist.addJarfile(this.createJarfile("j_anorm5_proxy.jar", new JarfileType[0]));
            } else if ("R4".equals(anormversion)) {
                jarfilelist.addJarfile(this.createJarfile("j_anorm_proxy.jar", "InitLoader", new JarfileType[0]));
                jarfilelist.addJarfile(this.createJarfile("horb20.jar", new JarfileType[0]));
            } else {
                jarfilelist.addJarfile(this.createJarfile("j_anorm5_proxy.jar", new JarfileType[0]));
            }
        }
        jarfilelist.addJarfile(this.createJarfile("lucene-analyzers.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("lucene-core.jar", "InitLoader", new JarfileType[0]));
        for (String s : new String[]{"bcmail-jdk18.jar", "bcprov-jdk18.jar", "commons-compress.jar", "fontbox.jar", "jempbox.jar", "metadata-extractor.jar", "ooxml-schemas.jar", "pdfbox.jar", "tagsoup.jar", "tika-core.jar", "tika-parser-apple-module.jar", "tika-parser-audiovideo-module.jar", "tika-parser-cad-module.jar", "tika-parser-code-module.jar", "tika-parser-crypto-module.jar", "tika-parser-digest-commons.jar", "tika-parser-font-module.jar", "tika-parser-html-commons.jar", "tika-parser-html-module.jar", "tika-parser-image-module.jar", "tika-parser-mail-commons.jar", "tika-parser-mail-module.jar", "tika-parser-microsoft-module.jar", "tika-parser-miscoffice-module.jar", "tika-parser-news-module.jar", "tika-parser-ocr-module.jar", "tika-parser-pdf-module.jar", "tika-parser-pkg-module.jar", "tika-parser-text-module.jar", "tika-parser-xml-module.jar", "tika-parser-xmp-commons.jar", "tika-parser-zip-commons.jar", "commons-csv.jar", "jmatio.jar", "SparseBitSet.jar", "bcpkix-jdk18on.jar", "dd-plist.jar", "jackcess-encrypt.jar", "jackcess.jar", "java-libpst.jar", "junrar.jar", "parso.jar", "pdfbox-debugger.jar", "rome-utils.jar", "rome.jar", "xmpcore-shaded.jar", "xmlbeans.jar", "aopalliance.jar", "commons-lang.jar", "xmpcore.jar", "apache-mime4j-core.jar", "apache-mime4j-dom.jar", "asm.jar", "jhighlight.jar"}) {
            jarfilelist.addJarfile(this.createJarfile(s, "InitLoader", new JarfileType[0]));
        }
        jarfilelist.addJarfile(this.createJarfile("j_appid.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("ant.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("xercesImpl.jar", "UploadFilenameConverter", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("xml-apis.jar", "UploadFilenameConverter", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("renamefile.jar", "UploadFilenameConverter", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("poi.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("poi-ooxml.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("poi-ooxml-lite.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("poi-scratchpad.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-dbutils.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jackson-annotations.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jackson-core.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jackson-databind.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("backport-util-concurrent.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("ical4j.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jettison.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("xstream.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-batch-core.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-batch-infrastructure.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-retry.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("javax.batch-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-boot.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-boot-autoconfigure.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jakarta.jms-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-pool2.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jedis.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-data-redis.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-data-keyvalue.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-data-commons.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-session-data-redis.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-session.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-security-config.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-security-core.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-security-ldap.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("spring-security-web.jar", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("javax.activation-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jaxb-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("jaxb-runtime.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("istack-commons-runtime.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("javax.annotation-api.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("flyway-core.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("ehcache-jmsreplication.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("activemq-client.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("geronimo-j2ee-management_1.1_spec.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("hawtbuf.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("commons-collections4.jar", "InitLoader", new JarfileType[0]));
        jarfilelist.addJarfile(this.createJarfile("tomcat-util.jar", "InitLoader", JarfileType.Env));
        jarfilelist.addJarfile(this.createJarfile("tomcat-util-scan.jar", "InitLoader", JarfileType.Env));
        File customizelib = new File(((WagbyR6DefElementContainer)this.con_).getCustomizeDirectory() + "/webapp/WEB-INF/lib");
        if (!customizelib.exists()) {
            String base = ((WagbyR6DefElementContainer)this.con_).getCustomizeDirectory();
            base = base.replace("customize", "../customize");
            customizelib = new File(base + "/webapp/WEB-INF/lib");
        }
        if (customizelib.exists() && customizelib.isDirectory()) {
            PrefixSuffixFilter filter = new PrefixSuffixFilter();
            filter.setPermitSuffix(".jar");
            File[] lists = customizelib.listFiles((FileFilter)filter);
            if (lists != null && lists.length > 0) {
                for (File jarfile : lists) {
                    jarfilelist.addJarfile(this.createJarfile(jarfile.getName(), "InitLoader", new JarfileType[0]));
                }
            }
        }
        project.setJarfilelist(jarfilelist);
    }

    private Jarfile createJarfile(String filename, JarfileType ... types) {
        return this.createJarfile(filename, (String)null, types);
    }

    private Jarfile createJarfile(String filename, String pattern, JarfileType ... types) {
        Jarfile jarfile = new Jarfile();
        jarfile.setContent(filename);
        if (pattern != null) {
            jarfile.setMf(pattern);
        }
        if (types != null) {
            for (JarfileType type : types) {
                if (type == JarfileType.Common) {
                    jarfile.setCommon(true);
                    continue;
                }
                if (type == JarfileType.Generate) {
                    jarfile.setGenerate(true);
                    continue;
                }
                if (type == JarfileType.Env) {
                    jarfile.setEnv(true);
                    continue;
                }
                if (type != JarfileType.Compileonly) continue;
                jarfile.setCompileonly(true);
            }
        }
        return jarfile;
    }

    private static enum JarfileType {
        Common,
        Compileonly,
        Env,
        Generate;

    }
}

