/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jp.jasminesoft.jfc.gen.appschema.Menu;
import jp.jasminesoft.jfc.gen.appschema.Menubar;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.repository.RepositoryIO;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectOuterlinkContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="BMenubar")
public class BMenubar
extends AppSchemaBuilder {
    protected Logger log = LogManager.getLogger(BMenubar.class);
    @Autowired(required=true)
    protected ProjectOuterlinkContainer pcon_;
    private final String TYPE_STORE = "store";
    private final String TYPE_MASTER = "master";
    public static final String SUBMENU_SEPARATOR = "$MENUSEP$";
    private Map<String, String> menuCategoryMap = new HashMap<String, String>();
    private HashMap<String, Integer> menurefAndMinMenuorderMap = new HashMap();
    private Map<String, Map<String, String>> menurefAttrMap = new HashMap<String, Map<String, String>>();
    private Map<String, String> menuMap = new HashMap<String, String>();

    @Override
    public void process(Project project) {
        Menubar menubar = null;
        RepositoryIO rio = RepositoryIO.getInstance();
        rio.loadMenu(this.menuMap);
        menubar = this.process0();
        project.setMenubar(menubar);
    }

    public Menubar process0() {
        String keyheader;
        String[] storeModelIds = this.con_.getAllStoreModelId();
        this.getMenurefAndMenuorderFromStore(this.menurefAndMinMenuorderMap, storeModelIds);
        String[] masterModelIds = this.con_.getAllMasterModelId();
        this.getMenurefAndMenuorderFromMaster(this.menurefAndMinMenuorderMap, masterModelIds);
        this.getMenurefAndMenuorderFromOuterlink(this.menurefAndMinMenuorderMap);
        boolean isAfterR67Flag = false;
        Map<String, String> projectMap = this.con_.getProjectRepositoryAsMap();
        for (Map.Entry<String, String> e : projectMap.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith("project/environment/menu/@")) continue;
            String name = this.con_.getProjectValue(key);
            String order = this.con_.getProjectValue(key + "_2");
            String c_key = key.substring("project/environment/menu/@".length());
            if (c_key.endsWith("_2")) continue;
            this.menuCategoryMap.put(c_key, name);
            this.menurefAndMinMenuorderMap.put(c_key, StringUtil.intValue((String)order));
            isAfterR67Flag = true;
        }
        for (int i = 1; i <= Integer.MAX_VALUE && projectMap.containsKey((keyheader = "menutab[" + i + "]/@") + "name"); ++i) {
            String name = this.getValueFromMenuMap(keyheader + "name", projectMap.get(keyheader + "name"));
            String order = this.getValueFromMenuMap(keyheader + "order", projectMap.get(keyheader + "order"));
            String color = this.getValueFromMenuMap(keyheader + "color", projectMap.get(keyheader + "color"));
            String labelcolor = this.getValueFromMenuMap(keyheader + "labelcolor", projectMap.get(keyheader + "labelcolor"));
            String menuImgSrc = this.getValueFromMenuMap(keyheader + "menuImgSrc", projectMap.get(keyheader + "menuImgSrc"));
            String menuImgStyle = this.getValueFromMenuMap(keyheader + "menuImgStyle", projectMap.get(keyheader + "menuImgStyle"));
            String tooltip = this.getValueFromMenuMap(keyheader + "menuTooltip", projectMap.get(keyheader + "menuTooltip"));
            String iconClass = this.getValueFromMenuMap(keyheader + "menuIconClass", projectMap.get(keyheader + "menuIconClass"));
            String menuref1 = Utils.adjustProperMenuref(name);
            this.menurefAndMinMenuorderMap.put(menuref1, StringUtil.intValue((String)order));
            Map<String, String> attrMap = this.menurefAttrMap.get(menuref1);
            if (attrMap == null) {
                attrMap = new HashMap<String, String>();
                this.menurefAttrMap.put(menuref1, attrMap);
            }
            attrMap.put("order", order);
            attrMap.put("color", color);
            attrMap.put("labelcolor", labelcolor);
            attrMap.put("menuImgSrc", menuImgSrc);
            attrMap.put("menuImgStyle", menuImgStyle);
            attrMap.put("menuTooltip", tooltip);
            attrMap.put("menuIconClass", iconClass);
        }
        if (!isAfterR67Flag) {
            this.menuCategoryMap.put("admin", rman.getValue("r.project.menu.admin"));
            this.menuCategoryMap.put("mastermenu", rman.getValue("r.project.menu.mastermenu"));
            this.menuCategoryMap.put("appmenu", rman.getValue("r.project.menu.appmenu"));
            this.menuCategoryMap.put("common", rman.getValue("r.project.menu.common"));
            this.menurefAndMinMenuorderMap.put("admin", 1000);
            this.menurefAndMinMenuorderMap.put("mastermenu", 2000);
            this.menurefAndMinMenuorderMap.put("appmenu", 3000);
            this.menurefAndMinMenuorderMap.put("common", 4000);
        }
        this.menuCategoryMap.put("jfcNoneOfMenuCategory", "");
        HashSet<String> rootSet = this.createRootMenu(this.menurefAndMinMenuorderMap);
        HashMap<String, HashSet<String>> parentChildMap = this.createParentChildMap(this.menurefAndMinMenuorderMap);
        Menu[] menu_arr = this.createRootMenuSet(this.menurefAndMinMenuorderMap, rootSet, parentChildMap);
        Menubar menubar = new Menubar();
        menubar.setId("menubar");
        for (int i = 0; i < menu_arr.length; ++i) {
            this.changeMenuTitle(menu_arr[i]);
        }
        menubar.addMenu(menu_arr);
        return menubar;
    }

    private String getValueFromMenuMap(String key, String defaultValue) {
        String value = this.menuMap.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    private void getMenurefAndMenuorderFromOuterlink(HashMap<String, Integer> menurefAndMinMenuorderMap) {
        for (Map<String, String> map : this.pcon_.getOuterlinkInfoMaps()) {
            int tmp_menuorder;
            String desc = map.get("menulinkaction/@description");
            String menuref = Utils.adjustProperMenuref(map.get("menulinkaction/@menuref"));
            if (menuref == null || "".equals(menuref)) continue;
            String menuorder = map.get("menulinkaction/@menuorder");
            int menuorderInt = 100;
            try {
                menuorderInt = this.changeMenuorder(menuref, Integer.parseInt(menuorder));
            }
            catch (NumberFormatException e1) {
                this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMenubar.getMenurefAndMenuorderFromOuterlink", new Object[]{desc}));
            }
            int minMenuorder = menuorderInt;
            if (menurefAndMinMenuorderMap.containsKey(menuref) && (tmp_menuorder = menurefAndMinMenuorderMap.get(menuref).intValue()) < minMenuorder) {
                minMenuorder = tmp_menuorder;
            }
            menurefAndMinMenuorderMap.put(menuref, minMenuorder);
            this.getParentMenurefAndMenuorderFromOuterlink(menuref, minMenuorder, menurefAndMinMenuorderMap);
        }
    }

    private void getParentMenurefAndMenuorderFromOuterlink(String menuref, int menuorder, HashMap<String, Integer> menurefAndMinMenuorderMap) {
        int tmp_menuorder;
        if (!menuref.contains(SUBMENU_SEPARATOR)) {
            return;
        }
        String parent = this.getParent(menuref);
        int minMenuorder = menuorder;
        if (menurefAndMinMenuorderMap.containsKey(parent) && (tmp_menuorder = menurefAndMinMenuorderMap.get(parent).intValue()) < minMenuorder) {
            minMenuorder = tmp_menuorder;
        }
        menurefAndMinMenuorderMap.put(parent, minMenuorder);
        this.getParentMenurefAndMenuorderFromOuterlink(parent, minMenuorder, menurefAndMinMenuorderMap);
    }

    private HashSet<String> createRootMenu(HashMap<String, Integer> menurefAndMinMenuorderMap) {
        HashSet<String> rootSet = new HashSet<String>();
        HashMap<String, Integer> parentMap = new HashMap<String, Integer>();
        for (String menuref : menurefAndMinMenuorderMap.keySet()) {
            this.checkAllMenurefAndMinMenuorder(menuref, Integer.MIN_VALUE, menurefAndMinMenuorderMap, rootSet, parentMap);
        }
        menurefAndMinMenuorderMap.putAll(parentMap);
        return rootSet;
    }

    private HashMap<String, HashSet<String>> createParentChildMap(HashMap<String, Integer> menurefAndMinMenuorderMap) {
        HashMap<String, HashSet<String>> parentChildMap = new HashMap<String, HashSet<String>>();
        for (String menuref : menurefAndMinMenuorderMap.keySet().toArray(new String[0])) {
            HashSet<Object> children;
            if (!menuref.contains(SUBMENU_SEPARATOR)) {
                if (parentChildMap.containsKey(menuref)) continue;
                HashSet children2 = new HashSet();
                parentChildMap.put(menuref, children2);
                continue;
            }
            String parent = this.getParent(menuref);
            String child = menuref;
            if (!parentChildMap.containsKey(parent)) {
                children = new HashSet<String>();
                children.add(child);
                parentChildMap.put(parent, children);
                continue;
            }
            children = parentChildMap.get(parent);
            children.add(child);
        }
        return parentChildMap;
    }

    private void getMenurefAndMenuorderFromStore(HashMap<String, Integer> menurefAndMinMenuorderMap, String[] modelIds) {
        this.getMenurefAndMenuorder("store", menurefAndMinMenuorderMap, modelIds);
    }

    private void getMenurefAndMenuorderFromMaster(HashMap<String, Integer> menurefAndMinMenuorderMap, String[] modelIds) {
        this.getMenurefAndMenuorder("master", menurefAndMinMenuorderMap, modelIds);
    }

    private void getMenurefAndMenuorder(String type, HashMap<String, Integer> menurefAndMinMenuorderMap, String[] modelIds) {
        for (String modelId : modelIds) {
            String[] keys;
            if ("master".equals(type)) {
                String menuref = Utils.getMasterModelMenuref(modelId, this.con_);
                Integer menuorder = Utils.getMasterModelMenuorder(modelId, this.con_);
                this.setMenurefAndMenuorder(modelId, menuref, menuorder, menurefAndMinMenuorderMap);
                continue;
            }
            for (String key : keys = new String[]{"action/@menuNameSelect", "action/@menuNameInsert", "action/@menuNameUpdatelist", "action/@menuNameReportlist", "action/@menuNameCalendarView", "action/@menuNameTotalview", "action/@menuNameTotalview2", "action/@menuNameTotalview3", "action/@menuNameTotalview4", "action/@menuNameTotalview5", "action/@menuNameTotalview6", "action/@menuNameTotalview7", "action/@menuNameTotalview8", "action/@menuNameTotalview9", "action/@menuNameTotalview10", "action/@menuNameDownload", "action/@menuNameUploadupdate"}) {
                String menuref = Utils.getStoreModelMenuref(modelId, key, this.con_);
                Integer menuorder = Utils.getStoreModelMenuorder(modelId, key.replaceAll("action/@menuName", "action/@menuorder"), this.con_);
                this.setMenurefAndMenuorder(modelId, menuref, menuorder, menurefAndMinMenuorderMap);
            }
        }
    }

    private void setMenurefAndMenuorder(String modelId, String menuref, Integer menuorder, HashMap<String, Integer> menurefAndMinMenuorderMap) {
        int tmp_menuorder;
        int menuorderInt = 100;
        if (menuorder != null) {
            menuorderInt = menuorder;
        }
        if ((menuorderInt = this.changeMenuorder(menuref, menuorderInt)) < 0) {
            this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMenubar.setMenurefAndMenuorder", new Object[]{modelId}));
            return;
        }
        int minMenuorder = menuorderInt;
        if (menurefAndMinMenuorderMap.containsKey(menuref) && (tmp_menuorder = menurefAndMinMenuorderMap.get(menuref).intValue()) < minMenuorder) {
            minMenuorder = tmp_menuorder;
        }
        menurefAndMinMenuorderMap.put(menuref, minMenuorder);
        this.getParentMenurefAndMenuorderFromOuterlink(menuref, minMenuorder, menurefAndMinMenuorderMap);
    }

    private Menu[] createRootMenuSet(HashMap<String, Integer> menurefAndMinMenuorderMap, HashSet<String> rootSet, HashMap<String, HashSet<String>> parentChildMap) {
        HashSet<Menu> menuSet = new HashSet<Menu>();
        for (String root : rootSet) {
            Integer menuorder = menurefAndMinMenuorderMap.get(root);
            String childNormalName = this.getChild(root);
            Menu rootMenu = this.createMenu(childNormalName, menuorder);
            menuSet.add(rootMenu);
            HashSet<String> children = parentChildMap.get(root);
            if (children == null) continue;
            this.createChildrenMenu(menurefAndMinMenuorderMap, parentChildMap, rootMenu, root);
        }
        Menu[] menu_arr = menuSet.toArray(new Menu[0]);
        Arrays.sort(menu_arr, new MenuComparator());
        return menu_arr;
    }

    private void createChildrenMenu(HashMap<String, Integer> menurefAndMinMenuorderMap, HashMap<String, HashSet<String>> parentChildMap, Menu parentMenu, String parentFullMenuTitle) {
        HashSet<String> childSet = parentChildMap.get(parentFullMenuTitle);
        if (childSet == null) {
            return;
        }
        HashSet<Menu> menuSet = new HashSet<Menu>();
        for (String child : childSet) {
            Integer menuorder = menurefAndMinMenuorderMap.get(child);
            Menu childMenu = this.createMenu(child, menuorder);
            menuSet.add(childMenu);
            HashSet<String> children = parentChildMap.get(child);
            if (children == null) continue;
            this.createChildrenMenu(menurefAndMinMenuorderMap, parentChildMap, childMenu, child);
        }
        Menu[] menu_arr = menuSet.toArray(new Menu[0]);
        Arrays.sort(menu_arr, new MenuComparator());
        parentMenu.addMenu(menu_arr);
    }

    private String getChild(String menuref) {
        String[] menurefSplit = StringUtils.splitByWholeSeparator((String)menuref, (String)SUBMENU_SEPARATOR);
        String child = menurefSplit.length > 1 ? menurefSplit[menurefSplit.length - 1] : menurefSplit[0];
        return child;
    }

    private void checkAllMenurefAndMinMenuorder(String menuref, int minMenuorderOfChildren, HashMap<String, Integer> menurefAndMinMenuorderMap, HashSet<String> rootSet, HashMap<String, Integer> parentMap) {
        int minMenuorder;
        String parent = this.getParent(menuref);
        if (menurefAndMinMenuorderMap.containsKey(parent)) {
            minMenuorder = menurefAndMinMenuorderMap.get(parent);
            int menuorder = menurefAndMinMenuorderMap.get(menuref);
            if (menuorder < minMenuorder) {
                minMenuorder = menuorder;
                parentMap.put(parent, minMenuorder);
            }
        } else {
            minMenuorder = menurefAndMinMenuorderMap.containsKey(menuref) ? menurefAndMinMenuorderMap.get(menuref) : minMenuorderOfChildren;
            parentMap.put(parent, minMenuorder);
        }
        if (!parent.contains(SUBMENU_SEPARATOR)) {
            rootSet.add(parent);
            return;
        }
        this.checkAllMenurefAndMinMenuorder(parent, minMenuorder, menurefAndMinMenuorderMap, rootSet, parentMap);
    }

    private String getParent(String menuref) {
        if (!menuref.contains(SUBMENU_SEPARATOR)) {
            return menuref;
        }
        Object parent = "";
        String[] menurefSplit = StringUtils.splitByWholeSeparator((String)menuref, (String)SUBMENU_SEPARATOR);
        for (int i = 0; i < menurefSplit.length - 1; ++i) {
            parent = (String)parent + menurefSplit[i];
            if (i >= menurefSplit.length - 2) continue;
            parent = (String)parent + SUBMENU_SEPARATOR;
        }
        return parent;
    }

    private int changeMenuorder(String menuref, int menuorder) {
        int ret = menuorder;
        for (Map.Entry<String, String> e : this.menuCategoryMap.entrySet()) {
            if (!menuref.equals(e.getKey()) && !menuref.equals(e.getValue())) continue;
            ret = this.menurefAndMinMenuorderMap.get(e.getKey());
            break;
        }
        return ret;
    }

    private Menu createMenu(String id, Integer order) {
        Map<String, String> attrMap = this.menurefAttrMap.get(id);
        Menu menu = new Menu();
        menu.setId(id);
        menu.setOrder(order);
        if (attrMap != null) {
            String menuIconClass;
            String menuTooltip;
            String menuImgStyle;
            String menuImgSrc;
            String labelcolor;
            String color = attrMap.get("color");
            if (StringUtils.isNotBlank((CharSequence)color)) {
                menu.setMenucolor(color);
            }
            if (StringUtils.isNotBlank((CharSequence)(labelcolor = attrMap.get("labelcolor")))) {
                menu.setMenulabelcolor(labelcolor);
            }
            if (StringUtils.isNotBlank((CharSequence)(menuImgSrc = attrMap.get("menuImgSrc")))) {
                menu.setMenuImgSrc(menuImgSrc);
            }
            if (StringUtils.isNotBlank((CharSequence)(menuImgStyle = attrMap.get("menuImgStyle")))) {
                menu.setMenuImgStyle(menuImgStyle);
            }
            if (StringUtils.isNotBlank((CharSequence)(menuTooltip = attrMap.get("menuTooltip")))) {
                menu.setMenuTooltip(menuTooltip);
            }
            if (StringUtils.isNotBlank((CharSequence)(menuIconClass = attrMap.get("menuIconClass")))) {
                menu.setMenuIconClass(menuIconClass);
            }
        }
        return menu;
    }

    private void changeMenuTitle(Menu menu) {
        Menu[] child_arr = menu.getMenu();
        menu.setTitle(this.getMenuTitle(menu.getId()));
        if (child_arr.length == 0) {
            return;
        }
        ArrayList<Menu> list = new ArrayList<Menu>();
        for (int i = 0; i < child_arr.length; ++i) {
            Menu childmenu = child_arr[i];
            Map<String, String> attrMap = this.menurefAttrMap.get(childmenu.getId());
            if (attrMap == null || attrMap.get("order") == null) {
                list.add(childmenu);
            }
            this.changeMenuTitle(childmenu);
        }
        Integer minmenuorder = this.menurefAndMinMenuorderMap.get(menu.getId());
        int order = minmenuorder;
        Collections.reverse(list);
        for (Menu childmenu : list) {
            childmenu.setOrder(--order);
        }
    }

    private String getMenuTitle(String menutitle) {
        String[] menutitleSplit;
        String ret = menutitle;
        if (this.menuCategoryMap.containsKey(menutitle)) {
            ret = this.menuCategoryMap.get(menutitle);
        }
        if ((menutitleSplit = StringUtils.splitByWholeSeparator((String)menutitle, (String)SUBMENU_SEPARATOR)).length > 1) {
            ret = menutitleSplit[menutitleSplit.length - 1];
        }
        return ret;
    }

    static class MenuComparator
    implements Comparator<Menu> {
        MenuComparator() {
        }

        @Override
        public int compare(Menu o1, Menu o2) {
            int ret = o1.getOrder() - o2.getOrder();
            if (ret == 0) {
                ret = o1.getId().compareTo(o2.getId());
            }
            return ret;
        }
    }
}

