/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Component(value="BProject")
public class BProject
extends AppSchemaBuilder {
    protected static Logger logger = LogManager.getLogger(BProject.class);
    protected static String devhomePath = "../../";
    private static final String LICENSEKYE_FILE = "wagby-licensekey.xml";
    private static final String DEFAULT_PROJECT_PACKAGE = "jp.jasminesoft.wagby";
    private static final Collection<String> keywords = Collections.unmodifiableCollection(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "true", "false"));

    @Override
    public void process(Project project) {
        String licensekey = "";
        try {
            DOMParser parser = new DOMParser();
            File f = new File("../wagby-licensekey.xml");
            if (!f.exists()) {
                f = new File(devhomePath + LICENSEKYE_FILE);
            }
            parser.parse(f.getAbsolutePath());
            Document document = parser.getDocument();
            if (document.hasChildNodes()) {
                Node node = document.getFirstChild();
                licensekey = node.getTextContent();
            } else {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.process.1"));
            }
        }
        catch (SAXException e) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.process.2"));
        }
        catch (IOException e) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.process.1"));
        }
        String project_package = this.getProjectPackage();
        String project_id = this.getProjectId(project_package);
        String project_title = this.getProjectTitle(project_id);
        String webappname = this.con_.getProjectValue("project/@id");
        if (Utils.isMicroservice(this.con_)) {
            webappname = null;
        }
        if (webappname != null) {
            webappname = webappname.trim();
        }
        if (ExcelFunction.ISINCLUDE((String)webappname, (String)" \u3000\t")) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.process.3", new Object[]{webappname}));
        }
        String project_version = "9";
        try {
            List lines = FileUtils.readLines((File)new File(devhomePath, "version.txt"), (String)StandardCharsets.UTF_8.name());
            if (!lines.isEmpty()) {
                project_version = (String)lines.get(0);
            }
            if (project_version.indexOf(" ") > 0) {
                project_version = project_version.substring(project_version.indexOf(" ") + 1);
            }
            if (project_version.lastIndexOf(" ") > 0) {
                project_version = project_version.substring(0, project_version.lastIndexOf(" "));
            }
            StringBuilder sb = new StringBuilder();
            int minseparator = 0;
            for (int i = 0; i < project_version.length(); ++i) {
                char ch = project_version.charAt(i);
                if ((ch < '0' || ch > '9') && ch != '.') continue;
                if (ch == '.' && ++minseparator > 1) break;
                sb.append(ch);
            }
            project_version = sb.toString();
        }
        catch (IOException e) {
            logger.warn("Read error, version.txt");
        }
        String project_licensekey = licensekey;
        project.setName(StringUtil.escapeStringForXML((String)project_id));
        project.setTitle(StringUtil.escapeStringForXML((String)project_title));
        project.setPackage(StringUtil.escapeStringForXML((String)project_package));
        if (StringUtils.isNotBlank((CharSequence)webappname)) {
            project.setWebappname(StringUtil.escapeStringForXML((String)webappname));
        }
        project.setLicensekey(StringUtil.escapeStringForXML((String)project_licensekey));
        project.setVersion(project_version);
        project.setDebug(false);
        project.setDebugcompile(true);
        project.setBasedir("work/srcgen");
        project.setUseCVS(true);
        project.setEncoding("UTF-8");
        project.setWebencoding("UTF-8");
        String desc = this.con_.getProjectValue("project/@description");
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            project.setDescription(StringUtil.escapeStringForXML((String)desc));
        }
    }

    private String getProjectId(String projectid) {
        return StringUtils.substringAfterLast((String)projectid, (String)".");
    }

    private String getProjectTitle(String pid) {
        String ptitle = this.con_.getProjectValue("project/@title");
        if ((ptitle == null || "".equals(ptitle)) && pid != null) {
            this.getMessageListener().info(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.getProjectTitle", new Object[]{pid}));
            ptitle = pid;
        }
        return ptitle;
    }

    private String getProjectPackage() {
        String ppackage = this.con_.getProjectValue("project/@package");
        if (StringUtils.isBlank((CharSequence)ppackage)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.getProjectPackage", new Object[]{DEFAULT_PROJECT_PACKAGE}));
            ppackage = DEFAULT_PROJECT_PACKAGE;
        }
        if ((ppackage = ppackage.trim()).endsWith(".")) {
            ppackage = ppackage.substring(0, ppackage.length() - 1);
        }
        if (!this.validatePackagename(ppackage)) {
            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.getProjectPackage.2", new Object[]{ppackage}));
            if (ppackage.indexOf("-") > -1) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BProject.getProjectPackage.3"));
            }
            ppackage = DEFAULT_PROJECT_PACKAGE;
        }
        return ppackage;
    }

    private boolean validatePackagename(String packagename) {
        for (String s : StringUtils.split((String)packagename, (char)'.')) {
            if (BProject.isIdentifier(s) && !BProject.isKeyword(s)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifier(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    private static boolean isKeyword(String id) {
        return keywords.contains(id);
    }
}

