/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.util.Map;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Menulinkaction;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppSchemaBuilder;
import jp.jasminesoft.jfc.tools.xls2appschema.ProjectOuterlinkContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="BProjectOuterlink")
public class BProjectOuterlink
extends AppSchemaBuilder {
    protected Logger log = LogManager.getLogger(BProjectOuterlink.class);
    @Autowired(required=true)
    protected ProjectOuterlinkContainer pcon_;

    @Override
    public void process(Project project) {
        this.addMenulinkaction(project);
    }

    private void addMenulinkaction(Project project) {
        String webappname = (String)StringUtils.defaultIfEmpty((CharSequence)project.getWebappname(), (CharSequence)"");
        boolean useSpringSession = false;
        Environment env = project.getEnvironment();
        if (env.getHttpSessionStoreType().equals("springsession_redis") || env.getHttpSessionStoreType().equals("springsession_hashmap")) {
            useSpringSession = true;
        }
        for (Map<String, String> map : this.pcon_.getOuterlinkInfoMaps()) {
            String menuIconClass;
            String menuref = Utils.adjustProperMenuref(map.get("menulinkaction/@menuref"));
            Object menuurl = map.get("menulinkaction/@menuurl");
            String description = map.get("menulinkaction/@description");
            description = description != null ? description.replaceAll("<br/>", "&#10;") : null;
            String menuorder = map.get("menulinkaction/@menuorder");
            String menucolor = map.get("menulinkaction/@menucolor");
            String menulabelcolor = map.get("menulinkaction/@menulabelcolor");
            String target = map.get("menulinkaction/@target");
            if (description == null || "".contains(description) || menuref == null && "".equals(menuurl)) continue;
            Menulinkaction menulinkaction = new Menulinkaction();
            if (menuref != null && !"".equals(menuref)) {
                menulinkaction.setMenuref(menuref);
            }
            if (menuurl != null && !"".equals(menuurl)) {
                String chkheader;
                if (useSpringSession && ((String)menuurl).startsWith(chkheader = "/" + webappname)) {
                    String prestr = ((String)menuurl).substring(0, chkheader.length());
                    String poststr = ((String)menuurl).substring(chkheader.length());
                    menuurl = StringUtils.isNotBlank((CharSequence)webappname) ? prestr + "/${multisessionid}" + poststr : "/${multisessionid}/" + poststr;
                }
                menulinkaction.setMenuurl((String)menuurl);
            }
            if (description != null && !"".equals(description)) {
                menulinkaction.setDescription(description);
            }
            try {
                menulinkaction.setMenuorder(Integer.parseInt(menuorder));
            }
            catch (NumberFormatException e) {
                this.getMessageListener().warn(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.builder.project.BMenubar.getMenurefAndMenuorderFromOuterlink", new Object[]{description}));
            }
            if (menucolor != null && !"".equals(menucolor)) {
                menulinkaction.setMenucolor(menucolor);
            }
            if (menulabelcolor != null && !"".equals(menulabelcolor)) {
                menulinkaction.setMenulabelcolor(menulabelcolor);
            }
            if (target != null && !"".equals(target)) {
                menulinkaction.setTarget("_blank");
            }
            menulinkaction.setMobile("true".equals(map.get("menulinkaction/@mobile")));
            String imgSrc = map.get("menulinkaction/@menuImgSrc");
            String imgStyle = map.get("menulinkaction/@menuImgStyle");
            String tooltip = map.get("menulinkaction/@menuTooltip");
            if (StringUtils.isNotBlank((CharSequence)imgSrc)) {
                menulinkaction.setMenuImgSrc(imgSrc);
            }
            if (StringUtils.isNotBlank((CharSequence)imgStyle)) {
                menulinkaction.setMenuImgStyle(imgStyle);
            }
            if (StringUtils.isNotBlank((CharSequence)tooltip)) {
                menulinkaction.setMenuTooltip(tooltip);
            }
            if (StringUtils.isNotBlank((CharSequence)(menuIconClass = map.get("menulinkaction/@menuIconClass")))) {
                menulinkaction.setMenuIconClass(menuIconClass);
            }
            String linenumber = map.get("menulinkaction/@__linenumber");
            menulinkaction.setPermission(this.createPermission(linenumber));
            project.addContent((IProjectChoice)menulinkaction);
        }
    }

    private Permission createPermission(String linenumber) {
        Permission permission = new Permission();
        permission.setName("menulinkaction_" + linenumber);
        permission.setAction("menu");
        return permission;
    }
}

