/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.builder.project;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.InitLoaderFormInfoUtil;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Jfcmodel;
import jp.jasminesoft.jfc.gen.appschema.Jfcmodels;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;

public class JfcmodelInitDataCreator {
    private static final int SYSTEM_MODEL = 1;
    private static final int USER_MODEL = 2;
    private static final int STORE_MODEL = 1;
    private static final int MASTER_MODEL = 2;
    private Project project;
    private ElementContainer con;
    private Set<String> differentDomainModelIdSet;

    public JfcmodelInitDataCreator(ElementContainer con, Project project) {
        this.con = con;
        this.project = project;
    }

    public JfcmodelInitDataCreator setDifferentDomainModelIdSet(Set<String> differentDomainModelIdSet) {
        this.differentDomainModelIdSet = differentDomainModelIdSet;
        return this;
    }

    public Jfcmodels createJfcmodels() {
        Jfcmodels jfcmodels = new Jfcmodels();
        Predicate<Model> isStore = model -> "store".equals(model.getType());
        Predicate<Model> isMaster = model -> "master".equals(model.getType());
        Predicate<Model> isNotCompulsoryChangeM = model -> !"compulsoryChange_m".equals(model.getId());
        Stream.of(this.project.getContent()).filter(content -> content instanceof Model).map(content -> (Model)content).filter(isStore.or(isMaster).and(isNotCompulsoryChangeM)).forEach(model -> jfcmodels.addJfcmodel(this.createJfcmodel((Model)model)));
        this.addDifferentDomainModels(jfcmodels);
        return jfcmodels;
    }

    private Jfcmodel createJfcmodel(Model model) {
        if ("store".equals(model.getType())) {
            return this.createJfcStoreModel(model);
        }
        if ("master".equals(model.getType())) {
            return this.createJfcMasterModel(model);
        }
        throw new IllegalStateException("Unreachable");
    }

    private Jfcmodel createJfcStoreModel(Model model) {
        Jfcmodel jfcmodel = new Jfcmodel();
        jfcmodel.setNameEn(model.getId());
        jfcmodel.setNameJp(model.getDescription());
        jfcmodel.setKind(1);
        jfcmodel.setCreatetype(this.getCreateType(model.getId()));
        jfcmodel.setUseWorkflow(this.getUseWorkflow(model));
        jfcmodel.setDomain(AppSchemaUtil.getDomains((Model)model, (Project)this.project));
        return jfcmodel;
    }

    private Jfcmodel createJfcMasterModel(Model model) {
        Jfcmodel jfcmodel = new Jfcmodel();
        jfcmodel.setNameEn(model.getId());
        jfcmodel.setNameJp(model.getDescription());
        jfcmodel.setKind(2);
        jfcmodel.setCreatetype(this.getCreateType(model.getId()));
        jfcmodel.setUseWorkflow(2);
        jfcmodel.setDomain(AppSchemaUtil.getDomains((Model)model, (Project)this.project));
        return jfcmodel;
    }

    private int getUseWorkflow(Model model) {
        if (model.getWorkflow()) {
            return 1;
        }
        return 2;
    }

    private int getCreateType(String modelId) {
        if (InitLoaderFormInfoUtil.IS_SYSTEM_MODEL((String)modelId)) {
            return 1;
        }
        return 2;
    }

    private void addDifferentDomainModels(Jfcmodels jfcmodels) {
        if (this.differentDomainModelIdSet == null) {
            return;
        }
        for (String modelId : this.differentDomainModelIdSet) {
            Jfcmodel jfcmodel = this.createJfcStoreModel(modelId);
            if (jfcmodel == null) continue;
            jfcmodels.addJfcmodel(jfcmodel);
        }
    }

    private Jfcmodel createJfcStoreModel(String modelId) {
        int[] domains = Utils.getDomain(modelId, this.con);
        if (domains.length == 0) {
            return null;
        }
        Jfcmodel jfcmodel = new Jfcmodel();
        jfcmodel.setNameEn(modelId);
        jfcmodel.setNameJp(Utils.getDescription(modelId, this.con));
        jfcmodel.setKind(1);
        jfcmodel.setCreatetype(this.getCreateType(modelId));
        if (Utils.isWorkflowModel(modelId, this.con)) {
            jfcmodel.setUseWorkflow(1);
        } else {
            jfcmodel.setUseWorkflow(2);
        }
        jfcmodel.addDomain(domains);
        return jfcmodel;
    }
}

