/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.error;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.tools.xls2appschema.AppschemaChecker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="CheckForeignKey")
public class CheckForeignKey
extends AppschemaChecker {
    @Override
    public void check(Project project) {
        for (IProjectChoice ipc : project.getContent()) {
            Model model;
            if (!(ipc instanceof Model) || !"store".equals((model = (Model)ipc).getType())) continue;
            for (IModelChoice imc : model.getContent()) {
                Modelitem mitem;
                if (!(imc instanceof ForeignKey)) continue;
                String modelId = model.getId();
                ForeignKey fkey = (ForeignKey)imc;
                Modelitem thisitem = AppSchemaUtil.getModelitem((String)fkey.getName(), (Model)model);
                if (thisitem == null) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckForeignKey.check.1", new Object[]{modelId, fkey.getName()}));
                    continue;
                }
                String thisitemtype = AppSchemaUtil.getModelitemType((Project)project, (String)model.getId(), (Modelitem)thisitem, (String)"roleid");
                String idref = fkey.getIdref();
                Model tmodel = AppSchemaUtil.getModel((Project)project, (String)idref);
                if (tmodel == null) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckForeignKey.check.2", new Object[]{modelId, idref}));
                    continue;
                }
                String refname = fkey.getRefname();
                if (StringUtils.isBlank((CharSequence)refname)) {
                    refname = fkey.getName();
                }
                if ((mitem = AppSchemaUtil.getModelitem((String)refname, (Model)tmodel)) == null) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckForeignKey.check.3", new Object[]{modelId, idref, refname}));
                    continue;
                }
                String ref_type = AppSchemaUtil.getModelitemType((Project)project, (String)tmodel.getId(), (Modelitem)mitem, (String)"roleid");
                if (thisitemtype.equals(ref_type)) continue;
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckForeignKey.check.4", new Object[]{modelId, fkey.getName(), thisitemtype, idref, refname, ref_type}));
            }
        }
    }
}

