/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.error;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.tools.xls2appschema.AppschemaChecker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="CheckMainSubModel")
public class CheckMainSubModel
extends AppschemaChecker {
    private CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();
    private Set<String> isNotPermitItem4JuserSubmodelSet;

    @PostConstruct
    public void init() throws Exception {
        this.isNotPermitItem4JuserSubmodelSet = new HashSet<String>();
        this.isNotPermitItem4JuserSubmodelSet.add("passwdNow");
        this.isNotPermitItem4JuserSubmodelSet.add("passwd2");
        this.isNotPermitItem4JuserSubmodelSet.add("compulsoryChange");
        this.isNotPermitItem4JuserSubmodelSet.add("passwdChangeDate");
        this.isNotPermitItem4JuserSubmodelSet.add("passwdChangeFlag");
        this.isNotPermitItem4JuserSubmodelSet.add("passwdErrCount");
        this.isNotPermitItem4JuserSubmodelSet.add("oldPasswds");
    }

    @Override
    public void check(Project project) {
        for (IProjectChoice ipc : project.getContent()) {
            String mainmodelidref;
            Model model;
            if (!(ipc instanceof Model) || !"store".equals((model = (Model)ipc).getType()) || StringUtils.isBlank((CharSequence)(mainmodelidref = model.getMainmodelidref()))) continue;
            String modelId = model.getId();
            if (mainmodelidref.equals(model.getId())) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.1", new Object[]{modelId}));
                continue;
            }
            Model tmodel = AppSchemaUtil.getStoreModel((Model)AppSchemaUtil.getModel((Project)project, (String)mainmodelidref));
            if (tmodel == null) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.2", new Object[]{modelId, mainmodelidref}));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)tmodel.getMainmodelidref())) {
                Object key = "jp.jasminesoft.jfc.tools.xls2appschema.builder.error.CheckMainSubModel.subsubmodel";
                if (!this.compatibilityManager.getBooleanValue((String)(key = (String)key + "." + modelId))) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.subsubmodel", new Object[]{modelId, mainmodelidref}));
                    continue;
                }
            }
            boolean isJuserSubmodel = "juser".equals(mainmodelidref);
            for (IModelChoice imc : model.getContent()) {
                if (!(imc instanceof Modelitem)) continue;
                Modelitem mitem = (Modelitem)imc;
                Modelitem m_mitem = AppSchemaUtil.getModelitem((String)mitem.getName(), (Model)tmodel);
                if (m_mitem == null || m_mitem.getTransient()) {
                    Relation _rel;
                    if (mitem.getTransient() || (_rel = AppSchemaUtil.getRelationTypeIsRef((Modelitem)mitem)) != null && "refmodel".equals(_rel.getRefstoretype())) continue;
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.3", new Object[]{modelId, mainmodelidref, mitem.getName()}));
                    continue;
                }
                if (!m_mitem.getExistCheck()) continue;
                String mitem_type = AppSchemaUtil.getModelitemType((Project)project, (String)model.getId(), (Modelitem)mitem, (String)"roleid");
                String m_mitem_type = AppSchemaUtil.getModelitemType((Project)project, (String)tmodel.getId(), (Modelitem)m_mitem, (String)"roleid");
                if (mitem_type != null && !mitem_type.equals(m_mitem_type)) {
                    this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.4", new Object[]{modelId, mainmodelidref, mitem.getName(), m_mitem_type, mitem_type}));
                    continue;
                }
                if (mitem.getType().equals("storeref")) {
                    Relation r_sub = AppSchemaUtil.getRelationTypeExceptRef((Modelitem)mitem);
                    Relation r_main = AppSchemaUtil.getRelationTypeExceptRef((Modelitem)m_mitem);
                    if (r_sub != null && r_main != null) {
                        boolean isCheckSub = r_sub.getType().equals("check");
                        boolean isCheckMain = r_main.getType().equals("check");
                        if (isCheckSub && !isCheckMain || !isCheckSub && isCheckMain) {
                            this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.5", new Object[]{modelId, mainmodelidref, mitem.getName(), r_main.getType(), r_sub.getType()}));
                            continue;
                        }
                    }
                }
                if (!isJuserSubmodel || !this.isNotPermitItem4JuserSubmodelSet.contains(mitem.getName())) continue;
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.CheckMainSubModel.check.juser", new Object[]{modelId, mitem.getName()}));
            }
        }
    }
}

