/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tools.xls2appschema.error;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.tools.xls2appschema.ElementContainer;
import jp.jasminesoft.jfc.tools.xls2appschema.ErrorChecker;
import jp.jasminesoft.jfc.tools.xls2appschema.Utils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="InvalidModelitemName")
public class InvalidModelitemName
extends ErrorChecker {
    @Override
    public void check() {
        String[] modelIds;
        ElementContainer con = this.getElementContainer();
        for (String modelId : modelIds = con.getAllStoreModelId()) {
            String[] names;
            for (String name : names = con.getModelitemNames(modelId)) {
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                this.checkModelitemName(modelId, name);
            }
        }
    }

    private void checkModelitemName(String modelId, String name) {
        if (AppSchemaUtil.hasChildPart((String)name)) {
            String pname = AppSchemaUtil.getParentPart((String)name);
            String cname = AppSchemaUtil.getChildPart((String)name);
            String errorCh = Utils.isValidName(pname);
            if (errorCh.length() > 0) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelitemName.check.1", new Object[]{modelId, pname, errorCh}));
            }
            if ((errorCh = Utils.isValidName(cname)).length() > 0) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelitemName.check.2", new Object[]{modelId, pname, cname, errorCh}));
            }
            if (!StringUtil.isValidXmlName((String)pname)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelitemName.check.3", new Object[]{modelId, pname}));
            }
            if (!StringUtil.isValidXmlName((String)cname)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelitemName.check.4", new Object[]{modelId, pname, cname}));
            }
        } else {
            String errorCh = Utils.isValidName(name);
            if (errorCh.length() > 0) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelitemName.check.5", new Object[]{modelId, name, errorCh}));
            }
            if (!StringUtil.isValidXmlName((String)name)) {
                this.getMessageListener().error(rman.getValue("jp.jasminesoft.jfc.tools.xls2appschema.error.InvalidModelitemName.check.6", new Object[]{modelId, name}));
            }
        }
    }
}

