/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.ArrayList;
import jp.jasminesoft.jfc.appgen.component.AbstractItem;
import jp.jasminesoft.jfc.appgen.component.BaseModel;
import jp.jasminesoft.jfc.appgen.component.ConditionModelitem;
import jp.jasminesoft.jfc.appgen.component.ModelType;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.StoreModelitem;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;

public class ConditionModel
extends BaseModel {
    protected StoreModel storeModel;

    public ConditionModel(Model conditionModel) {
        super(conditionModel);
        if (!ModelType.CONDITION.equals((Object)ModelType.modelTypeValue(conditionModel))) {
            throw new IllegalArgumentException("model type is not store. [type: " + conditionModel.getType() + "]");
        }
        this.storeModel = new StoreModel(AppSchemaUtil.getStoreModel(conditionModel));
    }

    public AbstractItem[] getModelitems() {
        ArrayList<StoreModelitem> list = new ArrayList<StoreModelitem>();
        for (Modelitem modelitem : ModelUtils.getModelitems(this.model)) {
            if (AppSchemaUtil.isGenerationModelitem(modelitem.getName(), this.model)) continue;
            list.add(new StoreModelitem(this.model, modelitem));
        }
        return list.toArray(new StoreModelitem[list.size()]);
    }

    public ConditionModelitem getModelitem(String modelitemName) {
        Modelitem modelitem = AppSchemaUtil.getModelitem(modelitemName, this.model);
        if (modelitem != null) {
            return new ConditionModelitem(this.model, modelitem);
        }
        for (Modelitem mitem : ModelUtils.getModelitems(this.model)) {
            if (!mitem.getName().equals(modelitemName)) continue;
            return new ConditionModelitem(this.model, mitem);
        }
        throw new IllegalStateException(modelitemName + " is not included in " + this.model.getId() + " model.");
    }

    public StoreModel getStoreModel() {
        return this.storeModel;
    }
}

