/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;

public enum ShowlistActionType {
    CALENDAR("CalendarView"),
    REPORTLIST("ReportList"),
    SEARCHLIST("SearchList"),
    SEARCHLISTFORREFGROUP("SearchListForRefgroup"),
    SHOWLIST(""),
    SHOWLISTPARSECSVDATA("ShowListParseCsvData"),
    SHOWLISTRESTRICTPARAM("ShowListRestrictparam"),
    TOTALVIEW("Totalview"),
    UPDATELIST("UpdateList"),
    SCHEDULEVIEW("ScheduleVIEW");

    private String type;

    private ShowlistActionType(String type) {
        this.type = type;
    }

    public String typeName() {
        return this.type;
    }

    public static ShowlistActionType showlistActionTypeValue(Action action) {
        if (!"showList".equals(action.getType())) {
            throw new IllegalArgumentException("action type is not showList. [type: " + action.getType() + "]");
        }
        String modelId = SourceGenerator.capFirst(action.getIdref());
        if (action.getId().equals("showList" + modelId)) {
            return SHOWLIST;
        }
        if (action.getId().equals("showList" + modelId + "Calendarview")) {
            return CALENDAR;
        }
        if (action.getId().equals("showList" + modelId + "Scheduleview")) {
            return SCHEDULEVIEW;
        }
        if (action.getId().equals("searchList" + modelId)) {
            return SEARCHLIST;
        }
        if (action.getId().equals("searchList" + modelId + SourceGenerator.capFirst("_jshparam"))) {
            return SEARCHLISTFORREFGROUP;
        }
        if (action.getId().equals("reportList" + modelId)) {
            return REPORTLIST;
        }
        if (action.getId().equals("updateList" + modelId)) {
            return UPDATELIST;
        }
        if (action.getId().startsWith("showList" + modelId) && action.getId().endsWith("Totalview")) {
            return TOTALVIEW;
        }
        if (action.getId().startsWith("restrictedList" + modelId + "For")) {
            return SHOWLISTRESTRICTPARAM;
        }
        if (action.getId().startsWith("parseCsvDataShowList" + modelId + "For")) {
            return SHOWLISTPARSECSVDATA;
        }
        throw new IllegalArgumentException("No ActionType [action/@id: " + action.getId() + "]");
    }
}

