/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import jp.jasminesoft.jfc.appgen.component.AbstractPrimarykey;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplePrimarykey
extends AbstractPrimarykey {
    private static final Logger logger = LogManager.getLogger(SimplePrimarykey.class);
    protected final PrimaryKey primarykey;

    public SimplePrimarykey(Model model, PrimaryKey primarykey) {
        super(model);
        this.primarykey = primarykey;
    }

    @Override
    public String getClassName() {
        String name = this.primarykey.getName();
        Modelitem modelitem = AppSchemaUtil.getModelitem(name, this.model);
        String type = AppSchemaUtil.getModelitemType(this.getProject(), this.model.getId(), modelitem, "roleid");
        return JavaSourceGenerator.getProperWrapperType(type);
    }

    @Override
    public String getName() {
        return StringUtils.enclose((String)StringUtils.defaultString((String)this.primarykey.getRefname()), null, (String)"_") + this.primarykey.getName();
    }

    public String getAccessorName() {
        return SourceGenerator.capFirst(this.getName());
    }

    @Override
    public String getPackage() {
        String classname = this.getClassName();
        String packagename = ClassUtils.getPackageName((String)classname);
        if (StringUtils.isNotBlank((CharSequence)packagename)) {
            return packagename;
        }
        Class clazz = null;
        try {
            clazz = ClassUtils.getClass((String)("java.lang." + classname));
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage());
        }
        if (clazz != null) {
            return clazz.getPackage().getName();
        }
        return "";
    }

    @Override
    public boolean isCompositeKey() {
        return false;
    }

    public String getDataType() {
        return this.primarykey.getType();
    }

    public SimplePrimarykey[] getElements() {
        return new SimplePrimarykey[]{this};
    }
}

