/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.ArrayList;
import jp.jasminesoft.jfc.appgen.component.AbstractModelitem;
import jp.jasminesoft.jfc.appgen.component.ContainerStoreModelitem;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelitemUtils;
import jp.jasminesoft.jfc.core.pattern.DecorativeArrayFilter;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.HibernateParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import org.apache.commons.lang3.ArrayUtils;

public class StoreModelitem
extends AbstractModelitem {
    protected StoreModel storeModel;
    private final Modelitem pitem;

    public StoreModelitem(Model model, Modelitem modelitem) {
        super(model, modelitem);
        this.storeModel = new StoreModel(model);
        Model pmodel = AppSchemaUtil.getModel(this.getProject(), this.storeModel.getId(), "presentation");
        this.pitem = AppSchemaUtil.getModelitem(modelitem.getName(), pmodel);
    }

    public StoreModel getStoreModel() {
        return this.storeModel;
    }

    public String getHibernatePropertyName() {
        return AppSchemaUtil.getHibernatePropertyName(this.model, this.modelitem);
    }

    public String getListTable() {
        HibernateParameterModelitem hpmitem = AppSchemaUtil.getHibernateParameterModelitem(this.modelitem);
        if (hpmitem == null) {
            return "";
        }
        return hpmitem.getListTablename();
    }

    public boolean isMultiple() {
        return this.modelitem.getMultiple();
    }

    public ContainerStoreModelitem getContainer() {
        return new ContainerStoreModelitem(this.model, AppSchemaUtil.getModelitem(this.getContainerName(), this.model));
    }

    public boolean isTransient() {
        return this.modelitem.getTransient();
    }

    public boolean isReference() {
        if (!ModelitemUtils.isStoreref(this.modelitem)) {
            return false;
        }
        if (!ModelitemUtils.isRefType(this.modelitem)) {
            return false;
        }
        if (this.modelitem.getTransient()) {
            return true;
        }
        return "refmodel".equals(AppSchemaUtil.getRelationTypeIsRef(this.modelitem).getRefstoretype());
    }

    public boolean isRelatoin() {
        if (!ModelitemUtils.isStoreref(this.modelitem)) {
            return false;
        }
        if (ModelitemUtils.isRefType(this.modelitem)) {
            return false;
        }
        return !this.isCheckbox();
    }

    public StoreModelitem getReferenceModelitem() {
        if (!ModelitemUtils.isRefType(this.modelitem)) {
            return null;
        }
        Relation relation = AppSchemaUtil.getRelationTypeIsRef(this.modelitem);
        Model model = AppSchemaUtil.getModel(this.getProject(), relation.getIdref());
        StoreModel referenceModel = new StoreModel(model);
        return referenceModel.getModelitem(relation.getName());
    }

    public StoreModelitem[] getRelatedModelitems() {
        if (!ModelitemUtils.isRefType(this.modelitem)) {
            return null;
        }
        Relation relation = AppSchemaUtil.getRelationTypeIsRef(this.modelitem);
        ArrayList<StoreModelitem> list = new ArrayList<StoreModelitem>();
        for (String relatedItem : this.relatedItem(relation)) {
            Modelitem[] modelitems;
            for (Modelitem modelitem : modelitems = ModelitemUtils.getModelitem(this.model, AppSchemaUtil.getModelitem(relatedItem, this.model), this.getProject())) {
                list.add(new StoreModelitem(this.model, modelitem));
            }
        }
        return list.toArray(new StoreModelitem[list.size()]);
    }

    protected String[] relatedItem(Relation relation) {
        Object[] foreignKeys = this.foreignKeys(relation);
        if (ArrayUtils.isEmpty((Object[])foreignKeys) || foreignKeys.length == 1) {
            return new String[]{relation.getRelateditem()};
        }
        ArrayList<String> foreignKeyNames = new ArrayList<String>();
        for (Object foreignKey : foreignKeys) {
            if (!ModelitemUtils.isStrictForeignkey((ForeignKey)foreignKey)) continue;
            foreignKeyNames.add(((ForeignKey)foreignKey).getName());
        }
        if (!foreignKeyNames.contains(relation.getRelateditem())) {
            return new String[]{relation.getRelateditem()};
        }
        return foreignKeyNames.toArray(new String[foreignKeyNames.size()]);
    }

    private ForeignKey[] foreignKeys(Relation relation) {
        Object[] foreignKeys = AppSchemaUtil.getTargetForeignKey(this.model, relation.getIdref());
        final ForeignKey relatedForeignKey = this.relatedForeignKey(relation, (ForeignKey[])foreignKeys);
        if (relatedForeignKey == null) {
            return null;
        }
        return (ForeignKey[])new DecorativeArrayFilter<ForeignKey>(){

            protected boolean accept(ForeignKey target) {
                if (target == null) {
                    return false;
                }
                if (!AppSchemaUtil.getForeignKeyTargetItemName(target).equals(AppSchemaUtil.getForeignKeyTargetItemName(relatedForeignKey))) {
                    return true;
                }
                return target.getName().equals(relatedForeignKey.getName());
            }
        }.filter(foreignKeys);
    }

    private ForeignKey relatedForeignKey(Relation relation, ForeignKey[] foreignKeys) {
        if (ArrayUtils.isEmpty((Object[])foreignKeys)) {
            return null;
        }
        for (ForeignKey f : foreignKeys) {
            if (!relation.getRelateditem().equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public StoreModelitem getRoleidModelitem() {
        if (!ModelitemUtils.isStoreref(this.modelitem) || ModelitemUtils.isRefType(this.modelitem)) {
            return null;
        }
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(this.modelitem);
        Model model = AppSchemaUtil.getModel(this.getProject(), relation.getIdref());
        StoreModel referenceModel = new StoreModel(model);
        return referenceModel.getModelitem(AppSchemaUtil.getRoleid(relation, this.getProject()));
    }

    public boolean isForeignkey() {
        return ModelitemUtils.isForeignkeyMeta(this.modelitem, this.model);
    }

    public StoreModelitem getForeignkeyReferenceModelitem() {
        if (!this.isForeignkey()) {
            return null;
        }
        ForeignKey foreignKey = AppSchemaUtil.getForeignKey(this.modelitem.getName(), this.model);
        String refname = AppSchemaUtil.getForeignKeyTargetItemName(foreignKey);
        Model referenceModel = (Model)foreignKey.getIdrefAsIRNode();
        return new StoreModelitem(referenceModel, AppSchemaUtil.getModelitem(refname, referenceModel));
    }

    public boolean isPriorToForeignkey() {
        if (!this.isRelatoin()) {
            return true;
        }
        if (!this.isForeignkey()) {
            return true;
        }
        ForeignKey foreignKey = AppSchemaUtil.getForeignKey(this.modelitem.getName(), this.model);
        Model referenceModel = (Model)foreignKey.getIdrefAsIRNode();
        return AppSchemaUtil.getPrimaryKey(referenceModel).length < 2;
    }

    public String getFilterName() {
        if (this.pitem == null) {
            return "minimalfilter";
        }
        if (!this.isCheckbox() || "masterref".equals(this.modelitem.getType())) {
            if (StringUtils.isBlank((CharSequence)this.pitem.getFilter())) {
                return "minimalfilter";
            }
            return this.pitem.getFilter();
        }
        Project project = this.getProject();
        Modelitem referenceModelitem = ModelitemUtils.getReferenceModelitem(this.model, this.modelitem, project);
        StoreModelitem targetModelitem = this;
        if (referenceModelitem != this.modelitem) {
            Model referenceModel = ModelitemUtils.getModel(referenceModelitem);
            targetModelitem = new StoreModelitem(referenceModel, referenceModelitem);
        }
        StoreModelitem roleidModelitem = targetModelitem.getRoleidModelitem();
        Model presentationModel = AppSchemaUtil.getModel(project, roleidModelitem.getModel().getId(), "presentation");
        Modelitem presentationModelitem = AppSchemaUtil.getModelitem(roleidModelitem.getName(), presentationModel);
        if (presentationModelitem == null || StringUtils.isBlank((CharSequence)presentationModelitem.getFilter())) {
            return "minimalfilter";
        }
        return presentationModelitem.getFilter();
    }
}

