/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component.appschema;

import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;

public class ModelitemUtils {
    protected ModelitemUtils() {
    }

    public static Modelitem[] getModelitem(Model model, Modelitem modelitem, Project project) {
        Modelitem referenceModelitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(project, model.getId(), modelitem);
        if (!"storeref".equals(referenceModelitem.getType())) {
            return new Modelitem[]{modelitem};
        }
        Relation referenceRelation = AppSchemaUtil.getRelationTypeExceptRef(referenceModelitem);
        Model referenceModel = AppSchemaUtil.getModel(project, referenceRelation.getIdref());
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(referenceModel, project);
        if (pkeys == null || pkeys.length == 1) {
            return new Modelitem[]{modelitem};
        }
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        for (PrimaryKey pkey : pkeys) {
            Modelitem copyModelitem = ModelitemUtils.clone(modelitem);
            copyModelitem.setName(copyModelitem.getName() + "_" + pkey.getName());
            Relation copyModelitemRelation = AppSchemaUtil.getRelationTypeExceptRef(copyModelitem);
            if (copyModelitemRelation != null) {
                copyModelitemRelation.setRoleid(pkey.getName());
            } else {
                copyModelitemRelation = AppSchemaUtil.getRelationTypeIsRef(copyModelitem);
                if (copyModelitemRelation != null) {
                    copyModelitemRelation.setName(copyModelitemRelation.getName() + "_" + pkey.getName());
                }
            }
            list.add(copyModelitem);
        }
        return list.toArray(new Modelitem[list.size()]);
    }

    public static Modelitem clone(Modelitem original) {
        Modelitem replica = null;
        try {
            replica = new Modelitem(original.makeDocument());
        }
        catch (ParserConfigurationException e) {
            replica = (Modelitem)original.clone();
        }
        return replica;
    }

    public static Modelitem getReferenceModelitem(Model model, Modelitem modelitem, Project project) {
        if (modelitem == null) {
            return null;
        }
        if (!ModelitemUtils.isRefType(modelitem)) {
            return modelitem;
        }
        Relation relation = AppSchemaUtil.getRelationTypeIsRef(modelitem);
        Model rmodel = AppSchemaUtil.getModel(project, relation.getIdref());
        Modelitem referenceModelitem = AppSchemaUtil.getModelitem(relation.getName(), rmodel);
        if (referenceModelitem == null) {
            for (Modelitem item : ModelUtils.getModelitems(rmodel, project)) {
                if (!relation.getName().equals(item.getName())) continue;
                referenceModelitem = item;
                break;
            }
        }
        return ModelitemUtils.getReferenceModelitem(rmodel, referenceModelitem, project);
    }

    public static Model getModel(Modelitem modelitem) {
        if (modelitem == null) {
            return null;
        }
        return (Model)modelitem.rGetParentRNode();
    }

    public static boolean isStoreref(Modelitem modelitem) {
        return "storeref".equals(modelitem.getType());
    }

    public static boolean isRefType(Modelitem modelitem) {
        if (!ModelitemUtils.isStoreref(modelitem)) {
            return false;
        }
        return AppSchemaUtil.getRelationTypeExceptRef(modelitem) == null;
    }

    public static boolean isForeignkeyMeta(Modelitem modelitem, Model model) {
        return ModelitemUtils.isStrictForeignkey(AppSchemaUtil.getForeignKey(modelitem.getName(), model));
    }

    public static boolean isStrictForeignkey(ForeignKey foreignKey) {
        if (foreignKey == null) {
            return false;
        }
        String refname = AppSchemaUtil.getForeignKeyTargetItemName(foreignKey);
        return ModelitemUtils.isPrimaryKey(refname, (Model)foreignKey.getIdrefAsIRNode());
    }

    private static boolean isPrimaryKey(String name, Model model) {
        for (PrimaryKey primaryKey : AppSchemaUtil.getPrimaryKey(model)) {
            if (!primaryKey.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

