/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.generator;

import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelitemUtils;
import jp.jasminesoft.jfc.appgen.generator.AppschemaBasedGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;

public class DataOwnerMethodGenerator
extends AppschemaBasedGenerator {
    protected final Model model;
    protected Modelitem ownerModelitem;

    public DataOwnerMethodGenerator(Model model) {
        super(ModelUtils.getProject(model));
        if ("store".equals(model.getType())) {
            this.model = model;
            this.ownerModelitem = this.ownerModelitem();
        } else {
            this.model = null;
            this.ownerModelitem = null;
        }
    }

    public DataOwnerMethodGenerator(Modelitem ownerModelitem) {
        super(ModelUtils.getProject(ModelitemUtils.getModel(ownerModelitem)));
        this.model = ModelitemUtils.getModel(ownerModelitem);
        this.ownerModelitem = ownerModelitem;
    }

    protected Modelitem ownerModelitem() {
        if (this.model == null) {
            return null;
        }
        for (Modelitem modelitem : AppSchemaUtil.getModelitem(this.model)) {
            if (!"owner".equals(modelitem.getGroupDataType())) continue;
            return modelitem;
        }
        return null;
    }

    @Override
    protected String getFilename() {
        return null;
    }

    @Override
    protected String getContent() {
        return this.generateDataOwnerMethod();
    }

    protected String generateDataOwnerMethod() {
        if (this.ownerModelitem == null) {
            return "";
        }
        StoreModel storeModel = new StoreModel(this.model);
        StringBuilder sb = new StringBuilder();
        sb.append(ISourceVariable.CR);
        sb.append("    ").append("/** {@inheritDoc} **/").append(ISourceVariable.CR);
        sb.append("    ").append("public String dataOwner(").append(storeModel.getClassName()).append(" entity) {").append(ISourceVariable.CR);
        sb.append("        ").append("return entity").append(JavaSourceGenerator.getterFullMethod(this.ownerModelitem.getName())).append(";").append(ISourceVariable.CR);
        sb.append("    ").append("}").append(ISourceVariable.CR);
        return sb.toString();
    }

    public String generateContent() {
        return this.getContent();
    }
}

