/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.generator;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.appgen.generator.VelocityBasedGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class InitDataGenerator {
    private static final Logger logger = LogManager.getLogger(InitDataGenerator.class);
    protected ResourceManager rman;
    protected final Project project;

    public InitDataGenerator(Project project) {
        this.project = project;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public void generate() throws IOException {
        VelocityBasedGenerator generator = new VelocityBasedGenerator(this.project, "init");
        generator.addContext(this.createContext());
        generator.generate("juser/item_0.xml.vm");
        generator.generate("juser/item_1.xml.vm");
    }

    protected Map<String, Object> createContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String algorithm = AppSchemaUtil.getInitParamValue(this.project.getEnvironment(), "userinfo_passwd_digest_algorithm");
        if (StringUtils.isBlank((CharSequence)algorithm) && AppSchemaUtil.getBCryptStrengthSecurityParam(this.project.getEnvironment()) != null) {
            algorithm = "BCrypt";
        }
        if (!("raw".equals(algorithm) || "md5".equals(algorithm) || "sha-1".equals(algorithm) || "sha-256".equals(algorithm) || "sha-384".equals(algorithm) || "sha-512".equals(algorithm) || "BCrypt".equals(algorithm))) {
            algorithm = "raw";
            Object[] o = new Object[]{"\"userinfo_passwd_digest_algorithm\"", algorithm};
            logger.error(this.rman.getValue("value.illegal.initparam", o));
            return context;
        }
        context.put("adminPasswd", "wagby");
        context.put("jobadminPasswd", "wagby");
        context.put("guestPasswd", "guest");
        if (!algorithm.equals("raw")) {
            for (Map.Entry entry : new HashMap(context).entrySet()) {
                context.put((String)entry.getKey(), this.getHash((String)entry.getValue(), algorithm));
            }
        }
        for (Map.Entry entry : new HashMap(context).entrySet()) {
            context.put((String)entry.getKey(), StringUtil.escapeStringForXML((String)((String)entry.getValue())));
        }
        return context;
    }

    private String getHash(String value, String algorithm) {
        if ("bcrypt".equalsIgnoreCase(algorithm)) {
            return new BCryptPasswordEncoder(AppSchemaUtil.getBCryptStrength(this.project.getEnvironment()).intValue(), new SecureRandom(value.getBytes())).encode((CharSequence)value);
        }
        return StringUtil.getHash((String)value, (String)algorithm);
    }
}

