/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationContextBean
implements ISourceVariable {
    protected Logger logger = LogManager.getLogger((String)ApplicationContextBean.class.getName());
    public static final String APPLICATIONCONTEXT_DEFAULT_PATH = "/WEB-INF/applicationContext.xml";
    private String beanId;
    private String beanClass;
    private String modelId;
    private String applicationContextPath = "/WEB-INF/applicationContext.xml";
    private boolean singleton = false;
    private String scope;
    private Boolean lazyInit = null;
    private boolean aopScopedProxy = false;
    private boolean aopScopedProxytargetClass = true;
    private String dependsOn;
    private Map<String, String> lookupMethodMap = new TreeMap<String, String>();
    private Map<String, Object> propertyMap = new TreeMap<String, Object>();
    private Map<String, Map<String, Object>> propertyRefMap = new TreeMap<String, Map<String, Object>>();
    private List<ConstructorArgType> constructorArgList = new ArrayList<ConstructorArgType>();
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public ApplicationContextBean(String beanId, String beanClass) {
        this.setBeanId(beanId);
        this.setBeanClass(beanClass);
    }

    public ApplicationContextBean(String beanId, String beanClass, String applicationContextPath) {
        this(beanId, beanClass);
        this.setApplicationContextPath(applicationContextPath);
    }

    public ApplicationContextBean(String beanId, String beanClass, String applicationContextPath, String modelId) {
        this(beanId, beanClass, applicationContextPath);
        this.setModelId(modelId);
    }

    public ApplicationContextBean(String beanId, String beanClass, String applicationContextPath, boolean singleton) {
        this(beanId, beanClass, applicationContextPath);
        this.setSingleton(singleton);
    }

    public ApplicationContextBean(String beanId, String beanClass, boolean singleton) {
        this(beanId, beanClass);
        this.setSingleton(singleton);
    }

    public ApplicationContextBean(String beanId, ApplicationContextBean bean) {
        this(beanId, bean.beanClass, bean.applicationContextPath, bean.singleton);
        this.modelId = bean.modelId;
        this.scope = bean.scope;
        this.lazyInit = bean.lazyInit;
        this.aopScopedProxy = bean.aopScopedProxy;
        this.aopScopedProxytargetClass = bean.aopScopedProxytargetClass;
        this.dependsOn = bean.dependsOn;
        this.lookupMethodMap.putAll(bean.lookupMethodMap);
        this.propertyMap.putAll(bean.propertyMap);
        for (Map.Entry<String, Map<String, Object>> e : bean.propertyRefMap.entrySet()) {
            TreeMap<String, Object> map = new TreeMap<String, Object>(e.getValue());
            this.propertyRefMap.put(e.getKey(), map);
        }
        for (ConstructorArgType argtype : bean.constructorArgList) {
            this.constructorArgList.add(argtype);
        }
    }

    public String getProperIdOrNameAttribute() {
        return "id";
    }

    private void setBeanId(String beanId) {
        if (beanId == null) {
            this.logger.error("beanId should not be null.");
        }
        this.beanId = beanId;
    }

    private void setBeanClass(String beanClass) {
        if (beanClass == null) {
            this.logger.error("beanClass should not be null.");
        }
        this.beanClass = beanClass;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    private void setApplicationContextPath(String applicationContextPath) {
        if (applicationContextPath != null) {
            this.applicationContextPath = applicationContextPath;
        }
    }

    public void setSingleton(boolean singleton) {
        if (this.beanClass == null) {
            this.logger.error("beanClass should not be null.");
        }
        this.singleton = singleton;
    }

    public void setLazyInit(Boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAopScopedProxy(boolean aopScopedProxy) {
        this.aopScopedProxy = aopScopedProxy;
    }

    public void setAopScopedProxytargetClass(boolean aopScopedProxytargetClass) {
        this.aopScopedProxytargetClass = aopScopedProxytargetClass;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    public boolean getSingleton() {
        return this.singleton;
    }

    public Boolean getLazyInit() {
        return this.lazyInit;
    }

    public boolean getAopScopedProxy() {
        return this.aopScopedProxy;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public String getScope() {
        return this.scope;
    }

    public void addLookupMethod(String name, String beanid) {
        this.lookupMethodMap.put(name, beanid);
    }

    public void addProperty(String name, String obj) {
        this.propertyMap.put(name, obj);
    }

    public void addProperty(String name, ReferenceElement obj) {
        this.propertyMap.put(name, obj);
    }

    public void addProperty(String name, XmlString obj) {
        this.propertyMap.put(name, obj);
    }

    public void addProperty(String name, ApplicationContextBean bean) {
        this.propertyMap.put(name, new ReferenceElement(bean.getBeanId()));
    }

    public void addPropertyMap(String name, Map<String, Object> pmap) {
        this.propertyRefMap.put(name, pmap);
    }

    public void addConstructorArg(ConstructorArgType constructorArg) {
        this.constructorArgList.add(constructorArg);
    }

    public int sizeLookupMethod() {
        return this.lookupMethodMap.size();
    }

    public int sizeProperty() {
        return this.propertyMap.size();
    }

    public int sizePropertyRef() {
        return this.propertyRefMap.size();
    }

    public int sizeConstructorArg() {
        return this.constructorArgList.size();
    }

    private boolean isCustomize() {
        return ApplicationContextBean.isCustomize(this.beanClass);
    }

    public static boolean isCustomize(String beanClass) {
        StringBuilder _path = new StringBuilder();
        _path.append(ApplicationContextBean.getCustomizeClassname(beanClass, File.separator));
        _path.append(".java");
        return ApplicationContextBean.existsCustomizeFile(_path.toString());
    }

    public String getCustomizeClassname() {
        return ApplicationContextBean.getCustomizeClassname(this.getBeanClass(), ".");
    }

    public static String getCustomizeClassname(String beanClass, String sep) {
        String _packagename = StringUtil.getPackageName((String)beanClass);
        String _classname = StringUtil.getClassName((String)beanClass);
        StringBuilder sb0 = new StringBuilder();
        if (!sep.equals(".")) {
            sb0.append(StringUtil.replaceAll((String)_packagename, (String)".", (String)sep));
        } else {
            sb0.append(_packagename);
        }
        sb0.append(sep);
        sb0.append("My");
        sb0.append(_classname);
        return sb0.toString();
    }

    public static boolean existsCustomizeFile(String filename) {
        String[] basedirs;
        for (String basedir : basedirs = rman.getValueStrArray("CustomizeJavaSourceBasedirs")) {
            File file = new File(basedir, filename.toString());
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.makeTextDocument("  ");
    }

    public String makeTextDocument() {
        return this.makeTextDocument("  ");
    }

    public String makeTextDocument(String tab) {
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("<bean");
        if (this.getBeanId() != null) {
            sb.append(" ");
            sb.append(this.getProperIdOrNameAttribute());
            sb.append("=\"" + this.getBeanId() + "\"");
        }
        if (this.getSingleton()) {
            if (this.lazyInit != null) {
                sb.append(" lazy-init=\"" + this.lazyInit + "\"");
            }
        } else if (this.scope != null) {
            sb.append(" scope=\"" + this.scope + "\"");
        } else {
            sb.append(" scope=\"prototype\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDependsOn())) {
            sb.append(" depends-on=\"" + this.getDependsOn() + "\"");
        }
        if (this.getBeanClass() != null) {
            if (this.getBeanId() != null) {
                sb.append(CR);
                sb.append(tab);
                sb.append("    ");
            }
            sb.append(" class=\"");
            if (this.isCustomize()) {
                sb.append(this.getCustomizeClassname());
            } else {
                sb.append(this.getBeanClass());
            }
            sb.append("\"");
        }
        if (this.lookupMethodMap.size() > 0 || this.propertyMap.size() > 0 || this.propertyRefMap.size() > 0 || this.constructorArgList.size() > 0 || this.aopScopedProxy) {
            sb.append(">");
            sb.append(CR);
            this.outputLookupMethodMap(sb, tab + "  ");
            this.outputPropertyMap(sb, tab + "  ");
            this.outputPropertyRefMap(sb, tab + "  ");
            this.outputConstructorArgList(sb, tab + "  ");
            if (this.aopScopedProxy) {
                sb.append(tab);
                sb.append("  ");
                sb.append("<aop:scoped-proxy");
                if (!this.aopScopedProxytargetClass) {
                    sb.append(" proxy-target-class=\"false\"");
                }
                sb.append("/>");
                sb.append(CR);
            }
            sb.append(tab);
            sb.append("</bean>");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    private void outputLookupMethodMap(StringBuilder sb, String tab) {
        for (String name : this.lookupMethodMap.keySet()) {
            String beanid = this.lookupMethodMap.get(name);
            sb.append(tab);
            sb.append("<lookup-method name=\"");
            sb.append(name);
            sb.append("\" ");
            sb.append("bean=\"");
            sb.append(beanid);
            sb.append("\"/>");
            sb.append(CR);
        }
    }

    private void outputPropertyMap(StringBuilder sb, String tab) {
        for (String name : this.propertyMap.keySet()) {
            Object o = this.propertyMap.get(name);
            if (o instanceof String) {
                String value = (String)o;
                sb.append(tab);
                sb.append("<property name=\"");
                sb.append(name);
                sb.append("\">");
                sb.append(CR);
                sb.append(tab);
                sb.append("  <value>");
                sb.append(value);
                sb.append("</value>");
                sb.append(CR);
                sb.append(tab);
                sb.append("</property>");
                sb.append(CR);
                continue;
            }
            if (o instanceof XmlString) {
                XmlString xmlString = (XmlString)o;
                sb.append(tab);
                sb.append("<property name=\"");
                sb.append(name);
                sb.append("\">");
                sb.append(xmlString);
                sb.append("</property>");
                sb.append(CR);
                continue;
            }
            if (!(o instanceof ReferenceElement)) continue;
            ReferenceElement ref = (ReferenceElement)o;
            sb.append(tab);
            sb.append("<property name=\"");
            sb.append(name);
            sb.append("\" ");
            sb.append("ref=\"");
            sb.append(ref.getContent());
            sb.append("\"");
            sb.append("/>");
            sb.append(CR);
        }
    }

    private void outputPropertyRefMap(StringBuilder sb, String tab) {
        for (String name : this.propertyRefMap.keySet()) {
            Map<String, Object> pmap = this.propertyRefMap.get(name);
            if (pmap.size() == 0) continue;
            sb.append(tab);
            sb.append("<property name=\"");
            sb.append(name);
            sb.append("\">");
            sb.append(CR);
            sb.append(tab);
            sb.append("  ");
            sb.append("<map>");
            sb.append(CR);
            for (Map.Entry<String, Object> entry : pmap.entrySet()) {
                String key = entry.getKey();
                Object o = entry.getValue();
                if (o instanceof String) {
                    String value = (String)o;
                    sb.append(tab);
                    sb.append("    ");
                    sb.append("<entry key=\"");
                    sb.append(key);
                    sb.append("\" value=\"");
                    sb.append(value);
                    sb.append("\"/>");
                    sb.append(CR);
                    continue;
                }
                if (o instanceof XmlString) {
                    XmlString xmlString = (XmlString)o;
                    sb.append(tab);
                    sb.append("    ");
                    sb.append("<entry key=\"");
                    sb.append(key);
                    sb.append("\">");
                    sb.append(xmlString);
                    sb.append("</entry>");
                    sb.append(CR);
                    continue;
                }
                if (!(o instanceof ReferenceElement)) continue;
                ReferenceElement ref = (ReferenceElement)o;
                sb.append(tab);
                sb.append("    ");
                sb.append("<entry key=\"");
                sb.append(key);
                sb.append("\" value-ref=\"");
                sb.append(ref.getContent());
                sb.append("\"/>");
                sb.append(CR);
            }
            sb.append(tab);
            sb.append("  ");
            sb.append("</map>");
            sb.append(CR);
            sb.append(tab);
            sb.append("</property>");
            sb.append(CR);
        }
    }

    private void outputConstructorArgList(StringBuilder sb, String tab) {
        for (int i = 0; i < this.constructorArgList.size(); ++i) {
            sb.append(tab);
            if (this.constructorArgList.get(i) != null) {
                sb.append(this.constructorArgList.get(i).toString(i));
            }
            sb.append(CR);
        }
    }

    static class ConstructorArgType {
        private String ref;
        private Class<?> type;
        private String value;
        private String content;

        public String getRef() {
            return this.ref;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        ConstructorArgType() {
        }

        ConstructorArgType(ConstructorArgType argtype) {
            this.ref = argtype.ref;
            this.type = argtype.type;
            this.value = argtype.value;
            this.content = argtype.content;
        }

        public String toString() {
            return this.toString(-1);
        }

        public String toString(int index) {
            StringBuilder sb = new StringBuilder();
            sb.append("<constructor-arg");
            if (index > -1) {
                sb.append(" index=\"" + index + "\"");
            }
            if (StringUtils.isNotBlank((CharSequence)this.ref)) {
                sb.append(" ref=\"" + StringUtil.escapeStringForXML((String)this.ref) + "\"");
            }
            if (this.type != null) {
                sb.append(" type=\"" + this.type.getName() + "\"");
            }
            if (StringUtils.isNotBlank((CharSequence)this.value)) {
                sb.append(" value=\"" + StringUtil.escapeStringForXML((String)this.value) + "\"");
            }
            if (this.content != null) {
                sb.append(">");
                sb.append(this.content);
                sb.append("</constructor-arg>");
                return sb.toString();
            }
            sb.append(" />");
            return sb.toString();
        }
    }

    public static class ReferenceElement {
        private String content;

        public ReferenceElement(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static class XmlString {
        private String content;

        public XmlString(String content) {
            this.content = content;
        }

        public String toString() {
            return this.content;
        }
    }
}

