/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SetClasspathGenerator;
import jp.jasminesoft.jfc.gen.appschema.Buildtask;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Initloader;
import jp.jasminesoft.jfc.gen.appschema.Jarfile;
import jp.jasminesoft.jfc.gen.appschema.Jarfilelist;
import jp.jasminesoft.jfc.gen.appschema.Manifest;
import jp.jasminesoft.jfc.gen.appschema.Manifestlist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Propertyfile;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class BuildXmlGenerator
extends ConfigGenerator {
    public static final int MAX_ITEM_NUM = 20;
    private String filename;
    private String enc;
    private String javacTaskParam;
    private boolean initLoaderV4Flag = false;
    private static boolean adjustFilePathCase = false;

    public BuildXmlGenerator(String dirname, String filename, Project project) {
        super(dirname + File.separator + filename + ".xml", project);
        this.filename = filename;
        this.enc = JavaSourceGenerator.getEncoding(project);
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getSubpackageName() {
        return "";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        HashSet<String> orgTargetsSet = new HashSet<String>();
        LinkedList<String> hookDoRelaxerSet = new LinkedList<String>();
        LinkedList<String> hookDoRelaxerJfcSet = new LinkedList<String>();
        LinkedList<String> hookDoRelaxerJfcRngSet = new LinkedList<String>();
        LinkedList<String> hookUntarTomcatSet = new LinkedList<String>();
        LinkedList<String> hookAfterAllSet = new LinkedList<String>();
        LinkedList<String> hookAfterAllDiffSet = new LinkedList<String>();
        int _idx = this.packagedir.indexOf(File.separator);
        String srcentry = "jp";
        if (_idx > 0) {
            srcentry = this.packagedir.substring(0, _idx);
        }
        String webencoding = JavaSourceGenerator.getWebEncoding(this.project);
        String jfcappname = this.project.getName();
        tplman.addContent("jfcappname", jfcappname);
        tplman.addContent("packagedir", this.packagedir);
        tplman.addContent("package", this.packagename);
        tplman.addContent("srcentryname", srcentry);
        tplman.addContent("encoding", this.enc);
        tplman.addContent("webencoding", webencoding);
        tplman.addContent("debugcompile", Boolean.toString(this.project.getDebugcompile()));
        tplman.addContent("relaxerversion", this.project.getRelaxer());
        String schematype = this.project.getRelaxSchemaType();
        String suffix = null;
        suffix = "NG".equals(schematype) ? "rng" : "rxm";
        tplman.addContent("relaxschemasuffix", suffix);
        Environment env = this.project.getEnvironment();
        tplman.addContent("database", DbTypeManager.getType(env));
        if (!DbTypeManager.isConnectionInterface(env) && DbTypeManager.isHSQLDB(env)) {
            tplman.addContent("usedb.hsqldb", "    <property name=\"do.initdb\" value=\"true\"/>");
            tplman.addContent("databasetype.relaxer_store_jdbc_op", "-jdbc.unique.constraints:table");
            tplman.addContent("databasetype.relaxer_master_jdbc_op", "-jdbc.unique.constraints:table");
            tplman.addContent("databasetype.jdbcoption", "-jdbc.unique.constraints:table");
        } else {
            tplman.addContent("usedb.hsqldb", "");
            tplman.addContent("databasetype.relaxer_store_jdbc_op", "");
            tplman.addContent("databasetype.relaxer_master_jdbc_op", "");
            tplman.addContent("databasetype.jdbcoption", "");
        }
        if (DbTypeManager.isDatabaseType(env, "oracle")) {
            orgTargetsSet.add(this.createReplaceUSQLTarget());
            String replaceDir = "${relaxgen}/${targetdir}";
            hookDoRelaxerSet.add(this.createReplaceUSQLTask(replaceDir));
            replaceDir = "${relaxgen}/${installdir}/${targetname}";
            String replaceCode = this.createReplaceUSQLTask(replaceDir);
            hookDoRelaxerJfcSet.add(replaceCode);
            hookDoRelaxerJfcRngSet.add(replaceCode);
        } else if (DbTypeManager.isDatabaseType(env, "db2")) {
            tplman.addContent("databasetype.relaxer_store_jdbc_op", "-jdbc.primarykey.notnull -jdbc.unique.notnul -jdbc.timestamp.settimestamp");
            tplman.addContent("databasetype.relaxer_master_jdbc_op", "-jdbc.primarykey.notnull -jdbc.unique.notnul -jdbc.timestamp.settimestamp");
            tplman.addContent("databasetype.jdbcoption", "-jdbc.primarykey.notnull -jdbc.unique.notnul -jdbc.timestamp.settimestamp");
        }
        tplman.addContent("hibernate_dialect", DbTypeManager.getHibernateDialect(env));
        Database db = AppSchemaUtil.getDatabase(env);
        if (db != null) {
            String schema = db.getHibernateSchema();
            if (StringUtils.isNotBlank((CharSequence)schema)) {
                tplman.addContent("hibernate_schema", schema);
            } else {
                tplman.addContent("hibernate_schema", "");
            }
        }
        String deployname = AppSchemaUtil.getWebappName(this.project);
        String tomcatVersion = "";
        if (env != null) {
            String tomcat_dir = env.getTomcatdir();
            tplman.addContent("tomcat_dir", tomcat_dir);
            String tomcat_pac = env.getTomcatpac();
            tplman.addContent("tomcat_pac", tomcat_pac);
            String dojo_extract_dir = env.getDojoExtractDir();
            tplman.addContent("dojo_extract_dir", dojo_extract_dir);
            String dojo_pac = env.getDojopac();
            tplman.addContent("dojo_pac", dojo_pac);
            String dojo_webpage_dir = env.getDojoWebpageDir();
            tplman.addContent("dojo_webpage_dir", dojo_webpage_dir);
            tomcatVersion = env.getTomcat();
            if (tomcatVersion.startsWith("5.5")) {
                StringBuilder untarbuf = new StringBuilder();
                untarbuf.append("    ");
                untarbuf.append("<antcall target=\"untar_tomcat_compat\"/>");
                untarbuf.append(CR);
                untarbuf.append("    ");
                untarbuf.append("<copy todir=\"${workdir}/${TOMCAT_DIRECTORY}/common/classes\">");
                untarbuf.append(CR);
                untarbuf.append("      ");
                untarbuf.append("<fileset dir=\"${workdir}/tomcat_opt/common/classes\"");
                untarbuf.append(CR);
                untarbuf.append("      ");
                untarbuf.append("         includes=\"*.properties\"/>");
                untarbuf.append(CR);
                untarbuf.append("    ");
                untarbuf.append("</copy>");
                hookUntarTomcatSet.add(untarbuf.toString());
                orgTargetsSet.add(this.createUntarTomcatCompat());
            }
            HashMap<String, String> javacTaskParamMap = new HashMap<String, String>();
            Buildtask[] buildtasks = AppSchemaUtil.getBuildtask(env);
            if (buildtasks != null && buildtasks.length > 0) {
                for (int i = 0; i < buildtasks.length; ++i) {
                    if (!"javac".equals(buildtasks[i].getName())) continue;
                    javacTaskParamMap.put(buildtasks[i].getParam(), buildtasks[i].getValue());
                }
            }
            StringBuilder javacbuf = new StringBuilder();
            for (Map.Entry entry : javacTaskParamMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                javacbuf.append("    ");
                javacbuf.append("       ");
                javacbuf.append(key);
                javacbuf.append("=\"" + value + "\"");
                javacbuf.append(CR);
            }
            this.javacTaskParam = javacbuf.toString();
            tplman.addContent("javactaskparam", this.javacTaskParam);
            tplman.addContent("javacmaxmemory", env.getJavacMaxMemory());
            tplman.addContent("javadocmaxmemory", env.getJavadocMaxMemory());
            tplman.addContent("jvmMaxPermSize", env.getJvmMaxPermSize());
            tplman.addContent("javactarget", env.getJavacTarget());
            tplman.addContent("javacsource", env.getJavacSource());
            SetClasspathGenerator.addContentMemorySetting(tplman, env);
        }
        tplman.addContent("deployname", deployname);
        String jspc_destdir_appname = null;
        jspc_destdir_appname = AppSchemaUtil.isRootDeployment(this.project) ? "_" : deployname;
        tplman.addContent("jspc_destdir_appname", jspc_destdir_appname);
        tplman.addContent("jarfilelist", this.createJarfilelist(this.project.getJarfilelist()));
        tplman.addContent("manifestlist", this.createManifestlist(this.project.getManifestlist(), this.project.getJarfilelist()));
        tplman.addContent("jarincludelist", this.createJarfileIncludeList(this.project.getJarfilelist()));
        Initloader initloader = AppSchemaUtil.getInitloader(env);
        String version = this.project.getVersion();
        if (StringUtil.doubleValue((String)version) >= 4.0 && initloader != null) {
            String basePath = initloader.getBasePath();
            String name = AppSchemaUtil.getInitLoaderBasePathLastName(env);
            tplman.addContent("initloader_home", "${package_webinf}/" + name);
            tplman.addContent("initloader_bin", "${devhome}/${packagename}/bin");
            tplman.addContent("initloader_param", "-c ${initloader_home}/conf/initdb.xml -d ${initloader_home}");
            tplman.addContent("initloader_begin_comment_v4", "<!--");
            tplman.addContent("initloader_end_comment_v4", "-->");
            tplman.addContent("initloader_begin_comment_v3", "");
            tplman.addContent("initloader_end_comment_v3", "");
            Object importParentPath = initloader.getImportParentPath();
            if (importParentPath == null || ((String)importParentPath).trim().length() == 0) {
                importParentPath = basePath;
            }
            if (!new File((String)importParentPath).isAbsolute()) {
                importParentPath = "${devhome}/${packagename}/bin/" + (String)importParentPath;
            }
            String exportDirectoryPrefix = initloader.getExportDirectoryPrefix();
            tplman.addContent("import_dir", (String)importParentPath);
            tplman.addContent("import_dir_prefix", exportDirectoryPrefix);
            this.initLoaderV4Flag = true;
        }
        if (!this.initLoaderV4Flag) {
            tplman.addContent("initloader_home", "${devhome}/${packagename}/command");
            tplman.addContent("initloader_bin", "${initloader_home}");
            tplman.addContent("initloader_param", "");
            tplman.addContent("initloader_begin_comment_v4", "");
            tplman.addContent("initloader_end_comment_v4", "");
            tplman.addContent("initloader_begin_comment_v3", "<!--");
            tplman.addContent("initloader_end_comment_v3", "-->");
            tplman.addContent("import_dir", "${devhome}/${packagename}/command/export");
            tplman.addContent("import_dir_prefix", "export_");
        }
        HashMap<String, List<String>> nameMap = new HashMap<String, List<String>>();
        nameMap.put("store", new ArrayList());
        nameMap.put("presentation", new ArrayList());
        nameMap.put("condition", new ArrayList());
        nameMap.put("list", new ArrayList());
        nameMap.put("total", new ArrayList());
        nameMap.put("master", new ArrayList());
        nameMap.put("dtd", new ArrayList());
        HashMap<String, StringBuilder> codeMap = new HashMap<String, StringBuilder>();
        codeMap.put("store", new StringBuilder());
        codeMap.put("presentation", new StringBuilder());
        codeMap.put("condition", new StringBuilder());
        codeMap.put("list", new StringBuilder());
        codeMap.put("total", new StringBuilder());
        codeMap.put("master", new StringBuilder());
        codeMap.put("javac", new StringBuilder());
        codeMap.put("create_ddl", new StringBuilder());
        HashMap<String, Set<String>> targetMap = new HashMap<String, Set<String>>();
        StringBuilder dtdbuf = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                if (!(ipc[i] instanceof Model)) continue;
                Model model = (Model)ipc[i];
                if ("jfcreminder".equals(model.getId()) || "jcategory".equals(model.getId())) {
                    this.createUntargetedModelDDL(model.getId(), (StringBuilder)codeMap.get("create_ddl"));
                }
                if (!model.getUseRelax() || "reserved".equals(model.getType())) continue;
                this.addTask(model, codeMap, nameMap, dtdbuf);
                this.addTarget(model, targetMap);
            }
        }
        tplman.addContent("relaxer_all", this.createAllTarget(nameMap));
        tplman.addContent("relaxer_store_model", ((StringBuilder)codeMap.get("store")).toString());
        tplman.addContent("relaxer_presentation_model", ((StringBuilder)codeMap.get("presentation")).toString());
        tplman.addContent("relaxer_condition_model", ((StringBuilder)codeMap.get("condition")).toString());
        tplman.addContent("relaxer_list_model", ((StringBuilder)codeMap.get("list")).toString());
        tplman.addContent("relaxer_total_model", ((StringBuilder)codeMap.get("total")).toString());
        tplman.addContent("relaxer_master_model", ((StringBuilder)codeMap.get("master")).toString());
        tplman.addContent("javac", ((StringBuilder)codeMap.get("javac")).toString());
        tplman.addContent("relaxer_store_namelist", this.createNamelist(nameMap, "store"));
        tplman.addContent("relaxer_presentation_namelist", this.createNamelist(nameMap, "presentation"));
        tplman.addContent("relaxer_condition_namelist", this.createNamelist(nameMap, "condition"));
        tplman.addContent("relaxer_list_namelist", this.createNamelist(nameMap, "list"));
        tplman.addContent("relaxer_total_namelist", this.createNamelist(nameMap, "total"));
        tplman.addContent("relaxer_master_namelist", this.createNamelist(nameMap, "master"));
        tplman.addContent("relaxer_dtd_namelist", this.createNamelist(nameMap, "dtd"));
        tplman.addContent("relaxer_customize_target", this.createCustomizeTarget(targetMap));
        tplman.addContent("relaxer_dtd", dtdbuf.toString());
        tplman.addContent("create_ddl", ((StringBuilder)codeMap.get("create_ddl")).toString());
        StringBuilder jc = new StringBuilder();
        String appname = AppSchemaUtil.getWebappName(this.project);
        String webenc = JavaSourceGenerator.getWebEncoding(this.project);
        jc.append(this.createJspCompileTaskTomcat5(appname, webenc));
        tplman.addContent("jspcompiletask", jc.toString());
        StringBuilder sb0 = new StringBuilder();
        if (this.initLoaderV4Flag) {
            sb0.append("          ");
            sb0.append("<exclude name=\"InitLoader.jar\"/>");
            sb0.append(CR);
        }
        tplman.addContent("jspcompiletask_initLoaderV4", sb0.toString());
        StringBuilder sb1 = new StringBuilder();
        if ("ROOT".equals(appname)) {
            sb1.append("    ");
            sb1.append("<move todir=\"${devhome}/${packagename}/work/Catalina/localhost/_\">");
            sb1.append(CR);
            sb1.append("      ");
            sb1.append("<fileset dir=\"${jspc.destdir}\"/>");
            sb1.append(CR);
            sb1.append("    ");
            sb1.append("</move>");
            sb1.append(CR);
        }
        tplman.addContent("jspcompiletask_finish_rootcase", sb1.toString());
        if (!adjustFilePathCase) {
            tplman.addContent("check_necessary_condition.comment.start", "    <!--");
            tplman.addContent("check_necessary_condition.comment.end", "    -->");
        } else {
            tplman.addContent("check_necessary_condition.comment.start", "");
            tplman.addContent("check_necessary_condition.comment.end", "");
        }
        tplman.addContent("org_targets", this.getCode(orgTargetsSet));
        tplman.addContent("hook_do_relaxer", this.getCode(hookDoRelaxerSet));
        tplman.addContent("hook_do_relaxer_jfc", this.getCode(hookDoRelaxerJfcSet));
        tplman.addContent("hook_do_relaxer_jfc_rng", this.getCode(hookDoRelaxerJfcRngSet));
        tplman.addContent("hook_untar_tomcat", this.getCode(hookUntarTomcatSet));
        tplman.addContent("hook_after_all", this.getCode(hookAfterAllSet));
        tplman.addContent("hook_after_all_diff", this.getCode(hookAfterAllDiffSet));
        return tplman.getResult();
    }

    protected void createUntargetedModelDDL(String modelId, StringBuilder sb) {
        sb.append("    ");
        sb.append("<antcall target=\"do_hibernateSchemaExport\">").append(CR).append("      ");
        sb.append("  <param name=\"mapping_file\" value=\"" + modelId + ".hbm.xml\"/>").append(CR).append("      ");
        sb.append("  <param name=\"model_dir\" value=\"jp/jasminesoft/jfc/model/" + modelId + "\"/>").append(CR).append("      ");
        sb.append("  <param name=\"ddl_file\" value=\"" + modelId + ".ddl\"/>").append(CR).append("    ");
        sb.append("</antcall>").append(CR).append(CR);
    }

    private void addTask(Model model, Map<String, StringBuilder> codeMap, Map<String, List<String>> nameMap, StringBuilder dtdbuf) {
        String id = model.getId();
        String type = model.getType();
        StringBuilder sbc = null;
        List<String> namelist = null;
        String modelpackagename = model.getPackage();
        boolean needsSchemaCompile = false;
        if (type == null) {
            return;
        }
        if ("store".equals(type)) {
            String storage = model.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            if (!model.getNoUseRelaxer()) {
                needsSchemaCompile = true;
            }
            if (needsSchemaCompile) {
                sbc = codeMap.get("store");
                String store_option = AppSchemaUtil.isUseRelaxerJdbcOption(model) ? "${relaxer_store_jdbc_op}" : "${relaxer_store_none_op}";
                sbc.append(this.relaxerBaseTask(modelpackagename, id, store_option, storagetype));
                namelist = nameMap.get("store");
                namelist.add("relaxer__" + id);
                dtdbuf.append(this.relaxerBaseTask(modelpackagename, "relaxer_dtd__", id, "-dtd"));
                namelist = nameMap.get("dtd");
                namelist.add("relaxer_dtd__" + id);
            }
            if (storagetype == 5 && AppSchemaUtil.isGenerateBuildXmlCreateDdl(model)) {
                sbc = codeMap.get("create_ddl");
                sbc.append("    ");
                sbc.append("<antcall target=\"do_hibernateSchemaExport\">");
                sbc.append(CR);
                if (modelpackagename != null) {
                    String _packagedir = JavaSourceGenerator.convPackage2FilePath(modelpackagename);
                    sbc.append("      ");
                    sbc.append("<param name=\"mapping_file\" value=\"");
                    sbc.append(id);
                    sbc.append(".hbm.xml\"/>");
                    sbc.append(CR);
                    sbc.append("      ");
                    sbc.append("<param name=\"model_dir\" value=\"");
                    sbc.append(_packagedir);
                    sbc.append("\"/>");
                    sbc.append(CR);
                    sbc.append("      ");
                    sbc.append("<param name=\"ddl_file\" value=\"");
                    sbc.append(id);
                    sbc.append(".ddl\"/>");
                    sbc.append(CR);
                } else {
                    sbc.append("      ");
                    sbc.append("<param name=\"schema_id\" value=\"");
                    sbc.append(id);
                    sbc.append("\"/>");
                    sbc.append(CR);
                }
                sbc.append("    ");
                sbc.append("</antcall>");
                sbc.append(CR);
                sbc.append(CR);
            }
        } else if ("presentation".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                needsSchemaCompile = true;
            }
            if (needsSchemaCompile) {
                sbc = codeMap.get("presentation");
                sbc.append(this.relaxerBaseTask(modelpackagename, id, "${relaxer_presentation_op}"));
                namelist = nameMap.get("presentation");
                namelist.add("relaxer__" + id);
            }
        } else if ("condition".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                needsSchemaCompile = true;
            }
            if (needsSchemaCompile) {
                sbc = codeMap.get("condition");
                sbc.append(this.relaxerBaseTask(modelpackagename, id, "${relaxer_condition_op}"));
                namelist = nameMap.get("condition");
                namelist.add("relaxer__" + id);
            }
        } else if ("list".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                needsSchemaCompile = true;
            }
            if (needsSchemaCompile) {
                sbc = codeMap.get("list");
                sbc.append(this.relaxerBaseTask(modelpackagename, id, "${relaxer_list_op}"));
                namelist = nameMap.get("list");
                namelist.add("relaxer__" + id);
            }
        } else if ("total".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                needsSchemaCompile = true;
            }
            if (needsSchemaCompile) {
                sbc = codeMap.get("total");
                sbc.append(this.relaxerBaseTask(modelpackagename, id, "${relaxer_total_op}"));
                namelist = nameMap.get("total");
                namelist.add("relaxer__" + id);
            }
        } else if ("master".equals(type)) {
            sbc = codeMap.get("master");
            String master_option = AppSchemaUtil.isUseRelaxerJdbcOption(model) ? "${relaxer_master_jdbc_op}" : "${relaxer_master_none_op}";
            sbc.append(this.relaxerBaseTask(modelpackagename, id, master_option));
            namelist = nameMap.get("master");
            namelist.add("relaxer__" + id);
        }
        if ("store".equals(type)) {
            StringBuilder sbj = codeMap.get("javac");
            sbj.append(this.javacTask(id));
        }
    }

    private String relaxerBaseTask(String modelpackagename, String id, String option) {
        return this.relaxerBaseTask(modelpackagename, "relaxer__", id, option);
    }

    private String relaxerBaseTask(String modelpackagename, String id, String option, int storagetype) {
        return this.relaxerBaseTask(modelpackagename, "relaxer__", id, option, storagetype);
    }

    private String relaxerBaseTask(String modelpackagename, String prefix, String id, String option) {
        return this.relaxerBaseTask(modelpackagename, prefix, id, option, -1);
    }

    private String relaxerBaseTask(String modelpackagename, String prefix, String id, String option, int storagetype) {
        StringBuilder sb = new StringBuilder();
        Object _packagedir = this.packagedir;
        Object _packagename = this.packagename;
        if (modelpackagename != null) {
            _packagename = modelpackagename;
            _packagedir = JavaSourceGenerator.convPackage2FilePath(modelpackagename);
        } else {
            _packagename = this.packagename + ".model." + id;
            _packagedir = this.packagedir + "/model/" + id;
        }
        sb.append(CR);
        sb.append("  ");
        sb.append("<target name=\"" + prefix + id + "\" depends=\"init\">");
        sb.append(CR);
        sb.append("    ");
        sb.append("<antcall target=\"do_relaxer\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<param name=\"targetdir\" value=\"");
        sb.append((String)_packagedir + "\"/>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<param name=\"targetpath\" value=\"");
        sb.append((String)_packagename + "\"/>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<param name=\"targetname\" value=\"" + id + "\"/>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<param name=\"option\" value=\"");
        sb.append(option);
        sb.append("\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</antcall>");
        sb.append(CR);
        sb.append("  ");
        sb.append("</target>");
        sb.append(CR);
        return sb.toString();
    }

    private String javacTask(String id) {
        StringBuilder sb = new StringBuilder();
        Model model = AppSchemaUtil.getModel(this.project, id);
        if (model == null) {
            return "";
        }
        Object packagedir = model.getPackage() == null ? "${fullpackagedir}/model/" + id + "*" : model.getPackage().replace('.', '/');
        sb.append(CR);
        sb.append("    ");
        sb.append("<javac srcdir=\"${package_src}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       destdir=\"${classdir}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       includes=\"" + (String)packagedir + "/*.java\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       deprecation=\"yes\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       encoding=\"UTF-8\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       classpathref=\"jars\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       debug=\"${debugcompile}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       fork=\"yes\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       target=\"${javac.target}\"");
        sb.append(" source=\"${javac.source}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       memoryMaximumSize=\"${javac.maxmemory}\"");
        sb.append(CR);
        if (this.javacTaskParam != null) {
            sb.append(this.javacTaskParam);
        }
        sb.append("    ");
        sb.append("/>");
        sb.append(CR);
        return sb.toString();
    }

    private String removeLastComm(String s) {
        if (s == null) {
            return null;
        }
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - ", ".length());
        }
        return s;
    }

    private void addTarget(Model model, Map<String, Set<String>> targetMap) {
        Set<String> set;
        IRNode node;
        String id;
        String idref = id = model.getId();
        String type = model.getType();
        if ("master".equals(type)) {
            return;
        }
        if (model.getNoUseRelaxer()) {
            return;
        }
        if ("presentation".equals(type) && (node = model.getIdrefAsIRNode()) != null && node instanceof Model) {
            model = (Model)node;
            type = model.getType();
            idref = model.getId();
        }
        if ("presentation".equals(type) || "list".equals(type) || "total".equals(type)) {
            idref = model.getIdref();
        }
        if ("condition".equals(type) && ((idref = model.getIdref()) == null || idref.length() == 0)) {
            idref = model.getId();
            idref = idref.substring(0, idref.indexOf("_c"));
        }
        if ((set = targetMap.get(idref)) == null) {
            set = new HashSet<String>();
            targetMap.put(idref, set);
        }
        set.add(id);
    }

    private String createAllTarget(Map<String, List<String>> nameMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<target name=\"relaxer_all\" depends=\"relaxer_ready, ");
        sb.append(this.createAllTarget0(nameMap, "store"));
        sb.append(this.createAllTarget0(nameMap, "presentation"));
        sb.append(this.createAllTarget0(nameMap, "list"));
        sb.append(this.createAllTarget0(nameMap, "total"));
        sb.append(this.createAllTarget0(nameMap, "condition"));
        sb.append(this.createAllTarget0(nameMap, "master"));
        return this.removeLastComm(sb.toString()) + "\"/>";
    }

    private String createAllTarget0(Map<String, List<String>> nameMap, String key) {
        List<String> list = nameMap.get(key);
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        if (size < 20) {
            sb.append("relaxer_" + key + ", ");
            return sb.toString();
        }
        int postfix = 1;
        for (int i = 0; i < size; i += 20) {
            sb.append("relaxer_" + key);
            sb.append(postfix++);
            sb.append(", ");
        }
        return sb.toString();
    }

    private String createNamelist(Map<String, List<String>> nameMap, String key) {
        List<String> list = nameMap.get(key);
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean multiFlag = false;
        int size = list.size();
        if (size >= 20) {
            multiFlag = true;
        }
        int postfix = 1;
        for (int i = 0; i < size; ++i) {
            if (i % 20 == 0) {
                if (i > 0) {
                    sb.append("\"/>");
                    sb.append(CR);
                }
                sb.append("  ");
                sb.append("<target name=\"relaxer_" + key);
                if (multiFlag) {
                    sb.append(postfix++);
                }
                sb.append("\" depends=\"");
            } else {
                sb.append(",");
            }
            sb.append(list.get(i));
        }
        if (!sb.toString().endsWith("\"/>")) {
            sb.append("\"/>");
            sb.append(CR);
        }
        return sb.toString();
    }

    private String createCustomizeTarget(Map<String, Set<String>> targetMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : targetMap.entrySet()) {
            String targetname = entry.getKey();
            if (targetname == null) continue;
            sb.append("  ");
            sb.append("<target name=\"relaxer_" + targetname + "_all\" depends=\"");
            sb.append("relaxer_ready, ");
            StringBuilder sb0 = new StringBuilder();
            Iterator<String> it2 = entry.getValue().iterator();
            while (it2.hasNext()) {
                sb0.append("relaxer__" + it2.next() + ", ");
            }
            String s0 = sb0.toString();
            sb.append(s0.substring(0, s0.length() - ", ".length()));
            sb.append("\"/>");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    private String getCode(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String createJarfilelist(Jarfilelist jarfilelist) {
        if (jarfilelist == null) {
            this.logger.error(this.rman.getValue("value.null.jarfilelist"));
            return "";
        }
        Jarfile[] jarfiles = jarfilelist.getJarfile();
        if (jarfiles == null) {
            this.logger.error(this.rman.getValue("value.null.jarfilelist.content"));
            return "";
        }
        TreeSet<String> generateset = new TreeSet<String>();
        HashSet<String> commonset = new HashSet<String>();
        HashSet<String> envset = new HashSet<String>();
        for (int i = 0; i < jarfiles.length; ++i) {
            Jarfile jarfile = jarfiles[i];
            if (jarfile.getGenerate()) continue;
            generateset.add(jarfile.getContent());
            if (jarfile.getCommon()) {
                commonset.add(jarfile.getContent());
                continue;
            }
            if (!jarfile.getEnv()) continue;
            envset.add(jarfile.getContent());
        }
        int size = generateset.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String content : generateset) {
            sb.append("      ");
            sb.append("<pathelement location=\"");
            if (commonset.contains(content)) {
                sb.append("${lib.common}/");
            } else if (envset.contains(content)) {
                sb.append("${lib.env}/");
            } else {
                sb.append("${lib}/");
            }
            sb.append(content);
            sb.append("\"/>");
            if (--size <= 0) continue;
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String createJarfileIncludeList(Jarfilelist jarfilelist) {
        if (jarfilelist == null) {
            this.logger.error(this.rman.getValue("value.null.jarfilelist"));
            return "";
        }
        Jarfile[] jarfiles = jarfilelist.getJarfile();
        if (jarfiles == null) {
            this.logger.error(this.rman.getValue("value.null.jarfilelist.content"));
            return "";
        }
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < jarfiles.length; ++i) {
            Jarfile jarfile = jarfiles[i];
            if (jarfile.getGenerate() || jarfile.getCompileonly()) continue;
            set.add(jarfile.getContent());
        }
        int size = set.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (--size <= 0) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected String createManifestlist(Manifestlist manifestlist, Jarfilelist jarfilelist) {
        if (jarfilelist == null) {
            this.logger.error(this.rman.getValue("value.null.jarfilelist"));
            return "";
        }
        Jarfile[] jarfiles = jarfilelist.getJarfile();
        if (jarfiles == null) {
            this.logger.error(this.rman.getValue("value.null.jarfilelist.content"));
            return "";
        }
        HashSet<String> manifestNameSet = new HashSet<String>();
        for (int i = 0; i < jarfiles.length; ++i) {
            Jarfile jarfile = jarfiles[i];
            String mf = jarfile.getMf();
            if (mf == null || mf.length() <= 0) continue;
            StringTokenizer st = new StringTokenizer(mf, ", ");
            while (st.hasMoreTokens()) {
                manifestNameSet.add(st.nextToken());
            }
        }
        Manifest[] manifests = null;
        if (manifestNameSet.size() > 0) {
            if (manifestlist == null) {
                this.logger.error(this.rman.getValue("value.null.manifestlist"));
                return "";
            }
            manifests = manifestlist.getManifest();
            if (manifests.length == 0) {
                this.logger.error(this.rman.getValue("value.null.manifestlist.content"));
                return "";
            }
        }
        Manifest manifest = null;
        StringBuilder sb = new StringBuilder();
        for (String name : manifestNameSet) {
            int j;
            for (int i = 0; i < manifests.length; ++i) {
                if (!name.equals(manifests[i].getName())) continue;
                manifest = manifests[i];
                break;
            }
            if (manifest == null) {
                this.logger.error(this.rman.getValue("value.null.manifest", name));
                continue;
            }
            Propertyfile[] props = manifest.getPropertyfile();
            if (props != null) {
                for (j = 0; j < props.length; ++j) {
                    String pname = props[j].getContent();
                    String rname = props[j].getRename();
                    Object dir = props[j].getDir();
                    if (dir != null && ((String)dir).length() > 0) {
                        if (!((String)dir).endsWith("/")) {
                            dir = (String)dir + "/";
                        }
                    } else {
                        dir = "";
                    }
                    if (rname == null || rname.length() == 0) {
                        rname = pname;
                    }
                    sb.append("    ");
                    sb.append("<copy file=\"");
                    sb.append((String)dir + pname);
                    sb.append("\"");
                    sb.append(CR);
                    sb.append("    ");
                    sb.append("      tofile=\"${workmanifest}/");
                    sb.append(rname);
                    sb.append("\" overwrite=\"yes\">");
                    sb.append(CR);
                    sb.append("    ");
                    sb.append("</copy>");
                    sb.append(CR);
                }
            }
            sb.append("    ");
            sb.append("<jar jarfile=\"${dirs.base}/");
            sb.append(name);
            sb.append(".jar\" basedir=\"${workmanifest}\"");
            sb.append(CR);
            if (props != null && props.length > 0) {
                sb.append("    ");
                sb.append("     includes=\"");
                String rname = null;
                for (int j2 = 0; j2 < props.length; ++j2) {
                    rname = props[j2].getRename();
                    if (rname == null || rname.length() == 0) {
                        rname = props[j2].getContent();
                    }
                    if (rname == null || rname.length() <= 0 || j2 >= props.length - 1) continue;
                    sb.append(rname);
                    sb.append(",");
                }
                if (rname != null && rname.length() > 0) {
                    sb.append(rname);
                }
                sb.append("\"");
                sb.append(CR);
            }
            sb.append("    ");
            sb.append("     manifest=\"${workmanifest}/");
            sb.append(name);
            sb.append(".manifest\"/>");
            sb.append(CR);
            if (props != null) {
                for (j = 0; j < props.length; ++j) {
                    String rname = props[j].getRename();
                    if (rname == null || rname.length() == 0) {
                        rname = props[j].getContent();
                    }
                    if (rname == null || rname.length() <= 0) continue;
                    sb.append("    ");
                    sb.append("<delete file=\"${workmanifest}/");
                    sb.append(rname);
                    sb.append("\"/>");
                    sb.append(CR);
                }
            }
            manifest = null;
        }
        return sb.toString();
    }

    protected String createJspCompileTaskTomcat5(String jfcappname, String encoding) {
        StringBuilder sb = new StringBuilder();
        String target_dir = this.project.getBasedir() + File.separator + "webpage";
        File webpage_dir = new File(target_dir);
        String[] contents = webpage_dir.list();
        for (int i = 0; i < contents.length; ++i) {
            String[] contents2;
            String filename = contents[i];
            File file = new File(target_dir + File.separator + filename);
            if (!file.isDirectory() || "customize".equals(filename) || "img".equals(filename) || "css".equals(filename) || "WEB-INF".equals(filename) || (contents2 = file.list()) == null || contents2.length < 1) continue;
            boolean hasJspFile = false;
            for (int j = 0; j < contents2.length; ++j) {
                if (!contents2[j].endsWith(".jsp")) continue;
                hasJspFile = true;
                break;
            }
            if (!hasJspFile) continue;
            String dirname = this.convertProperJspcDirectoryName(filename);
            sb.append("    ");
            sb.append("<echo message=\"compile ");
            sb.append(filename);
            sb.append(" jsp...\"/>");
            sb.append(CR);
            sb.append("    ");
            sb.append("<javac srcdir=\"${jspc.destdir}\"");
            sb.append(CR);
            sb.append("    ");
            sb.append("       destdir=\"${jspc.destdir}\"");
            sb.append(CR);
            sb.append("    ");
            sb.append("       encoding=\"UTF-8\"");
            sb.append(CR);
            sb.append("    ");
            sb.append("       classpathref=\"jspc.classpath\"");
            sb.append(CR);
            sb.append("    ");
            sb.append("       debug=\"${debugcompile}\"");
            sb.append(CR);
            sb.append("    ");
            sb.append("       fork=\"true\"");
            sb.append(CR);
            sb.append("    ");
            sb.append("       memoryMaximumSize=\"${javac.maxmemory}\">");
            sb.append(CR);
            sb.append("      ");
            sb.append("<include name=\"**/" + dirname + "/");
            sb.append("*.java\"/>");
            sb.append(CR);
            sb.append("      ");
            sb.append("<depend targetdir=\"${jspc.destdir}/**/" + dirname + "\"/>");
            sb.append(CR);
            sb.append("    ");
            sb.append("</javac>");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("<echo message=\"compile top directory");
        sb.append(" jsp...\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<javac srcdir=\"${jspc.destdir}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       destdir=\"${jspc.destdir}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       encoding=\"UTF-8\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       classpathref=\"jspc.classpath\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       debug=\"${debugcompile}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       fork=\"true\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("       memoryMaximumSize=\"${javac.maxmemory}\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<include name=\"**/");
        sb.append("*.java\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</javac>");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String convertProperJspcDirectoryName(String s) {
        s = s.replaceAll("_", "_005f");
        return s;
    }

    protected String createReplaceUSQLTarget() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<!-- Replace USQL for Oracle Database -->");
        sb.append(CR);
        sb.append("  ");
        sb.append("<target name=\"replaceUSQL\" description=\"Replace USQL.java file for Oracle Database\">");
        sb.append(CR);
        sb.append("    ");
        sb.append("<fixcrlf srcDir=\"${replace_dir}\" includes=\"**/USQL.java\" />");
        sb.append(CR);
        sb.append("    ");
        sb.append("<replace dir=\"${replace_dir}\" includes=\"**/USQL.java\" summary=\"Yes\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<replacetoken><![CDATA[");
        sb.append(CR);
        sb.append("    public static void setTIMESTAMPProperty(");
        sb.append(CR);
        sb.append("        ResultSet rs,");
        sb.append(CR);
        sb.append("        String name,");
        sb.append(CR);
        sb.append("        String path,");
        sb.append(CR);
        sb.append("        Element element");
        sb.append(CR);
        sb.append("    ) throws SQLException {");
        sb.append(CR);
        sb.append("        String data = rs.getString(name);");
        sb.append(CR);
        sb.append("        if (rs.wasNull()) {");
        sb.append(CR);
        sb.append("            return;");
        sb.append(CR);
        sb.append("        }");
        sb.append(CR);
        sb.append("        if (data != null) {");
        sb.append(CR);
        sb.append("            data.replace(' ', 'T');");
        sb.append(CR);
        sb.append("        }");
        sb.append(CR);
        sb.append("        setProperty(name, path, element, data);");
        sb.append(CR);
        sb.append("    }");
        sb.append(CR);
        sb.append("]]></replacetoken>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<replacevalue><![CDATA[    public static void setTIMESTAMPProperty(");
        sb.append(CR);
        sb.append("        ResultSet rs,");
        sb.append(CR);
        sb.append("        String name,");
        sb.append(CR);
        sb.append("        String path,");
        sb.append(CR);
        sb.append("        Element element");
        sb.append(CR);
        sb.append("    ) throws SQLException {");
        sb.append(CR);
        sb.append("        //String data = rs.getString(name);");
        sb.append(CR);
        sb.append("        String data = null;");
        sb.append(CR);
        sb.append("        Timestamp ts = rs.getTimestamp(name);");
        sb.append(CR);
        sb.append("        if (ts != null) {");
        sb.append(CR);
        sb.append("          data = ts.toString();");
        sb.append(CR);
        sb.append("        }");
        sb.append(CR);
        sb.append("        if (rs.wasNull()) {");
        sb.append(CR);
        sb.append("            return;");
        sb.append(CR);
        sb.append("        }");
        sb.append(CR);
        sb.append("        if (data != null) {");
        sb.append(CR);
        sb.append("            data.replace(' ', 'T');");
        sb.append(CR);
        sb.append("        }");
        sb.append(CR);
        sb.append("        setProperty(name, path, element, data);");
        sb.append(CR);
        sb.append("    }]]></replacevalue>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</replace>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<fixcrlf eol=\"lf\" srcDir=\"${replace_dir}\" includes=\"**/USQL.java\"/>");
        sb.append(CR);
        sb.append("  ");
        sb.append("</target>");
        sb.append(CR);
        return sb.toString();
    }

    protected String createReplaceUSQLTask(String replaceDir) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("<antcall target=\"replaceUSQL\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<param name=\"replace_dir\" value=\"" + replaceDir + "\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</antcall>");
        sb.append(CR);
        return sb.toString();
    }

    protected String createUntarTomcatCompat() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<!-- tomcat compat for jdk1.4(1.3) -->");
        sb.append(CR);
        sb.append("  ");
        sb.append("<target name=\"untar_tomcat_compat\" if=\"oldjdk\">");
        sb.append(CR);
        sb.append("    ");
        sb.append("<gunzip src=\"${dirs.base}/${tomcat_pac}-compat.tar.gz\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<untar  src=\"${dirs.base}/${tomcat_pac}-compat.tar\" dest=\"${workdir}\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<delete file=\"${tomcat_pac}-compat.tar\"/>");
        sb.append(CR);
        sb.append("  ");
        sb.append("</target>");
        return sb.toString();
    }

    protected String getJfctpdir() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("<property name=\"jfctoppackagedir\" value=\"jp\"/>");
        return sb.toString();
    }

    protected String getJfctpdirScp(boolean isPreservelastmodified) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("<copy todir=\"${package_src}/${jfctoppackagedir}\" overwrite=\"yes\" failonerror=\"false\"");
        if (isPreservelastmodified) {
            sb.append(" preservelastmodified=\"yes\"");
        }
        sb.append(">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<fileset dir=\"${srcgen}/${jfctoppackagedir}\" includes=\"**/*.java **/*.properties\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</copy>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<copy todir=\"${package_src}/${jfctoppackagedir}\" overwrite=\"yes\" failonerror=\"false\"");
        if (isPreservelastmodified) {
            sb.append(" preservelastmodified=\"yes\"");
        }
        sb.append(">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<fileset dir=\"${relaxgen}/${jfctoppackagedir}\" includes=\"**/*.java **/*.properties\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</copy>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<copy todir=\"${package_src}/${jfctoppackagedir}\" overwrite=\"yes\"");
        if (isPreservelastmodified) {
            sb.append(" preservelastmodified=\"yes\"");
        }
        sb.append(">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<fileset dir=\"${jfctoppackagedir}\" includes=\"**/*.java **/*.properties\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</copy>");
        return sb.toString();
    }

    protected String getJfctpdirCRTW() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("<copy todir=\"${package_src}/${jfctoppackagedir}\" preservelastmodified=\"yes\" failonerror=\"false\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<fileset dir=\"${srcgen}/${jfctoppackagedir}\" includes=\"${allrelaxschema}\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</copy>");
        sb.append(CR);
        sb.append("    ");
        sb.append("<copy todir=\"${package_src}/${jfctoppackagedir}\" overwrite=\"yes\" preservelastmodified=\"yes\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("<fileset dir=\"${jfctoppackagedir}\" includes=\"${allrelaxschema}\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</copy>");
        return sb.toString();
    }

    protected String getJfctpdirJavadoc() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("<javadoc packagenames=\"${jfctoppackagedir}.*\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         classpathref=\"jars\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         encoding=\"UTF-8\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         sourcepath=\"${package_src}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         destdir=\"${docdir}\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         author=\"true\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         version=\"true\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         use=\"true\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         windowtitle=\"database API Guide\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         doctitle=\"&lt;h1&gt; API Guide  &lt;/h1&gt;\"");
        sb.append(CR);
        sb.append("    ");
        sb.append("         bottom=\"&lt;i&gt;Copyright &#169; 2001- JasmineSoft &lt;/i&gt;\">");
        sb.append(CR);
        sb.append("    ");
        sb.append("</javadoc>");
        return sb.toString();
    }

    protected String getJfctpdirZipfileset() {
        StringBuilder sb = new StringBuilder();
        sb.append("${jfctoppackagedir}/**/*");
        return sb.toString();
    }

    protected String createJspCompileTaskDummy() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("<!-- Unknown Tomcat version is specified. -->");
        sb.append(CR);
        return sb.toString();
    }

    public static void setAdjustFilePathCaseFlagOn() {
        adjustFilePathCase = true;
    }

    public static void reset() {
        adjustFilePathCase = false;
    }
}

