/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.StyleSheetManager;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaytext;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CSSLayout
extends StyleSheetManager {
    private Integer currentDisplayitemIndex;
    private static DecimalFormat nf = new DecimalFormat("###.###");
    private Map<String, Map<String, String>> itemMap;
    private int fieldIdCounter = 0;
    private Map<String, Map<String, String>> fieldIdMap;
    private Map<IDisplayitemgroupChoice, Set<String>> fieldParentMap;
    private int groupCounter = 0;
    private Map<String, Map<String, String>> groupMap;
    private String currentGroupName;
    private Map<String, Map<String, String>> horizontalMap;
    private int innerCounter = 0;
    private StringBuilder csscontent = new StringBuilder();
    private Map<String, Map<String, String>> fieldCacheMap = new HashMap<String, Map<String, String>>();

    public CSSLayout(Project project, Presentation presentation, String id, String filename) {
        super(project, presentation, id, filename);
        this.itemMap = new LinkedHashMap<String, Map<String, String>>();
        this.fieldIdMap = new TreeMap<String, Map<String, String>>();
        this.fieldParentMap = new HashMap<IDisplayitemgroupChoice, Set<String>>();
        this.groupMap = new LinkedHashMap<String, Map<String, String>>();
        this.horizontalMap = new LinkedHashMap<String, Map<String, String>>();
    }

    public String getLabelClassName(Displayitem ditem) {
        return this.getClassName(null, ditem, "label");
    }

    public String getLabelClassName(Model pmodel, Displayitem ditem) {
        return this.getClassName(pmodel, ditem, "label");
    }

    public String getFieldClassName(Displayitem ditem) {
        return this.getClassName(null, ditem, "field");
    }

    public String getFieldClassName(Model pmodel, Displayitem ditem) {
        return this.getClassName(pmodel, ditem, "field");
    }

    public String getClassName(Model pmodel, Displayitem ditem, String postfix) {
        if (ditem == null) {
            return "";
        }
        String s = StringUtil.replaceAll((String)ditem.getName(), (String)"/", (String)"_") + "_" + postfix;
        if (pmodel != null && pmodel.getId().endsWith("_cp")) {
            Model smodel = (Model)pmodel.getIdrefAsIRNode();
            s = smodel.getId() + "_" + s;
        } else if (pmodel != null && (pmodel.getId().endsWith("_lp") || pmodel.getId().endsWith("_ulp"))) {
            s = pmodel.getId() + "_" + s;
        }
        return s;
    }

    public void createNewItem(String cssid) {
        this.createNewItem(cssid, null);
    }

    public void createNewItem(String cssid, Displayitem ditem) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        this.itemMap.put(cssid, map);
        String marginBottom = null;
        if (ditem == null || !"column".equals(ditem.getLabelalign())) {
            map.put("display", "flex");
            marginBottom = "1px";
        } else {
            marginBottom = "10px";
        }
        map.put("margin-bottom", marginBottom);
    }

    public String createNewFieldsetId(String modelid, Displayitemgroup ditemg, IDisplayitemgroupChoice parent, int i) {
        return this.createNewFieldsetId(modelid, ditemg, parent, i, null);
    }

    public String createNewFieldsetId(String modelid, Displayitemgroup ditemg, IDisplayitemgroupChoice parent, int i, String csscontent) {
        ++this.fieldIdCounter;
        String name = modelid + "_fieldset" + this.fieldIdCounter;
        Object currentSeparateValue = null;
        int sizeOfChildren = 0;
        String separate = null;
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (parent != null && parent instanceof Displayitemgroup) {
            separate = ((Displayitemgroup)parent).getSeparate();
            if (StringUtils.isNotBlank((CharSequence)separate) && !"0".contentEquals(separate)) {
                ArrayList<String> sepWidthList = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(separate, ", ");
                while (st.hasMoreTokens()) {
                    sepWidthList.add(st.nextToken());
                }
                if (i >= 0 && i < sepWidthList.size()) {
                    map.put("width", (String)sepWidthList.get(i));
                }
            }
        } else if (ditemg != null) {
            boolean hasChildDisplayitemgroup = false;
            for (IDisplayitemgroupChoice idgc : ditemg.getContent()) {
                if (!(idgc instanceof Displayitemgroup)) continue;
                hasChildDisplayitemgroup = true;
                break;
            }
            if (hasChildDisplayitemgroup) {
                separate = ditemg.getSeparate();
            }
            if (StringUtils.isNotBlank((CharSequence)separate) && !"0".contentEquals(separate)) {
                Set<String> children = this.fieldParentMap.get(ditemg);
                if (children == null) {
                    children = new HashSet<String>();
                    this.fieldParentMap.put(ditemg, children);
                }
                children.add(name);
                sizeOfChildren = children.size();
                ArrayList<String> sepWidthList = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(separate, ", ");
                while (st.hasMoreTokens()) {
                    sepWidthList.add(st.nextToken());
                }
                if (sizeOfChildren <= sepWidthList.size()) {
                    map.put("width", (String)sepWidthList.get(sizeOfChildren - 1));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)csscontent)) {
            this.setCsscontent2Map(csscontent, map);
        }
        if (map.size() > 0) {
            map.put("margin-top", "2px");
        }
        map.put("padding", "4px");
        this.fieldIdMap.put(name, map);
        return name;
    }

    private void setCsscontent2Map(String csscontent, Map<String, String> map) {
        String[] lines;
        for (String line : lines = csscontent.split(";")) {
            int ptr = line.indexOf(":");
            if (ptr <= 0) continue;
            String key = line.substring(0, ptr).trim();
            String value = line.substring(ptr + 1).trim();
            map.put(key, value);
        }
    }

    public String createNewHorizontalGroup(String modelid, Displayitemgroup parent, Displayitemgroup ditemg, String csscontent) {
        String separate;
        ++this.groupCounter;
        String name = modelid + "_group" + this.groupCounter;
        this.currentGroupName = name;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)csscontent)) {
            this.setCsscontent2Map(csscontent, map);
        }
        boolean isContainedDisplayitemgroup = false;
        if (ditemg != null) {
            for (IDisplayitemgroupChoice idic : ditemg.getContent()) {
                Displayitemgroup _ditemg;
                if (!(idic instanceof Displayitemgroup) || !"fieldset".equals((_ditemg = (Displayitemgroup)idic).getGroupLayout())) continue;
                isContainedDisplayitemgroup = true;
                break;
            }
        }
        if (!isContainedDisplayitemgroup) {
            map.put("background-color", "var(--bgcolor_group, #F6F6F6)");
            map.put("padding", "0");
        }
        map.put("margin-bottom", "1px");
        String string = separate = parent != null ? this.adjustDisplayitemgroupSeparateValue(parent) : null;
        if (separate != null && !"0".equals(separate) && ditemg != null) {
            String[] tokens = separate.split(",");
            for (int i = 0; i < parent.sizeContent(); ++i) {
                Displayitemgroup c_ditemg;
                IDisplayitemgroupChoice idic;
                idic = parent.getContent(i);
                if (!(idic instanceof Displayitemgroup) || !(c_ditemg = (Displayitemgroup)idic).toString().equals(ditemg.toString())) continue;
                if (i < tokens.length) {
                    map.put("width", tokens[i]);
                    break;
                }
                map.put("width", tokens[tokens.length - 1]);
                break;
            }
        }
        if (!map.containsKey("width") && !map.containsKey("display")) {
            map.put("width", "100%");
        }
        this.groupMap.put(name, map);
        this.currentDisplayitemIndex = -1;
        return name;
    }

    public void resetSeparateValue() {
        Map<String, String> map = this.groupMap.get(this.currentGroupName);
        if (map != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (!key.startsWith("#separate")) continue;
                removeList.add(key);
            }
            if (removeList.size() > 0) {
                for (String rkey : removeList) {
                    map.remove(rkey);
                }
            }
        }
    }

    public String createNewHorizonLayout(String modelid, Displayitem ditem, String csscontent) {
        return this.createNewHorizonLayout(modelid, ditem, csscontent, true);
    }

    public String createNewHorizonLayout(String modelid, Displayitem ditem, String csscontent, boolean isOutputMarginAdjustment) {
        String name = modelid + "_" + ditem.getName().replace('/', '_');
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)csscontent)) {
            this.setCsscontent2Map(csscontent, map);
        }
        if (isOutputMarginAdjustment) {
            boolean isColumn;
            boolean bl = isColumn = "column".equals(ditem.getLabelalign());
            if (isColumn || StringUtils.isNotBlank((CharSequence)ditem.getLayoutid())) {
                map.put("margin-right", "1px");
            } else {
                map.put("display", "flex");
            }
        }
        this.horizontalMap.put(name, map);
        return name;
    }

    public String createNewGroupFrame(String modelid, Displayitemgroup ditemg) {
        return this.createNewGroupFrame(modelid, ditemg, null);
    }

    public String createNewGroupFrame(String modelid, Displayitemgroup ditemg, Integer index) {
        String separate;
        ++this.groupCounter;
        String name = modelid + "_groupframe" + this.groupCounter;
        this.currentGroupName = name;
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        map.put("background-color", "var(--bgcolor_group, #F6F6F6)");
        map.put("padding", "0");
        map.put("display", "flex");
        map.put("margin-bottom", "1px");
        if (index != null) {
            map.put("#index", String.valueOf(index));
        }
        String string = separate = ditemg != null ? this.adjustDisplayitemgroupSeparateValue(ditemg) : null;
        if (separate != null && !"0".equals(separate)) {
            String[] tokens = separate.split(",");
            int size = tokens.length;
            for (int i = 0; i < size; ++i) {
                map.put("#separate" + i, tokens[i]);
            }
        }
        this.groupMap.put(name, map);
        this.currentDisplayitemIndex = -1;
        return name;
    }

    public String createNewInnerFrame(String modelid, Displayitemgroup ditemg, String csscontent) {
        ++this.innerCounter;
        String name = modelid + "_innerframe" + this.innerCounter;
        LinkedHashMap<String, String> map = null;
        if (StringUtils.isNotBlank((CharSequence)csscontent)) {
            map = new LinkedHashMap<String, String>();
            this.setCsscontent2Map(csscontent, map);
        }
        this.groupMap.put(name, map);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String adjustDisplayitemgroupSeparateValue(Displayitemgroup ditemg) {
        String separate = ditemg.getSeparate();
        if (StringUtils.isBlank((CharSequence)separate) || separate.indexOf(",") <= 0) {
            return separate;
        }
        ArrayList<String> sepWidthList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(separate, ", ");
        while (st.hasMoreTokens()) {
            sepWidthList.add(st.nextToken());
        }
        int idx = 0;
        double hiddensep = 0.0;
        ArrayList<Integer> removeIndexList = null;
        for (IDisplayitemgroupChoice idigc : ditemg.getContent()) {
            Displayitem ditem;
            if (idigc instanceof Displayitem && AppSchemaUtil.isHiddenDisplayitem(ditem = (Displayitem)idigc) && idx < sepWidthList.size()) {
                block25: {
                    String s = (String)sepWidthList.get(idx);
                    if (s.endsWith("%")) {
                        s = s.substring(0, s.length() - 1);
                    } else if (s.endsWith("px")) {
                        s = s.substring(0, s.length() - 2);
                    }
                    try {
                        Double d = Double.valueOf(s);
                        hiddensep += d.doubleValue();
                        if (removeIndexList != null) break block25;
                    }
                    catch (NumberFormatException e) {
                        try {
                            logger.warn("illegal separate, " + separate + " in " + ditemg);
                            if (removeIndexList == null) {
                                removeIndexList = new ArrayList();
                            }
                            removeIndexList.add(idx);
                        }
                        catch (Throwable throwable) {
                            if (removeIndexList == null) {
                                removeIndexList = new ArrayList<Integer>();
                            }
                            removeIndexList.add(idx);
                            throw throwable;
                        }
                    }
                    removeIndexList = new ArrayList();
                }
                removeIndexList.add(idx);
            }
            ++idx;
        }
        if (removeIndexList != null) {
            if (removeIndexList.size() == sepWidthList.size()) {
                return separate;
            }
            for (int i = removeIndexList.size() - 1; i >= 0; --i) {
                idx = (Integer)removeIndexList.get(i);
                sepWidthList.remove(idx);
            }
            if (sepWidthList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                double ratio = hiddensep / (double)sepWidthList.size();
                for (String s : sepWidthList) {
                    if (s.endsWith("%")) {
                        s = s.substring(0, s.length() - 1);
                    } else if (s.endsWith("px")) {
                        s = s.substring(0, s.length() - 2);
                    }
                    try {
                        Double d = Double.valueOf(s);
                        d = d + ratio;
                        Object n_width = nf.format(d);
                        if (((String)n_width).endsWith(".0")) {
                            n_width = ((String)n_width).substring(0, ((String)n_width).length() - ".0".length());
                        }
                        n_width = (String)n_width + "%";
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append((String)n_width);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("illegal separate value, " + s + " in " + sepWidthList);
                    }
                }
                return sb.toString();
            }
        }
        return separate;
    }

    public void addLabel(Model pmodel, Displayitem ditem, String name, String content) {
        this.addLabel(pmodel, ditem, name, content, true);
    }

    public void addLabel(Model pmodel, Displayitem ditem, String name, String content, boolean useLabelRatioValue) {
        if (this.currentDisplayitemIndex == null) {
            this.currentDisplayitemIndex = -1;
        }
        Integer n = this.currentDisplayitemIndex;
        this.currentDisplayitemIndex = this.currentDisplayitemIndex + 1;
        Map<String, String> gmap = this.groupMap.get(this.currentGroupName);
        TreeMap<String, String> map = new TreeMap<String, String>();
        String skey = "#separate" + this.currentDisplayitemIndex;
        if (gmap != null && gmap.containsKey(skey)) {
            map.put(skey, gmap.get(skey));
        }
        String labelwidth = null;
        if (ditem != null && !ditem.getDisplaylabel()) {
            labelwidth = ditem.getLabelwidth();
        }
        labelwidth = labelwidth != null ? labelwidth : "";
        boolean isLabelRatioValue = false;
        if (labelwidth.endsWith("%")) {
            labelwidth = labelwidth.substring(0, labelwidth.length() - 1);
            isLabelRatioValue = true;
        } else if (labelwidth.endsWith("px") || labelwidth.endsWith("em")) {
            labelwidth = labelwidth.substring(0, labelwidth.length() - 2);
        } else if (labelwidth.endsWith("rem")) {
            labelwidth = labelwidth.substring(0, labelwidth.length() - 3);
        }
        double label_v = NumberUtils.toDouble((String)labelwidth);
        String separate = (String)map.get("#separate" + this.currentDisplayitemIndex);
        if (StringUtils.isNotBlank((CharSequence)separate) && useLabelRatioValue) {
            separate = separate.substring(0, separate.length() - 1);
            double separate_v = NumberUtils.toDouble((String)separate);
            label_v = isLabelRatioValue ? separate_v / 100.0 * (label_v / 100.0) * 100.0 : separate_v / 100.0 * label_v;
        }
        if (label_v > 0.0) {
            Object n_labelwidth = nf.format(label_v);
            if (((String)n_labelwidth).endsWith(".0")) {
                n_labelwidth = ((String)n_labelwidth).substring(0, ((String)n_labelwidth).length() - ".0".length());
            }
            n_labelwidth = isLabelRatioValue ? (String)n_labelwidth + "%" : (String)n_labelwidth + "px";
            map.put("width", (String)n_labelwidth);
        }
        this.setThAlign(ditem.getThalign(), map);
        this.setThValign(ditem.getThvalign(), map);
        if (this.isDisplaytextLabel(ditem)) {
            map.put("flex-wrap", "wrap");
        }
        this.csscontent.append(this.add(pmodel, ditem, name, content, map, null));
    }

    private boolean isDisplaytextLabel(Displayitem ditem) {
        return this.isDisplaytextPosition(ditem, "label");
    }

    private boolean isDisplaytextField(Displayitem ditem) {
        return this.isDisplaytextPosition(ditem, "field");
    }

    private boolean isDisplaytextPosition(Displayitem ditem, String position) {
        IDisplayitemChoice[] contents = ditem.getContent();
        if (contents == null || contents.length == 0) {
            return false;
        }
        return Arrays.stream(contents).filter(c -> c instanceof Displaytext).anyMatch(c -> ((Displaytext)c).getPosition().equals(position));
    }

    public void addContent(Model pmodel, Displayitem ditem, String name, String content) {
        String separate;
        boolean isContentRatioValue;
        Map<String, String> gmap = this.groupMap.get(this.currentGroupName);
        boolean d = false;
        if (d) {
            System.out.println("ditem=" + ditem + " in " + pmodel.getIdref());
            System.out.println("name=" + name);
            System.out.println("content=" + content);
            System.out.println("currentGroupName=" + this.currentGroupName);
            System.out.println("gmap=" + gmap);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        String skey = "#separate" + this.currentDisplayitemIndex;
        if (gmap != null && gmap.containsKey(skey)) {
            map.put(skey, gmap.get(skey));
        }
        String labelwidth = ditem != null ? ditem.getLabelwidth() : "";
        labelwidth = labelwidth != null ? labelwidth : "";
        boolean isLabelRatioValue = false;
        if (ditem != null && !ditem.getDisplaylabel()) {
            isLabelRatioValue = true;
            labelwidth = "0";
        } else if (labelwidth.endsWith("%")) {
            labelwidth = labelwidth.substring(0, labelwidth.length() - 1);
            isLabelRatioValue = true;
        } else if (labelwidth.endsWith("px") || labelwidth.endsWith("em")) {
            labelwidth = labelwidth.substring(0, labelwidth.length() - 2);
        } else if (labelwidth.endsWith("rem")) {
            labelwidth = labelwidth.substring(0, labelwidth.length() - 3);
        }
        if (d) {
            System.out.println("labelwidth=" + labelwidth + ", isLabelRatioValue=" + isLabelRatioValue);
        }
        double label_v = NumberUtils.toDouble((String)labelwidth);
        Object contentwidth = ditem != null ? ditem.getWidth() : null;
        contentwidth = contentwidth != null ? contentwidth : "";
        boolean bl = isContentRatioValue = ditem != null && !ditem.getDisplaylabel() ? true : isLabelRatioValue;
        if (((String)contentwidth).endsWith("%")) {
            contentwidth = ((String)contentwidth).substring(0, ((String)contentwidth).length() - 1);
            isContentRatioValue = true;
        } else if (((String)contentwidth).endsWith("px") || ((String)contentwidth).endsWith("em")) {
            contentwidth = ((String)contentwidth).substring(0, ((String)contentwidth).length() - 2);
            isContentRatioValue = false;
        } else if (((String)contentwidth).endsWith("rem")) {
            contentwidth = ((String)contentwidth).substring(0, ((String)contentwidth).length() - 3);
            isContentRatioValue = false;
        }
        double content_v = -1.0;
        if (StringUtils.isNotBlank((CharSequence)contentwidth)) {
            content_v = NumberUtils.toDouble((String)contentwidth);
        }
        if (d) {
            System.out.println("label_v=" + label_v);
            System.out.println("content_v=" + content_v);
            System.out.println("isLabelRatioValue=" + isLabelRatioValue);
        }
        if (StringUtils.isNotBlank((CharSequence)(separate = (String)map.get("#separate" + this.currentDisplayitemIndex)))) {
            separate = separate.substring(0, separate.length() - 1);
            double separate_v = NumberUtils.toDouble((String)separate);
            if (isLabelRatioValue) {
                label_v = separate_v / 100.0 * (label_v / 100.0);
                content_v = (separate_v / 100.0 - label_v) * 100.0;
            }
        } else if (isLabelRatioValue && content_v <= 0.0) {
            content_v = (1.0 - label_v / 100.0) * 100.0;
        }
        if (d) {
            System.out.println("content_v (2) =" + content_v);
        }
        if (content_v > 0.0) {
            contentwidth = nf.format(content_v);
            if (d) {
                System.out.println("contentwidth=" + (String)contentwidth);
            }
            if (((String)contentwidth).endsWith(".0")) {
                contentwidth = ((String)contentwidth).substring(0, ((String)contentwidth).length() - ".0".length());
            }
            contentwidth = isContentRatioValue ? (String)contentwidth + "%" : (String)contentwidth + "px";
            if (d) {
                System.out.println("contentwidth last=" + (String)contentwidth);
            }
            if (!ThGenerator.isConditionDitemgLayoutLeft(ditem)) {
                map.put("width", (String)contentwidth);
            }
        } else {
            map.put("width", "100%");
        }
        this.setAlign(ditem.getAlign(), map);
        this.setValign(ditem.getValign(), map);
        if (this.isDisplaytextField(ditem)) {
            map.put("flex-wrap", "wrap");
        }
        this.addContentCore(pmodel, ditem, name, content, map);
    }

    public void addContentItem(Model pmodel, Displayitem ditem, String name, String content) {
        this.addContentCore(pmodel, ditem, name, content, null);
    }

    private void setThAlign(String align, Map<String, String> map) {
        this.setFlexAlign("justify-content", align, "center", map);
    }

    private void setAlign(String align, Map<String, String> map) {
        this.setFlexAlign("justify-content", align, "left", map);
    }

    private void setThValign(String valign, Map<String, String> map) {
        this.setValign(valign, map);
    }

    private void setValign(String valign, Map<String, String> map) {
        this.setFlexAlign("align-items", valign, "center", map);
    }

    private void setFlexAlign(String name, String align, String defaultAlign, Map<String, String> map) {
        String flexAlign = this.getFlexAlignValue(align);
        if (StringUtils.isBlank((CharSequence)flexAlign) || defaultAlign.equals(flexAlign)) {
            return;
        }
        map.put(name, flexAlign);
    }

    private String getFlexAlignValue(String align) {
        if ("left".equals(align) || "top".equals(align)) {
            return "flex-start";
        }
        if ("center".equals(align) || "middle".equals(align)) {
            return "center";
        }
        if ("right".equals(align) || "bottom".equals(align)) {
            return "flex-end";
        }
        return null;
    }

    public void addContentCore(Displayitem ditem, String name, String content) {
        this.addContentCore(null, ditem, name, content, null, null);
    }

    public void addContentCore(Model pmodel, Displayitem ditem, String name, String content) {
        this.addContentCore(pmodel, ditem, name, content, null, null);
    }

    public void addContentCore(Displayitem ditem, String name, String content, Map<String, String> map) {
        this.addContentCore(null, ditem, name, content, map, null);
    }

    public void addContentCore(Model pmodel, Displayitem ditem, String name, String content, Map<String, String> map) {
        this.addContentCore(pmodel, ditem, name, content, map, null);
    }

    public void addContentCore(Displayitem ditem, String name, String content, Map<String, String> map, String prefixModelId) {
        this.addContentCore(null, ditem, name, content, map, prefixModelId);
    }

    public void addContentCore(Model pmodel, Displayitem ditem, String name, String content, Map<String, String> map, String prefixModelId) {
        int endptr;
        int ptr;
        String header;
        this.setStyle(ditem, map);
        String s = this.add(pmodel, ditem, name, content, map, prefixModelId);
        String string = header = s != null && s.indexOf("{") > 0 ? s.substring(0, s.indexOf("{")) : "";
        if (header.length() > 0 && (ptr = this.csscontent.indexOf(header)) >= 0 && (endptr = this.csscontent.substring(ptr).indexOf("}")) > 0) {
            this.csscontent.delete(ptr, ptr + endptr + 1);
        }
        this.csscontent.append(s);
    }

    private void setStyle(Displayitem ditem, Map<String, String> map) {
        int ptr;
        boolean isUpdateScreen = false;
        if (StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"update") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"insert") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"copy")) {
            isUpdateScreen = true;
        }
        if (StringUtils.isBlank((CharSequence)ditem.getStyle()) || isUpdateScreen && "centerfield".equals(ditem.getStylePlace()) || ditem.getBarGauge() || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"showList") || StringUtils.startsWith((CharSequence)this.presentation.getIdref(), (CharSequence)"searchList")) {
            return;
        }
        String style = ditem.getStyle();
        if (CSSLayout.isStyleWithCondition(style)) {
            return;
        }
        if (style.charAt(0) == '\"') {
            style = style.substring(1);
        }
        if (style.charAt(style.length() - 1) == '\"') {
            style = style.substring(0, style.length() - 1);
        }
        if (StringUtils.startsWith((CharSequence)style, (CharSequence)"div{")) {
            style = StringUtils.contains((CharSequence)style, (CharSequence)"}") ? StringUtils.substringAfter((String)style, (String)"}") : "";
        }
        style = style.trim();
        while ((ptr = style.indexOf(":")) >= 0) {
            String key = style.substring(0, ptr).trim();
            String value = null;
            int ptr2 = (style = style.substring(ptr + 1).trim()).indexOf(";");
            if (ptr2 < 0) {
                value = style;
            } else {
                value = style.substring(0, ptr2).trim();
                style = style.substring(ptr2 + 1).trim();
            }
            if (map == null) {
                map = new HashMap<String, String>();
            }
            if (!map.containsKey(key)) {
                map.put(key, value);
                continue;
            }
            logger.warn("Override: " + ditem.getName() + ", " + map.get(key) + " -> " + value);
            map.put(key, value);
        }
    }

    public String addContainer(String name, Map<String, String> map) {
        String head = StringUtil.replaceAll((String)name, (String)"$", (String)"\\$");
        StringBuilder sb = new StringBuilder();
        sb.append(".").append(head).append(" ");
        sb.append(this.addContainer(map));
        return sb.toString();
    }

    public String addContainer(Map<String, String> map) {
        String v;
        Integer index = null;
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(CR);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String k = entry.getKey();
            String v2 = entry.getValue();
            if (k.startsWith("#")) {
                if (!k.equals("#index")) continue;
                index = NumberUtils.toInt((String)v2);
                continue;
            }
            sb.append("  ").append(k).append(": ").append(v2).append(";").append(CR);
        }
        if (index != null && (v = map.get("#separate" + index)) != null) {
            sb.append("  ").append("width: ").append(v).append(";").append(CR);
        }
        sb.append("}").append(CR);
        return sb.toString();
    }

    public String getCssId(String modelid, Displayitem ditem) {
        return this.getCssId(modelid, ditem, "");
    }

    public String getCssId(String modelid, Displayitem ditem, String type) {
        StringBuilder sb = new StringBuilder();
        String name = ditem != null ? ditem.getName() : type;
        name = StringUtil.replaceAll((String)name, (String)"$", (String)"_");
        name = StringUtil.replaceAll((String)name, (String)"/", (String)"_");
        sb.append(modelid).append("_").append(name);
        return sb.toString();
    }

    private String add(Model pmodel, Displayitem ditem, String type, String content, Map<String, String> map, String prefixModelId) {
        String _id;
        if (map == null) {
            map = new HashMap<String, String>();
        }
        boolean isListModel = false;
        String string = _id = pmodel != null ? pmodel.getId() : "";
        if (_id.endsWith("_lp") || _id.endsWith("_tp") || _id.endsWith("_ulp")) {
            isListModel = true;
        }
        map.putAll(this.getStyleMapFromDisplayitem(ditem));
        map.putAll(this.getStyleMapFromContent(content));
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(".");
        if (prefixModelId != null && !((String)type).startsWith(prefixModelId)) {
            sb.append(prefixModelId).append("_");
        }
        if (type != null && ((String)type).endsWith("_field")) {
            if (prefixModelId == null && !isListModel) {
                Map<String, String> cmap = this.fieldCacheMap.get(type);
                if (cmap == null) {
                    if (map != null && map.size() > 0) {
                        this.fieldCacheMap.put((String)type, map);
                    }
                } else if (cmap != null) {
                    for (String string2 : cmap.keySet()) {
                        if (map.containsKey(string2)) continue;
                        map.put(string2, cmap.get(string2));
                    }
                }
            }
            if (isListModel) {
                type = pmodel.getId() + "_" + (String)type;
            }
            sb.append((String)type);
        } else if (type != null && ((String)type).startsWith("label_")) {
            sb.append(this.getLabelClassName(pmodel, ditem));
        } else if (type != null && ((String)type).startsWith("content_")) {
            String fname = this.getFieldClassName(pmodel, ditem);
            Map<String, String> cmap = this.fieldCacheMap.get(fname);
            if (cmap == null) {
                if (map != null && map.size() > 0) {
                    this.fieldCacheMap.put(fname, map);
                }
            } else if (cmap != null) {
                for (String k : cmap.keySet()) {
                    if (map.containsKey(k)) continue;
                    map.put(k, cmap.get(k));
                }
            }
            sb.append(fname);
        }
        sb.append(" {").append(CR);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                String v = entry.getValue();
                if (string3 == null || string3.equals("class") || string3.equals("valign") || string3.equals("align")) continue;
                if (string3.startsWith("#")) {
                    if (!string3.equals("#ThFlag1")) continue;
                    sb.append("  ").append("margin-left: 1px;").append(CR);
                    continue;
                }
                if (string3.equals("width") && (v.startsWith("[") && v.endsWith("]") || "column".equals(ditem.getLabelalign())) || !StringUtils.isNotBlank((CharSequence)v) || StringUtil.isWhitespace((String)v) || CSSLayout.isStyleWithCondition(v)) continue;
                if ((v = v.trim()).endsWith(";")) {
                    v = v.substring(0, v.length() - 1);
                }
                sb.append("  ").append(string3).append(": ").append(v).append(";").append(CR);
            }
        }
        sb.append("}").append(CR);
        return sb.toString();
    }

    private Map<String, String> getStyleMapFromDisplayitem(Displayitem ditem) {
        HashMap<String, String> map = new HashMap<String, String>();
        String height = ditem.getHeight();
        if (StringUtils.isNotBlank((CharSequence)height)) {
            map.put("height", height);
        }
        if ((AppSchemaUtil.hasChildPart(ditem.getName()) || StringUtils.endsWith((CharSequence)ditem.getName(), (CharSequence)"jshparam")) && (StringUtils.isNotBlank((CharSequence)ditem.getPrestring()) || StringUtils.isNotBlank((CharSequence)ditem.getPoststring()))) {
            map.put("display", "flex");
            map.put("align-items", "center");
        }
        return map;
    }

    private Map<String, String> getStyleMapFromContent(String content) {
        int ptr;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)content)) {
            return map;
        }
        boolean isStyle = false;
        content = this.removeContentSpace(content);
        String key = null;
        StringBuilder buf = new StringBuilder();
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch == '=' && key == null) {
                key = buf.toString();
                buf = new StringBuilder();
                isStyle = false;
                continue;
            }
            if (!isStyle && ch == ' ') {
                String value = buf.toString();
                if (value.length() == 0) continue;
                if (value.charAt(0) == '\"') {
                    value = value.substring(1);
                }
                if (value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(0, value.length() - 1);
                }
                if ("style".equals(key)) {
                    int ptr2 = value.indexOf(":");
                    if (ptr2 > 0) {
                        key = value.substring(0, ptr2).trim();
                        value = value.substring(ptr2 + 1).trim();
                    }
                    isStyle = true;
                }
                if (value.endsWith(";")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ("width".equals(key) && map.containsKey(key)) {
                    if (StringUtils.isNotBlank((CharSequence)value) && value.length() > 0 && value.charAt(0) == '[') {
                        value = value.substring(1, value.length() - 1);
                        map.put(key, value);
                    }
                } else if (map.containsKey(key)) {
                    Object o_value = (String)map.get(key);
                    if (o_value == null) {
                        o_value = "";
                    }
                    if (o_value != null && !((String)o_value).equals(value)) {
                        if (!((String)o_value).endsWith(";")) {
                            o_value = (String)o_value + ";";
                        }
                        map.put(key, (String)o_value + value);
                    }
                } else {
                    map.put(key, value);
                }
                key = null;
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        String value = buf.toString();
        if (key == null && (ptr = value.indexOf(":")) > 0) {
            key = value.substring(0, ptr).trim();
            value = value.substring(ptr + 1).trim();
        }
        if (key != null && value.length() > 0) {
            if (value.charAt(0) == '\"') {
                value = value.substring(1);
            }
            if (value.charAt(value.length() - 1) == '\"') {
                value = value.substring(0, value.length() - 1);
            }
            if ("style".equals(key) && (ptr = value.indexOf(":")) > 0) {
                key = value.substring(0, ptr).trim();
                value = value.substring(ptr + 1).trim();
            }
            if (value.endsWith(";")) {
                value = value.substring(0, value.length() - 1);
            }
            if ("width".equals(key) && map.containsKey(key)) {
                if (StringUtils.isNotBlank((CharSequence)value) && value.length() > 0 && value.charAt(0) == '[') {
                    value = value.substring(1, value.length() - 1);
                    map.put(key, value);
                }
            } else if (map.containsKey(key)) {
                Object o_value = (String)map.get(key);
                if (o_value == null) {
                    o_value = "";
                }
                if (o_value != null && !((String)o_value).equals(value)) {
                    if (!((String)o_value).endsWith(";")) {
                        o_value = (String)o_value + ";";
                    }
                    map.put(key, (String)o_value + value);
                }
            } else {
                map.put(key, value);
            }
        }
        return map;
    }

    private String removeContentSpace(String content) {
        int length = content.length();
        boolean quote = false;
        boolean remove = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch == '\"') {
                if (!quote) {
                    quote = true;
                    remove = true;
                    continue;
                }
                quote = false;
                remove = false;
                continue;
            }
            if (remove && (ch == ' ' || ch == '\u3000')) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public String process0() {
        StringBuilder isb = new StringBuilder();
        for (String string : this.itemMap.keySet()) {
            Map<String, String> map = this.itemMap.get(string);
            String content = this.addContainer(string, map);
            String findkey = "." + string;
            int ptr = this.csscontent.indexOf(findkey);
            if (ptr > 0) {
                this.csscontent.insert(ptr, content);
                continue;
            }
            isb.append(content);
        }
        this.csscontent.insert(0, isb.toString());
        this.csscontent.insert(0, "@charset \"UTF-8\";" + CR);
        StringBuilder gsb = new StringBuilder();
        for (String string : this.groupMap.keySet()) {
            gsb.append(".").append(string);
            Map<String, String> map = this.groupMap.get(string);
            if (map != null) {
                String content = this.addContainer(map);
                gsb.append(" ").append(content);
                continue;
            }
            gsb.append(" {").append(CR);
            gsb.append("}").append(CR);
        }
        this.csscontent.append(gsb.toString());
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : this.horizontalMap.keySet()) {
            stringBuilder.append(".").append(key);
            Map<String, String> map = this.horizontalMap.get(key);
            if (map != null) {
                String content = this.addContainer(map);
                stringBuilder.append(" ").append(content);
                continue;
            }
            stringBuilder.append(" {").append(CR);
            stringBuilder.append("}").append(CR);
        }
        this.csscontent.append(stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String key : this.fieldIdMap.keySet()) {
            stringBuilder2.append(".").append(key);
            Map<String, String> map = this.fieldIdMap.get(key);
            if (map != null) {
                String content = this.addContainer(map);
                stringBuilder2.append(" ").append(content);
                continue;
            }
            stringBuilder2.append(" {").append(CR);
            stringBuilder2.append("}").append(CR);
        }
        this.csscontent.append(stringBuilder2.toString());
        return this.csscontent.toString();
    }

    public static boolean isStyleWithCondition(String content) {
        return Optional.ofNullable(StringUtils.split((String)content, (String)";")).map(Arrays::stream).orElse(Stream.empty()).map(s -> s.trim()).anyMatch(s -> StringUtils.startsWith((CharSequence)s, (CharSequence)"${") || StringUtils.contains((CharSequence)s, (CharSequence)"=") || StringUtils.contains((CharSequence)s, (CharSequence)")") || StringUtils.contains((CharSequence)s, (CharSequence)"("));
    }
}

