/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBeanByName;
import jp.jasminesoft.jfc.gen.CalendarFacadeGenerator;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CalendarFacadeCoreGenerator
extends JavaSourceGenerator
implements IGeneratorFactory {
    public static final String SUB_PACKAGE_NAME = "app";
    protected static Logger logger = LogManager.getLogger((String)CalendarFacadeCoreGenerator.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected CalendarFacadeGenerator cfg;

    public CalendarFacadeCoreGenerator(CalendarFacadeGenerator cfg, Project project) {
        super(project);
        this.cfg = cfg;
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, null);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, null);
    }

    @Override
    public String[] getDefaultImport() {
        Action action;
        int i;
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("java.util.*");
        importList.add("jp.jasminesoft.jfc.JFCErrorManager");
        importList.add("jp.jasminesoft.jfc.JFCUtils");
        importList.add("jp.jasminesoft.jfc.ActionParameter");
        importList.add("jp.jasminesoft.jfc.ActionParameter");
        importList.add("jp.jasminesoft.util.*");
        Action[] actions = this.cfg.getAction();
        for (i = 0; i < actions.length; ++i) {
            action = actions[i];
            Model model = AppSchemaUtil.getModel(this.project, action.getIdref());
            if (model != null) {
                this.setImportStatement_model(model, importList);
            }
            this.setImportStatement_condition(action, importList);
        }
        for (i = 0; i < actions.length; ++i) {
            action = actions[i];
            Model smodel = AppSchemaUtil.getModel(this.project, action.getIdref());
            String serviceClass = CalendarFacadeCoreGenerator.getServiceClassName(action);
            String subpackagename = SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, smodel);
            importList.add(this.project.getPackage() + "." + subpackagename + "." + serviceClass);
        }
        return importList.toArray(new String[0]);
    }

    public abstract String gClassDeclaration();

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gVariable());
        sb.append(this.gContent());
        sb.append(this.gEnd());
        return sb.toString();
    }

    protected String gHeader() {
        int i;
        String _package;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((_package = this.getPackage()) != null) {
            sb.append("package ");
            sb.append(_package);
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        ArrayList<String> importList = new ArrayList<String>();
        String[] ary = this.getDefaultImport();
        if (ary != null) {
            for (i = 0; i < ary.length; ++i) {
                if (importList.contains(ary[i])) continue;
                importList.add(ary[i]);
            }
        }
        for (i = 0; i < importList.size(); ++i) {
            String stmt = (String)importList.get(i);
            sb.append("import ");
            sb.append(stmt);
            sb.append(";");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i2 = 0; i2 < comment_str.length; ++i2) {
                sb.append(" * ");
                sb.append(comment_str[i2]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return this.getClassname();
    }

    @Override
    public String getClassname() {
        return "CalendarFacadeImpl";
    }

    public String getInterfacename() {
        return "CalendarFacade";
    }

    protected abstract String gVariable();

    protected String gContent() {
        Action[] actions = this.cfg.getAction();
        if (actions == null || actions.length == 0) {
            return "";
        }
        String serviceName = "calendarFacade";
        ApplicationContextBeanByName _bean = new ApplicationContextBeanByName(serviceName, this.project.getPackage() + ".app." + this.getClassname() + "Impl", null, true);
        StringBuilder sb = new StringBuilder();
        sb.append(this.gMethod_setJFCErrorManager());
        sb.append(CR);
        sb.append(this.gMethod_getJFCErrorManager());
        sb.append(CR);
        for (int i = 0; i < actions.length; ++i) {
            Action action = actions[i];
            sb.append(this.gMethod_setService(action));
            sb.append(CR);
            sb.append(this.gMethod_getService(action));
            sb.append(CR);
            String serviceObject = CalendarFacadeCoreGenerator.getServiceObjectName(action);
            String serviceClass = CalendarFacadeCoreGenerator.getServiceClassName(action);
            _bean.addLookupMethod("get" + serviceClass, serviceObject);
        }
        sb.append(this.gMethod_findAll());
        sb.append(CR);
        sb.append(this.gMethod_createDateMap());
        sb.append(CR);
        sb.append(this.gMethod_setJcalendarItem());
        sb.append(this.gMethod_setIcalendarItem());
        if (!SpringApplicationContextContainer.isExistApplicationContextBean(_bean) && _bean.sizeLookupMethod() > 0) {
            SpringApplicationContextContainer.addApplicationContextBean(_bean);
        }
        return sb.toString();
    }

    protected abstract String gMethod_setJFCErrorManager();

    protected abstract String gMethod_getJFCErrorManager();

    protected abstract String gMethod_findAll();

    protected abstract String gMethod_setJcalendarItem();

    protected abstract String gMethod_setIcalendarItem();

    protected abstract String gMethod_createDateMap();

    protected abstract String gMethod_setService(Action var1);

    protected abstract String gMethod_getService(Action var1);

    protected String gMethod_setJFCErrorManager_declare() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void setJFCErrorManager(JFCErrorManager errorManager)");
        return sb.toString();
    }

    protected String gMethod_getJFCErrorManager_declare() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public JFCErrorManager getJFCErrorManager()");
        return sb.toString();
    }

    protected String gMethod_findAll_declare() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public Object[] findAll(");
        sb.append("String[] types, ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_setJcalendarItem_declare() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void ");
        sb.append("setJcalendarItem(");
        sb.append(CR);
        sb.append("        ");
        sb.append("int month,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int day,");
        sb.append(CR);
        sb.append("        ");
        sb.append("Object[] data,");
        sb.append(CR);
        sb.append("        ");
        sb.append("List list,");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_setIcalendarItem_declare() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void ");
        sb.append("setIcalendarItem(");
        sb.append(CR);
        sb.append("        ");
        sb.append("int year,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int month,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int day,");
        sb.append(CR);
        sb.append("        ");
        sb.append("Object[] data,");
        sb.append(CR);
        sb.append("        ");
        sb.append("List list,");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p)");
        return sb.toString();
    }

    protected String gMethod_createDateMap_declare() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void createDateMap(Object[] data, Map map)");
        return sb.toString();
    }

    protected String gMethod_setService_declare(Action action) {
        String serviceClass = CalendarFacadeCoreGenerator.getServiceClassName(action);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void set");
        sb.append(serviceClass);
        sb.append("(");
        sb.append(serviceClass);
        sb.append(" service)");
        return sb.toString();
    }

    protected String gMethod_getService_declare(Action action) {
        String serviceClass = CalendarFacadeCoreGenerator.getServiceClassName(action);
        String getterServiceClass = CalendarFacadeCoreGenerator.getGetterServiceClassName(action);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public ");
        sb.append(serviceClass);
        sb.append(" ");
        sb.append(getterServiceClass);
        return sb.toString();
    }
}

