/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.CryptoUtil;
import jp.jasminesoft.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CatalinaPropertiesGenerator
extends SourceGenerator {
    public static final String ENCODE = "UTF8";
    private static final boolean USE_ENVIRONMENT_VARIABLE_CONFIGURE = true;
    private byte[] secretkey;
    private static final long DEFAULT_TOMCAT_CACHE_MAX_SIZE = 10240L;
    private static final long DEFAULT_TOMCAT_CACHE_TTL = 5000L;
    private static final String[][] PROPS = new String[][]{{"mail.mime.charset", "utf-8"}};

    public CatalinaPropertiesGenerator(Project project, byte[] secretkey) {
        super(project);
        this.secretkey = secretkey;
    }

    @Override
    public String getEncoding() {
        return ENCODE;
    }

    @Override
    public String getFileSuffix() {
        return ".properties";
    }

    public String getFilename() {
        return "catalina-wagby";
    }

    public String getSubpackageName() {
        return "conf";
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public String process0() {
        String string;
        Properties prop = this.createProperties();
        StringWriter writer = new StringWriter();
        try {
            prop.store((Writer)writer, null);
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.logger.error("io error", (Throwable)e);
                throw new IllegalStateException();
            }
        }
        ((Writer)writer).close();
        return string;
    }

    public Properties createProperties() {
        int i;
        Environment env = this.project.getEnvironment();
        Database db = AppSchemaUtil.getDatabase(env);
        String password = db.getPassword();
        Database[] subdb = AppSchemaUtil.getSubdatabases(env);
        String[] subdbpassword = new String[subdb.length];
        for (int i2 = 0; i2 < subdb.length; ++i2) {
            subdbpassword[i2] = subdb[i2].getPassword();
        }
        ArrayList<String> propertySource = new ArrayList<String>();
        if (this.secretkey != null) {
            try {
                CryptoUtil util = new CryptoUtil();
                password = util.encrypto(this.secretkey, password);
                for (i = 0; i < subdb.length; ++i) {
                    subdbpassword[i] = util.encrypto(this.secretkey, subdbpassword[i]);
                }
                propertySource.add("jp.jasminesoft.jfc.app.MyTomcatPropertySource");
            }
            catch (GeneralSecurityException e) {
                this.logger.error("failed encrypt database password", (Throwable)e);
            }
        }
        propertySource.add("org.apache.tomcat.util.digester.EnvironmentPropertySource");
        Properties prop = new Properties();
        prop.setProperty("org.apache.tomcat.util.digester.PROPERTY_SOURCE", String.join((CharSequence)",", propertySource));
        this.addDatabaseSetting("WAGBY_DATASOURCE_", db, password, prop);
        for (i = 0; i < subdb.length; ++i) {
            String header = "WAGBY_DATASOURCE_SUBDATABASE" + (i + 1) + "_";
            this.addDatabaseSetting(header, subdb[i], subdbpassword[i], prop);
        }
        String tomcatCacheMaxSize = env.getTomcatCacheMaxSize();
        if (!StringUtils.isNumeric((CharSequence)tomcatCacheMaxSize)) {
            tomcatCacheMaxSize = String.valueOf(10240L);
        }
        prop.setProperty("WAGBY_TOMCAT_CACHE_MAX_SIZE", tomcatCacheMaxSize);
        String tomcatCacheTtl = env.getTomcatCacheTtl();
        if (!StringUtils.isNumeric((CharSequence)tomcatCacheTtl)) {
            tomcatCacheMaxSize = String.valueOf(5000L);
        }
        prop.setProperty("WAGBY_TOMCAT_CACHE_TTL", tomcatCacheTtl);
        for (String[] p : PROPS) {
            prop.setProperty(p[0], p[1]);
        }
        return prop;
    }

    private void addDatabaseSetting(String header, Database db, String password, Properties prop) {
        prop.setProperty(header + "DRIVERCLASSNAME", db.getDriver());
        prop.setProperty(header + "URL", db.getUrl());
        prop.setProperty(header + "USERNAME", db.getUser());
        prop.setProperty(header + "PASSWORD", password);
        prop.setProperty(header + "MAXTOTAL", db.getMaxActiveAsString());
        prop.setProperty(header + "MAXIDLE", db.getMaxIdleAsString());
        prop.setProperty(header + "MAXWAITMILLIS", db.getMaxWaitAsString());
    }
}

