/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.ControllerGeneratorBase;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.TargetitemGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Forward;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Mapping;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ControllerGenerator
extends ControllerGeneratorBase {
    protected static Logger logger = LogManager.getLogger((String)ControllerGenerator.class.getName());
    protected Action action;
    protected ControllerGenerator2 cgen2;

    public ControllerGenerator(Project project, Action action) {
        super(project);
        this.action = action;
    }

    protected void setControllerGenerator2(ControllerGenerator2 cgen2) {
        this.cgen2 = cgen2;
    }

    @Override
    public Map<String, Object> createParameterMap() {
        Map<String, Object> map = super.createParameterMap();
        map.put("url", this.action.getId());
        map.put("forwardHeader", this.action.getId());
        map.put("action", this.action);
        map.put("isSubmenu", AppSchemaUtil.getSubmenu(this.action) != null);
        map.put("usejasperreports", this.getUseJasperreports());
        map.put("wizardpagenum", this.getWizardPagenum());
        map.put("isThymeleaf", this.isUseThymeleaf(this.project, this.action));
        this.putForwardNameMap(map);
        this.putForwardUrlMap(map);
        String code = null;
        if (this.cgen2 != null) {
            code = this.cgen2.gCommand();
        }
        if (code != null && code.length() > 0) {
            map.put("codeGetCommand", code);
        }
        return map;
    }

    private boolean isUseThymeleaf(Project project, Action action) {
        if (!AppSchemaUtil.isCSSLayout(project, action)) {
            return false;
        }
        return "show".equals(action.getType()) || "showList".equals(action.getType()) || "insert".equals(action.getType()) || "update".equals(action.getType()) || "copy".equals(action.getType()) || "download".equals(action.getType()) || "uploadUpdate".equals(action.getType());
    }

    private TreeSet<Integer> getWizardPagenum() {
        TreeSet<Integer> wizardpagenum = new TreeSet<Integer>();
        Forward forward = AppSchemaUtil.getForward(this.action);
        if (forward == null || forward.getMapping() == null) {
            return wizardpagenum;
        }
        for (Mapping mapping : forward.getMapping()) {
            if (!"wizard".equals(mapping.getType())) continue;
            wizardpagenum.add(mapping.getPagenum());
        }
        return wizardpagenum;
    }

    private boolean getUseJasperreports() {
        Print[] prints;
        boolean usejasperreports = false;
        for (Print print : prints = AppSchemaUtil.getPrint(this.action)) {
            String uselibrary;
            IRNode node = print.getIdrefAsIRNode();
            if (!(node instanceof Printlayout) || !"jasperreports".equals(uselibrary = ((Printlayout)node).getUselibrary())) continue;
            usejasperreports = true;
            break;
        }
        if (!usejasperreports) {
            ArrayList<String> dummyImportList = new ArrayList<String>();
            this.setImportStatement_jasperreports(this.action, dummyImportList);
            for (String s : dummyImportList) {
                if (!s.startsWith("net.sf.jasperreports")) continue;
                usejasperreports = true;
                break;
            }
        }
        return usejasperreports;
    }

    @Override
    public String getClassname() {
        return ControllerGenerator.getClassname(this.action);
    }

    public static final String getClassname(Action action) {
        StringBuilder sb = new StringBuilder();
        sb.append(ControllerGenerator.capFirst(action.getId()));
        sb.append("Controller");
        return sb.toString();
    }

    @Override
    protected Model getStoreModel() {
        return this.getStoreModel(this.action);
    }

    protected Model getStoreModel(Action action) {
        Model model = null;
        if (action != null) {
            IRNode node = action.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                model = (Model)node;
            } else if (action.getIdref() != null) {
                Object[] o = new Object[]{action.getId(), action.getIdref()};
                logger.error(rman.getValue("value.null.model", o));
            }
        }
        return model;
    }

    protected void putCodePresentationModelClassName(Map<String, Object> map) {
        Model[] rmodels = AppSchemaUtil.getDataitemAsModel(this.action, "presentation");
        this.putCodeModelClassName(map, rmodels[0], "p");
    }

    protected void putCodeModelClassName(Map<String, Object> map, Model model, String header) {
        if (model == null) {
            logger.error(rman.getValue("value.null.rmodels", this.action.getId()));
        } else {
            map.put(header + "model", model);
            map.put(header + "PackageName", AppSchemaUtil.getPackagename(model, this.project));
            map.put(header + "ClassName", AppSchemaUtil.getClassname(model));
        }
    }

    protected void putCodeListModelClassName(Map<String, Object> map) {
        Model lpmodel = this.getListPModel();
        this.putCodeListModelClassName(map, lpmodel, "l");
    }

    protected void putCodeListModelClassName(Map<String, Object> map, Model lpmodel, String header) {
        this.putCodeModelClassName(map, lpmodel, header + "p");
        Model lmodel = null;
        if (lpmodel != null) {
            lmodel = (Model)lpmodel.getIdrefAsIRNode();
            this.putCodeModelClassName(map, lmodel, header);
        }
    }

    protected Model getListPModel() {
        return this.getListPModel("list");
    }

    protected Model getListPModel(String dataitemtype) {
        Model lpmodel = null;
        Dataitem[] dataitems = AppSchemaUtil.getDataitems(this.action);
        if (dataitems != null) {
            for (Dataitem dataitem : dataitems) {
                if (!dataitemtype.equals(dataitem.getType())) continue;
                lpmodel = (Model)dataitem.getIdrefAsIRNode();
                break;
            }
        }
        return lpmodel;
    }

    protected void putCodeConditionModelClassName(Map<String, Object> map) {
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, this.action);
        if (cmodel == null) {
            logger.error(rman.getValue("value.null.rmodels", this.action.getId()));
        } else {
            map.put("cPackageName", AppSchemaUtil.getPackagename(cmodel, this.project));
            map.put("cClassName", AppSchemaUtil.getClassname(cmodel));
        }
        Model cpmodel = AppSchemaUtil.getConditionPModel(this.project, this.action, true);
        if (cpmodel == null) {
            logger.error(rman.getValue("value.null.rmodels", this.action.getId()));
        } else {
            map.put("cpPackageName", AppSchemaUtil.getPackagename(cpmodel, this.project));
            map.put("cpClassName", AppSchemaUtil.getClassname(cpmodel));
        }
    }

    protected String generateCodeTARGETITEMS() {
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, this.action);
        if (presentations == null) {
            return "";
        }
        return this.generateCodeTARGETITEMS(presentations[0]);
    }

    protected String generateCodeTARGETITEMS(Presentation presentation) {
        TargetitemGenerator tgen = new TargetitemGenerator();
        tgen.setAction(this.action);
        String[] sa = tgen.createTargetitems(presentation);
        return ControllerGenerator.outputStringArrayCode(sa);
    }

    protected void putWizardTargetitems(Map<String, Object> map) {
        map.put("wizardTargetitems", this.createWizardTargetitems());
    }

    protected Map<Integer, List<String>> createWizardTargetitems() {
        if (!this.action.getWizard()) {
            return null;
        }
        HashMap<Integer, List<String>> targetitemsMap = new HashMap<Integer, List<String>>();
        Presentation[] presentation = this.getPresentation4Wizard();
        if (presentation != null && presentation.length >= 0) {
            if (presentation.length == 0) {
                return null;
            }
            for (int i = 0; i < presentation.length; ++i) {
                int suffix = i + 1;
                String[] targetitems = this.createTargetitems(presentation[i]);
                ArrayList<String> list = new ArrayList<String>();
                if (targetitems != null && targetitems.length > 0) {
                    for (int j = 0; j < targetitems.length; ++j) {
                        list.add(StringUtil.convertJavaString((String)targetitems[j]));
                    }
                }
                targetitemsMap.put(suffix, list);
            }
        } else {
            Object[] o = new Object[]{this.action.getIdref(), this.action.getDescription()};
            logger.error(rman.getValue("struts.invalid.wizard.nopresentation", o));
            return null;
        }
        return targetitemsMap;
    }

    protected void putTargetitems(Map<String, Object> map) {
        map.put("targetitems", this.createTargetitems());
    }

    protected List<String> createTargetitems() {
        if (this.action.getWizard()) {
            return null;
        }
        Presentation[] presentations = this.getPresentation4Wizard();
        if (presentations == null || presentations.length == 0) {
            return null;
        }
        Presentation presentation = presentations[0];
        String[] targetitems = this.createTargetitems(presentation);
        if (targetitems != null && targetitems.length > 0) {
            String _idref = presentation.getIdref();
            String _filename = presentation.getFilename();
            if (_idref != null && (_filename == null || _filename != null && _idref.equals(_filename)) && targetitems != null && targetitems.length > 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int j = 0; j < targetitems.length; ++j) {
                    list.add(StringUtil.convertJavaString((String)targetitems[j]));
                }
                return list;
            }
        }
        return null;
    }

    private Presentation[] getPresentation4Wizard() {
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, this.action);
        if (presentations == null) {
            return null;
        }
        ArrayList<Presentation> ret = new ArrayList<Presentation>();
        for (Presentation presentation : presentations) {
            String filename = presentation.getFilename();
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                if (filename.startsWith("confirmInsert") || filename.startsWith("confirmUpdate")) continue;
                ret.add(presentation);
                continue;
            }
            ret.add(presentation);
        }
        return ret.toArray(new Presentation[0]);
    }

    protected String[] createTargetitems(Presentation presentation) {
        TargetitemGenerator tgen = new TargetitemGenerator(){

            @Override
            protected boolean isIncludeTargetItemSet(Displayitem ditem) {
                return ControllerGenerator.this.isIncludeTargetItemSet(ditem);
            }
        };
        tgen.setAction(this.action);
        return tgen.createTargetitems(presentation);
    }

    protected boolean isIncludeTargetItemSet(Displayitem ditem) {
        return true;
    }

    protected void putForwardNameMap(Map<String, Object> map) {
        map.put("FORWARDNAME", this.createForwardNameMap());
    }

    protected Map<String, String> createForwardNameMap() {
        LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
        Forward forward = AppSchemaUtil.getForward(this.action);
        if (forward == null) {
            return null;
        }
        Mapping[] mappings = forward.getMapping();
        for (int i = 0; i < mappings.length; ++i) {
            Object type;
            Mapping mapping = mappings[i];
            String _type = mapping.getType();
            if ("cmd".equals(_type)) continue;
            Object name = mapping.getName();
            if (name == null || ((String)name).length() == 0) {
                name = mapping.getContent();
            }
            if (StringUtils.isBlank((CharSequence)(type = mapping.getType()))) continue;
            if ("wizard".equals(type)) {
                type = (String)type + mapping.getPagenum();
                name = (String)name + mapping.getPagenum();
            }
            if (((String)name).endsWith(".page")) {
                name = ((String)name).substring(0, ((String)name).length() - ".page".length());
            }
            nameMap.put((String)type, (String)name);
        }
        if (nameMap.size() == 0) {
            return null;
        }
        return nameMap;
    }

    protected void putForwardUrlMap(Map<String, Object> map) {
        map.put("FORWARDURL", this.createForwardUrlMap());
    }

    protected Map<String, String> createForwardUrlMap() {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        Forward forward = AppSchemaUtil.getForward(this.action);
        if (forward == null) {
            return null;
        }
        Mapping[] mappings = forward.getMapping();
        for (int i = 0; i < mappings.length; ++i) {
            Action _target;
            Mapping mapping = mappings[i];
            String _type = mapping.getType();
            if (!"cmd".equals(_type)) continue;
            Object name = mapping.getName();
            if (name == null || ((String)name).length() == 0) {
                name = mapping.getContent();
            }
            String pattern = mapping.getPattern();
            String actionType = null;
            if (pattern.startsWith("Copy")) {
                actionType = "copy";
            } else if (pattern.startsWith("Update")) {
                actionType = "update";
            } else if (pattern.startsWith("Show")) {
                actionType = "show";
            }
            if (actionType != null && (_target = AppSchemaUtil.getActionByModelIdAndType(this.project, this.action.getIdref(), actionType)) != null) {
                name = _target.getId();
                if (_target.getWizard()) {
                    name = (String)name + "1";
                }
            }
            urlMap.put(pattern, (String)name);
        }
        if (urlMap.size() == 0) {
            return null;
        }
        return urlMap;
    }

    protected ActionNode createActionNode() {
        Model smodel = this.getStoreModel();
        ActionNode node = new ActionNode();
        node.setBeanid(this.action.getId() + "Controller");
        node.setBeanclass(this.getBeanClassname());
        node.addPropertyrefMap("entityService", AppSchemaUtil.getHelperClassname(smodel, "EntityService"));
        return node;
    }

    public String getBeanClassname() {
        return ControllerGenerator.getBeanClassname(this.action, this.getPackage(), this.getClassname());
    }

    public static String getBeanClassname(Action action, String packagenm, String classnm) {
        Object beanclassname;
        if (action.getStrutsclasstype() != null) {
            Object classname = action.getStrutsclasstype();
            if (((String)classname).endsWith("Action")) {
                classname = ((String)classname).substring(0, ((String)classname).length() - "Action".length()) + "Controller";
            }
            beanclassname = classname;
        } else {
            beanclassname = classnm;
        }
        beanclassname = packagenm + "." + (String)beanclassname;
        if (!ControllerGenerator.isCustomize((String)beanclassname)) {
            return beanclassname;
        }
        return ControllerGenerator.getCustomizeClassname((String)beanclassname, ".");
    }

    protected static class ActionNode {
        private String beanid;
        private String beanclass;
        private TreeMap<String, String> propertyrefMap = new TreeMap();
        private TreeMap<String, String> lookupmethodMap = new TreeMap();
        private String otherproperty;

        protected ActionNode() {
        }

        public String getBeanid() {
            return this.beanid;
        }

        public void setBeanid(String beanid) {
            this.beanid = beanid;
        }

        public String getBeanclass() {
            return this.beanclass;
        }

        public void setBeanclass(String beanclass) {
            this.beanclass = beanclass;
        }

        public SortedMap<String, String> getPropertyrefMap() {
            return Collections.unmodifiableSortedMap(this.propertyrefMap);
        }

        public void addPropertyrefMap(String name, String ref) {
            this.propertyrefMap.put(name, ref);
        }

        public void removePropertyrefMap(String name) {
            this.propertyrefMap.remove(name);
        }

        public SortedMap<String, String> getLoolupmethodMap() {
            return Collections.unmodifiableSortedMap(this.lookupmethodMap);
        }

        public void addLookupmethodMap(String name, String bean) {
            this.lookupmethodMap.put(name, bean);
        }

        public String getOtherproperty() {
            return this.otherproperty;
        }

        public void setOtherproperty(String otherproperty) {
            this.otherproperty = otherproperty;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String tab) {
            StringBuilder sb = new StringBuilder();
            sb.append(tab);
            sb.append("<bean id=\"" + this.beanid + "\"");
            sb.append(ISourceVariable.CR);
            sb.append(tab + "    ");
            sb.append("class=\"" + this.beanclass + "\">");
            sb.append(ISourceVariable.CR);
            for (Map.Entry<String, String> e : this.propertyrefMap.entrySet()) {
                sb.append(tab + "    ");
                sb.append("<property name=\"" + e.getKey() + "\" ref=\"" + e.getValue() + "\" />");
                sb.append(ISourceVariable.CR);
            }
            for (Map.Entry<String, String> e : this.lookupmethodMap.entrySet()) {
                sb.append(tab + "    ");
                sb.append("<lookup-method name=\"" + e.getKey() + "\" bean=\"" + e.getValue() + "\"/>");
                sb.append(ISourceVariable.CR);
            }
            if (this.otherproperty != null) {
                sb.append(this.otherproperty);
            }
            sb.append(tab);
            sb.append("</bean>");
            sb.append(ISourceVariable.CR);
            return sb.toString();
        }
    }
}

