/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_empty;
import jp.jasminesoft.jfc.gen.ControllerGenerator_myclass;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Command;
import jp.jasminesoft.jfc.gen.appschema.Extension;
import jp.jasminesoft.jfc.gen.appschema.Op;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Usermethod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerGenerator2_myclass
extends ControllerGenerator2_empty {
    protected Logger logger = LogManager.getLogger((String)ControllerGenerator2_myclass.class.getName());

    @Override
    protected String getTemplateFile() {
        return "MyClassController2.vm";
    }

    public ControllerGenerator2_myclass(Project project, Action action) {
        super(project, action);
    }

    @Override
    public String getClassname() {
        return this.getControllerGenerator().getClassname();
    }

    @Override
    public String getClassExplanation() {
        return rman.getValue("struts.comment.4customize");
    }

    @Override
    public String getClassDeclarationSuffix() {
        return " extends " + super.getClassname();
    }

    @Override
    public String getSuperClassname() {
        if (this.getControllerGenerator() instanceof ControllerGenerator_myclass) {
            ControllerGenerator_myclass congen = (ControllerGenerator_myclass)this.getControllerGenerator();
            return congen.getSuperClassname();
        }
        return super.getClassname();
    }

    @Override
    protected String gDefinedMethod() {
        Command command = AppSchemaUtil.getCommand(this.action);
        if (command == null) {
            return "";
        }
        ArrayList<Op> list = null;
        for (Op op : command.getOp()) {
            if (!"CommandType.UserDefined".equals(op.getContent())) continue;
            if (list == null) {
                list = new ArrayList<Op>();
            }
            list.add(op);
        }
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.gDoOriginal(sb, list);
        this.gIsUpdateMethodUserDefinedAction(sb, (List<Op>)list);
        return sb.toString();
    }

    protected void gDoOriginal(StringBuilder sb, List<Op> list) {
        String dbActionParameterClassname = "ActionParameter";
        sb.append("    ");
        sb.append("@Override");
        sb.append(CR);
        sb.append("    ");
        sb.append("public String do_original(").append("ActionParameter").append(" p)");
        sb.append(CR);
        sb.append("        ");
        sb.append("throws IOException, ServletException, SecurityException");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append(this.gHook("do_original", "first", "        ", this.hsb));
        Extension extension = AppSchemaUtil.getExtension(this.action);
        Usermethod[] usermethods = extension != null ? extension.getUsermethod() : null;
        this.gDoOriginalByUsermethod(usermethods, "        ", sb, false);
        sb.append("        ");
        if ("show".equals(this.action.getType())) {
            sb.append("// you can access 'p.o' object as primary key.");
            sb.append(CR);
            sb.append("        ");
            sb.append("return do_show(p);");
        } else if ("insert".equals(this.action.getType()) || "update".equals(this.action.getType()) || "copy".equals(this.action.getType())) {
            sb.append("// you can access 'p.o' object as presentation model.");
            sb.append(CR);
            if (list.size() == 1) {
                Op op = list.get(0);
                if ("TemplateSave".equals(op.getAction()) && this.action.getConfirm()) {
                    sb.append("        ").append("p.cmd = CommandType.Confirm;").append(CR);
                }
                String method = op.getMethod();
                sb.append("        ");
                sb.append("return ");
                if ("insert".equals(method) || "copy".equals(method)) {
                    sb.append("do_insert(p);");
                } else if ("update".equals(method)) {
                    sb.append("do_update(p);");
                } else {
                    sb.append("do_default(p);");
                }
            } else {
                for (Op op : list) {
                    String method = op.getMethod();
                    sb.append("        ").append("if (\"").append(op.getAction()).append("\".equals(p.action)) {").append(CR);
                    if ("TemplateSave".equals(op.getAction()) && this.action.getConfirm()) {
                        sb.append("            ").append("p.cmd = CommandType.Confirm;").append(CR);
                    }
                    sb.append("            ").append("return ");
                    if ("insert".equals(method) || "copy".equals(method)) {
                        sb.append("do_insert(p);");
                    } else if ("update".equals(method)) {
                        sb.append("do_update(p);");
                    } else {
                        sb.append("do_default(p);");
                    }
                    sb.append(CR);
                    sb.append("        ").append("}").append(CR);
                }
                sb.append("        ").append("return do_default(p);").append(CR);
            }
        } else if ("showList".equals(this.action.getType())) {
            sb.append("do_default(p);");
            sb.append(CR);
            sb.append("        ");
            sb.append("return null;");
        } else if ("delete".equals(this.action.getType())) {
            if (list.size() == 1) {
                Op op = list.get(0);
                String method = op.getMethod();
                if ("delete".equals(method)) {
                    sb.append("do_delete(p);");
                } else {
                    sb.append("return null;");
                }
            } else {
                for (Op op : list) {
                    String method = op.getMethod();
                    sb.append("        ").append("if (\"").append(op.getAction()).append("\".equals(p.action)) {").append(CR);
                    sb.append("            ").append("return ");
                    if ("delete".equals(method)) {
                        sb.append("do_delete(p);");
                    } else {
                        sb.append("return null;");
                    }
                    sb.append(CR);
                    sb.append("        ").append("}").append(CR);
                }
                sb.append("        ").append("return null;").append(CR);
            }
        } else {
            sb.append("return null;");
        }
        sb.append(CR);
        sb.append(this.gHook("do_original", "finish", "        ", this.hsb));
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    protected void gIsUpdateMethodUserDefinedAction(StringBuilder sb, List<Op> list) {
        if (!"update".equals(this.action.getType())) {
            return;
        }
        ArrayList<String> actions = new ArrayList<String>();
        for (Op op : list) {
            String method = op.getMethod();
            if (!"update".equals(method)) continue;
            actions.add(op.getAction());
        }
        if (actions.size() == 0) {
            return;
        }
        sb.append("    ");
        sb.append("@Override");
        sb.append(CR);
        sb.append("    ");
        sb.append("protected boolean isUpdateMethodUserDefinedAction(ActionParameter p) {");
        sb.append(CR);
        sb.append(this.gHook("isUpdateMethodUserDefinedAction", "first", "        ", this.hsb));
        ArrayList<String> codes = new ArrayList<String>();
        for (String action : actions) {
            codes.addAll(Arrays.asList("if (\"" + action + "\".equals(p.action)) {", "    return true;", "}"));
        }
        codes.add("return super.isUpdateMethodUserDefinedAction(p);");
        for (String code : codes) {
            sb.append("        ").append(code).append(CR);
        }
        sb.append(this.gHook("isUpdateMethodUserDefinedAction", "finish", "        ", this.hsb));
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
    }

    @Override
    protected boolean canOutputMethod(String methodname) {
        return false;
    }
}

