/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.appgen.component.ShowlistAction;
import jp.jasminesoft.jfc.appgen.component.ShowlistActionType;
import jp.jasminesoft.jfc.appgen.component.appschema.ActionUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ControllerGenerator;
import jp.jasminesoft.jfc.gen.TargetitemGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Page;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang3.StringUtils;

public class ControllerGenerator_showList
extends ControllerGenerator {
    public ControllerGenerator_showList(Project project, Action action) {
        super(project, action);
    }

    @Override
    protected String getTemplateFile() {
        return "ShowListController.vm";
    }

    @Override
    public Map<String, Object> createParameterMap() {
        boolean hasScheduleView;
        Map<String, Object> map = super.createParameterMap();
        this.putCodeConditionModelClassName(map);
        this.putCodeListModelClassName(map);
        map.put("codeTARGETITEMS", this.generateCodeTARGETITEMS());
        map.put("codeLIST_TARGETITEMS", this.generateCodeLIST_TARGETITEMS());
        map.put("codePANKUZU_PARAMETER_ITEM", this.generateCodePANKUZU_PARAMETER_ITEM());
        map.put("defaultSizePerPage", this.getDefaultSizePerPage());
        Model lpmodel = this.getListPModel();
        map.put("superClassName", this.getSuperClassname(lpmodel));
        if (new ShowlistAction(this.action).getStrictActionType() == ShowlistActionType.SHOWLIST && (hasScheduleView = this.hasScheduleView())) {
            map.put("hasScheduleView", true);
            Model storeModel = (Model)this.action.getIdrefAsIRNode();
            Action[] actions = AppSchemaUtil.getActionByModelId(this.project, storeModel.getId());
            map.put("scheduleType", Arrays.stream(actions).filter(action -> "schedule".equals(action.getView())).map(action -> AppSchemaUtil.getView(action).getScheduleType()).findFirst().get());
        }
        return map;
    }

    protected String generateCodeLIST_TARGETITEMS() {
        Model smodel = this.getStoreModel();
        TargetitemGenerator tgen = new TargetitemGenerator();
        Set<String> targetitems = tgen.createListTargetitems(this.project, smodel);
        String[] sa = targetitems.toArray(new String[targetitems.size()]);
        return ControllerGenerator_showList.outputStringArrayCode(sa);
    }

    protected String generateCodePANKUZU_PARAMETER_ITEM() {
        ArrayList<String> list = new ArrayList<String>();
        Condition[] conds = null;
        Conditionlist clist = AppSchemaUtil.getConditionlist(this.action);
        if (clist != null) {
            conds = AppSchemaUtil.getAllInnerCondition(clist);
        }
        if (conds != null && conds.length > 0) {
            for (Condition cond : conds) {
                list.add(cond.getName());
            }
        }
        String[] sa = list.toArray(new String[list.size()]);
        return ControllerGenerator_showList.outputStringArrayCode(sa);
    }

    protected Integer getDefaultSizePerPage() {
        int size = 10;
        Page page = AppSchemaUtil.getPage(this.action);
        if (page != null) {
            if (AppSchemaUtil.isReportList(this.action, this.project)) {
                return page.getSize();
            }
            size = Math.max(1, page.getSize());
            if (size > 10000) {
                Object[] o = new Object[]{this.action.getId(), Integer.toString(size), Integer.toString(10000)};
                logger.warn(rman.getValue("struts.showlist.sizeperpage.over", o));
                size = 10000;
            }
        }
        return size;
    }

    private String getSuperClassname(Model lpmodel) {
        String eclassname = null;
        if (lpmodel != null && lpmodel.getSelectable()) {
            String selecttype = this.action.getSelecttype();
            if (StringUtils.isBlank((CharSequence)selecttype) || "page".equals(selecttype)) {
                eclassname = "DbShowListSelectableController";
            } else if ("all".equals(selecttype)) {
                eclassname = "DbShowListSelectableAllController";
            }
        }
        if (eclassname == null) {
            eclassname = "DbShowListController";
        }
        return eclassname;
    }

    @Override
    public String generateControllerBean(String tab) {
        if (!this.action.getValid()) {
            return "";
        }
        ControllerGenerator.ActionNode actionnode = this.createActionNode();
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, this.action);
        Model cpmodel = AppSchemaUtil.getConditionPModel(this.project, this.action, true);
        boolean emptycpmodel = false;
        IModelChoice[] _imc = cpmodel.getContent();
        if (_imc == null || _imc.length == 0) {
            emptycpmodel = true;
        }
        Model lpmodel = this.getListPModel();
        Model lmodel = (Model)lpmodel.getIdrefAsIRNode();
        String finderContextId = ActionUtils.getFinderContextBeanId(this.action);
        Model smodel = AppSchemaUtil.getStoreModelByAction(this.action);
        actionnode.addPropertyrefMap("entityHelper", AppSchemaUtil.getHelperClassname(smodel));
        actionnode.addPropertyrefMap("conditionHelper", AppSchemaUtil.getHelperClassname(cmodel));
        actionnode.addPropertyrefMap("conditionPHelper", AppSchemaUtil.getHelperClassname(cpmodel));
        if (!emptycpmodel) {
            actionnode.addPropertyrefMap("conditionFilterHelper", AppSchemaUtil.getHelperClassname(cpmodel, "FilterHelper"));
            actionnode.addPropertyrefMap("conditionInputCheckHelper", AppSchemaUtil.getHelperClassname(cpmodel, "InputCheckHelper"));
            actionnode.addPropertyrefMap("conditionCreateObjectHelper", AppSchemaUtil.getHelperClassname(cpmodel, "CreateObjectHelper"));
        }
        actionnode.addPropertyrefMap("listHelper", AppSchemaUtil.getHelperClassname(lmodel));
        actionnode.addPropertyrefMap("listPHelper", AppSchemaUtil.getHelperClassname(lpmodel));
        ShowlistAction showlistAction = new ShowlistAction(this.action);
        if (showlistAction.getStrictActionType() == ShowlistActionType.SHOWLIST) {
            actionnode.addPropertyrefMap("restDataConverter", showlistAction.getRestDataConverterClassName());
            if (this.hasScheduleView()) {
                actionnode.addPropertyrefMap("scheduleViewRestDataConverter", showlistAction.getScheduleViewRestDataConverterClassName());
            }
        }
        actionnode.addLookupmethodMap("getFinderContext", finderContextId);
        return actionnode.toString(tab);
    }

    private boolean hasScheduleView() {
        Model storeModel = (Model)this.action.getIdrefAsIRNode();
        Action[] actions = AppSchemaUtil.getActionByModelId(this.project, storeModel.getId());
        return Arrays.stream(actions).anyMatch(action -> "schedule".equals(action.getView()));
    }
}

