/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.appgen.component.appschema.ActionUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ControllerGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Page;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerGenerator_updateList
extends ControllerGenerator {
    protected static Logger logger = LogManager.getLogger((String)ControllerGenerator_updateList.class.getName());

    public ControllerGenerator_updateList(Project project, Action action) {
        super(project, action);
    }

    @Override
    protected String getTemplateFile() {
        return "UpdateListController.vm";
    }

    @Override
    public Map<String, Object> createParameterMap() {
        Map<String, Object> map = super.createParameterMap();
        this.putCodeConditionModelClassName(map);
        this.putCodeListModelClassName(map);
        Page page = AppSchemaUtil.getPage(this.action);
        boolean disable_paging_fkey = true;
        if (page != null) {
            disable_paging_fkey = !page.getPagingFkey();
        }
        map.put("disable_paging_fkey", disable_paging_fkey);
        this.putEdabanItemname(map);
        return map;
    }

    @Override
    public String generateControllerBean(String tab) {
        if (!this.action.getValid()) {
            return "";
        }
        ControllerGenerator.ActionNode actionnode = this.createActionNode();
        Model smodel = AppSchemaUtil.getStoreModelByAction(this.action);
        String finderContextId = ActionUtils.getFinderContextBeanId(this.action);
        actionnode.addPropertyrefMap("entityHelper", AppSchemaUtil.getHelperClassname(smodel));
        actionnode.addLookupmethodMap("getFinderContext", finderContextId);
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, this.action);
        actionnode.addPropertyrefMap("conditionHelper", AppSchemaUtil.getHelperClassname(cmodel));
        Model ulpmodel = this.getListPModel();
        actionnode.addPropertyrefMap("updateListPHelper", AppSchemaUtil.getHelperClassname(ulpmodel));
        actionnode.addPropertyrefMap("updateListPInputCheckHelper", AppSchemaUtil.getHelperClassname(ulpmodel, "InputCheckHelper"));
        return actionnode.toString(tab);
    }

    private void putEdabanItemname(Map<String, Object> map) {
        Model ulpmodel = this.getListPModel();
        ArrayList<String> edabanItemnames = new ArrayList<String>();
        ArrayList<String> edabanUpdateOnlyItemnames = new ArrayList<String>();
        for (IModelChoice imc : ulpmodel.getContent()) {
            Modelitem mitem;
            String edabantype;
            if (!(imc instanceof Modelitem) || (edabantype = (mitem = (Modelitem)imc).getEdabantype()) == null) continue;
            if (edabantype.equals("edaban")) {
                edabanItemnames.add(mitem.getName());
                continue;
            }
            if (!edabantype.equals("edabanUpdateOnly")) continue;
            edabanUpdateOnlyItemnames.add(mitem.getName());
        }
        Model smodel = this.getStoreModel();
        if (edabanItemnames.size() > 0) {
            String edabanItemname = (String)edabanItemnames.get(0);
            if (edabanItemnames.size() > 1) {
                logger.warn("Edaban modelitem is too many in model " + smodel.getId() + " modelitem " + String.join((CharSequence)",", edabanItemnames) + ".. use modelitem " + edabanItemname + ".");
            }
            map.put("edabanItemname", JavaSourceGenerator.capFirst(edabanItemname));
            ArrayList<String> edabanUpdateOnlyItemnames2 = new ArrayList<String>();
            for (String itemname : edabanUpdateOnlyItemnames) {
                edabanUpdateOnlyItemnames2.add(JavaSourceGenerator.capFirst(itemname));
            }
            map.put("edabanUpdateOnlyItemnames", edabanUpdateOnlyItemnames2);
        } else if (edabanUpdateOnlyItemnames.size() > 0) {
            logger.warn("Edaban modelitem is nothing model " + smodel.getId() + ". but exists edabanUpdateOnly modelitem " + String.join((CharSequence)",", edabanUpdateOnlyItemnames) + ".");
        }
    }
}

